/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.model;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;

public class TLCSpec
extends Spec {
    private final Spec spec;

    TLCSpec(Spec spec) {
        super(spec.getProject());
        this.spec = spec;
    }

    public SpecObj getRootModule() {
        return this.spec.getRootModule();
    }

    public Spec toSpec() {
        return this.spec;
    }

    public Map<String, Model> getModels() {
        return this.getModels(".*_SnapShot_[0-9]*$", false);
    }

    public Map<String, Model> getModels(String regexp, boolean include) {
        ILaunchConfiguration[] launchConfigurations = TLCSpec.getAllLaunchConfigurations();
        HashMap<String, Model> res = new HashMap<String, Model>();
        IPath location = this.getProject().getLocation();
        int i = 0;
        while (i < launchConfigurations.length) {
            Model model;
            ILaunchConfiguration aConfiguration = launchConfigurations[i];
            if (location.isPrefixOf(aConfiguration.getFile().getLocation()) && (model = (Model)aConfiguration.getAdapter(Model.class)).getName().matches(regexp) == include) {
                res.put(model.getName(), model);
            }
            ++i;
        }
        return res;
    }

    private static ILaunchConfiguration[] getAllLaunchConfigurations() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.lamport.tla.toolbox.tool.tlc.modelCheck");
        try {
            return launchManager.getLaunchConfigurations(launchConfigurationType);
        }
        catch (CoreException shouldNeverHappen) {
            shouldNeverHappen.printStackTrace();
            return new ILaunchConfiguration[0];
        }
    }

    public Model getModel(String modelName) {
        String sanitizedName = Model.sanitizeName(modelName);
        Map<String, Model> models = this.getModels(Pattern.quote(sanitizedName), true);
        return models.get(sanitizedName);
    }

    public void rename(Spec aNewSpec) {
        Collection<Model> models = this.getModels().values();
        for (Model model : models) {
            model.specRename(aNewSpec);
        }
    }

    public String getModelNameSuggestion() {
        return this.getModelNameSuggestion("Model_1");
    }

    private String getModelNameSuggestion(String proposition) {
        Model model = this.getModel(proposition);
        if (model != null || this.getProject().getFile(proposition + ".tla").exists()) {
            String oldNumber = proposition.substring(proposition.lastIndexOf("_") + 1);
            int number = Integer.parseInt(oldNumber) + 1;
            proposition = proposition.substring(0, proposition.lastIndexOf("_") + 1);
            return this.getModelNameSuggestion(proposition + number);
        }
        return proposition;
    }

    public String getModelNameSuggestion(Model model) {
        String modelName = model.getName();
        int idx = modelName.lastIndexOf("_");
        if (idx > 0) {
            String suffix = modelName.substring(idx + 1, modelName.length());
            try {
                Integer.parseInt(suffix);
            }
            catch (NumberFormatException ignore) {
                return modelName + "_Copy";
            }
            return this.getModelNameSuggestion(model.getName());
        }
        return modelName + "_Copy";
    }

    public Set<Module> getModulesSANY() {
        HashSet<Module> s = new HashSet<Module>();
        Enumeration enumerate = this.spec.getRootModule().parseUnitContext.keys();
        while (enumerate.hasMoreElements()) {
            ParseUnit parseUnit = (ParseUnit)this.spec.getRootModule().parseUnitContext.get(enumerate.nextElement());
            s.add(new Module(parseUnit));
        }
        return s;
    }
}

