/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.Action;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.job.AbstractJob;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationDefaults;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.ModelCoverage;
import org.lamport.tla.toolbox.tool.tlc.result.IResultPresenter;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.ToolboxJob;
import tlc2.TLCGlobals;
import tlc2.util.FP64;

public abstract class TLCJob
extends AbstractJob
implements IModelConfigurationConstants,
IModelConfigurationDefaults {
    public static final String AllJobsMatcher = ToolboxJob.FAMILY;
    protected static final int STEP = 30;
    private static final int COVERAGE_INTERVAL = 3;
    protected long timeout = 1000L;
    protected IFile rootModule;
    protected IFile cfgFile;
    protected IFile outFile;
    protected IFolder launchDir;
    protected int workers = 1;
    protected ILaunch launch;
    protected String modelName;
    protected final String specName;
    protected boolean appendConsole = true;

    public TLCJob(String specName, String modelName, ILaunch launch) {
        this(specName, modelName, launch, 1);
    }

    public TLCJob(String specName, String modelName, ILaunch launch, int workers) {
        super("TLC run for " + modelName);
        this.specName = specName;
        this.modelName = modelName;
        this.workers = workers;
        IProject project = ResourceHelper.getProject((String)specName);
        Assert.isNotNull((Object)project, (String)("Error accessing the spec project " + specName));
        this.launchDir = project.getFolder(modelName);
        Assert.isNotNull((Object)this.launchDir, (String)("Error accessing the model folder " + modelName));
        this.launch = launch;
        if (launch.getLaunchMode().equals("exploreTrace")) {
            this.rootModule = this.launchDir.getFile("TE.tla");
            this.cfgFile = this.launchDir.getFile("TE.cfg");
            this.outFile = this.launchDir.getFile("TE.out");
        } else {
            this.rootModule = this.launchDir.getFile("MC.tla");
            this.cfgFile = this.launchDir.getFile("MC.cfg");
            this.outFile = this.launchDir.getFile("MC.out");
        }
    }

    protected String[] constructProgramArguments() throws CoreException {
        int fpBits;
        IResource[] checkpoints;
        boolean hasSpec;
        ArrayList<String> arguments = new ArrayList<String>();
        ILaunchConfiguration config = this.launch.getLaunchConfiguration();
        if (!this.checkDeadlock()) {
            arguments.add("-deadlock");
        }
        if (!this.checkPoint()) {
            arguments.add("-checkpoint");
            arguments.add(String.valueOf(0));
        }
        if (hasSpec = this.hasSpec(config)) {
            if (this.runAsModelCheck()) {
                if (this.isDepthFirst()) {
                    int dfidDepth = config.getAttribute("dfidDepth", 100);
                    arguments.add("-dfid");
                    arguments.add(String.valueOf(dfidDepth));
                }
            } else {
                int traceDepth;
                arguments.add("-simulate");
                String simuNumTraces = config.getAttribute("simuNumTraces", Long.toString(Long.MAX_VALUE));
                if (!"".equals(simuNumTraces) && Long.valueOf(simuNumTraces) != Long.MAX_VALUE) {
                    arguments.add(String.format("num=%s", Long.valueOf(simuNumTraces)));
                }
                if ((traceDepth = config.getAttribute("simuDepth", 100)) != 100) {
                    arguments.add("-depth");
                    arguments.add(String.valueOf(traceDepth));
                }
                int aril = config.getAttribute("simuAril", -1);
                int seed = config.getAttribute("simuSeed", -1);
                if (aril != -1) {
                    arguments.add("-aril");
                    arguments.add(String.valueOf(aril));
                }
                if (seed != -1) {
                    arguments.add("-seed");
                    arguments.add(String.valueOf(seed));
                }
            }
        }
        if (hasSpec && this.recover() && (checkpoints = ((Model)config.getAdapter(Model.class)).getCheckpoints(false)).length > 0) {
            arguments.add("-recover");
            arguments.add(checkpoints[0].getName());
        }
        if (this.deferLiveness()) {
            arguments.add("-lncheck");
            arguments.add("final");
        }
        if ((fpBits = this.launch.getLaunchConfiguration().getAttribute("fpBits", -1)) >= 0) {
            arguments.add("-fpbits");
            arguments.add(String.valueOf(fpBits));
        }
        if (this.launch.getLaunchConfiguration().getAttribute("fpIndexRandom", true)) {
            int fpIndex = new Random().nextInt(FP64.Polys.length);
            arguments.add("-fp");
            arguments.add(String.valueOf(fpIndex));
        } else {
            int fpSeedOffset = this.launch.getLaunchConfiguration().getAttribute("fpIndex", 1);
            arguments.add("-fp");
            arguments.add(String.valueOf(fpSeedOffset));
        }
        int maxSetSize = this.launch.getLaunchConfiguration().getAttribute("maxSetSize", TLCGlobals.setBound);
        if (maxSetSize != TLCGlobals.setBound) {
            arguments.add("-maxSetSize");
            arguments.add(String.valueOf(maxSetSize));
        }
        if (this.visualizeStateGraph() && hasSpec) {
            arguments.add("-dump");
            arguments.add("dot,colorize");
            arguments.add(this.modelName);
        }
        arguments.add("-config");
        arguments.add(this.cfgFile.getName());
        if (this.collectCoverage()) {
            arguments.add("-coverage");
            arguments.add(String.valueOf(3));
        }
        arguments.add("-workers");
        arguments.add(String.valueOf(this.workers));
        arguments.add("-noGenerateSpecTE");
        arguments.add("-tool");
        arguments.add("-metadir");
        arguments.add(this.launchDir.getLocation().toOSString());
        arguments.add(ResourceHelper.getModuleName((IResource)this.rootModule));
        ILaunchConfiguration launchConfig = this.launch.getLaunchConfiguration();
        String tlcParameters = launchConfig.getAttribute("TLCCmdLineParameters", null);
        if (tlcParameters != null && !"".equals(tlcParameters.trim())) {
            String[] split = tlcParameters.trim().split("\\s+");
            arguments.addAll(Arrays.asList(split));
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected boolean deferLiveness() throws CoreException {
        return this.launch.getLaunchConfiguration().getAttribute("deferLiveness", false);
    }

    protected boolean collectCoverage() throws CoreException {
        ILaunchConfiguration launchConfiguration = this.launch.getLaunchConfiguration();
        if (launchConfiguration.getAttribute("collectCoverage", 1) != ModelCoverage.OFF.ordinal()) {
            return launchConfiguration.getAttribute("modelBehaviorSpecType", 2) != 0;
        }
        return false;
    }

    protected boolean recover() throws CoreException {
        return this.launch.getLaunchConfiguration().getAttribute("recover", false);
    }

    protected boolean isDepthFirst() throws CoreException {
        return this.launch.getLaunchConfiguration().getAttribute("dfidMode", false);
    }

    protected boolean runAsModelCheck() throws CoreException {
        return this.launch.getLaunchConfiguration().getAttribute("mcMode", true);
    }

    protected boolean checkPoint() {
        return true;
    }

    protected boolean checkDeadlock() throws CoreException {
        return this.launch.getLaunchConfiguration().getAttribute("modelCorrectnessCheckDeadlock", true);
    }

    protected boolean visualizeStateGraph() throws CoreException {
        return this.launch.getLaunchConfiguration().getAttribute("visualizeStateGraph", false);
    }

    protected boolean hasSpec(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("modelBehaviorSpecType", 2) != 0;
    }

    @Override
    protected Action getJobCompletedAction() {
        return new Action("View job results"){

            public void run() {
                IResultPresenter[] registeredResultPresenters = TLCJob.getRegisteredResultPresenters();
                int i = 0;
                while (i < registeredResultPresenters.length) {
                    Model model = (Model)TLCJob.this.launch.getLaunchConfiguration().getAdapter(Model.class);
                    registeredResultPresenters[i].showResults(model);
                    ++i;
                }
            }
        };
    }

    protected abstract IStatus run(IProgressMonitor var1);

    protected boolean checkAndSleep() {
        try {
            Thread.sleep(this.timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.checkCondition();
    }

    protected abstract boolean checkCondition();

    public boolean belongsTo(Object family) {
        if (family != null) {
            if (family instanceof Model) {
                return ((Model)this.launch.getLaunchConfiguration().getAdapter(Model.class)).equals(family);
            }
            if (family instanceof ILaunchConfiguration) {
                return this.launch.getLaunchConfiguration().contentsEqual((ILaunchConfiguration)family);
            }
            if (family instanceof Spec) {
                Spec spec = (Spec)family;
                return spec.getName().equals(this.specName);
            }
            if (AllJobsMatcher.equals(family)) {
                return true;
            }
        }
        return false;
    }

    protected static IResultPresenter[] getRegisteredResultPresenters() {
        IConfigurationElement[] decls = Platform.getExtensionRegistry().getConfigurationElementsFor("org.lamport.tla.toolbox.tlc.processResultPresenter");
        Vector<IResultPresenter> validExtensions = new Vector<IResultPresenter>();
        int i = 0;
        while (i < decls.length) {
            try {
                IResultPresenter extension = (IResultPresenter)decls[i].createExecutableExtension("class");
                validExtensions.add(extension);
            }
            catch (CoreException e) {
                TLCActivator.logError("Error instatiating the IResultPresenter extension", e);
            }
            ++i;
        }
        return validExtensions.toArray(new IResultPresenter[validExtensions.size()]);
    }
}

