/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.job;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.lamport.tla.toolbox.tool.tlc.job.TLCProcessJob;
import org.lamport.tla.toolbox.util.ResourceHelper;
import tlc2.tool.distributed.TLCServer;

public class DistributedTLCJob
extends TLCProcessJob {
    private static final List<String> WHITELIST = new ArrayList<String>();
    private static final List<String> WHITELIST_WITH_ARG = new ArrayList<String>();

    static {
        WHITELIST.add("-deadlock");
        WHITELIST.add("-terse");
        WHITELIST.add("-nowarning");
        WHITELIST_WITH_ARG.add("-checkpoint");
        WHITELIST_WITH_ARG.add("-fp");
        WHITELIST_WITH_ARG.add("-recover");
        WHITELIST_WITH_ARG.add("-metadir");
    }

    public DistributedTLCJob(String specName, String modelName, ILaunch launch, int numberOfWorkers) {
        super(specName, modelName, launch, numberOfWorkers);
    }

    @Override
    protected String[] constructProgramArguments() throws CoreException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        List<String> superArguments = Arrays.asList(super.constructProgramArguments());
        int i = 0;
        while (i < superArguments.size()) {
            String arg = superArguments.get(i);
            if (WHITELIST.contains(arg)) {
                arguments.add(arg);
            } else if (WHITELIST_WITH_ARG.contains(arg)) {
                arguments.add(arg);
                arguments.add(superArguments.get(++i));
            }
            ++i;
        }
        String userDir = this.launchDir.getLocation().toOSString();
        String specFile = ResourceHelper.getModuleName((IResource)this.rootModule);
        arguments.add(userDir + File.separator + specFile);
        arguments.add("-tool");
        return arguments.toArray(new String[arguments.size()]);
    }

    @Override
    protected List<String> getAdditionalVMArgs() throws CoreException {
        String iface;
        List<String> additionalVMArgs = super.getAdditionalVMArgs();
        ILaunchConfiguration launchConfig = this.launch.getLaunchConfiguration();
        int distributedFPSetCount = launchConfig.getAttribute("distributedFPSetCount", 0);
        if (distributedFPSetCount > 0) {
            additionalVMArgs.add("-Dtlc2.tool.distributed.TLCServer.expectedFPSetCount=" + distributedFPSetCount);
        }
        if (!"".equals(iface = launchConfig.getAttribute("distributedNetworkInterface", ""))) {
            additionalVMArgs.add("-Djava.rmi.server.hostname=" + iface);
        }
        return additionalVMArgs;
    }

    @Override
    protected Class getMainClass() {
        return TLCServer.class;
    }
}

