/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.job;

import java.io.File;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;

public abstract class AbstractJob
extends Job {
    public AbstractJob(String name) {
        super(name);
    }

    protected static boolean isModal(Job job) {
        Boolean isModal = (Boolean)job.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    protected void doFinish() {
        if (AbstractJob.isModal(this)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractJob.this.getJobCompletedAction().run();
                }
            });
        } else {
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            this.setProperty(IProgressConstants.ACTION_PROPERTY, this.getJobCompletedAction());
        }
    }

    protected IVMInstall getVMInstall() {
        IVMInstall vmInstall = null;
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            StandardVMType installType = new StandardVMType();
            vmInstall = installType.createVMInstall("TLCModelCheckerNestedVM");
            vmInstall.setInstallLocation(new File(javaHome));
            return vmInstall;
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    protected abstract Action getJobCompletedAction();
}

