/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.expression;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.model.Model;

public class MarkerPropertyTester
extends PropertyTester {
    /*
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("hasMarker".equals(property) && args.length > 0 && args[0] instanceof String) {
            String markerId = (String)args[0];
            String attributeName = null;
            if (args.length > 1 && args[1] instanceof String) {
                attributeName = (String)args[1];
            }
            if (receiver != null && receiver instanceof Model) {
                Model model = (Model)receiver;
                IFile file = model.getLaunchConfiguration().getFile();
                if (!file.exists()) {
                    return false;
                }
                try {
                    IMarker[] foundMarkers = file.findMarkers(markerId, true, 2);
                    if (attributeName != null) {
                        int i = 0;
                        while (i < foundMarkers.length) {
                            Object value = foundMarkers[i].getAttribute(attributeName);
                            if (value == null || !value.equals(expectedValue)) {
                                return false;
                            }
                            ++i;
                        }
                        return foundMarkers.length > 0;
                    }
                    int expectedCount = -1;
                    if (expectedValue != null && expectedValue instanceof Integer) {
                        expectedCount = (Integer)expectedValue;
                    }
                    boolean result = expectedCount == -1 ? foundMarkers.length > 0 : foundMarkers.length == expectedCount;
                    return result;
                }
                catch (CoreException e) {
                    TLCActivator.logError("Error testing markers", e);
                }
            }
        }
        return false;
    }
}

