/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.util;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;

public class ModelNameValidator
implements IInputValidator {
    private final Spec spec;

    public ModelNameValidator(Spec spec) {
        this.spec = spec;
    }

    public String isValid(String newText) {
        if (newText == null || "".equals(newText)) {
            return "Model name must be not empty";
        }
        Model existingModel = ((TLCSpec)((Object)this.spec.getAdapter(TLCSpec.class))).getModel(newText);
        if (existingModel != null) {
            return "Model with the name " + newText + " already exists. Please choose a different name";
        }
        if (newText.indexOf(this.spec.getName() + "___") == 0) {
            return "Model name cannot begin with \"" + this.spec.getName() + "___\".";
        }
        if (newText.contains(":")) {
            return "Model name cannot contain ':' characters.";
        }
        IStatus fileStatus = ResourcesPlugin.getWorkspace().validateName(newText, 1);
        if (!fileStatus.isOK()) {
            return fileStatus.getMessage();
        }
        return null;
    }
}

