/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.ITLCOutputListener;
import org.lamport.tla.toolbox.tool.tlc.output.data.ActionInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageInformation;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.GeneralOutputParsingHelper;
import org.lamport.tla.toolbox.tool.tlc.output.data.ITLCModelLaunchDataPresenter;
import org.lamport.tla.toolbox.tool.tlc.output.data.StateSpaceInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCError;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCState;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCRegion;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCRegionContainer;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.st.Location;
import tlc2.model.Assignment;
import tlc2.model.Formula;

public class TLCModelLaunchDataProvider
implements ITLCOutputListener {
    public static final String STATESORTORDER = "STATESORTORDER";
    public static final String NO_OUTPUT_AVAILABLE = "No output is available";
    public static final String NO_ERRORS = "No errors";
    public static final String NOT_RUNNING = "Not running";
    public static final String COMPUTING_INIT = "Computing initial states";
    public static final String RECOVERING = "Recovering from checkpoint";
    public static final String COMPUTING_REACHABLE = "Computing reachable states";
    public static final String CHECKPOINTING = "Checkpointing";
    public static final String CHECKING_LIVENESS_FINAL = "Checking final liveness";
    public static final String CHECKING_LIVENESS = "Checking liveness";
    public static final String SERVER_RUNNING = "Master waiting for workers";
    public static final String SINGLE_WORKER_REGISTERED = " worker registered";
    public static final String MULTIPLE_WORKERS_REGISTERED = " workers registered";
    public static final String BREADTH_FIRST_SEARCH = "Breadth-first search";
    public static final String DEPTH_FIRST_SEARCH = "Depth-first search";
    public static final String SIMULATION_MODE = "Simulation";
    public static final Pattern CONSTANT_EXPRESSION_OUTPUT_PATTERN = Pattern.compile("(?s)<<[\\s]*" + Pattern.quote("\"$!@$!@$!@$!@$!\"") + "[\\s]*,(.*)>>");
    private final CopyOnWriteArrayList<ITLCModelLaunchDataPresenter> m_dataPresenters;
    protected List<TLCError> errors;
    protected long startTimestamp;
    protected long finishTimestamp;
    protected String tlcMode;
    protected long lastCheckpointTimeStamp;
    protected String coverageTimestamp;
    protected String currentStatus;
    protected String fingerprintCollisionProbability;
    protected CoverageInformation coverageInfo;
    protected boolean zeroCoverage = false;
    protected List<StateSpaceInformationItem> progressInformation;
    protected TLCError lastDetectedError;
    protected boolean isDone;
    protected Document progressOutput;
    protected Document userOutput;
    protected String constantExprEvalOutput;
    private final Model model;
    protected boolean isTLCStarted = false;
    protected int numWorkers = 0;
    private int fpIndex;
    private boolean isSymmetryWithLiveness = false;
    private boolean isConstraintsWithLiveness = false;
    private final Object parsingLock;
    private final AtomicBoolean parsing;
    private static final String CR = "\n";
    private static final String EMPTY = "";
    private static final Pattern startupMessagePattern = Pattern.compile("^Running (depth|breadth)-first search Model-Checking with fp ([0-9]+) and seed [-0-9]+ with [0-9]+ worker[s]? on [0-9]+ cores with .*? heap and .*? offheap memory (\\[pid: [0-9]+\\])? \\(.*\\).$");
    private static final Pattern collisionProbabilityPattern = Pattern.compile("^Model checking completed\\. No error has been found\\.\\n  Estimates of the probability that TLC did not check all reachable states\\n  because two distinct states had the same fingerprint:\\n  calculated \\(optimistic\\):  val = ([0-9]*\\.?[0-9]+[eE][-+]?[0-9]+?)(\\n  based on the actual fingerprints:  val = ([0-9]*\\.?[0-9]+[eE][-+]?[0-9]+?))?$");
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TLCModelLaunchDataProvider(Model tlcModel) {
        Assert.isNotNull((Object)tlcModel);
        this.model = tlcModel;
        this.m_dataPresenters = new CopyOnWriteArrayList();
        this.initialize();
        this.parsingLock = new Object();
        this.parsing = new AtomicBoolean(true);
        Object object = this.parsingLock;
        synchronized (object) {
            this.parsing.set(this.connectToSourceRegistry());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForParsingFinish() {
        if (this.parsing.get()) {
            Object object = this.parsingLock;
            synchronized (object) {
                try {
                    this.parsingLock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void initialize() {
        this.isDone = false;
        this.isTLCStarted = false;
        this.errors = new Vector<TLCError>();
        this.lastDetectedError = null;
        this.model.removeMarkers("org.lamport.tla.toolbox.tlc.modelErrorTLC");
        this.coverageInfo = new CoverageInformation();
        this.progressInformation = new Vector<StateSpaceInformationItem>();
        this.startTimestamp = Long.MIN_VALUE;
        this.finishTimestamp = Long.MIN_VALUE;
        this.tlcMode = EMPTY;
        this.lastCheckpointTimeStamp = Long.MIN_VALUE;
        this.coverageTimestamp = EMPTY;
        this.setCurrentStatus(NOT_RUNNING);
        this.setFingerprintCollisionProbability(EMPTY);
        this.progressOutput = new Document(NO_OUTPUT_AVAILABLE);
        this.userOutput = new Document(NO_OUTPUT_AVAILABLE);
        this.constantExprEvalOutput = EMPTY;
        this.isSymmetryWithLiveness = false;
        this.zeroCoverage = false;
    }

    protected void informPresenter(int fieldId) {
        this.m_dataPresenters.stream().forEach(presenter -> presenter.modelChanged(this, fieldId));
    }

    public void populate() {
        int i = 0;
        while (i < ITLCModelLaunchDataPresenter.ALL_FIELDS.length) {
            this.informPresenter(ITLCModelLaunchDataPresenter.ALL_FIELDS[i]);
            ++i;
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDone() {
        if (this.lastDetectedError != null) {
            this.errors.add(this.lastDetectedError);
            this.informPresenter(512);
        }
        this.setCurrentStatus(NOT_RUNNING);
        this.informPresenter(2048);
        this.isDone = true;
        if (this.zeroCoverage) {
            this.informPresenter(32);
        }
        Object object = this.parsingLock;
        synchronized (object) {
            block10: {
                try {
                    try {
                        this.parsingLock.notifyAll();
                    }
                    catch (Exception exception) {
                        this.parsing.set(false);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.parsing.set(false);
                    throw throwable;
                }
                this.parsing.set(false);
            }
        }
    }

    @Override
    public void onNewSource() {
        this.initialize();
        this.populate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onOutput(ITypedRegion region, String text) {
        if (this.isDone) {
            this.isTLCStarted = false;
            this.isDone = false;
        }
        String outputMessage = text;
        if (region instanceof TLCRegion) {
            TLCRegion tlcRegion = (TLCRegion)region;
            int severity = tlcRegion.getSeverity();
            int messageCode = tlcRegion.getMessageCode();
            switch (severity) {
                case 4: {
                    Assert.isNotNull((Object)this.lastDetectedError, (String)"The state encountered without the error describing the reason for it. This is a bug.");
                    this.lastDetectedError.addState(TLCState.parseState(outputMessage, this.getModelName()));
                    return;
                }
                case 1: 
                case 2: 
                case 3: {
                    switch (messageCode) {
                        case 2121: 
                        case 2264: {
                            return;
                        }
                        case 2156: {
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2279: {
                            this.isSymmetryWithLiveness = true;
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            this.informPresenter(131072);
                            return;
                        }
                        case 2284: {
                            this.isConstraintsWithLiveness = true;
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            this.informPresenter(131072);
                            return;
                        }
                        default: {
                            if (this.lastDetectedError != null) {
                                this.errors.add(this.lastDetectedError);
                                this.informPresenter(512);
                                this.lastDetectedError = null;
                            }
                            this.lastDetectedError = this.createError(tlcRegion, text);
                            return;
                        }
                    }
                }
                case 0: {
                    if (messageCode == 2776) return;
                    if (this.lastDetectedError != null) {
                        this.errors.add(this.lastDetectedError);
                        this.informPresenter(512);
                        this.lastDetectedError = null;
                    }
                    switch (messageCode) {
                        case 2102: 
                        case 2168: 
                        case 2194: 
                        case 2199: 
                        case 2204: 
                        case 2205: 
                        case 2210: 
                        case 2212: 
                        case 2219: 
                        case 2220: 
                        case 2262: 
                        case 2268: 
                        case 2269: {
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2187: {
                            this.tlcMode = BREADTH_FIRST_SEARCH;
                            this.fpIndex = TLCModelLaunchDataProvider.getFPIndex(outputMessage);
                            this.informPresenter(65536);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2271: {
                            this.tlcMode = DEPTH_FIRST_SEARCH;
                            this.fpIndex = TLCModelLaunchDataProvider.getFPIndex(outputMessage);
                            this.informPresenter(65536);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2188: {
                            this.tlcMode = SIMULATION_MODE;
                            this.informPresenter(65536);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2193: {
                            this.setFingerprintCollisionProbability(this.extractCollisionProbability(outputMessage));
                            this.informPresenter(8192);
                            return;
                        }
                        case 2189: {
                            this.setCurrentStatus(COMPUTING_INIT);
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2190: 
                        case 2191: {
                            if (this.addOrReplaceProgressInformation(StateSpaceInformationItem.parseInit(outputMessage))) {
                                this.informPresenter(256);
                            }
                        }
                        case 2207: 
                        case 2208: {
                            this.setCurrentStatus(COMPUTING_REACHABLE);
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2195: {
                            this.setCurrentStatus(CHECKPOINTING);
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2196: {
                            this.setCurrentStatus(COMPUTING_REACHABLE);
                            this.informPresenter(2048);
                            this.lastCheckpointTimeStamp = GeneralOutputParsingHelper.parseTLCTimestamp(outputMessage);
                            this.informPresenter(1024);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2192: {
                            if (outputMessage.contains("complete")) {
                                this.setCurrentStatus(CHECKING_LIVENESS_FINAL);
                            } else {
                                this.setCurrentStatus(CHECKING_LIVENESS);
                            }
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2267: {
                            this.setCurrentStatus(COMPUTING_REACHABLE);
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2197: {
                            this.setCurrentStatus(RECOVERING);
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2198: 
                        case 2203: {
                            this.setCurrentStatus(COMPUTING_REACHABLE);
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 2185: {
                            this.isTLCStarted = true;
                            this.startTimestamp = GeneralOutputParsingHelper.parseTLCTimestamp(outputMessage);
                            this.informPresenter(4);
                            return;
                        }
                        case 2186: {
                            this.setCurrentStatus(NOT_RUNNING);
                            this.informPresenter(2048);
                            this.finishTimestamp = GeneralOutputParsingHelper.parseTLCTimestamp(outputMessage);
                            this.informPresenter(8);
                            return;
                        }
                        case 2200: 
                        case 2206: 
                        case 2209: {
                            if (!this.addOrReplaceProgressInformation(StateSpaceInformationItem.parse(outputMessage))) return;
                            this.informPresenter(256);
                            return;
                        }
                        case 2201: {
                            this.coverageTimestamp = CoverageInformationItem.parseCoverageTimestamp(outputMessage);
                            this.coverageInfo = new CoverageInformation(this.model.getSavedTLAFiles());
                            this.informPresenter(16);
                            this.informPresenter(32);
                            return;
                        }
                        case 2774: {
                            this.coverageInfo.add(ActionInformationItem.parseProp(outputMessage, this.getModelName()));
                            this.informPresenter(32);
                            return;
                        }
                        case 2773: {
                            this.coverageInfo.add(ActionInformationItem.parseInit(outputMessage, this.getModelName()));
                            this.informPresenter(32);
                            return;
                        }
                        case 2772: {
                            this.coverageInfo.add(ActionInformationItem.parseNext(outputMessage, this.getModelName()));
                            this.informPresenter(32);
                            return;
                        }
                        case 2778: {
                            this.coverageInfo.add(ActionInformationItem.parseConstraint(outputMessage, this.getModelName()));
                            this.informPresenter(32);
                            return;
                        }
                        case 2775: {
                            CoverageInformationItem item = CoverageInformationItem.parseCost(outputMessage, this.getModelName());
                            this.coverageInfo.add(item);
                            if (item.getCount() == 0L) {
                                this.zeroCoverage = true;
                            }
                            this.informPresenter(32);
                            return;
                        }
                        case 2221: {
                            CoverageInformationItem item = CoverageInformationItem.parse(outputMessage, this.getModelName());
                            this.coverageInfo.add(item);
                            if (item.getCount() == 0L) {
                                this.zeroCoverage = true;
                            }
                            this.informPresenter(32);
                            return;
                        }
                        case 2777: {
                            if (this.getModel().isRunning()) {
                                this.informPresenter(128);
                                return;
                            }
                        }
                        case 2202: {
                            this.informPresenter(64);
                            return;
                        }
                        case 7000: {
                            this.numWorkers = 0;
                            this.setCurrentStatus(SERVER_RUNNING);
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 7001: {
                            if (++this.numWorkers <= 1) {
                                this.setCurrentStatus(this.numWorkers + SINGLE_WORKER_REGISTERED);
                            } else {
                                this.setCurrentStatus(this.numWorkers + MULTIPLE_WORKERS_REGISTERED);
                            }
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 7002: {
                            if (--this.numWorkers <= 1) {
                                this.setCurrentStatus(this.numWorkers + SINGLE_WORKER_REGISTERED);
                            } else {
                                this.setCurrentStatus(this.numWorkers + MULTIPLE_WORKERS_REGISTERED);
                            }
                            this.informPresenter(2048);
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        case 7006: 
                        case 7007: {
                            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
                            return;
                        }
                        default: {
                            TLCModelLaunchDataProvider.setDocumentText(this.userOutput, outputMessage, true);
                            this.informPresenter(1);
                            return;
                        }
                    }
                }
                default: {
                    throw new IllegalArgumentException("This is a bug, the TLCToken with unexpected severity detected: " + severity);
                }
            }
        }
        if (this.isTLCStarted) {
            Matcher constExprEvalOutputMatcher = CONSTANT_EXPRESSION_OUTPUT_PATTERN.matcher(outputMessage);
            if (constExprEvalOutputMatcher.find()) {
                String constExprEvalOutput = outputMessage.substring(constExprEvalOutputMatcher.start(1), constExprEvalOutputMatcher.end(1));
                this.constantExprEvalOutput = constExprEvalOutput.trim();
                this.informPresenter(4096);
                outputMessage = outputMessage.replaceFirst(CONSTANT_EXPRESSION_OUTPUT_PATTERN.toString() + "\r\n", EMPTY);
            }
            if (outputMessage.length() == 0) return;
            TLCModelLaunchDataProvider.setDocumentText(this.userOutput, outputMessage, true);
            this.informPresenter(1);
            return;
        } else {
            TLCModelLaunchDataProvider.setDocumentText(this.progressOutput, outputMessage, true);
            this.informPresenter(2);
        }
    }

    static int getFPIndex(String startupMessage) {
        Matcher matcher = startupMessagePattern.matcher(startupMessage);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 0;
    }

    private boolean addOrReplaceProgressInformation(StateSpaceInformationItem latest) {
        if (!this.progressInformation.isEmpty()) {
            StateSpaceInformationItem head = this.progressInformation.get(0);
            if (head.equals(latest)) {
                this.progressInformation.set(0, latest);
                return false;
            }
            this.progressInformation.add(0, latest);
            if (this.progressInformation.size() > 1) {
                this.progressInformation.get(1).setMostRecent(false);
            }
            return true;
        }
        this.progressInformation.add(latest);
        return true;
    }

    public void destroy() {
        TLCOutputSourceRegistry.getModelCheckSourceRegistry().disconnect(this);
    }

    protected TLCError createError(TLCRegion tlcRegion, String message) {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        boolean stateSortOrder = dialogSettings.getBoolean(STATESORTORDER);
        TLCError topError = new TLCError(TLCError.Order.valueOf(stateSortOrder));
        if (tlcRegion instanceof TLCRegionContainer) {
            TLCRegionContainer container = (TLCRegionContainer)tlcRegion;
            ITypedRegion[] regions = container.getSubRegions();
            Assert.isTrue((regions.length < 3 ? 1 : 0) != 0, (String)"Unexpected error region structure, this is a bug.");
            int i = 0;
            while (i < regions.length) {
                block32: {
                    if (regions[i] instanceof TLCRegion) {
                        TLCError cause = this.createError((TLCRegion)regions[i], message);
                        topError.setCause(cause);
                    } else {
                        IFile mcFile = this.getModel().getTLAFile();
                        FileEditorInput mcFileEditorInput = new FileEditorInput(mcFile);
                        FileDocumentProvider mcFileDocumentProvider = new FileDocumentProvider();
                        try {
                            Object errorMessage = message;
                            Document errorDocument = new Document();
                            errorDocument.set((String)errorMessage);
                            boolean markerInstalled = false;
                            mcFileDocumentProvider.connect((Object)mcFileEditorInput);
                            IDocument mcDocument = mcFileDocumentProvider.getDocument((Object)mcFileEditorInput);
                            FindReplaceDocumentAdapter mcSearcher = new FindReplaceDocumentAdapter(mcDocument);
                            IRegion[] ids = ModelHelper.findIds((String)errorMessage);
                            Hashtable[] props = new Hashtable[ids.length];
                            int j = 0;
                            while (j < ids.length) {
                                Object idReplacement;
                                String id = errorDocument.get(ids[j].getOffset(), ids[j].getLength());
                                int[] coordinates = ModelHelper.calculateCoordinates((IDocument)mcDocument, (FindReplaceDocumentAdapter)mcSearcher, (String)id);
                                if (ModelHelper.EMPTY_LOCATION.equals(coordinates)) {
                                    throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc.ui", "Provided id " + id + " not found in the model file."));
                                }
                                props[j] = ModelHelper.createMarkerDescription((IFile)mcFile, (IDocument)mcDocument, (FindReplaceDocumentAdapter)mcSearcher, (String)errorMessage, (int)2, (int[])coordinates);
                                String attributeName = (String)props[j].get("attributeName");
                                Integer attributeIndex = (Integer)props[j].get("attributeIndex");
                                if (attributeName != null) {
                                    idReplacement = null;
                                    if (ModelHelper.isListAttribute((String)attributeName)) {
                                        List valueList;
                                        int attributeNumber;
                                        List attributeValue = this.model.getAttribute(attributeName, new ArrayList(0));
                                        int n = attributeNumber = attributeIndex != null ? attributeIndex : 0;
                                        if ("modelParameterConstants".equals(attributeName)) {
                                            valueList = ModelHelper.deserializeAssignmentList((List)attributeValue);
                                            if (valueList.size() >= attributeNumber + 1) {
                                                Assignment assignment = (Assignment)valueList.get(attributeNumber);
                                                idReplacement = assignment.getRight();
                                            } else {
                                                idReplacement = "'LL claims this should not happen. See Bug in TLCModelLaunchDataProvider.'";
                                            }
                                        } else {
                                            valueList = Formula.deserializeFormulaList((List)attributeValue);
                                            if (valueList.size() >= attributeNumber + 1) {
                                                Formula value = (Formula)valueList.get(attributeNumber);
                                                idReplacement = value.getFormula();
                                            } else {
                                                idReplacement = "'No value in valueList " + String.valueOf(attributeValue) + " for " + attributeNumber + ". Bug in TLCModelLaunchDataProvider.'";
                                            }
                                        }
                                    } else {
                                        idReplacement = this.model.getAttribute(attributeName, EMPTY);
                                    }
                                } else {
                                    throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc.ui", "Provided id " + id + " maps to an attribute that was not found in the model. This is a bug."));
                                }
                                errorMessage = ((String)errorMessage).substring(0, ((String)errorMessage).indexOf(id)) + (String)idReplacement + ((String)errorMessage).substring(((String)errorMessage).indexOf(id) + id.length());
                                ++j;
                            }
                            IRegion[] locations = ModelHelper.findLocations((String)errorMessage);
                            String[] regionContent = new String[locations.length];
                            int j2 = 0;
                            while (j2 < locations.length) {
                                block31: {
                                    String locationString = EMPTY;
                                    try {
                                        locationString = errorDocument.get(locations[j2].getOffset(), locations[j2].getLength());
                                    }
                                    catch (BadLocationException ble) {
                                        break block31;
                                    }
                                    Location location = Location.parseLocation((String)locationString);
                                    if (location.source().equals(mcFile.getName().substring(0, mcFile.getName().length() - ".tla".length()))) {
                                        IRegion region = AdapterFactory.locationToRegion((IDocument)mcDocument, (Location)location);
                                        regionContent[j2] = mcDocument.get(region.getOffset(), region.getLength());
                                        if (locationString != null && regionContent[j2] != null) {
                                            errorMessage = ((String)errorMessage).replace(locationString, regionContent[j2]);
                                        }
                                    }
                                }
                                ++j2;
                            }
                            int msgLen = ((String)errorMessage).length();
                            if (msgLen > 50000) {
                                errorMessage = ((String)errorMessage).substring(0, 30000) + "  ...stuff deleted here...  " + ((String)errorMessage).substring(msgLen - 20000, msgLen);
                            }
                            int j3 = 0;
                            while (j3 < props.length) {
                                props[j3].put("message", errorMessage);
                                this.model.setMarker((Map)props[j3], "org.lamport.tla.toolbox.tlc.modelErrorTLC");
                                markerInstalled = true;
                                ++j3;
                            }
                            if (!markerInstalled) {
                                Hashtable prop = ModelHelper.createMarkerDescription((String)errorMessage, (int)2);
                                this.model.setMarker((Map)prop, "org.lamport.tla.toolbox.tlc.modelErrorTLC");
                            }
                            topError.setMessage((String)errorMessage);
                            topError.setErrorCode(tlcRegion.getMessageCode());
                        }
                        catch (BadLocationException e) {
                            TLCUIActivator.getDefault().logError("Error parsing the error message", e);
                            mcFileDocumentProvider.disconnect((Object)mcFileEditorInput);
                            break block32;
                        }
                        catch (CoreException e) {
                            try {
                                TLCUIActivator.getDefault().logError("Error parsing the error message", e);
                                break block32;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                mcFileDocumentProvider.disconnect((Object)mcFileEditorInput);
                            }
                        }
                        mcFileDocumentProvider.disconnect((Object)mcFileEditorInput);
                    }
                }
                ++i;
            }
        }
        return topError;
    }

    public static synchronized void setDocumentText(final Document document, final String message, final boolean append) {
        UIHelper.runUIAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DocumentRewriteSession rewriteSession;
                    if (append && !TLCModelLaunchDataProvider.isDefaultLabel((IDocument)document)) {
                        rewriteSession = document.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                        document.replace(document.getLength(), 0, message + (message.endsWith(TLCModelLaunchDataProvider.CR) ? TLCModelLaunchDataProvider.EMPTY : TLCModelLaunchDataProvider.CR));
                    } else {
                        rewriteSession = document.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
                        document.replace(0, document.getLength(), message + (message.endsWith(TLCModelLaunchDataProvider.CR) ? TLCModelLaunchDataProvider.EMPTY : TLCModelLaunchDataProvider.CR));
                    }
                    document.stopRewriteSession(rewriteSession);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private static boolean isDefaultLabel(IDocument document) throws BadLocationException {
        return document.getLength() == NO_OUTPUT_AVAILABLE.length() && document.get(0, NO_OUTPUT_AVAILABLE.length()) != null && NO_OUTPUT_AVAILABLE.equals(document.get(0, NO_OUTPUT_AVAILABLE.length()));
    }

    protected boolean connectToSourceRegistry() {
        return TLCOutputSourceRegistry.getModelCheckSourceRegistry().connect(this);
    }

    public void addDataPresenter(ITLCModelLaunchDataPresenter presenter) {
        this.m_dataPresenters.add(presenter);
        this.populate();
    }

    public void removeDataPresenter(ITLCModelLaunchDataPresenter presenter) {
        this.m_dataPresenters.remove(presenter);
        this.populate();
    }

    public List<TLCError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<TLCError> errors) {
        this.errors = errors;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getFinishTimestamp() {
        return this.finishTimestamp;
    }

    public String getTLCMode() {
        return this.tlcMode;
    }

    public String getCoverageTimestamp() {
        return this.coverageTimestamp;
    }

    public void setCoverageTimestamp(String coverageTimestamp) {
        this.coverageTimestamp = coverageTimestamp;
    }

    public CoverageInformation getCoverageInfo() {
        return this.coverageInfo;
    }

    public boolean hasZeroCoverage() {
        return this.zeroCoverage;
    }

    public List<StateSpaceInformationItem> getProgressInformation() {
        return this.progressInformation;
    }

    public void setProgressInformation(List<StateSpaceInformationItem> progressInformation) {
        this.progressInformation = progressInformation;
    }

    public Document getUserOutput() {
        return this.userOutput;
    }

    public Document getProgressOutput() {
        return this.progressOutput;
    }

    public long getLastCheckpointTimeStamp() {
        return this.lastCheckpointTimeStamp;
    }

    public void setCurrentStatus(String currentStatus) {
        this.currentStatus = currentStatus;
    }

    public String getCurrentStatus() {
        return this.currentStatus;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void setFingerprintCollisionProbability(String fingerprintCollisionProbability) {
        this.fingerprintCollisionProbability = fingerprintCollisionProbability;
    }

    public String getFingerprintCollisionProbability() {
        return this.fingerprintCollisionProbability;
    }

    public String getCalcOutput() {
        return this.constantExprEvalOutput;
    }

    private String extractCollisionProbability(String outputMessage) {
        Matcher matcher = collisionProbabilityPattern.matcher(outputMessage);
        if (matcher.find()) {
            String optimistic = matcher.group(1);
            String actual = matcher.group(3);
            if (actual != null) {
                return String.format("calculated: %s  observed: %s", optimistic, actual);
            }
            return String.format("calculated: %s", optimistic);
        }
        return EMPTY;
    }

    protected String getModelName() {
        return this.getModel().getName();
    }

    public String toString() {
        return this.getModel().getSpec().getName() + "___" + this.getModelName();
    }

    public int getFPIndex() {
        return this.fpIndex;
    }

    public boolean isSymmetryWithLiveness() {
        return this.isSymmetryWithLiveness;
    }

    public boolean isConstraintsWithLiveness() {
        return this.isConstraintsWithLiveness;
    }

    public static Date parseDate(String str) {
        try {
            return SDF.parse(str);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static String formatInterval(long firstTS, long secondTS) {
        long interval = secondTS - firstTS;
        long hr = TimeUnit.MILLISECONDS.toHours(interval);
        long min = TimeUnit.MILLISECONDS.toMinutes(interval - TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(interval - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min));
        return String.format("%02d:%02d:%02d", hr, min, sec);
    }
}

