/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.handlers;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCModelFactory;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.util.ModelNameValidator;
import org.lamport.tla.toolbox.util.UIHelper;

public class CloneModelHandlerDelegate
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "toolbox.tool.tlc.commands.model.clone.delegate";
    public static final String PARAM_MODEL_NAME = "toolbox.tool.tlc.commands.model.clone.param.modelName";
    public static final String PARAM_FOREIGN_FULLY_QUALIFIED_MODEL_NAME = "toolbox.tool.tlc.commands.model.clone.param.foreignFullyQualifiedModelName";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean isForeignClone;
        TLCSpec spec = (TLCSpec)ToolboxHandle.getCurrentSpec().getAdapter(TLCSpec.class);
        Model model = null;
        String paramModelName = event.getParameter(PARAM_MODEL_NAME);
        String paramForeignModelName = event.getParameter(PARAM_FOREIGN_FULLY_QUALIFIED_MODEL_NAME);
        boolean bl = isForeignClone = paramForeignModelName != null;
        if (paramModelName != null) {
            model = spec.getModel(paramModelName);
        } else if (isForeignClone) {
            model = TLCModelFactory.getByName((String)paramForeignModelName);
        } else {
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (selection != null && selection instanceof IStructuredSelection) {
                model = (Model)((IStructuredSelection)selection).getFirstElement();
            }
        }
        if (model != null) {
            InputDialog dialog = new InputDialog(UIHelper.getShellProvider().getShell(), "Clone model...", "Please input the new name of the model", spec.getModelNameSuggestion(model), (IInputValidator)new ModelNameValidator((Spec)spec));
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                String chosenName = dialog.getValue();
                if (isForeignClone) {
                    if (model.copyIntoForeignSpec((Spec)spec, chosenName) == null) {
                        throw new ExecutionException("Failed to copy with name " + chosenName + " from model " + model.getName() + " in spec " + model.getSpec().getName());
                    }
                } else if (model.copy(chosenName) == null) {
                    throw new ExecutionException("Failed to copy with name " + chosenName + " from model " + model.getName());
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("toolbox.tool.tlc.commands.model.open.param", chosenName);
                UIHelper.runCommand((String)"toolbox.tool.tlc.commands.model.open", parameters);
            }
        }
        return null;
    }
}

