/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.part;

import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.BasicFormPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.IValidateble;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.provider.FormulaContentProvider;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.provider.FormulaLabelProvider;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.wizard.FormulaWizard;
import tlc2.model.Formula;

public class ValidateableTableSectionPart
extends SectionPart
implements IValidateble {
    private BasicFormPage page;
    protected TableViewer tableViewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    protected SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ValidateableTableSectionPart.this.buttonAdd) {
                ValidateableTableSectionPart.this.doAdd();
            } else if (source == ValidateableTableSectionPart.this.buttonRemove) {
                ValidateableTableSectionPart.this.doRemove();
            } else if (source == ValidateableTableSectionPart.this.buttonEdit) {
                ValidateableTableSectionPart.this.doEdit();
            }
        }
    };
    protected ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object source = event.getSource();
            if (source == ValidateableTableSectionPart.this.tableViewer) {
                ValidateableTableSectionPart.this.changeButtonEnablement();
            }
        }
    };

    public ValidateableTableSectionPart(Composite composite, String title, String description, FormToolkit toolkit, BasicFormPage page, String sectionName) {
        this(composite, title, description, toolkit, 384, page, sectionName);
    }

    public ValidateableTableSectionPart(Composite composite, String title, String description, FormToolkit toolkit, int sectionFlags, BasicFormPage page, String sectionName) {
        super(FormHelper.createSectionComposite(composite, title, description, toolkit, sectionFlags, null));
        this.page = page;
        page.getDataBindingManager().bindSection(this, sectionName, page.getId());
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.sectionInitialize(form.getToolkit());
    }

    public void commit(boolean onSave) {
        if (onSave) {
            super.commit(onSave);
        }
    }

    protected void sectionInitialize(FormToolkit toolkit) {
        Composite sectionArea = (Composite)this.getSection().getClient();
        sectionArea.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        this.getSection().setLayoutData((Object)gd);
        Table table = this.createTable(sectionArea, toolkit);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        table.setLayoutData((Object)gd);
        this.tableViewer = this.createTableViewer(table);
        this.createButtons(sectionArea, toolkit, true, true, true);
        this.changeButtonEnablement();
    }

    protected TableViewer createTableViewer(Table table) {
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        if ("gtk".equals(Platform.getWS())) {
            tableViewer.setLabelProvider((IBaseLabelProvider)new FormulaLabelProvider());
        }
        tableViewer.setContentProvider((IContentProvider)new FormulaContentProvider());
        tableViewer.addSelectionChangedListener(this.fSelectionChangedListener);
        tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ValidateableTableSectionPart.this.doEdit();
            }
        });
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ValidateableTableSectionPart.this.doCheck();
            }
        });
        return tableViewer;
    }

    protected Table createTable(Composite sectionArea, FormToolkit toolkit) {
        Table table = toolkit.createTable(sectionArea, 66338);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        return table;
    }

    protected void createButtons(Composite sectionArea, FormToolkit toolkit, boolean add, boolean edit, boolean remove) {
        this.doCreateButtons(sectionArea, toolkit, add, edit, remove);
    }

    protected void doCreateButtons(Composite sectionArea, FormToolkit toolkit, boolean add, boolean edit, boolean remove) {
        GridData gd;
        int added = 0;
        if (add) {
            this.buttonAdd = toolkit.createButton(sectionArea, "Add", 8);
            this.buttonAdd.addSelectionListener(this.fSelectionListener);
            gd = new GridData();
            gd.verticalAlignment = 128;
            gd.horizontalAlignment = 4;
            this.buttonAdd.setLayoutData((Object)gd);
            ++added;
        }
        if (edit) {
            this.buttonEdit = toolkit.createButton(sectionArea, "Edit", 8);
            this.buttonEdit.addSelectionListener(this.fSelectionListener);
            gd = new GridData();
            gd.verticalAlignment = 128;
            gd.horizontalAlignment = 4;
            this.buttonEdit.setLayoutData((Object)gd);
            ++added;
        }
        if (remove) {
            this.buttonRemove = toolkit.createButton(sectionArea, "Remove", 8);
            this.buttonRemove.addSelectionListener(this.fSelectionListener);
            gd = new GridData();
            gd.verticalAlignment = 128;
            gd.horizontalAlignment = 4;
            this.buttonRemove.setLayoutData((Object)gd);
            ++added;
        }
        if (added < 3) {
            Composite span = toolkit.createComposite(sectionArea);
            gd = new GridData();
            gd.verticalSpan = 3 - added;
            gd.verticalAlignment = 128;
            gd.horizontalAlignment = 4;
            span.setLayoutData((Object)gd);
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected void doRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Vector input = (Vector)this.tableViewer.getInput();
        input.removeAll(selection.toList());
        this.tableViewer.setInput((Object)input);
        this.doMakeDirty();
    }

    protected void doAdd() {
        Formula formula = this.doEditFormula(null);
        if (formula != null) {
            Vector input = (Vector)this.tableViewer.getInput();
            input.add(formula);
            this.tableViewer.setInput((Object)input);
            if (this.tableViewer instanceof CheckboxTableViewer) {
                ((CheckboxTableViewer)this.tableViewer).setChecked((Object)formula, true);
            }
            this.doMakeDirty();
        }
    }

    protected void doEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Formula formula = (Formula)selection.getFirstElement();
        Formula editedFormula = this.doEditFormula(formula);
        if (editedFormula != null) {
            formula.setFormula(editedFormula.getFormula());
            if (this.tableViewer instanceof CheckboxTableViewer) {
                ((CheckboxTableViewer)this.tableViewer).setChecked((Object)formula, true);
            }
            this.doMakeDirty();
            this.tableViewer.refresh();
        }
    }

    protected void doCheck() {
        this.doMakeDirty();
    }

    protected void changeButtonEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (this.buttonRemove != null) {
            this.buttonRemove.setEnabled(!selection.isEmpty());
        }
        if (this.buttonEdit != null) {
            this.buttonEdit.setEnabled(selection.size() == 1);
        }
    }

    protected Formula doEditFormula(Formula formula) {
        FormulaWizard wizard = new FormulaWizard(this.getSection().getText(), this.getSection().getDescription());
        wizard.setFormula(formula);
        WizardDialog dialog = new WizardDialog(this.getTableViewer().getTable().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            return wizard.getFormula();
        }
        return null;
    }

    protected void doMakeDirty() {
        this.validate();
        this.markDirty();
    }

    @Override
    public void validate() {
        this.page.validatePage(false);
    }
}

