/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.commons.notifications.core.INotificationService;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.editor.basic.TLAFastPartitioner;
import org.lamport.tla.toolbox.editor.basic.TLAPartitionScanner;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.ModelCoverage;
import org.lamport.tla.toolbox.tool.tlc.output.data.ActionInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageInformation;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageUINotification;
import org.lamport.tla.toolbox.tool.tlc.output.data.ITLCModelLaunchDataPresenter;
import org.lamport.tla.toolbox.tool.tlc.output.data.StateSpaceInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCError;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.contribution.DynamicContributionItem;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.DataBindingManager;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.TLACoverageEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.BasicFormPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.ErrorMessage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.MainModelPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.advanced.AdvancedTLCOptionsPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.CoverageLabelProvider;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.CoverageViewerComparator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.EvaluateConstantExpressionPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.StateSpaceLabelProvider;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.util.DirtyMarkingListener;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.util.RecordToSourceCoupler;
import org.lamport.tla.toolbox.tool.tlc.ui.view.TLCErrorView;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import org.lamport.tla.toolbox.util.FontPreferenceChangeListener;
import org.lamport.tla.toolbox.util.UIHelper;
import tlc2.model.Assignment;

public class ResultPage
extends BasicFormPage
implements Closeable,
ITLCModelLaunchDataPresenter {
    public static final String RESULT_PAGE_PROBLEM = "ResultPageProblem";
    public static final String ID = "resultPage";
    private static final Color ERROR_PANE_BACKGROUND = new Color((Device)PlatformUI.getWorkbench().getDisplay(), 255, 241, 237);
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("HH:mm:ss '('MMM d')'");
    private SourceViewer userOutput;
    private SourceViewer progressOutput;
    private Composite calculatorSection;
    private SourceViewer expressionEvalResult;
    private SourceViewer expressionEvalInput;
    private ValidateableSectionPart validateableCalculatorSection;
    private Button noBehaviorModeToggleButton;
    private Section generalSection;
    private int collapsedSectionHeight = 20;
    private long startTimestamp;
    private Composite generalTopPane;
    private Label startLabel;
    private Label lastCheckpointLabel;
    private Label finishLabel;
    private Label tlcSimulationLabel;
    private Label tlcSearchModeLabel;
    private Label tlcStatusLabel;
    private Composite generalErrorPane;
    private Hyperlink errorStatusHyperLink;
    private Label fingerprintCollisionLabel;
    private Text coverageTimestampText;
    private TableViewer coverage;
    private TableViewer stateSpace;
    private final Map<String, Section> sections = new HashMap<String, Section>();
    private final Lock disposeLock = new ReentrantLock(true);
    private FontPreferenceChangeListener fontChangeListener;
    private final IHyperlinkListener m_errorHyperLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            if (ResultPage.this.getModel() != null) {
                ResultPage.this.getModel().setOriginalTraceShown(true);
                TLCErrorView.updateErrorView(ResultPage.this.getModelEditor());
            }
        }
    };
    private IMarker incompleteStateExploration;
    private final INotificationService notificationService;
    private final ErrorPaneViewState errorPaneViewState;
    private final ArrayList<String> markedErrorMessages;

    static String getGraphTitleSuffix(ResultPage resultPage) {
        return "(" + resultPage.getModel().getName() + ")";
    }

    public ResultPage(FormEditor editor) {
        super(editor, ID, "Model Checking Results", "icons/full/results_page_[XXXXX].png");
        this.helpId = "resultModelPage";
        this.notificationService = NotificationsUi.getService();
        this.errorPaneViewState = new ErrorPaneViewState();
        this.markedErrorMessages = new ArrayList();
    }

    @Override
    public void modelCheckingWillBegin() {
        this.errorPaneViewState.clearState();
        this.markedErrorMessages.clear();
        this.getManagedForm().getMessageManager().removeAllMessages();
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            if (!this.tlcStatusLabel.isDisposed()) {
                this.tlcStatusLabel.setText("Starting...");
                this.errorStatusHyperLink.setVisible(this.errorPaneViewState.errorLinkIsDisplayed());
                this.fingerprintCollisionLabel.setVisible(this.errorPaneViewState.fingerprintIsDisplayed());
                this.setErrorPaneVisible(this.errorPaneViewState.shouldDisplay());
            }
        });
    }

    @Override
    public void modelChanged(TLCModelLaunchDataProvider dataProvider, int fieldId) {
        UIHelper.runUIAsync(() -> {
            block56: {
                this.disposeLock.lock();
                try {
                    if (this.getPartControl().isDisposed()) {
                        return;
                    }
                    switch (fieldId) {
                        case 1: {
                            this.userOutput.setDocument((IDocument)dataProvider.getUserOutput());
                            break;
                        }
                        case 2: {
                            this.progressOutput.setDocument((IDocument)dataProvider.getProgressOutput());
                            break;
                        }
                        case 4096: {
                            if (this.expressionEvalResult == null) break;
                            this.expressionEvalResult.getTextWidget().setText(dataProvider.getCalcOutput());
                            break;
                        }
                        case 4: {
                            this.setStartTime(dataProvider.getStartTimestamp());
                            break;
                        }
                        case 8: {
                            this.setEndTime(dataProvider.getFinishTimestamp());
                            long delta = dataProvider.getFinishTimestamp() - dataProvider.getStartTimestamp();
                            String duration = DurationFormatUtils.formatDuration((long)delta, (String)"HH'hrs' mm'mins' ss'sec'");
                            this.startLabel.setToolTipText(duration);
                            this.finishLabel.setToolTipText(duration);
                            break;
                        }
                        case 65536: {
                            this.setSearchMode(dataProvider.getTLCMode());
                            IFormPage iep = this.getEditor().findPage("AdvancedTLCOptionsPage");
                            if (iep != null) {
                                ((AdvancedTLCOptionsPage)iep).setFpIndex(dataProvider.getFPIndex());
                            } else {
                                this.getModel().setAttribute("fpIndex", dataProvider.getFPIndex());
                                this.getModelEditor().saveModel();
                            }
                        }
                        case 1024: {
                            this.setCheckpoint(dataProvider.getLastCheckpointTimeStamp());
                            break;
                        }
                        case 2048: {
                            this.tlcStatusLabel.setText(dataProvider.getCurrentStatus());
                            this.generalTopPane.layout(true, true);
                            break;
                        }
                        case 8192: {
                            String collisionText = dataProvider.getFingerprintCollisionProbability().trim();
                            if (collisionText.length() == 0) {
                                this.fingerprintCollisionLabel.setVisible(false);
                                this.errorPaneViewState.setFingerprintDisplay(false);
                                this.setErrorPaneVisible(this.errorPaneViewState.shouldDisplay());
                                break;
                            }
                            this.fingerprintCollisionLabel.setText("Fingerprint collision probability: " + collisionText);
                            this.fingerprintCollisionLabel.setVisible(true);
                            this.errorPaneViewState.setFingerprintDisplay(true);
                            this.setErrorPaneVisible(true);
                            break;
                        }
                        case 16: {
                            String coverageTimestamp = dataProvider.getCoverageTimestamp();
                            if ("".equals(coverageTimestamp)) {
                                this.coverageTimestampText.setText("");
                                break;
                            }
                            Date date = TLCModelLaunchDataProvider.parseDate(coverageTimestamp);
                            String interval = TLCModelLaunchDataProvider.formatInterval(this.getStartTimestamp(), date.getTime());
                            this.coverageTimestampText.setText(String.format("(at %s)", interval));
                            this.coverageTimestampText.setToolTipText("Time indicates the execution time at which the numbers were recorded");
                            break;
                        }
                        case 32: {
                            CoverageInformation coverageInfo = dataProvider.getCoverageInfo();
                            this.coverage.setInput((Object)coverageInfo);
                            break;
                        }
                        case 128: {
                            this.notificationService.notify(Collections.singletonList(new CoverageUINotification(this.getModelEditor())));
                        }
                        case 64: {
                            CoverageInformation ci = dataProvider.getCoverageInfo();
                            if (ci.isEmpty() || ci.isLegacy()) break;
                            try {
                                List modules = this.getModel().getSpec().getModules();
                                for (Module module : modules) {
                                    module.getResource().deleteMarkers("org.lamport.tla.toolbox.tlc.zerocoverage", false, 0);
                                }
                            }
                            catch (CoreException e) {
                                TLCUIActivator.getDefault().logError(e.getMessage(), e);
                            }
                            List<ActionInformationItem> zeroCoverageInformation = ci.getDisabledSpecActions();
                            for (ActionInformationItem item : zeroCoverageInformation) {
                                Module m = this.getModel().getSpec().getModule(item.getModule());
                                if (m == null) continue;
                                try {
                                    IMarker createMarker = m.getResource().createMarker("org.lamport.tla.toolbox.tlc.zerocoverage");
                                    createMarker.setAttribute("message", (Object)String.format("%s is never enabled.", item.getName()));
                                    createMarker.setAttribute("lineNumber", item.getModuleLocation().beginLine());
                                }
                                catch (CoreException e) {
                                    TLCUIActivator.getDefault().logError(e.getMessage(), e);
                                }
                            }
                            if (ModelCoverage.ACTION.equals((Object)this.getModel().getCoverage())) break;
                            ModelEditor modelEditor = (ModelEditor)this.getEditor();
                            List savedTLAFiles = modelEditor.getModel().getSavedTLAFiles();
                            for (IFile iFile : savedTLAFiles) {
                                if (!ci.has(iFile)) continue;
                                FileEditorInput input = new FileEditorInput(iFile);
                                IEditorPart[] findEditors = modelEditor.findEditors((IEditorInput)input);
                                try {
                                    if (findEditors.length == 0) {
                                        modelEditor.addPage((IEditorPart)new TLACoverageEditor(ci.projectionFor(iFile)), (IEditorInput)input);
                                        continue;
                                    }
                                    if (!(findEditors[0] instanceof TLACoverageEditor)) continue;
                                    TLACoverageEditor coverageEditor = (TLACoverageEditor)findEditors[0];
                                    coverageEditor.resetInput(ci.projectionFor(iFile));
                                }
                                catch (PartInitException e) {
                                    TLCUIActivator.getDefault().logError(e.getMessage(), e);
                                }
                            }
                            break;
                        }
                        case 256: {
                            this.stateSpace.setInput(dataProvider.getProgressInformation());
                            String suffix = ResultPage.getGraphTitleSuffix(this);
                            Shell[] shells = UIHelper.getCurrentDisplay().getShells();
                            int i = 0;
                            while (i < shells.length) {
                                if (shells[i].getText().endsWith(suffix)) {
                                    shells[i].redraw();
                                    shells[i].update();
                                }
                                ++i;
                            }
                            break;
                        }
                        case 131072: {
                            MainModelPage mmp;
                            Optional<Assignment> possibleSymmetrySet;
                            if (dataProvider.isSymmetryWithLiveness() && (possibleSymmetrySet = (mmp = (MainModelPage)this.getModelEditor().getFormPage("MainModelPage")).getConstants().stream().filter(c -> c.isSymmetricalSet()).findFirst()).isPresent()) {
                                Assignment symmetrySet = possibleSymmetrySet.get();
                                String errorMessage = String.format("%s %s", symmetrySet.getLabel(), "declared to be symmetric. Liveness checking under symmetry might fail to find a violation.");
                                this.getModelEditor().addErrorMessage(new ErrorMessage(errorMessage, symmetrySet.getLabel(), "MainModelPage", Arrays.asList("__what_is_the_model", "__what_to_check_properties"), "modelParameterConstants"));
                                Hashtable marker = ModelHelper.createMarkerDescription((String)errorMessage, (int)1);
                                this.getModel().setMarker((Map)marker, "org.lamport.tla.toolbox.tlc.modelErrorTLC");
                            }
                            if (!dataProvider.isConstraintsWithLiveness()) break;
                            String errorMessage = "Liveness checking with state or action constraints might fail to find a violation. Please read section 14.3.5 on page 247 of Specifying Systems (https://lamport.azurewebsites.net/tla/book.html) for more details.";
                            this.getModelEditor().addErrorMessage(new ErrorMessage("Liveness checking with state or action constraints might fail to find a violation. Please read section 14.3.5 on page 247 of Specifying Systems (https://lamport.azurewebsites.net/tla/book.html) for more details.", "StateConstraintWarning", "advancedModelPage", Arrays.asList("__state_constraints"), "modelParameterContraint"));
                            Hashtable marker = ModelHelper.createMarkerDescription((String)"Liveness checking with state or action constraints might fail to find a violation. Please read section 14.3.5 on page 247 of Specifying Systems (https://lamport.azurewebsites.net/tla/book.html) for more details.", (int)1);
                            this.getModel().setMarker((Map)marker, "org.lamport.tla.toolbox.tlc.modelErrorTLC");
                            break;
                        }
                        case 512: {
                            boolean visible;
                            Color color;
                            Object text;
                            int errorCount = dataProvider.getErrors().size();
                            switch (errorCount) {
                                case 0: {
                                    text = "No errors";
                                    color = TLCUIActivator.getColor(2);
                                    this.errorStatusHyperLink.removeHyperlinkListener(this.m_errorHyperLinkListener);
                                    visible = false;
                                    break;
                                }
                                case 1: {
                                    text = "1 Error";
                                    this.errorStatusHyperLink.addHyperlinkListener(this.m_errorHyperLinkListener);
                                    color = TLCUIActivator.getColor(3);
                                    visible = true;
                                    break;
                                }
                                default: {
                                    text = String.valueOf(errorCount) + " Errors";
                                    this.errorStatusHyperLink.addHyperlinkListener(this.m_errorHyperLinkListener);
                                    color = TLCUIActivator.getColor(3);
                                    visible = true;
                                }
                            }
                            if (visible) {
                                ModelEditor editor = (ModelEditor)this.getEditor();
                                MainModelPage mmp = (MainModelPage)editor.findPage("MainModelPage");
                                mmp.addGlobalTLCErrorMessage("resultPage_err_" + errorCount);
                            }
                            ArrayList<String> arrayList = this.markedErrorMessages;
                            synchronized (arrayList) {
                                for (TLCError error : dataProvider.getErrors()) {
                                    String message = error.getMessage();
                                    if (this.markedErrorMessages.contains(message)) continue;
                                    Hashtable marker = ModelHelper.createMarkerDescription((String)message, (int)2);
                                    this.getModel().setMarker((Map)marker, "org.lamport.tla.toolbox.tlc.modelErrorTLC");
                                    this.markedErrorMessages.add(message);
                                }
                            }
                            this.errorStatusHyperLink.setText((String)text);
                            this.errorStatusHyperLink.setForeground(color);
                            this.errorStatusHyperLink.setVisible(visible);
                            this.errorPaneViewState.setErrorLinkDisplay(visible);
                            this.setErrorPaneVisible(this.errorPaneViewState.shouldDisplay());
                            TLCErrorView.updateErrorView(this.getModelEditor());
                            break;
                        }
                    }
                    if (!(this.stateSpace.getLabelProvider() instanceof StateSpaceLabelProvider)) break block56;
                    StateSpaceLabelProvider sslp = (StateSpaceLabelProvider)this.stateSpace.getLabelProvider();
                    if (dataProvider.isDone() && dataProvider.getProgressInformation().size() > 0) {
                        long statesLeft = dataProvider.getProgressInformation().get(0).getLeftStates();
                        if (statesLeft > 0L) {
                            sslp.setHighlightUnexplored();
                            if (this.incompleteStateExploration == null) {
                                Hashtable marker = ModelHelper.createMarkerDescription((String)"State space exploration incomplete", (int)1);
                                marker.put("basicFormPageId", ID);
                                this.incompleteStateExploration = this.getModel().setMarker((Map)marker, "org.lamport.tla.toolbox.tlc.modelErrorTLC");
                            }
                        } else {
                            if (this.incompleteStateExploration != null) {
                                try {
                                    this.incompleteStateExploration.delete();
                                    this.resetMessage(RESULT_PAGE_PROBLEM);
                                    this.incompleteStateExploration = null;
                                }
                                catch (CoreException e) {
                                    TLCUIActivator.getDefault().logError(e.getMessage(), e);
                                }
                            }
                            sslp.unsetHighlightUnexplored();
                        }
                    }
                    this.stateSpace.refresh();
                }
                finally {
                    this.disposeLock.unlock();
                }
            }
        });
    }

    public void setFocus() {
        if (this.expressionEvalInput != null && !this.expressionEvalInput.getTextWidget().isDisposed() && !this.expressionEvalInput.getTextWidget().isFocusControl()) {
            StyledText st = this.expressionEvalInput.getTextWidget();
            int caretOffset = st.getText().length();
            st.setFocus();
            Runnable ohSWT = () -> {
                try {
                    Thread.sleep(75L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!st.isDisposed()) {
                    st.getDisplay().asyncExec(() -> {
                        if (!st.isDisposed()) {
                            st.setCaretOffset(caretOffset);
                        }
                    });
                }
            };
            new Thread(ohSWT).start();
        }
    }

    @Override
    public void loadData() throws CoreException {
        TLCOutputSourceRegistry modelCheckSourceRegistry = TLCOutputSourceRegistry.getModelCheckSourceRegistry();
        TLCModelLaunchDataProvider provider = modelCheckSourceRegistry.getProvider(this.getModel());
        if (provider != null) {
            provider.addDataPresenter(this);
        } else {
            this.reinit();
        }
        Document document = new Document(this.getModel().getEvalExpression());
        TLAFastPartitioner partitioner = new TLAFastPartitioner(TLAEditorActivator.getDefault().getTLAPartitionScanner(), TLAPartitionScanner.TLA_PARTITION_TYPES);
        document.setDocumentPartitioner("__tla_partitioning", (IDocumentPartitioner)partitioner);
        partitioner.connect((IDocument)document);
        if (this.expressionEvalInput != null) {
            this.expressionEvalInput.setDocument((IDocument)document);
        }
    }

    private synchronized void reinit() {
        this.disposeLock.lock();
        try {
            if (this.getPartControl().isDisposed()) {
                return;
            }
            this.startTimestamp = 0L;
            this.startLabel.setText("");
            this.lastCheckpointLabel.setText("");
            this.finishLabel.setText("");
            this.tlcSimulationLabel.setVisible(false);
            this.tlcSearchModeLabel.setText("");
            this.tlcStatusLabel.setText("Not running");
            this.errorStatusHyperLink.setText("No errors");
            this.errorStatusHyperLink.setVisible(false);
            this.fingerprintCollisionLabel.setText("");
            this.fingerprintCollisionLabel.setVisible(false);
            this.coverage.setInput(new Vector());
            this.stateSpace.setInput(new Vector());
            this.progressOutput.setDocument((IDocument)new Document("No output is available"));
            this.userOutput.setDocument((IDocument)new Document("No output is available"));
            this.setErrorPaneVisible(false);
            this.generalTopPane.layout(true, true);
        }
        finally {
            this.disposeLock.unlock();
        }
    }

    @Override
    public void dispose() {
        this.disposeLock.lock();
        try {
            try {
                TLCModelLaunchDataProvider provider;
                String suffix = ResultPage.getGraphTitleSuffix(this);
                Shell[] shells = UIHelper.getCurrentDisplay().getShells();
                int i = 0;
                while (i < shells.length) {
                    if (shells[i].getText().endsWith(suffix)) {
                        shells[i].dispose();
                    }
                    ++i;
                }
                if (this.incompleteStateExploration != null) {
                    this.incompleteStateExploration.delete();
                    this.incompleteStateExploration = null;
                }
                JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.fontChangeListener);
                Model model = this.getModel();
                TLCOutputSourceRegistry modelCheckSourceRegistry = TLCOutputSourceRegistry.getModelCheckSourceRegistry();
                if (modelCheckSourceRegistry.hasProvider(model) && (provider = modelCheckSourceRegistry.getProvider(model)) != null) {
                    provider.removeDataPresenter(this);
                }
                super.dispose();
            }
            catch (CoreException e) {
                e.printStackTrace();
                this.disposeLock.unlock();
            }
        }
        finally {
            this.disposeLock.unlock();
        }
    }

    @Override
    protected Layout getBodyLayout() {
        return FormHelper.createFormTableWrapLayout(true, 1);
    }

    @Override
    protected void createBodyContent(IManagedForm managedForm) {
        int sectionFlags = 452;
        int textFieldFlags = 66378;
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        body.setLayout((Layout)gl);
        this.generalSection = FormHelper.createSectionComposite(body, "General", "", toolkit, 324, null);
        this.sections.put("__general", this.generalSection);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.generalSection.setLayoutData((Object)gd);
        GeneralSectionExpansionHoopJumper absurdListener = new GeneralSectionExpansionHoopJumper();
        this.generalSection.addExpansionListener((IExpansionListener)absurdListener);
        this.generalSection.setData("_why_oh_why_..._sigh", (Object)absurdListener);
        Composite generalArea = (Composite)this.generalSection.getClient();
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 6;
        generalArea.setLayout((Layout)gl);
        this.generalTopPane = new Composite(generalArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.generalTopPane.setLayoutData((Object)gd);
        gl = new GridLayout(6, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 12;
        this.generalTopPane.setLayout((Layout)gl);
        this.startLabel = new Label(this.generalTopPane, 0);
        this.startLabel.setLayoutData((Object)new GridData());
        this.startLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        this.lastCheckpointLabel = new Label(this.generalTopPane, 0);
        this.lastCheckpointLabel.setLayoutData((Object)new GridData());
        this.finishLabel = new Label(this.generalTopPane, 0);
        this.finishLabel.setLayoutData((Object)new GridData());
        this.finishLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        this.tlcSimulationLabel = new Label(this.generalTopPane, 0);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        this.tlcSimulationLabel.setLayoutData((Object)gd);
        this.tlcSimulationLabel.setText("Simulation mode");
        this.tlcSimulationLabel.setVisible(false);
        this.tlcSimulationLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont"));
        this.tlcSearchModeLabel = new Label(this.generalTopPane, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        this.tlcSearchModeLabel.setLayoutData((Object)gd);
        this.tlcStatusLabel = new Label(this.generalTopPane, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 18;
        this.tlcStatusLabel.setLayoutData((Object)gd);
        this.tlcStatusLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        this.generalErrorPane = new Composite(generalArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalIndent = 9;
        gd.verticalAlignment = 128;
        this.generalErrorPane.setLayoutData((Object)gd);
        gl = new GridLayout(3, false);
        gl.marginHeight = 6;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 6;
        this.generalErrorPane.setLayout((Layout)gl);
        this.generalErrorPane.setBackground(ERROR_PANE_BACKGROUND);
        this.errorStatusHyperLink = toolkit.createHyperlink(this.generalErrorPane, "", 0);
        this.errorStatusHyperLink.setBackground(this.generalErrorPane.getBackground());
        this.errorStatusHyperLink.setVisible(false);
        this.fingerprintCollisionLabel = new Label(this.generalErrorPane, 0);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        this.fingerprintCollisionLabel.setLayoutData((Object)gd);
        this.fingerprintCollisionLabel.setVisible(false);
        this.setErrorPaneVisible(false);
        Section section = FormHelper.createSpaceGrabbingSectionComposite(body, "Statistics", "", toolkit, 356, this.getExpansionListener());
        this.sections.put("__coverage", section);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        Composite statArea = (Composite)section.getClient();
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        statArea.setLayout((Layout)gl);
        int heightGuidance = this.getHeightGuidanceForLabelTextFieldLine(statArea, toolkit);
        this.createAndSetupStateSpace(statArea, toolkit, heightGuidance);
        this.createAndSetupCoverage(statArea, toolkit, heightGuidance);
        IPreferenceStore ips = TLCUIActivator.getDefault().getPreferenceStore();
        boolean eceInItsOwnTab = ips.getBoolean("showECEAsTab");
        this.calculatorSection = new Composite(body, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = !eceInItsOwnTab;
        this.calculatorSection.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.calculatorSection.setLayout((Layout)gl);
        this.calculatorSection.setBackground(this.calculatorSection.getDisplay().getSystemColor(1));
        if (!eceInItsOwnTab) {
            this.pageShouldDisplayEvaluateConstantUI(true);
        }
        section = FormHelper.createSpaceGrabbingSectionComposite(body, "User Output", "TLC output generated by evaluating Print and PrintT expressions.", toolkit, 452, this.getExpansionListener());
        this.sections.put("__output", section);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        Composite outputArea = (Composite)section.getClient();
        outputArea.setLayout((Layout)new GridLayout(1, false));
        this.userOutput = FormHelper.createFormsOutputViewer(toolkit, outputArea, 66378);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.minimumWidth = 360;
        gd.minimumHeight = 120;
        gd.widthHint = 400;
        this.userOutput.getTextWidget().setLayoutData((Object)gd);
        this.userOutput.getTextWidget().setFont(JFaceResources.getFont((String)"org.lamport.tla.toolbox.tool.tlc.ui.tlcOutputFont"));
        section = FormHelper.createSpaceGrabbingSectionComposite(body, "Progress Output", "  ", toolkit, 388, this.getExpansionListener());
        this.sections.put("__progress", section);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gd);
        Composite progressArea = (Composite)section.getClient();
        progressArea.setLayout((Layout)new GridLayout(1, false));
        this.progressOutput = FormHelper.createFormsOutputViewer(toolkit, progressArea, 66378);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.minimumWidth = 360;
        gd.minimumHeight = 120;
        gd.widthHint = 400;
        this.progressOutput.getTextWidget().setLayoutData((Object)gd);
        this.progressOutput.getTextWidget().setFont(JFaceResources.getFont((String)"org.lamport.tla.toolbox.tool.tlc.ui.tlcOutputFont"));
        Vector<Control> controls = new Vector<Control>();
        controls.add(this.userOutput.getControl());
        controls.add(this.progressOutput.getControl());
        this.fontChangeListener = new FontPreferenceChangeListener(controls, "org.lamport.tla.toolbox.tool.tlc.ui.tlcOutputFont");
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.fontChangeListener);
        this.headClientTBM.add((IContributionItem)new DynamicContributionItem((IAction)new LoadOutputAction()));
    }

    @Override
    public void commit(boolean onSave) {
        if (this.expressionEvalInput != null) {
            String expression = this.expressionEvalInput.getDocument().get();
            this.getModel().unsavedSetEvalExpression(expression);
        }
        super.commit(onSave);
    }

    private void setStartTime(long msTime) {
        this.startTimestamp = msTime;
        if (msTime < 0L) {
            this.startLabel.setText("Awaiting first run...");
        } else {
            this.startLabel.setText("Start: " + DATE_FORMATTER.format(new Date(msTime)));
        }
        this.generalTopPane.layout(true, true);
    }

    private void setEndTime(long msTime) {
        if (msTime < 0L) {
            this.finishLabel.setVisible(false);
        } else {
            this.finishLabel.setText("End: " + DATE_FORMATTER.format(new Date(msTime)));
            this.finishLabel.setVisible(true);
        }
        this.generalTopPane.layout(true, true);
    }

    private void setCheckpoint(long msTime) {
        if (msTime < 0L) {
            this.lastCheckpointLabel.setVisible(false);
        } else {
            this.lastCheckpointLabel.setText("Last checkpoint: " + DATE_FORMATTER.format(new Date(msTime)));
            this.lastCheckpointLabel.setVisible(true);
        }
        this.generalTopPane.layout(true, true);
    }

    private void setSearchMode(String mode) {
        if ("Depth-first search".equals(mode)) {
            this.tlcSearchModeLabel.setText("Depth-first search");
            this.tlcSearchModeLabel.setVisible(true);
            this.tlcSimulationLabel.setVisible(false);
        } else {
            this.tlcSearchModeLabel.setVisible(false);
            this.tlcSimulationLabel.setVisible("Simulation".equals(mode));
        }
        this.generalTopPane.layout(true, true);
    }

    private void setErrorPaneVisible(boolean visible) {
        GridData gd = (GridData)this.generalErrorPane.getLayoutData();
        gd.exclude = !visible;
        this.generalErrorPane.setLayoutData((Object)gd);
        this.generalErrorPane.setVisible(visible);
    }

    private int getHeightGuidanceForLabelTextFieldLine(Composite parent, FormToolkit toolkit) {
        Label l = toolkit.createLabel(parent, "Just Some Concerned Text you get");
        Text t = toolkit.createText(parent, "More time text 12345:67890", 0x800000);
        int height = Math.max(t.computeSize((int)-1, (int)-1).y, l.computeSize((int)-1, (int)-1).y);
        l.dispose();
        t.dispose();
        return height;
    }

    private Composite createAndSetupStateSpace(Composite parent, FormToolkit toolkit, int headerHeight) {
        Composite statespaceComposite = toolkit.createComposite(parent, 64);
        GridLayout gl = new GridLayout(1, false);
        gl.marginTop = 0;
        gl.marginBottom = 3;
        gl.marginWidth = 0;
        statespaceComposite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        statespaceComposite.setLayoutData((Object)gd);
        Label title = toolkit.createLabel(statespaceComposite, "State space progress (click column header for graph)");
        gd = new GridData();
        gd.heightHint = headerHeight + 2;
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 6;
        title.setLayoutData((Object)gd);
        Composite tableComposite = new Composite(statespaceComposite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        Table stateTable = toolkit.createTable(tableComposite, 68098);
        StateSpaceLabelProvider sslp = new StateSpaceLabelProvider(this);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        gd.minimumWidth = sslp.getMinimumTotalWidth();
        gd.minimumHeight = 100;
        tableComposite.setLayoutData((Object)gd);
        stateTable.setHeaderVisible(true);
        stateTable.setLinesVisible(true);
        sslp.createTableColumns(stateTable, this, tableColumnLayout);
        this.stateSpace = new TableViewer(stateTable);
        this.stateSpace.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement != null && inputElement instanceof List) {
                    return ((List)inputElement).toArray(new Object[((List)inputElement).size()]);
                }
                return null;
            }
        });
        this.stateSpace.setLabelProvider((IBaseLabelProvider)sslp);
        this.getSite().setSelectionProvider((ISelectionProvider)this.stateSpace);
        return statespaceComposite;
    }

    private Composite createAndSetupCoverage(Composite parent, FormToolkit toolkit, int headerHeight) {
        Composite coverageComposite = toolkit.createComposite(parent, 64);
        GridLayout gl = new GridLayout(1, false);
        gl.marginTop = 0;
        gl.marginBottom = 3;
        gl.marginWidth = 0;
        coverageComposite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        coverageComposite.setLayoutData((Object)gd);
        Composite headerLine = toolkit.createComposite(coverageComposite, 64);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        headerLine.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        headerLine.setLayoutData((Object)gd);
        Label title = toolkit.createLabel(headerLine, "Sub-actions of next-state");
        gd = new GridData();
        gd.horizontalIndent = 0;
        gd.verticalIndent = 6;
        gd.heightHint = headerHeight + 2;
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 1024;
        title.setLayoutData((Object)gd);
        this.coverageTimestampText = toolkit.createText(headerLine, "", 0x800000);
        this.coverageTimestampText.setEditable(false);
        this.coverageTimestampText.setMessage("(No numbers recorded yet. Has profiling been enabled on TLC options?)");
        gd = new GridData();
        gd.horizontalIndent = 6;
        gd.verticalIndent = 0;
        gd.minimumWidth = 150;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.coverageTimestampText.setLayoutData((Object)gd);
        Composite tableComposite = new Composite(coverageComposite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        Table coverageTable = toolkit.createTable(tableComposite, 68098);
        CoverageLabelProvider clp = new CoverageLabelProvider();
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        gd.minimumWidth = clp.getMinimumTotalWidth();
        gd.heightHint = 100;
        tableComposite.setLayoutData((Object)gd);
        coverageTable.setHeaderVisible(true);
        coverageTable.setLinesVisible(true);
        coverageTable.setToolTipText("Click on a row to go to action.");
        clp.createTableColumns(coverageTable, tableColumnLayout);
        this.coverage = new TableViewer(coverageTable);
        this.coverage.getTable().addMouseListener((MouseListener)new RecordToSourceCoupler((Viewer)this.coverage));
        this.coverage.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement != null && inputElement instanceof List) {
                    return ((List)inputElement).toArray(new Object[((List)inputElement).size()]);
                }
                if (inputElement instanceof CoverageInformation) {
                    return ((CoverageInformation)inputElement).getSpecActions().toArray();
                }
                return null;
            }
        });
        this.coverage.setLabelProvider((IBaseLabelProvider)clp);
        this.coverage.setComparator((ViewerComparator)new CoverageViewerComparator());
        TableColumn[] tableColumnArray = this.coverage.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.addListener(13, e -> {
                TableColumn sortColumn = this.coverage.getTable().getSortColumn();
                int direction = this.coverage.getTable().getSortDirection();
                if (column.equals(sortColumn)) {
                    direction = direction == 128 ? 1024 : 128;
                } else {
                    this.coverage.getTable().setSortColumn(column);
                    direction = 128;
                }
                this.coverage.getTable().setSortDirection(direction);
                this.coverage.refresh();
            });
            ++n2;
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.coverage);
        return coverageComposite;
    }

    long getStartTimestamp() {
        return this.startTimestamp;
    }

    TableViewer getStateSpaceTableViewer() {
        return this.stateSpace;
    }

    public StateSpaceInformationItem[] getStateSpaceInformation() {
        List infoList = (List)this.stateSpace.getInput();
        StateSpaceInformationItem[] result = new StateSpaceInformationItem[infoList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (StateSpaceInformationItem)infoList.get(result.length - i - 1);
            ++i;
        }
        return result;
    }

    public Set<Section> getSections(String ... sectionIDs) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(sectionIDs));
        return this.sections.entrySet().stream().filter(e -> set.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public EvaluateConstantExpressionPage.State getECEContent() {
        if (this.expressionEvalInput != null) {
            return new EvaluateConstantExpressionPage.State(this.expressionEvalInput.getDocument(), this.expressionEvalResult.getTextWidget().getText(), this.noBehaviorModeToggleButton.getSelection());
        }
        return null;
    }

    public void setECEContent(EvaluateConstantExpressionPage.State state) {
        if (this.expressionEvalInput == null) {
            TLCUIActivator.getDefault().logError("Can't set ECE content on null objects.");
        } else {
            this.expressionEvalInput.setDocument(state.getInputDocument());
            this.expressionEvalResult.getTextWidget().setText(state.getOutputText());
            this.noBehaviorModeToggleButton.setSelection(state.getToggleState());
        }
    }

    public void setNoBehaviorSpecToggleState(boolean selected) {
        if (this.noBehaviorModeToggleButton != null) {
            this.noBehaviorModeToggleButton.setSelection(selected);
        }
    }

    public void pageShouldDisplayEvaluateConstantUI(boolean shouldShow) {
        IManagedForm managedForm = this.getManagedForm();
        if (shouldShow) {
            FormToolkit toolkit = managedForm.getToolkit();
            int sectionFlags = 324;
            int textFieldFlags = 66122;
            EvaluateConstantExpressionPage.BodyContentAssets assets = EvaluateConstantExpressionPage.createBodyContent(this.calculatorSection, toolkit, 324, 66122, this.getExpansionListener(), (ModelEditor)this.getEditor());
            final Section section = assets.getSection();
            this.sections.put("__expression", section);
            this.expressionEvalInput = assets.getExpressionInput();
            this.expressionEvalResult = assets.getExpressionOutput();
            this.noBehaviorModeToggleButton = assets.getToggleButton();
            this.validateableCalculatorSection = new ValidateableSectionPart(section, this, "__expression");
            managedForm.addPart((IFormPart)this.validateableCalculatorSection);
            this.expressionEvalInput.getTextWidget().addModifyListener((ModifyListener)new DirtyMarkingListener((AbstractFormPart)this.validateableCalculatorSection, false));
            this.getDataBindingManager().bindAttribute("modelExpressionEval", this.expressionEvalInput, this.validateableCalculatorSection);
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    if (e.getState()) {
                        GridData gd = new GridData();
                        gd.horizontalAlignment = 4;
                        gd.verticalAlignment = 4;
                        gd.grabExcessHorizontalSpace = true;
                        gd.grabExcessVerticalSpace = true;
                        ResultPage.this.calculatorSection.setLayoutData((Object)gd);
                    } else {
                        GridData gd = (GridData)ResultPage.this.calculatorSection.getLayoutData();
                        Point size = section.computeSize(-1, -1);
                        gd.grabExcessVerticalSpace = e.getState();
                        gd.heightHint = size.y;
                        ResultPage.this.calculatorSection.setLayoutData((Object)gd);
                    }
                }
            });
        } else if (this.validateableCalculatorSection != null) {
            this.sections.remove("__expression");
            managedForm.removePart((IFormPart)this.validateableCalculatorSection);
            this.validateableCalculatorSection = null;
            this.expressionEvalInput = null;
            this.expressionEvalResult = null;
            this.noBehaviorModeToggleButton = null;
            Control[] controlArray = this.calculatorSection.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            this.getDataBindingManager().unbindSectionFromPage("__expression", this.getId());
        }
        GridData gd = (GridData)this.calculatorSection.getLayoutData();
        gd.grabExcessVerticalSpace = shouldShow;
        this.calculatorSection.setLayoutData((Object)gd);
        this.getManagedForm().reflow(true);
    }

    @Override
    public void close() throws IOException {
        this.getModelEditor().resultsPageIsClosing();
        DataBindingManager dm = this.getDataBindingManager();
        dm.unbindSectionAndAttribute("modelExpressionEval");
        dm.unbindSectionFromPage("__expression", this.getId());
    }

    static class ErrorPaneViewState {
        private final AtomicBoolean m_displayErrorLink = new AtomicBoolean(false);
        private final AtomicBoolean m_displayFingerprint = new AtomicBoolean(false);
        private final AtomicBoolean m_displayZeroCount = new AtomicBoolean(false);

        ErrorPaneViewState() {
        }

        void setErrorLinkDisplay(boolean display) {
            this.m_displayErrorLink.set(display);
        }

        boolean errorLinkIsDisplayed() {
            return this.m_displayErrorLink.get();
        }

        void setFingerprintDisplay(boolean display) {
            this.m_displayFingerprint.set(display);
        }

        boolean fingerprintIsDisplayed() {
            return this.m_displayFingerprint.get();
        }

        void clearState() {
            this.m_displayErrorLink.set(false);
            this.m_displayFingerprint.set(false);
            this.m_displayZeroCount.set(false);
        }

        boolean shouldDisplay() {
            return this.m_displayErrorLink.get() || this.m_displayFingerprint.get() || this.m_displayZeroCount.get();
        }
    }

    private class GeneralSectionExpansionHoopJumper
    extends ExpansionAdapter
    implements Consumer<Boolean> {
        private GeneralSectionExpansionHoopJumper() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            this.accept(e.getState());
        }

        @Override
        public void accept(Boolean expand) {
            if (expand.booleanValue()) {
                Composite c = (Composite)ResultPage.this.generalSection.getClient();
                GridData gd = (GridData)ResultPage.this.generalSection.getLayoutData();
                gd.heightHint = ResultPage.this.collapsedSectionHeight + c.computeSize((int)-1, (int)-1).y;
                ResultPage.this.generalSection.setLayoutData((Object)gd);
                ResultPage.this.generalSection.getParent().layout(true, true);
            } else {
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.verticalAlignment = 128;
                ResultPage.this.generalSection.setLayoutData((Object)gd);
                ResultPage.this.collapsedSectionHeight = ResultPage.this.generalSection.computeSize((int)-1, (int)-1).y;
            }
        }
    }

    class LoadOutputAction
    extends Action {
        public LoadOutputAction() {
            super("Load output", TLCUIActivator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox.tool.tlc.ui", (String)"icons/full/copy_edit.gif"));
            this.setDescription("Loads the output from an external model run (requires \"-tool\" parameter) corresponding to this model.");
            this.setToolTipText("Loads an existing output (e.g. from a standlone TLC run that corresponds to this model). Output has to contain tool markers. Run TLC with \"-tool\" command line parameter.\t");
        }

        public void run() {
            FileDialog fileDialog = new FileDialog(new Shell());
            final String path = fileDialog.open();
            if (path == null) {
                return;
            }
            WorkspaceJob j = new WorkspaceJob("Loading output file..."){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        TLCOutputSourceRegistry modelCheckSourceRegistry = TLCOutputSourceRegistry.getModelCheckSourceRegistry();
                        modelCheckSourceRegistry.removeTLCStatusSource(new Model[]{ResultPage.this.getModel()});
                        ResultPage.this.getModel().createModelOutputLogFile((InputStream)new FileInputStream(new File(path)), monitor);
                        UIJob job = new UIJob("Updating results page with loaded output..."){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                try {
                                    ResultPage.this.loadData();
                                }
                                catch (CoreException e) {
                                    return new Status(4, "org.lamport.tla.toolbox.tool.tlc.ui", e.getMessage(), (Throwable)e);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                    catch (FileNotFoundException e) {
                        return new Status(4, "org.lamport.tla.toolbox.tool.tlc.ui", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            j.setRule(workspace.getRuleFactory().buildRule());
            j.schedule();
        }

        public boolean isEnabled() {
            if (ResultPage.this.getModel().isRunning()) {
                return false;
            }
            return super.isEnabled();
        }
    }
}

