/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.dialog;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtraModulesDialog
extends Dialog {
    private CheckboxTableViewer tableViewer;
    private final Set<String> modules;
    private final Set<String> selection;

    public ExtraModulesDialog(Shell parentShell, Set<String> modules, Set<String> previouslySelectedModuleNames) {
        super(parentShell);
        this.modules = modules;
        this.selection = previouslySelectedModuleNames;
    }

    public Set<String> getSelection() {
        return this.selection;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 9;
        container.setLayout((Layout)gl);
        Label l = new Label(container, 16384);
        l.setText("Selected modules to be made available in trace expressions.");
        l.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2564);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        this.tableViewer.setInput(this.modules);
        this.selection.stream().forEach(element -> {
            boolean bl = this.tableViewer.setChecked(element, true);
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 333;
        this.tableViewer.getTable().setLayoutData((Object)gd);
        Composite buttonPane = new Composite(container, 0);
        gl = new GridLayout(1, false);
        buttonPane.setLayout((Layout)gl);
        Button b = new Button(buttonPane, 8);
        b.setText("Select All");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ExtraModulesDialog.this.tableViewer.setAllChecked(true);
            }
        });
        b = new Button(buttonPane, 8);
        b.setText("Deselect All");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ExtraModulesDialog.this.tableViewer.setAllChecked(false);
            }
        });
        return container;
    }

    protected void okPressed() {
        this.selection.clear();
        Arrays.stream(this.tableViewer.getCheckedElements()).forEach(element -> {
            boolean bl = this.selection.add((String)element);
        });
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Extra Modules");
    }
}

