/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.util.UIHelper;

public class StartLaunchHandler
extends AbstractHandler {
    private ModelEditor lastModelEditor;
    private boolean m_isEnabled = false;

    public void setEnabled(Object evaluationContext) {
        ModelEditor modelEditor = this.getModelEditor((IEvaluationContext)evaluationContext);
        this.m_isEnabled = modelEditor != null;
    }

    public boolean isEnabled() {
        return this.m_isEnabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Map models;
        TLCSpec spec;
        ModelEditor modelEditor = this.getModelEditor(event);
        if (modelEditor == null && (spec = (TLCSpec)ToolboxHandle.getCurrentSpec().getAdapter(TLCSpec.class)) != null && (models = spec.getModels()).size() == 1) {
            Model model = models.values().toArray(new Model[1])[0];
            modelEditor = (ModelEditor)UIHelper.openEditor((String)"org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor", (IFile)model.getFile());
        }
        if (modelEditor != null) {
            IEditorReference[] editors;
            Model model = modelEditor.getModel();
            if (model.isRunning()) {
                return null;
            }
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
            IEditorReference[] iEditorReferenceArray = editors = site.getPage().getEditorReferences();
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                if ("org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer".equals(ref.getId()) && ref.isDirty()) {
                    String title = ref.getName();
                    boolean save = MessageDialog.openQuestion((Shell)shell, (String)("Save " + title + " spec?"), (String)("The spec " + title + " has not been saved, should the spec be saved prior to launching?"));
                    if (save) {
                        ref.getEditor(true).doSave((IProgressMonitor)new NullProgressMonitor());
                        try {
                            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (OperationCanceledException e) {
                            throw new ExecutionException(e.getMessage(), (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            throw new ExecutionException(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        return null;
                    }
                }
                ++n2;
            }
            if (modelEditor.isDirty()) {
                modelEditor.doSaveWithoutValidating((IProgressMonitor)new NullProgressMonitor());
            }
            if (model.isStale()) {
                boolean unlock = MessageDialog.openQuestion((Shell)shell, (String)"Repair model?", (String)"The current model is stale and has to be repaird prior to launching. Should the model be repaired now?");
                if (unlock) {
                    model.recover();
                } else {
                    return null;
                }
            }
            modelEditor.launchModel("modelcheck", true);
        }
        return null;
    }

    private ModelEditor getModelEditor(ExecutionEvent event) {
        return this.getModelEditor((IEvaluationContext)event.getApplicationContext());
    }

    private ModelEditor getModelEditor(IEvaluationContext context) {
        String id;
        Object variable = context.getVariable("activeEditorId");
        String string = id = variable != IEvaluationContext.UNDEFINED_VARIABLE ? (String)variable : null;
        if (id != null && id.startsWith("org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor") && (variable = context.getVariable("activeEditor")) instanceof IEditorPart) {
            this.lastModelEditor = (ModelEditor)((Object)variable);
        }
        if (this.lastModelEditor == null) {
            IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)context.getVariable("activeWorkbenchWindow");
            IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
            int n = iWorkbenchPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n3 = iEditorReferenceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference editorRefs = iEditorReferenceArray[n4];
                    if (editorRefs.getId().equals("org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor")) {
                        this.lastModelEditor = (ModelEditor)editorRefs.getEditor(true);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (this.lastModelEditor != null && this.lastModelEditor.isDisposed()) {
            this.lastModelEditor = null;
        }
        return this.lastModelEditor;
    }
}

