/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCError;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCState;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariable;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.traceexplorer.TraceExplorerComposite;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.dialog.ErrorViewTraceFilterDialog;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.TLACoverageEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.util.ExpandableSpaceReclaimer;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.util.RecordToSourceCoupler;
import org.lamport.tla.toolbox.tool.tlc.ui.util.TLCUIHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.view.ErrorTraceTreeViewer;
import org.lamport.tla.toolbox.util.FontPreferenceChangeListener;
import org.lamport.tla.toolbox.util.UIHelper;

public class TLCErrorView
extends ViewPart {
    public static final String ID = "toolbox.tool.tlc.view.TLCErrorView";
    static final String JFACE_ERROR_TRACE_ID = "org.lamport.tla.toolbox.tool.tlc.ui.tlcErrorTraceFont_private";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("MMM dd,yyyy HH:mm:ss");
    private static final String CELL_TEXT_PROTOTYPE = "{|qgyA!#93^<[?";
    private static final String INNER_WEIGHTS_KEY = "INNER_WEIGHTS_KEY";
    private static final String OUTER_WEIGHTS_KEY = "OUTER_WEIGHTS_KEY";
    private static final String MID_WEIGHTS_KEY = "MID_WEIGHTS_KEY";
    private static final String SYNCED_TRAVERSAL_KEY = "SYNCED_TRAVERSAL_KEY";
    private static final String NO_VALUE_VIEWER_TEXT = "\u2022 Select a line in Error Trace to show its value here.\n\u2022 Double+Click on a line to go to corresponding action in spec \u2014 or while holding down " + (Platform.getOS().equals("macosx") ? "\u2318" : "CTRL") + " to go to the original PlusCal code, if present.\n\u2022 Click on a variable while holding down ALT to hide the variable from view.\n\u2022 Right+Click on a location row for a context menu.";
    private static final Pattern CONSTANT_EXPRESSION_ERROR_PATTERN = Pattern.compile("Evaluating assumption PrintT\\(" + TLCModelLaunchDataProvider.CONSTANT_EXPRESSION_OUTPUT_PATTERN.toString() + "\\)", 32);
    private int numberOfStatesToShow = TLCUIActivator.getDefault().getPreferenceStore().getInt("traceMaxShowErrors");
    private FormToolkit toolkit;
    private Form form;
    private SourceViewer errorViewer;
    private ErrorTraceTreeViewer errorTraceTreeViewer;
    private RecordToSourceCoupler stackTraceActionListener;
    private Button valueReflectsFiltering;
    private SourceViewer valueViewer;
    private ModelEditor modelEditor;
    private TraceExplorerComposite traceExplorerComposite;
    private TLCError unfilteredInput;
    private final HashMap<TLCState, Integer> filteredStateIndexMap;
    private Set<TLCVariable> currentErrorTraceFilterSet = new HashSet<TLCVariable>();
    private ExpandableSpaceReclaimer spaceReclaimer;
    private FontPreferenceChangeListener outputFontChangeListener;

    private static final IDocument EMPTY_DOCUMENT() {
        return new Document("No error information");
    }

    private static final IDocument NO_VALUE_DOCUMENT() {
        return new Document(NO_VALUE_VIEWER_TEXT);
    }

    public TLCErrorView() {
        this.filteredStateIndexMap = new HashMap();
    }

    public void clear() {
        this.errorViewer.setDocument(TLCErrorView.EMPTY_DOCUMENT());
        this.setTraceInput(new TLCError(), true);
        this.traceExplorerComposite.getTableViewer().setInput(new Vector());
        this.valueViewer.setInput((Object)TLCErrorView.EMPTY_DOCUMENT());
    }

    protected void fill(Model model, List<TLCError> problems, List<String> serializedInput) {
        this.traceExplorerComposite.getTableViewer().setInput(new Vector());
        FormHelper.setSerializedInput(this.traceExplorerComposite.getTableViewer(), serializedInput);
        TLCError trace = null;
        if (problems != null && !problems.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < problems.size()) {
                TLCError error = problems.get(i);
                TLCErrorView.appendError(buffer, error);
                if (error.hasTrace()) {
                    Assert.isTrue((trace == null ? 1 : 0) != 0, (String)"Two traces are provided. Unexpected. This is a bug");
                    trace = error;
                }
                ++i;
            }
            if (trace == null) {
                trace = new TLCError();
            }
            IDocument document = this.errorViewer.getDocument();
            try {
                document.replace(0, document.getLength(), buffer.toString());
                TLCUIHelper.setTLCLocationHyperlinks(this.errorViewer.getTextWidget());
            }
            catch (BadLocationException e) {
                TLCUIActivator.getDefault().logError("Error reporting the error " + buffer.toString(), e);
            }
            TLCError oldTrace = this.errorTraceTreeViewer.getCurrentTrace();
            if (Boolean.getBoolean(TLCErrorView.class.getName() + ".noRestore")) {
                if (oldTrace.hasTrace() && !trace.hasTrace()) {
                    Tree tree = this.errorTraceTreeViewer.getTreeViewer().getTree();
                    tree.setBackground(tree.getDisplay().getSystemColor(19));
                } else if (trace != oldTrace) {
                    this.setTraceInput(trace, true);
                }
            } else {
                boolean isNewTrace;
                boolean bl = isNewTrace = trace != null && oldTrace != null && trace != oldTrace;
                if (isNewTrace) {
                    this.setTraceInput(trace, true);
                }
            }
            if (model.isSnapshot()) {
                String date = sdf.format(model.getSnapshotTimeStamp());
                this.form.setText(model.getSnapshotFor().getName() + " (" + date + ")");
            } else {
                this.form.setText(model.getName());
            }
        } else {
            this.clear();
        }
        this.traceExplorerComposite.changeButtonEnablement();
    }

    public void hide() {
        this.getViewSite().getPage().hideView((IViewPart)this);
    }

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        this.toolkit = new FormToolkit(display);
        this.form = this.toolkit.createForm(parent);
        this.form.setText("");
        this.toolkit.decorateFormHeading(this.form);
        Composite body = this.form.getBody();
        GridLayout layout = new GridLayout(1, false);
        body.setLayout((Layout)layout);
        SashForm outerSashForm = new SashForm(body, 512);
        this.toolkit.adapt((Composite)outerSashForm);
        GridData gd = new GridData(4, 4, true, true);
        outerSashForm.setLayoutData((Object)gd);
        this.errorViewer = FormHelper.createFormsOutputViewer(this.toolkit, (Composite)outerSashForm, 2818);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = 100;
        this.errorViewer.getControl().setLayoutData((Object)gd);
        this.errorViewer.getControl().setFont(JFaceResources.getFont((String)"org.lamport.tla.toolbox.tool.tlc.ui.tlcOutputFont"));
        final StyledText text = this.errorViewer.getTextWidget();
        text.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                HashSet<Class<? extends ITextEditor>> blacklist = new HashSet<Class<? extends ITextEditor>>();
                blacklist.add(TLACoverageEditor.class);
                TLCUIHelper.openTLCLocationHyperlink(text, e, TLCErrorView.this.modelEditor.getModel(), blacklist);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Composite belowErrorViewerComposite = this.toolkit.createComposite((Composite)outerSashForm);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        belowErrorViewerComposite.setLayout((Layout)layout);
        SashForm middleSashForm = new SashForm(belowErrorViewerComposite, 512);
        this.toolkit.adapt((Composite)middleSashForm);
        gd = new GridData(4, 4, true, true);
        middleSashForm.setLayoutData((Object)gd);
        this.traceExplorerComposite = new TraceExplorerComposite((Composite)middleSashForm, "Error-Trace Exploration", "Expressions to be evaluated at each state of the trace - drag to re-order.", this.toolkit, this);
        Section errorTraceSection = this.toolkit.createSection((Composite)middleSashForm, 256);
        errorTraceSection.setLayoutData((Object)new GridData(4, 4, true, true));
        errorTraceSection.setLayout((Layout)new GridLayout(1, true));
        errorTraceSection.setText("Error-Trace");
        Composite errorTraceSectionClientArea = this.toolkit.createComposite((Composite)errorTraceSection);
        errorTraceSectionClientArea.setLayout((Layout)new GridLayout(1, true));
        errorTraceSection.setClient((Control)errorTraceSectionClientArea);
        this.spaceReclaimer = new ExpandableSpaceReclaimer(this.traceExplorerComposite.getSection(), middleSashForm);
        SashForm sashForm = new SashForm(errorTraceSectionClientArea, 512);
        this.toolkit.adapt((Composite)sashForm);
        gd = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gd);
        Tree tree = this.toolkit.createTree((Composite)sashForm, 268503554);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        gd = new GridData(16384, 128, true, false);
        gd.minimumHeight = 300;
        tree.setLayoutData((Object)gd);
        tree.addListener(41, event -> {
            int height;
            Font originalFont = event.gc.getFont();
            event.gc.setFont(JFaceResources.getFontRegistry().getBold(JFACE_ERROR_TRACE_ID));
            event.height = height = event.gc.stringExtent((String)CELL_TEXT_PROTOTYPE).y + 2;
            event.gc.setFont(originalFont);
        });
        this.errorTraceTreeViewer = new ErrorTraceTreeViewer(tree, this.modelEditor);
        this.getSite().setSelectionProvider((ISelectionProvider)this.errorTraceTreeViewer.getTreeViewer());
        HashSet<Class<? extends ITextEditor>> blacklist = new HashSet<Class<? extends ITextEditor>>();
        blacklist.add(TLACoverageEditor.class);
        this.stackTraceActionListener = new RecordToSourceCoupler((Viewer)this.errorTraceTreeViewer.getTreeViewer(), blacklist, (IWorkbenchPart)this, RecordToSourceCoupler.FocusRetentionPolicy.ARROW_KEY_TRAVERSAL);
        tree.addMouseListener((MouseListener)this.stackTraceActionListener);
        tree.addKeyListener((KeyListener)this.stackTraceActionListener);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)errorTraceSection);
        toolBarManager.add((IAction)new ExportErrorTrace2Clipboard(display));
        final FilterErrorTrace filterErrorTraceAction = new FilterErrorTrace();
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Object selection;
                TreeViewer treeViewer;
                ISelection is;
                if ((event.stateMask & 0x10000) != 0 && (is = (treeViewer = TLCErrorView.this.errorTraceTreeViewer.getTreeViewer()).getSelection()) != null && !is.isEmpty() && is instanceof StructuredSelection && (selection = ((StructuredSelection)is).getFirstElement()) instanceof TLCVariable) {
                    if (filterErrorTraceAction.isChecked()) {
                        TLCErrorView.this.addVariableFamilyToFiltering((TLCVariable)selection);
                    } else {
                        TLCErrorView.this.currentErrorTraceFilterSet.clear();
                        TLCErrorView.this.addVariableFamilyToFiltering((TLCVariable)selection);
                        filterErrorTraceAction.setChecked(true);
                    }
                    TLCErrorView.this.performVariableViewPopulation(EnumSet.of(FilterType.VARIABLES));
                }
            }
        });
        toolBarManager.add((IAction)filterErrorTraceAction);
        ShiftClickAction action = new ShiftClickAction("Toggle between expand and collapse all (Shift+Click to restore the default two-level expansion)", TLCUIActivator.getImageDescriptor("icons/elcl16/toggle_expand_state.png"), display){

            @Override
            void runWithKey(boolean pressed) {
                TreeViewer treeViewer = TLCErrorView.this.errorTraceTreeViewer.getTreeViewer();
                if (pressed) {
                    treeViewer.collapseAll();
                    treeViewer.expandToLevel(2);
                } else {
                    Object[] expandedElements = treeViewer.getExpandedElements();
                    if (expandedElements.length == 0) {
                        treeViewer.expandAll();
                    } else {
                        treeViewer.collapseAll();
                    }
                }
            }
        };
        toolBarManager.add((IAction)action);
        SyncStackTraversal syncStackTraversalAction = new SyncStackTraversal();
        toolBarManager.add((IAction)syncStackTraversalAction);
        tree.addDisposeListener(event -> {
            IDialogSettings ids = Activator.getDefault().getDialogSettings();
            ids.put(SYNCED_TRAVERSAL_KEY, syncStackTraversalAction.isChecked());
        });
        toolBarManager.update(true);
        errorTraceSection.setTextClient((Control)toolbar);
        this.errorTraceTreeViewer.getTreeViewer().addSelectionChangedListener(event -> this.handleValueViewerUpdate((IStructuredSelection)event.getSelection()));
        Composite valueViewerComposite = new Composite((Composite)sashForm, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 3;
        valueViewerComposite.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 128;
        gd.grabExcessHorizontalSpace = true;
        valueViewerComposite.setLayoutData((Object)gd);
        this.valueReflectsFiltering = new Button(valueViewerComposite, 32);
        this.valueReflectsFiltering.setText("Reflect filtering");
        this.valueReflectsFiltering.setSelection(true);
        this.valueReflectsFiltering.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TLCErrorView.this.handleValueViewerUpdate((IStructuredSelection)TLCErrorView.this.errorTraceTreeViewer.getTreeViewer().getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalAlignment = 128;
        gd.exclude = true;
        this.valueReflectsFiltering.setLayoutData((Object)gd);
        this.valueReflectsFiltering.setVisible(false);
        this.valueViewer = FormHelper.createFormsSourceViewer(this.toolkit, valueViewerComposite, 2818);
        this.valueViewer.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.valueViewer.getControl().setLayoutData((Object)gd);
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        String innerWeights = dialogSettings.get(INNER_WEIGHTS_KEY);
        if (innerWeights != null) {
            sashForm.setWeights(this.stringToIntArray(innerWeights));
        } else {
            sashForm.setWeights(new int[]{1, 1});
        }
        String outerWeights = dialogSettings.get(OUTER_WEIGHTS_KEY);
        if (outerWeights != null) {
            outerSashForm.setWeights(this.stringToIntArray(outerWeights));
        } else {
            outerSashForm.setWeights(new int[]{1, 4});
        }
        String midWeights = dialogSettings.get(MID_WEIGHTS_KEY);
        if (midWeights != null) {
            middleSashForm.setWeights(this.stringToIntArray(midWeights));
        } else {
            int[] weights = this.traceExplorerComposite.getSection().isExpanded() ? new int[]{3, 7} : new int[]{1, 9};
            middleSashForm.setWeights(weights);
        }
        sashForm.addDisposeListener(event -> {
            IDialogSettings ids = Activator.getDefault().getDialogSettings();
            ids.put(INNER_WEIGHTS_KEY, Arrays.toString(sashForm.getWeights()));
        });
        outerSashForm.addDisposeListener(event -> {
            IDialogSettings ids = Activator.getDefault().getDialogSettings();
            ids.put(OUTER_WEIGHTS_KEY, Arrays.toString(outerSashForm.getWeights()));
        });
        middleSashForm.addDisposeListener(event -> {
            IDialogSettings ids = Activator.getDefault().getDialogSettings();
            ids.put(MID_WEIGHTS_KEY, Arrays.toString(middleSashForm.getWeights()));
        });
        this.form.getToolBarManager().add((IAction)new HelpAction());
        this.form.getToolBarManager().update(true);
        this.clear();
        Vector<Control> controls = new Vector<Control>();
        controls.add(this.errorViewer.getControl());
        this.outputFontChangeListener = new FontPreferenceChangeListener(controls, "org.lamport.tla.toolbox.tool.tlc.ui.tlcOutputFont");
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.outputFontChangeListener);
        TLCUIHelper.setHelp((Control)parent, "TLCErrorView");
    }

    private void handleValueViewerUpdate(IStructuredSelection structuredSelection) {
        if (!structuredSelection.isEmpty()) {
            Object selection = structuredSelection.getFirstElement();
            if (selection instanceof TLCState) {
                TLCState state;
                if (this.filteredStateIndexMap.size() != 0 && !this.valueReflectsFiltering.getSelection()) {
                    Integer index = this.filteredStateIndexMap.get(selection);
                    if (index != null) {
                        state = this.unfilteredInput.getStates(TLCError.Length.ALL).get(index);
                    } else {
                        TLCUIActivator.getDefault().logWarning("Could not find mapped index for state.");
                        state = (TLCState)selection;
                    }
                } else {
                    state = (TLCState)selection;
                }
                this.valueViewer.setDocument((IDocument)new Document(state.getConjunctiveDescription(true)));
            } else {
                this.valueViewer.setDocument((IDocument)new Document(selection.toString()));
            }
        } else {
            this.valueViewer.setDocument(TLCErrorView.NO_VALUE_DOCUMENT());
        }
    }

    private int[] stringToIntArray(String str) {
        String[] strings = str.replace("[", "").replace("]", "").split(", ");
        int[] result = new int[strings.length];
        int i = 0;
        while (i < result.length) {
            result[i] = Integer.parseInt(strings[i]);
            ++i;
        }
        return result;
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.outputFontChangeListener);
        this.errorTraceTreeViewer.dispose();
        this.toolkit.dispose();
        super.dispose();
    }

    private static void appendError(StringBuffer buffer, TLCError error) {
        String message = error.getMessage();
        if (message != null && !message.equals("")) {
            String toAppend = message.replaceAll("@!@!@STARTMSG [0-9]{4}:[0-9] @!@!@", "");
            toAppend = toAppend.replaceAll("@!@!@ENDMSG [0-9]{4} @!@!@", "");
            toAppend = CONSTANT_EXPRESSION_ERROR_PATTERN.matcher(toAppend).replaceAll("The `Evaluate Constant Expression\ufffd section\ufffds evaluation");
            buffer.append(toAppend).append("\n");
        }
        TLCError cause = error.getCause();
        while (cause != null) {
            if (message == null || !message.contains(cause.getMessage())) {
                TLCErrorView.appendError(buffer, cause);
                break;
            }
            cause = cause.getCause();
        }
    }

    public void updateErrorView() {
        TLCErrorView.updateErrorView(this.modelEditor);
    }

    public static void updateErrorView(ModelEditor associatedModelEditor) {
        TLCErrorView.updateErrorView(associatedModelEditor, true);
    }

    public static void updateErrorView(ModelEditor associatedModelEditor, boolean openErrorView) {
        if (associatedModelEditor == null) {
            return;
        }
        Model model = associatedModelEditor.getModel();
        boolean isTraceExplorerUpdate = !model.isOriginalTraceShown();
        TLCModelLaunchDataProvider provider = isTraceExplorerUpdate ? TLCOutputSourceRegistry.getTraceExploreSourceRegistry().getProvider(model) : TLCOutputSourceRegistry.getModelCheckSourceRegistry().getProvider(model);
        if (provider == null) {
            return;
        }
        TLCErrorView.updateErrorView(provider, associatedModelEditor, openErrorView);
    }

    public static void updateErrorView(TLCModelLaunchDataProvider provider, ModelEditor associatedModelEditor, boolean openErrorView) {
        TLCErrorView errorView = provider.getErrors().size() > 0 && openErrorView ? (TLCErrorView)UIHelper.openView((String)ID) : (TLCErrorView)UIHelper.findView((String)ID);
        if (errorView != null) {
            errorView.setModelEditor(associatedModelEditor);
            List serializedInput = associatedModelEditor.getModel().getTraceExplorerExpressions();
            errorView.fill(provider.getModel(), provider.getErrors(), serializedInput);
            if (provider.getErrors().size() == 0) {
                errorView.hide();
            }
        }
    }

    public TLCError getTrace() {
        if (this.errorTraceTreeViewer == null) {
            return null;
        }
        return this.errorTraceTreeViewer.getCurrentTrace();
    }

    public Model getModel() {
        return this.modelEditor.getModel();
    }

    private void setModelEditor(ModelEditor associatedModelEditor) {
        this.modelEditor = associatedModelEditor;
        if (this.errorTraceTreeViewer != null) {
            this.errorTraceTreeViewer.setModelEditor(associatedModelEditor);
        }
    }

    void setTraceInput(TLCError error, boolean isNew) {
        if (isNew) {
            this.unfilteredInput = error;
        }
        error.restrictTraceTo(this.numberOfStatesToShow);
        TreeViewer treeViewer = this.errorTraceTreeViewer.getTreeViewer();
        treeViewer.getTree().setItemCount(error.getTraceSize() + (error.isTraceRestricted() ? 1 : 0));
        treeViewer.setInput((Object)error);
        treeViewer.getTree().setSortDirection(error.getOrder() == TLCError.Order.OneToN ? 128 : 1024);
        boolean level = true;
        if (error.getTraceSize(1) < 1000) {
            treeViewer.expandToLevel(2);
        }
        if (!error.isTraceEmpty()) {
            this.valueViewer.setDocument(TLCErrorView.NO_VALUE_DOCUMENT());
        } else {
            this.valueViewer.setDocument(TLCErrorView.EMPTY_DOCUMENT());
        }
    }

    public void setOriginalTraceShown(boolean b) {
        this.modelEditor.getModel().setOriginalTraceShown(b);
    }

    TreeViewer getViewer() {
        return this.errorTraceTreeViewer.getTreeViewer();
    }

    private void addVariableFamilyToFiltering(TLCVariable protoVariable) {
        for (TLCState state : this.unfilteredInput.getStates(TLCError.Length.ALL)) {
            for (TLCVariable variable : state.getVariablesAsList()) {
                if (!protoVariable.representsTheSameAs(variable)) continue;
                this.currentErrorTraceFilterSet.add(variable);
            }
        }
    }

    private void performVariableViewPopulation(EnumSet<FilterType> filters) {
        this.filteredStateIndexMap.clear();
        if (filters.contains((Object)FilterType.NONE)) {
            this.setTraceInput(this.unfilteredInput, false);
            GridData gd = (GridData)this.valueReflectsFiltering.getLayoutData();
            gd.exclude = true;
            this.valueReflectsFiltering.setLayoutData((Object)gd);
            this.valueReflectsFiltering.setVisible(false);
        } else {
            List<TLCVariable> variables;
            TLCError filtered = this.unfilteredInput.clone();
            GridData gd = (GridData)this.valueReflectsFiltering.getLayoutData();
            gd.exclude = false;
            this.valueReflectsFiltering.setLayoutData((Object)gd);
            this.valueReflectsFiltering.setVisible(true);
            if (filters.contains((Object)FilterType.VARIABLES) && this.currentErrorTraceFilterSet.size() > 0) {
                int index = 0;
                for (TLCState filteredState : filtered.getStates(TLCError.Length.ALL)) {
                    List<TLCVariable> variables2 = filteredState.getVariablesAsList();
                    ArrayList<TLCVariable> removals = new ArrayList<TLCVariable>();
                    Iterator iterator = variables2.iterator();
                    block1: while (iterator.hasNext()) {
                        TLCVariable variable = (TLCVariable)iterator.next();
                        for (TLCVariable filterVariable : this.currentErrorTraceFilterSet) {
                            if (!filterVariable.representsTheSameAs(variable)) continue;
                            removals.add(variable);
                            continue block1;
                        }
                    }
                    variables2.removeAll(removals);
                    this.filteredStateIndexMap.put(filteredState, new Integer(index));
                    ++index;
                }
            }
            if (filters.contains((Object)FilterType.MODIFIED_VALUES_MODIFIED_FRAMES)) {
                ArrayList<TLCState> emptyStates = new ArrayList<TLCState>();
                this.filteredStateIndexMap.clear();
                int index = 0;
                for (TLCState tLCState : filtered.getStates(TLCError.Length.ALL)) {
                    variables = tLCState.getVariablesAsList();
                    ArrayList<TLCVariable> removals = new ArrayList<TLCVariable>();
                    for (TLCVariable variable : variables) {
                        if (variable.isChanged()) continue;
                        removals.add(variable);
                    }
                    variables.removeAll(removals);
                    if (variables.size() == 0) {
                        emptyStates.add(tLCState);
                    } else {
                        this.filteredStateIndexMap.put(tLCState, new Integer(index));
                    }
                    ++index;
                }
                filtered.removeStates(emptyStates);
            } else if (filters.contains((Object)FilterType.MODIFIED_VALUES_ALL_FRAMES)) {
                HashSet<TLCVariable> changedVariables = new HashSet<TLCVariable>();
                for (TLCState state : filtered.getStates(TLCError.Length.ALL)) {
                    List<TLCVariable> variables2 = state.getVariablesAsList();
                    for (TLCVariable variable : variables2) {
                        if (!variable.isChanged()) continue;
                        changedVariables.add(variable);
                    }
                }
                this.filteredStateIndexMap.clear();
                int index = 0;
                for (TLCState tLCState : filtered.getStates(TLCError.Length.ALL)) {
                    variables = tLCState.getVariablesAsList();
                    variables.retainAll(changedVariables);
                    this.filteredStateIndexMap.put(tLCState, new Integer(index));
                    ++index;
                }
            }
            this.setTraceInput(filtered, false);
        }
        this.valueReflectsFiltering.getParent().layout(true, true);
    }

    private class ExportErrorTrace2Clipboard
    extends ShiftClickAction
    implements ISelectionChangedListener {
        private static final String DEFAULT_TOOL_TIP_TEXT = "Click to export error-trace to clipboard as\nsequence of records. Shift+Click to \nomit the action's position (_TEPosition), \nname, and location.";
        private final Display display;

        ExportErrorTrace2Clipboard(Display display) {
            super("Export the error-trace to the OS clipboard.", 1, display);
            this.display = display;
            TLCErrorView.this.errorTraceTreeViewer.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            this.setImageDescriptor(TLCUIActivator.getImageDescriptor("platform:/plugin/org.eclipse.ui.ide/icons/full/etool16/export_wiz.png"));
            this.setToolTipText(DEFAULT_TOOL_TIP_TEXT);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (TLCErrorView.this.errorTraceTreeViewer == null) {
                this.setEnabled(false);
            }
            this.setEnabled(TLCErrorView.this.errorTraceTreeViewer.getCurrentTrace().hasTrace());
        }

        @Override
        public void runWithKey(boolean excludeActionHeader) {
            if (TLCErrorView.this.errorTraceTreeViewer == null) {
                return;
            }
            TLCError trace = TLCErrorView.this.errorTraceTreeViewer.getCurrentTrace();
            if (!trace.hasTrace()) {
                return;
            }
            Clipboard clipboard = new Clipboard(this.display);
            clipboard.setContents(new Object[]{trace.toSequenceOfRecords(!excludeActionHeader)}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    private class FilterErrorTrace
    extends Action {
        private static final String DEFAULT_TOOL_TIP_TEXT = "Click to select variables and expressions to omit from the trace display; ALT+Click on an individual item below to omit it immediately.";
        private static final String SELECTED_TOOL_TIP_TEXT = "Click to display all variables and expressions.";

        FilterErrorTrace() {
            super("Filter the displayed variables and expressions", 2);
            ImageDescriptor id = TLCUIActivator.getImageDescriptor("icons/elcl16/trace_filter.png");
            this.setImageDescriptor(id);
            this.setToolTipText(DEFAULT_TOOL_TIP_TEXT);
        }

        public void setChecked(boolean flag) {
            super.setChecked(flag);
            this.setToolTipText(SELECTED_TOOL_TIP_TEXT);
        }

        public void run() {
            if (this.isChecked()) {
                this.setToolTipText(SELECTED_TOOL_TIP_TEXT);
            } else {
                this.setToolTipText(DEFAULT_TOOL_TIP_TEXT);
            }
            TLCError trace = TLCErrorView.this.errorTraceTreeViewer.getCurrentTrace();
            List<TLCState> states = trace.getStates();
            if (states.size() == 0) {
                return;
            }
            if (this.isChecked()) {
                Shell s = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                TLCState state = states.get(0);
                ErrorViewTraceFilterDialog dialog = new ErrorViewTraceFilterDialog(s, state.getVariablesAsList());
                dialog.setSelection(TLCErrorView.this.currentErrorTraceFilterSet);
                if (dialog.open() == 0) {
                    TLCErrorView.this.currentErrorTraceFilterSet = dialog.getSelection();
                    ErrorViewTraceFilterDialog.MutatedFilter mutated = dialog.getMutatedFilterSelection();
                    if (ErrorViewTraceFilterDialog.MutatedFilter.NO_FILTER.equals((Object)mutated)) {
                        TLCErrorView.this.performVariableViewPopulation(EnumSet.of(FilterType.VARIABLES));
                    } else {
                        FilterType filterType;
                        switch (mutated) {
                            case CHANGED_ALL_FRAMES: {
                                filterType = FilterType.MODIFIED_VALUES_ALL_FRAMES;
                                break;
                            }
                            default: {
                                filterType = FilterType.MODIFIED_VALUES_MODIFIED_FRAMES;
                            }
                        }
                        TLCErrorView.this.performVariableViewPopulation(EnumSet.of(FilterType.VARIABLES, filterType));
                    }
                }
            } else {
                TLCErrorView.this.performVariableViewPopulation(EnumSet.of(FilterType.NONE));
            }
        }
    }

    private static enum FilterType {
        NONE,
        VARIABLES,
        MODIFIED_VALUES_ALL_FRAMES,
        MODIFIED_VALUES_MODIFIED_FRAMES;

    }

    private class HelpAction
    extends Action {
        public HelpAction() {
            super("Help", JFaceResources.getImageRegistry().getDescriptor("dialog_help_image"));
            this.setDescription("Opens help");
            this.setToolTipText("Opens help for the TLC Error View.");
        }

        public void run() {
            UIHelper.showDynamicHelp();
        }
    }

    private static abstract class ShiftClickAction
    extends Action
    implements Listener {
        private boolean holdDown = false;

        public ShiftClickAction(String text, ImageDescriptor imageDescriptor, Display display) {
            super(text, imageDescriptor);
            display.addFilter(1, (Listener)this);
            display.addFilter(2, (Listener)this);
        }

        public ShiftClickAction(String text, int style, Display display) {
            super(text, style);
            display.addFilter(1, (Listener)this);
            display.addFilter(2, (Listener)this);
        }

        public void runWithEvent(Event event) {
            this.runWithKey(this.holdDown);
        }

        abstract void runWithKey(boolean var1);

        public void handleEvent(Event event) {
            if (event.keyCode == 131072) {
                if (event.stateMask == 131072) {
                    this.holdDown = false;
                } else if (event.stateMask == 0) {
                    this.holdDown = true;
                }
            }
        }
    }

    private class SyncStackTraversal
    extends Action {
        SyncStackTraversal() {
            super("Sync traversing of the stack trace by arrow keys to the editor.", 2);
            ImageDescriptor id = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED");
            this.setImageDescriptor(id);
            boolean enabled = Activator.getDefault().getDialogSettings().getBoolean(TLCErrorView.SYNCED_TRAVERSAL_KEY);
            this.setChecked(enabled);
            this.run();
        }

        public void run() {
            int value = this.isChecked() ? 6 : 0;
            TLCErrorView.this.stackTraceActionListener.setNonDefaultObservables(value);
        }
    }
}

