/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.lamport.tla.toolbox.tool.tlc.launch.IConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.launch.IConfigurationDefaults;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.DataBindingManager;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.BasicFormPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.TLCConsumptionProfile;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.advanced.AdvancedTLCOptionsPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.EvaluateConstantExpressionPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.ResultPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableConstantSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableTableSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.util.DirtyMarkingListener;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.util.SemanticHelper;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import org.lamport.tla.toolbox.util.HelpButton;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.semantic.ModuleNode;
import tlc2.model.Assignment;
import tlc2.model.TypedSet;
import util.TLCRuntime;

public class MainModelPage
extends BasicFormPage
implements IConfigurationConstants,
IConfigurationDefaults {
    public static final String ID = "MainModelPage";
    public static final String CUSTOM_TLC_PROFILE_PREFERENCE_VALUE = "local custom";
    static final String CLOUD_CONFIGURATION_KEY = "jclouds";
    private static final String TITLE = "Model Overview";
    private static final String INIT_NEXT_COMBO_LABEL = "Initial predicate and next-state relation";
    private static final String TEMPORAL_FORMULA_COMBO_LABEL = "Temporal formula";
    private static final String NO_SPEC_COMBO_LABEL = "No behavior spec";
    private static final String[] VARIABLE_BEHAVIOR_COMBO_ITEMS = new String[]{"Initial predicate and next-state relation", "Temporal formula", "No behavior spec"};
    private static final String[] NO_VARIABLE_BEHAVIOR_COMBO_ITEMS = new String[]{"No behavior spec"};
    private static final String TLC_PROFILE_LOCAL_SEPARATOR = "\u2014\u2014 Local \u2014\u2014";
    private static final String TLC_PROFILE_REMOTE_SEPARATOR = "\u2014\u2014 Remote \u2014\u2014";
    private static final String CUSTOM_TLC_PROFILE_DISPLAY_NAME = "Custom";
    private static final String[] TLC_PROFILE_DISPLAY_NAMES;
    private static final DecimalFormat MEMORY_FORMAT;
    private Combo behaviorCombo;
    private int previousBehaviorComboSelection;
    private SourceViewer commentsSource;
    private SourceViewer initFormulaSource;
    private SourceViewer nextFormulaSource;
    private SourceViewer specSource;
    private Button checkDeadlockButton;
    private Combo tlcProfileCombo;
    private AtomicInteger lastSelectedTLCProfileIndex;
    private Label tlcResourceSummaryLabel;
    private Hyperlink tlcTuneHyperlink;
    private AtomicBoolean currentProfileIsAdHoc;
    private AtomicInteger workerThreadCount;
    private AtomicInteger heapPercentage;
    private AtomicBoolean workerValueCanBeModified;
    private AtomicBoolean heapPercentageCanBeModified;
    private Spinner distributedFPSetCountSpinner;
    private Spinner distributedNodesCountSpinner;
    private Text resultMailAddressText;
    private Combo networkInterfaceCombo;
    private TableViewer invariantsTable;
    private TableViewer propertiesTable;
    private TableViewer constantTable;
    protected HyperlinkAdapter advancedModelOptionsOpener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent he) {
            MainModelPage.this.getModelEditor().addOrShowAdvancedModelPage();
        }
    };
    protected HyperlinkAdapter advancedTLCOptionsOpener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent he) {
            MainModelPage.this.getModelEditor().addOrShowAdvancedTLCOptionsPage();
        }
    };
    protected HyperlinkAdapter resultsPageOpener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent he) {
            MainModelPage.this.getModelEditor().addOrShowResultsPage();
        }
    };
    private Composite behaviorOptions;
    private Composite distributedOptions;

    static {
        MEMORY_FORMAT = new DecimalFormat("#,###");
        TLCConsumptionProfile[] profiles = TLCConsumptionProfile.values();
        int size = profiles.length;
        TLC_PROFILE_DISPLAY_NAMES = new String[size + 2];
        MainModelPage.TLC_PROFILE_DISPLAY_NAMES[0] = TLC_PROFILE_LOCAL_SEPARATOR;
        int indexIncrement = 1;
        boolean haveStartedRemoteProfiles = false;
        int i = 0;
        while (i < size) {
            if (profiles[i].profileIsForRemoteWorkers() && !haveStartedRemoteProfiles) {
                MainModelPage.TLC_PROFILE_DISPLAY_NAMES[i + indexIncrement] = TLC_PROFILE_REMOTE_SEPARATOR;
                haveStartedRemoteProfiles = true;
                ++indexIncrement;
            }
            MainModelPage.TLC_PROFILE_DISPLAY_NAMES[i + indexIncrement] = profiles[i].getDisplayName();
            ++i;
        }
    }

    public static String generateMemoryDisplayText(int percentage, long megabytes) {
        return percentage + "% (" + MEMORY_FORMAT.format(megabytes) + " mb)";
    }

    public MainModelPage(FormEditor editor) {
        super(editor, ID, TITLE, "icons/full/model_options_[XXXXX].png");
        this.helpId = "mainModelPage";
        this.currentProfileIsAdHoc = new AtomicBoolean(false);
        this.workerValueCanBeModified = new AtomicBoolean(true);
        this.heapPercentageCanBeModified = new AtomicBoolean(true);
    }

    @Override
    protected void loadData() throws CoreException {
        int memoryPercentage;
        int threadCount;
        Model model = this.getModel();
        int specType = model.getAttribute("modelBehaviorSpecType", 2);
        this.setSpecSelection(specType);
        String modelSpecification = model.getAttribute("modelBehaviorSpec", "");
        Document closedDoc = new Document(modelSpecification);
        this.specSource.setDocument((IDocument)closedDoc);
        String modelInit = model.getAttribute("modelBehaviorInit", "");
        Document initDoc = new Document(modelInit);
        this.initFormulaSource.setDocument((IDocument)initDoc);
        String modelNext = model.getAttribute("modelBehaviorNext", "");
        Document nextDoc = new Document(modelNext);
        this.nextFormulaSource.setDocument((IDocument)nextDoc);
        boolean checkDeadlock = model.getAttribute("modelCorrectnessCheckDeadlock", true);
        this.checkDeadlockButton.setSelection(checkDeadlock);
        List serializedList = model.getAttribute("modelCorrectnessInvariants", new Vector());
        FormHelper.setSerializedInput(this.invariantsTable, serializedList);
        serializedList = model.getAttribute("modelCorrectnessProperties", new Vector());
        FormHelper.setSerializedInput(this.propertiesTable, serializedList);
        List savedConstants = model.getAttribute("modelParameterConstants", new Vector());
        FormHelper.setSerializedInput(this.constantTable, savedConstants);
        if (!savedConstants.isEmpty()) {
            this.expandSection("__what_is_the_model");
        }
        this.currentProfileIsAdHoc.set(false);
        IPreferenceStore prefStore = TLCUIActivator.getDefault().getPreferenceStore();
        if (model.hasAttribute("tlcResourcesProfile")) {
            String tlcProfile = model.getAttribute("tlcResourcesProfile", null);
            if (tlcProfile.equals(CUSTOM_TLC_PROFILE_PREFERENCE_VALUE)) {
                threadCount = model.getAttribute("numberOfWorkers", prefStore.getInt("tlcWorkersCountDefault"));
                int defaultMaxHeapSize = prefStore.getInt("maxHeapSizeDefault");
                memoryPercentage = model.getAttribute("maxHeapSize", defaultMaxHeapSize);
                this.setTLCProfileComboSelection(CUSTOM_TLC_PROFILE_DISPLAY_NAME);
            } else {
                TLCConsumptionProfile profile = TLCConsumptionProfile.getProfileWithPreferenceValue(tlcProfile);
                this.setTLCProfileComboSelection(profile.getDisplayName());
                if (profile.profileIsForRemoteWorkers()) {
                    String configuration = profile.getConfigurationKey();
                    boolean isAdHoc = configuration.equals(TLCConsumptionProfile.REMOTE_AD_HOC.getConfigurationKey());
                    this.currentProfileIsAdHoc.set(isAdHoc);
                    this.moveToTopOfDistributedOptionsStack(configuration, false, isAdHoc);
                    if (configuration.equals(CLOUD_CONFIGURATION_KEY)) {
                        String email = model.getAttribute("result.mail.address", "");
                        this.resultMailAddressText.setText(email);
                    }
                } else {
                    this.moveToTopOfDistributedOptionsStack("off", true, true);
                }
                threadCount = profile.getWorkerThreads();
                memoryPercentage = this.currentProfileIsAdHoc.get() ? model.getAttribute("maxHeapSize", profile.getMemoryPercentage()) : profile.getMemoryPercentage();
            }
        } else {
            String remoteWorkers;
            block16: {
                remoteWorkers = "off";
                try {
                    remoteWorkers = model.getAttribute("distributedTLC", "off");
                }
                catch (CoreException e) {
                    if (!model.getAttribute("distributedTLC", false)) break block16;
                    remoteWorkers = TLCConsumptionProfile.REMOTE_AD_HOC.getConfigurationKey();
                    this.currentProfileIsAdHoc.set(true);
                }
            }
            if (remoteWorkers.equals("off")) {
                this.moveToTopOfDistributedOptionsStack("off", true, true);
                threadCount = model.getAttribute("numberOfWorkers", prefStore.getInt("tlcWorkersCountDefault"));
                int defaultMaxHeapSize = prefStore.getInt("maxHeapSizeDefault");
                memoryPercentage = model.getAttribute("maxHeapSize", defaultMaxHeapSize);
                this.setTLCProfileComboSelection(CUSTOM_TLC_PROFILE_DISPLAY_NAME);
            } else {
                TLCConsumptionProfile profile = TLCConsumptionProfile.getProfileWithPreferenceValue(remoteWorkers);
                String configuration = profile.getConfigurationKey();
                boolean isAdHoc = configuration.equals(TLCConsumptionProfile.REMOTE_AD_HOC.getConfigurationKey());
                this.currentProfileIsAdHoc.set(isAdHoc);
                this.moveToTopOfDistributedOptionsStack(configuration, false, isAdHoc);
                if (configuration.equals(CLOUD_CONFIGURATION_KEY)) {
                    String email = model.getAttribute("result.mail.address", "");
                    this.resultMailAddressText.setText(email);
                }
                threadCount = 0;
                if (isAdHoc) {
                    int defaultMaxHeapSize = prefStore.getInt("maxHeapSizeDefault");
                    memoryPercentage = model.getAttribute("maxHeapSize", defaultMaxHeapSize);
                } else {
                    memoryPercentage = 0;
                }
                this.setTLCProfileComboSelection(profile.getDisplayName());
            }
        }
        this.workerThreadCount = new AtomicInteger(threadCount);
        this.heapPercentage = new AtomicInteger(memoryPercentage);
        this.distributedFPSetCountSpinner.setSelection(model.getAttribute("distributedFPSetCount", 0));
        this.distributedNodesCountSpinner.setSelection(model.getAttribute("distributedNodesCount", 1));
        String commentsStr = model.getAttribute("modelComments", "");
        this.commentsSource.setDocument((IDocument)new Document(commentsStr));
        if (!"".equals(commentsStr)) {
            this.expandSection("__what_is_the_description");
        }
        this.updateTLCResourcesLabel();
    }

    public void setNoBehaviorSpec(boolean noSpec) {
        if (noSpec) {
            this.previousBehaviorComboSelection = this.behaviorCombo.getSelectionIndex();
            this.setSpecSelection(0);
        } else {
            this.behaviorCombo.select(this.previousBehaviorComboSelection);
            this.moveToTopOfBehaviorOptionsStack(this.behaviorCombo.getText());
        }
        DataBindingManager dm = this.getDataBindingManager();
        dm.getSection(dm.getSectionForAttribute("modelBehaviorNoSpec")).markDirty();
        this.validatePage(false);
    }

    public void setInitNextBehavior(String initFormula, String nextFormula) {
        boolean setDirty = this.setSpecSelection(2);
        if (initFormula != null) {
            this.initFormulaSource.setDocument((IDocument)new Document(initFormula));
            setDirty = true;
        }
        if (nextFormula != null) {
            this.nextFormulaSource.setDocument((IDocument)new Document(nextFormula));
            setDirty = true;
        }
        if (setDirty) {
            DataBindingManager dm = this.getDataBindingManager();
            dm.getSection(dm.getSectionForAttribute("modelBehaviorNoSpec")).markDirty();
            this.validatePage(false);
        }
    }

    @Override
    public void validatePage(boolean switchToErrorPage) {
        List<String> values;
        Assignment constant;
        if (this.getManagedForm() == null) {
            return;
        }
        DataBindingManager dm = this.getDataBindingManager();
        IMessageManager mm = this.getManagedForm().getMessageManager();
        mm.setAutoUpdate(false);
        ModelEditor modelEditor = (ModelEditor)this.getEditor();
        ModuleNode rootModuleNode = SemanticHelper.getRootModuleNode();
        this.getLookupHelper().resetModelNames(this);
        List<Assignment> constants = this.getConstants();
        String sectionId = dm.getSectionForAttribute("modelParameterConstants");
        if (rootModuleNode != null) {
            SectionPart constantSection;
            List toDelete = ModelHelper.mergeConstantLists(constants, (List)ModelHelper.createConstantsList((ModuleNode)rootModuleNode));
            if (!toDelete.isEmpty() && (constantSection = dm.getSection(sectionId)) != null) {
                constantSection.markDirty();
            }
            this.constantTable.setInput(constants);
        }
        String symmetryType = null;
        Control widget = UIHelper.getWidget((Object)dm.getAttributeControl("modelParameterConstants"));
        int i = 0;
        while (i < constants.size()) {
            constant = constants.get(i);
            values = Arrays.asList(constant.getParams());
            this.validateId(sectionId, widget, values, "param1_", "A parameter name");
            String label = constant.getLabel();
            if (constant.getRight() == null || "".equals(constant.getRight())) {
                modelEditor.addErrorMessage(label, "Provide a value for constant " + label, this.getId(), 3, widget);
                this.setComplete(false);
                this.expandSection(sectionId);
            } else {
                modelEditor.removeErrorMessage(label, widget);
                if (constant.isSetOfModelValues()) {
                    TypedSet modelValuesSet = TypedSet.parseSet((String)constant.getRight());
                    if (constant.isSymmetricalSet()) {
                        if (this.hasLivenessProperty()) {
                            modelEditor.addErrorMessage(constant.getLabel(), String.format("%s declared to be symmetric while one or more temporal formulas are set to be checked.\nIf the temporal formula is a liveness property, liveness checking might fail to find\nviolations. The Model Checking Result page will show a warning during TLC startup if\nany one of the temporal formulas is a liveness property.", constant.getLabel()), this.getId(), 1, UIHelper.getWidget((Object)dm.getAttributeControl("modelParameterConstants")));
                            this.expandSection(dm.getSectionForAttribute("modelParameterConstants"));
                            this.expandSection(dm.getSectionForAttribute("modelCorrectnessProperties"));
                        }
                        boolean hasTwoTypes = false;
                        String typeString = null;
                        if (modelValuesSet.hasType()) {
                            typeString = modelValuesSet.getType();
                        } else {
                            int j = 0;
                            while (j < modelValuesSet.getValues().length) {
                                String thisTypeString = TypedSet.getTypeOfId((String)modelValuesSet.getValues()[j]);
                                if (thisTypeString != null) {
                                    if (typeString != null && !typeString.equals(thisTypeString)) {
                                        hasTwoTypes = true;
                                    } else {
                                        typeString = thisTypeString;
                                    }
                                }
                                ++j;
                            }
                        }
                        if (hasTwoTypes || symmetryType != null && typeString != null && !typeString.equals(symmetryType)) {
                            modelEditor.addErrorMessage(constant.getLabel(), "Two differently typed model values used in symmetry sets.", this.getId(), 3, UIHelper.getWidget((Object)dm.getAttributeControl("modelParameterConstants")));
                            this.setComplete(false);
                            this.expandSection(dm.getSectionForAttribute("modelParameterConstants"));
                        } else if (typeString != null) {
                            symmetryType = typeString;
                        }
                    }
                    if (modelValuesSet.getValueCount() > 0) {
                        List mvList = modelValuesSet.getValuesAsList();
                        this.validateUsage(sectionId, widget, mvList, "modelValues2_", "A model value", "Constant Assignment", true);
                        this.validateId(sectionId, widget, mvList, "modelValues2_", "A model value");
                        int j = 0;
                        while (j < mvList.size()) {
                            String value = (String)mvList.get(j);
                            if (SemanticHelper.isConfigFileKeyword(value)) {
                                modelEditor.addErrorMessage(value, "The toolbox cannot handle the model value " + value + ".", this.getId(), 3, widget);
                                this.setComplete(false);
                            }
                            ++j;
                        }
                    } else {
                        modelEditor.addErrorMessage(label, "The set of model values should not be empty.", this.getId(), 3, widget);
                        this.setComplete(false);
                    }
                }
            }
            if (SemanticHelper.isConfigFileKeyword(label)) {
                modelEditor.addErrorMessage(label, "The toolbox cannot handle the constant identifier " + label + ".", this.getId(), 3, widget);
                this.setComplete(false);
            }
            ++i;
        }
        i = 0;
        while (i < constants.size()) {
            constant = constants.get(i);
            values = Arrays.asList(constant.getParams());
            this.validateUsage(sectionId, widget, values, "param1_", "A parameter name", "Constant Assignment", false);
            ++i;
        }
        int networkAddressIndex = this.networkInterfaceCombo.getSelectionIndex();
        if (networkAddressIndex < 0) {
            modelEditor.addErrorMessage("strangeAddress1", String.format("Found the manually inserted master's network address %s. This is usually unnecessary and hints at a misconfiguration. Make sure your computer running the TLC master is reachable at address %s.", this.networkInterfaceCombo.getText(), this.networkInterfaceCombo.getText()), this.getId(), 2, (Control)this.networkInterfaceCombo);
            this.expandSection("__how_to_run");
        }
        if (rootModuleNode != null) {
            Control errorMsgControl = UIHelper.getWidget((Object)this.getDataBindingManager().getAttributeControl("modelBehaviorNoSpec"));
            String errorMsgKey = "modelBehaviorNoSpecErrorMsgKey";
            if (rootModuleNode.getVariableDecls().length == 0) {
                this.setHasVariables(false);
                modelEditor.addErrorMessage("modelBehaviorNoSpecErrorMsgKey", "\"What is the behavior spec?\" automatically set to \"No Behavior Spec\" because spec has no declared variables.", this.getId(), 1, errorMsgControl);
                if (!NO_SPEC_COMBO_LABEL.equals(this.behaviorCombo.getText())) {
                    this.setSpecSelection(0);
                    dm.getSection(dm.getSectionForAttribute("modelBehaviorNoSpec")).markDirty();
                }
            } else {
                this.setHasVariables(true);
                modelEditor.removeErrorMessage("modelBehaviorNoSpecErrorMsgKey", errorMsgControl);
            }
        }
        Section whatToCheckSection = dm.getSection("__what_to_check").getSection();
        ResultPage rp = (ResultPage)modelEditor.findPage("resultPage");
        EvaluateConstantExpressionPage ecep = rp != null ? (EvaluateConstantExpressionPage)modelEditor.findPage("evaluateConstantExpressionPage") : null;
        Set<Section> resultPageSections = rp != null ? rp.getSections("__general", "__coverage") : null;
        String hint = " (\"What is the behavior spec?\" above has no behavior spec)";
        String hintResults = " (\"What is the behavior spec?\" on \"Model Overview\" page has no behavior spec)";
        if (NO_SPEC_COMBO_LABEL.equals(this.behaviorCombo.getText())) {
            whatToCheckSection.setText((String)(!whatToCheckSection.getText().endsWith(" (\"What is the behavior spec?\" above has no behavior spec)") ? whatToCheckSection.getText() + " (\"What is the behavior spec?\" above has no behavior spec)" : whatToCheckSection.getText()));
            whatToCheckSection.setExpanded(false);
            whatToCheckSection.setEnabled(false);
            if (resultPageSections != null) {
                resultPageSections.forEach(section -> {
                    section.setText((String)(!section.getText().endsWith(" (\"What is the behavior spec?\" on \"Model Overview\" page has no behavior spec)") ? section.getText() + " (\"What is the behavior spec?\" on \"Model Overview\" page has no behavior spec)" : section.getText()));
                    section.setEnabled(false);
                    this.compensateForExpandableCompositesPoorDesign((Section)section, false);
                });
            }
            if (ecep != null) {
                ecep.setNoBehaviorSpecToggleState(true);
            } else if (rp != null) {
                rp.setNoBehaviorSpecToggleState(true);
            }
        } else {
            whatToCheckSection.setText(whatToCheckSection.getText().replace(" (\"What is the behavior spec?\" above has no behavior spec)", ""));
            whatToCheckSection.setExpanded(true);
            whatToCheckSection.setEnabled(true);
            if (resultPageSections != null) {
                resultPageSections.forEach(section -> {
                    section.setText(section.getText().replace(" (\"What is the behavior spec?\" on \"Model Overview\" page has no behavior spec)", ""));
                    section.setEnabled(true);
                    this.compensateForExpandableCompositesPoorDesign((Section)section, true);
                });
            }
            if (ecep != null) {
                ecep.setNoBehaviorSpecToggleState(false);
            } else if (rp != null) {
                rp.setNoBehaviorSpecToggleState(false);
            }
        }
        Control initTA = UIHelper.getWidget((Object)dm.getAttributeControl("modelBehaviorInit"));
        Control nextTA = UIHelper.getWidget((Object)dm.getAttributeControl("modelBehaviorNext"));
        Control specTA = UIHelper.getWidget((Object)dm.getAttributeControl("modelBehaviorSpec"));
        modelEditor.removeErrorMessage("noInit", initTA);
        modelEditor.removeErrorMessage("noNext", nextTA);
        modelEditor.removeErrorMessage("noSpec", specTA);
        if (TEMPORAL_FORMULA_COMBO_LABEL.equals(this.behaviorCombo.getText()) && this.specSource.getDocument().get().trim().length() == 0) {
            modelEditor.addErrorMessage("noSpec", "The formula must be provided", this.getId(), 3, specTA);
            this.setComplete(false);
            this.expandSection(dm.getSectionForAttribute("modelBehaviorSpec"));
        } else if (INIT_NEXT_COMBO_LABEL.equals(this.behaviorCombo.getText())) {
            String init = this.initFormulaSource.getDocument().get().trim();
            String next = this.nextFormulaSource.getDocument().get().trim();
            if (init.length() == 0) {
                modelEditor.addErrorMessage("noInit", "The Init formula must be provided", this.getId(), 3, initTA);
                this.setComplete(false);
                this.expandSection(dm.getSectionForAttribute("modelBehaviorInit"));
            }
            if (next.length() == 0) {
                modelEditor.addErrorMessage("noNext", "The Next formula must be provided", this.getId(), 3, nextTA);
                this.setComplete(false);
                this.expandSection(dm.getSectionForAttribute("modelBehaviorNext"));
            }
        }
        Control emails = UIHelper.getWidget((Object)dm.getAttributeControl("result.mail.address"));
        modelEditor.removeErrorMessage("email address invalid", emails);
        modelEditor.removeErrorMessage("email address missing", emails);
        TLCConsumptionProfile profile = this.getSelectedTLCProfile();
        if (profile != null && CLOUD_CONFIGURATION_KEY.equals(profile.getConfigurationKey())) {
            String text = this.resultMailAddressText.getText();
            try {
                InternetAddress.parse((String)text, (boolean)true);
            }
            catch (AddressException exp) {
                modelEditor.addErrorMessage("email address invalid", "For Cloud TLC to work please enter a valid email address.", this.getId(), 3, emails);
                this.setComplete(false);
                this.expandSection("__how_to_run");
            }
            if ("".equals(text.trim())) {
                modelEditor.addErrorMessage("email address missing", "For Cloud TLC to work please enter an email address.", this.getId(), 3, emails);
                this.setComplete(false);
                this.expandSection("__how_to_run");
            }
        }
        mm.setAutoUpdate(true);
        super.validatePage(switchToErrorPage);
    }

    public boolean hasLivenessProperty() {
        return ((CheckboxTableViewer)this.propertiesTable).getCheckedElements().length > 0;
    }

    public boolean workerCountCanBeModified() {
        return this.workerValueCanBeModified.get();
    }

    public int getWorkerCount() {
        return this.workerThreadCount.get();
    }

    public void setWorkerCount(int count) {
        this.workerThreadCount.set(count);
        this.setTLCProfileComboSelection(CUSTOM_TLC_PROFILE_DISPLAY_NAME);
        this.updateTLCResourcesLabel();
    }

    public boolean heapPercentageCanBeModified() {
        return this.heapPercentageCanBeModified.get();
    }

    public int getHeapPercentage() {
        return this.heapPercentage.get();
    }

    public void setHeapPercentage(int percentage) {
        this.heapPercentage.set(percentage);
        if (!this.currentProfileIsAdHoc.get()) {
            this.setTLCProfileComboSelection(CUSTOM_TLC_PROFILE_DISPLAY_NAME);
        }
        this.updateTLCResourcesLabel();
    }

    private void setHasVariables(boolean hasVariables) {
        String[] newItems = null;
        if (hasVariables) {
            if (this.behaviorCombo.indexOf(INIT_NEXT_COMBO_LABEL) == -1) {
                newItems = VARIABLE_BEHAVIOR_COMBO_ITEMS;
            }
        } else if (this.behaviorCombo.indexOf(INIT_NEXT_COMBO_LABEL) != -1) {
            newItems = NO_VARIABLE_BEHAVIOR_COMBO_ITEMS;
        }
        if (newItems != null) {
            String currentSelection = this.behaviorCombo.getText();
            this.behaviorCombo.removeAll();
            this.behaviorCombo.setItems(newItems);
            int index = this.behaviorCombo.indexOf(currentSelection);
            if (index != -1) {
                this.behaviorCombo.select(index);
            }
        }
    }

    private boolean setSpecSelection(int specType) {
        int index = -1;
        switch (specType) {
            case 0: {
                index = this.behaviorCombo.indexOf(NO_SPEC_COMBO_LABEL);
                break;
            }
            case 1: {
                index = this.behaviorCombo.indexOf(TEMPORAL_FORMULA_COMBO_LABEL);
                break;
            }
            case 2: {
                index = this.behaviorCombo.indexOf(INIT_NEXT_COMBO_LABEL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong spec type, this is a bug");
            }
        }
        if (index != -1 && index != this.behaviorCombo.getSelectionIndex()) {
            this.behaviorCombo.select(index);
            this.moveToTopOfBehaviorOptionsStack(this.behaviorCombo.getText());
            return true;
        }
        return false;
    }

    private int getModelConstantForSpecSelection() {
        String selectedBehavior = this.behaviorCombo.getText();
        int specType = TEMPORAL_FORMULA_COMBO_LABEL.equals(selectedBehavior) ? 1 : (INIT_NEXT_COMBO_LABEL.equals(selectedBehavior) ? 2 : (NO_SPEC_COMBO_LABEL.equals(selectedBehavior) ? 0 : 2));
        return specType;
    }

    @Override
    public void commit(boolean onSave) {
        Model model = this.getModel();
        String comments = FormHelper.trimTrailingSpaces(this.commentsSource.getDocument().get());
        model.setAttribute("modelComments", comments);
        String closedFormula = FormHelper.trimTrailingSpaces(this.specSource.getDocument().get());
        model.setAttribute("modelBehaviorSpec", closedFormula);
        String initFormula = FormHelper.trimTrailingSpaces(this.initFormulaSource.getDocument().get());
        model.setAttribute("modelBehaviorInit", initFormula);
        String nextFormula = FormHelper.trimTrailingSpaces(this.nextFormulaSource.getDocument().get());
        model.setAttribute("modelBehaviorNext", nextFormula);
        model.setAttribute("modelBehaviorSpecType", this.getModelConstantForSpecSelection());
        boolean checkDeadlock = this.checkDeadlockButton.getSelection();
        model.setAttribute("modelCorrectnessCheckDeadlock", checkDeadlock);
        TLCConsumptionProfile profile = this.getSelectedTLCProfile();
        String profileValue = profile != null ? profile.getPreferenceValue() : CUSTOM_TLC_PROFILE_PREFERENCE_VALUE;
        model.setAttribute("tlcResourcesProfile", profileValue);
        model.setAttribute("numberOfWorkers", this.workerThreadCount.get());
        model.setAttribute("maxHeapSize", this.heapPercentage.get());
        if (profile != null && profile.profileIsForRemoteWorkers()) {
            model.setAttribute("distributedTLC", profile.getPreferenceValue());
        } else {
            model.setAttribute("distributedTLC", "off");
        }
        String resultMailAddress = this.resultMailAddressText.getText();
        model.setAttribute("result.mail.address", resultMailAddress);
        model.setAttribute("distributedFPSetCount", this.distributedFPSetCountSpinner.getSelection());
        model.setAttribute("distributedNodesCount", this.distributedNodesCountSpinner.getSelection());
        String iface = "";
        int index = this.networkInterfaceCombo.getSelectionIndex();
        iface = index == -1 ? this.networkInterfaceCombo.getText() : this.networkInterfaceCombo.getItem(index);
        model.setAttribute("distributedNetworkInterface", iface);
        List<String> serializedList = FormHelper.getSerializedInput(this.invariantsTable);
        model.setAttribute("modelCorrectnessInvariants", serializedList);
        serializedList = FormHelper.getSerializedInput(this.propertiesTable);
        model.setAttribute("modelCorrectnessProperties", serializedList);
        List<String> constants = FormHelper.getSerializedInput(this.constantTable);
        model.setAttribute("modelParameterConstants", constants);
        String variables = ModelHelper.createVariableList((ModuleNode)SemanticHelper.getRootModuleNode());
        model.setAttribute("modelBehaviorVars", variables);
        super.commit(onSave);
    }

    public List<Assignment> getConstants() {
        List constants = (List)this.constantTable.getInput();
        if (constants == null) {
            return new ArrayList<Assignment>();
        }
        return constants;
    }

    @Override
    protected void createBodyContent(IManagedForm managedForm) {
        DataBindingManager dm = this.getDataBindingManager();
        int sectionFlags = 388;
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        this.installTopMargin(body);
        TableWrapLayout twl = new TableWrapLayout();
        twl.leftMargin = 0;
        twl.rightMargin = 0;
        twl.numColumns = 2;
        body.setLayout((Layout)twl);
        Section section = FormHelper.createSectionComposite(body, "Model description (optional)", "", toolkit, sectionFlags, this.getExpansionListener());
        TableWrapData twd = new TableWrapData();
        twd.colspan = 2;
        twd.grabHorizontal = true;
        twd.align = 128;
        section.setLayoutData((Object)twd);
        SectionPart commentsPart = new SectionPart(section);
        this.getDataBindingManager().bindSection(commentsPart, "__what_is_the_description", this.getId());
        managedForm.addPart((IFormPart)commentsPart);
        DirtyMarkingListener commentsListener = new DirtyMarkingListener((AbstractFormPart)commentsPart, true);
        Composite commentsArea = (Composite)section.getClient();
        commentsArea.setLayout((Layout)new TableWrapLayout());
        this.commentsSource = FormHelper.createFormsSourceViewer(toolkit, commentsArea, 576);
        twd = new TableWrapData(256);
        twd.heightHint = 60;
        this.commentsSource.addTextListener((ITextListener)commentsListener);
        this.commentsSource.getTextWidget().setLayoutData((Object)twd);
        this.commentsSource.getTextWidget().addFocusListener(this.focusListener);
        toolkit.paintBordersFor(commentsArea);
        dm.bindAttribute("modelComments", this.commentsSource, commentsPart);
        Composite linkLineComposite = new Composite(body, 0);
        twd = new TableWrapData();
        twd.colspan = 2;
        twd.grabHorizontal = true;
        twd.align = 8;
        linkLineComposite.setLayoutData((Object)twd);
        linkLineComposite.setBackground(body.getDisplay().getSystemColor(1));
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginRight = 36;
        gl.horizontalSpacing = 0;
        linkLineComposite.setLayout((Layout)gl);
        Hyperlink hyper = toolkit.createHyperlink(linkLineComposite, "Additional Spec Options", 0);
        hyper.addHyperlinkListener((IHyperlinkListener)this.advancedModelOptionsOpener);
        Font baseFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        FontData[] baseFD = baseFont.getFontData();
        FontData biggerLinkFD = new FontData(baseFD[0].getName(), baseFD[0].getHeight() + 1, baseFD[0].getStyle());
        Font biggerLinkFont = new Font((Device)body.getDisplay(), biggerLinkFD);
        hyper.setFont(biggerLinkFont);
        Composite left = toolkit.createComposite(body);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        left.setLayout((Layout)gl);
        twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        left.setLayoutData((Object)twd);
        Composite right = toolkit.createComposite(body);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        right.setLayout((Layout)gl);
        twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        right.setLayoutData((Object)twd);
        section = FormHelper.createSectionComposite(left, "What is the behavior spec?", "", toolkit, sectionFlags | 0x40, this.getExpansionListener());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        section.setLayoutData((Object)gd);
        Composite behaviorArea = (Composite)section.getClient();
        behaviorArea.setLayout((Layout)new GridLayout(1, false));
        ValidateableSectionPart behaviorPart = new ValidateableSectionPart(section, this, "__what_is_the_spec");
        managedForm.addPart((IFormPart)behaviorPart);
        DirtyMarkingListener whatIsTheSpecListener = new DirtyMarkingListener((AbstractFormPart)behaviorPart, true);
        this.behaviorCombo = new Combo(behaviorArea, 8);
        this.behaviorCombo.setItems(VARIABLE_BEHAVIOR_COMBO_ITEMS);
        this.behaviorCombo.addFocusListener(this.focusListener);
        this.behaviorCombo.addSelectionListener((SelectionListener)whatIsTheSpecListener);
        this.behaviorCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                MainModelPage.this.moveToTopOfBehaviorOptionsStack(MainModelPage.this.behaviorCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.behaviorCombo.setLayoutData((Object)gd);
        dm.bindAttribute("modelBehaviorNoSpec", this.behaviorCombo, behaviorPart);
        this.behaviorOptions = new Composite(behaviorArea, 0);
        StackLayout stackLayout = new StackLayout();
        this.behaviorOptions.setLayout((Layout)stackLayout);
        Composite noSpecComposite = new Composite(this.behaviorOptions, 0);
        this.behaviorOptions.setData(NO_SPEC_COMBO_LABEL, (Object)noSpecComposite);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.minimumHeight = 1;
        this.behaviorOptions.setLayoutData((Object)gd);
        stackLayout.topControl = noSpecComposite;
        Composite initNextComposite = new Composite(this.behaviorOptions, 0);
        this.behaviorOptions.setData(INIT_NEXT_COMBO_LABEL, (Object)initNextComposite);
        initNextComposite.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        initNextComposite.setLayoutData((Object)gd);
        toolkit.createLabel(initNextComposite, "Init:");
        this.initFormulaSource = FormHelper.createFormsSourceViewer(toolkit, initNextComposite, 2562);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 48;
        StyledText st = this.initFormulaSource.getTextWidget();
        st.setLayoutData((Object)gd);
        st.addModifyListener((ModifyListener)whatIsTheSpecListener);
        st.addFocusListener(this.focusListener);
        st.addTraverseListener(event -> {
            event.doit = true;
        });
        dm.bindAttribute("modelBehaviorInit", this.initFormulaSource, behaviorPart);
        toolkit.createLabel(initNextComposite, "Next:");
        this.nextFormulaSource = FormHelper.createFormsSourceViewer(toolkit, initNextComposite, 2562);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 48;
        st = this.nextFormulaSource.getTextWidget();
        st.setLayoutData((Object)gd);
        st.addModifyListener((ModifyListener)whatIsTheSpecListener);
        st.addFocusListener(this.focusListener);
        st.addTraverseListener(event -> {
            event.doit = true;
        });
        dm.bindAttribute("modelBehaviorNext", this.nextFormulaSource, behaviorPart);
        Composite temporalFormulaComposite = new Composite(this.behaviorOptions, 0);
        this.behaviorOptions.setData(TEMPORAL_FORMULA_COMBO_LABEL, (Object)temporalFormulaComposite);
        temporalFormulaComposite.setLayout((Layout)new GridLayout(1, true));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        temporalFormulaComposite.setLayoutData((Object)gd);
        this.specSource = FormHelper.createFormsSourceViewer(toolkit, temporalFormulaComposite, 2560);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.minimumHeight = 55;
        this.specSource.getTextWidget().setLayoutData((Object)gd);
        this.specSource.getTextWidget().addModifyListener((ModifyListener)whatIsTheSpecListener);
        dm.bindAttribute("modelBehaviorSpec", this.specSource, behaviorPart);
        section = FormHelper.createSectionComposite(body, "What to check?", "", toolkit, sectionFlags & 0xFFFFFF7F | 0x40, this.getExpansionListener());
        twd = new TableWrapData();
        twd.colspan = 2;
        twd.grabHorizontal = true;
        twd.align = 128;
        section.setLayoutData((Object)twd);
        Composite toBeCheckedArea = (Composite)section.getClient();
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        toBeCheckedArea.setLayout((Layout)gl);
        this.checkDeadlockButton = toolkit.createButton(toBeCheckedArea, "Deadlock", 32);
        ValidateableSectionPart toBeCheckedPart = new ValidateableSectionPart(section, this, "__what_to_check");
        managedForm.addPart((IFormPart)toBeCheckedPart);
        DirtyMarkingListener whatToCheckListener = new DirtyMarkingListener((AbstractFormPart)toBeCheckedPart, true);
        this.checkDeadlockButton.addSelectionListener((SelectionListener)whatToCheckListener);
        ValidateableTableSectionPart invariantsPart = new ValidateableTableSectionPart(toBeCheckedArea, "Invariants", "Formulas true in every reachable state.", toolkit, sectionFlags, this, "__what_to_check_invariants");
        managedForm.addPart((IFormPart)invariantsPart);
        this.invariantsTable = invariantsPart.getTableViewer();
        dm.bindAttribute("modelCorrectnessInvariants", this.invariantsTable, invariantsPart);
        ValidateableTableSectionPart propertiesPart = new ValidateableTableSectionPart(toBeCheckedArea, "Properties", "Temporal formulas true for every possible behavior.", toolkit, sectionFlags, this, "__what_to_check_properties");
        managedForm.addPart((IFormPart)propertiesPart);
        this.propertiesTable = propertiesPart.getTableViewer();
        dm.bindAttribute("modelCorrectnessProperties", this.propertiesTable, propertiesPart);
        ValidateableConstantSectionPart constantsPart = new ValidateableConstantSectionPart(right, "What is the model?", "Specify the values of declared constants.", toolkit, sectionFlags, this, "__what_is_the_model");
        gd = new GridData(768);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        constantsPart.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)constantsPart);
        this.constantTable = constantsPart.getTableViewer();
        dm.bindAttribute("modelParameterConstants", this.constantTable, constantsPart);
        linkLineComposite = new Composite(body, 0);
        twd = new TableWrapData();
        twd.colspan = 2;
        twd.grabHorizontal = true;
        twd.align = 8;
        linkLineComposite.setLayoutData((Object)twd);
        linkLineComposite.setBackground(body.getDisplay().getSystemColor(1));
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginRight = 36;
        gl.horizontalSpacing = 0;
        linkLineComposite.setLayout((Layout)gl);
        hyper = toolkit.createHyperlink(linkLineComposite, "Additional TLC Options", 0);
        hyper.addHyperlinkListener((IHyperlinkListener)this.advancedTLCOptionsOpener);
        hyper.setFont(biggerLinkFont);
        section = FormHelper.createSectionComposite(body, "How to run?", "", toolkit, sectionFlags, this.getExpansionListener());
        twd = new TableWrapData();
        twd.colspan = 2;
        twd.grabHorizontal = true;
        twd.align = 128;
        section.setLayoutData((Object)twd);
        Composite howToRunArea = (Composite)section.getClient();
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.verticalSpacing = 2;
        howToRunArea.setLayout((Layout)gl);
        ValidateableSectionPart howToRunPart = new ValidateableSectionPart(section, this, "__how_to_run");
        managedForm.addPart((IFormPart)howToRunPart);
        DirtyMarkingListener howToRunListener = new DirtyMarkingListener((AbstractFormPart)howToRunPart, true);
        toolkit.createLabel(howToRunArea, "System resources dedicated to TLC:");
        this.tlcProfileCombo = new Combo(howToRunArea, 8);
        this.tlcProfileCombo.setItems(TLC_PROFILE_DISPLAY_NAMES);
        this.tlcProfileCombo.addSelectionListener((SelectionListener)howToRunListener);
        this.tlcProfileCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                boolean needReset;
                String selectedText = MainModelPage.this.tlcProfileCombo.getText();
                boolean bl = needReset = MainModelPage.TLC_PROFILE_LOCAL_SEPARATOR.equals(selectedText) || MainModelPage.TLC_PROFILE_REMOTE_SEPARATOR.equals(selectedText);
                if (needReset) {
                    MainModelPage.this.tlcProfileCombo.select(MainModelPage.this.lastSelectedTLCProfileIndex.get());
                } else {
                    TLCConsumptionProfile profile = TLCConsumptionProfile.getProfileWithDisplayName(selectedText);
                    MainModelPage.this.lastSelectedTLCProfileIndex.set(MainModelPage.this.tlcProfileCombo.getSelectionIndex());
                    MainModelPage.this.currentProfileIsAdHoc.set(false);
                    if (profile != null) {
                        MainModelPage.this.workerThreadCount.set(profile.getWorkerThreads());
                        MainModelPage.this.heapPercentage.set(profile.getMemoryPercentage());
                        IFormPage iep = MainModelPage.this.getEditor().findPage("AdvancedTLCOptionsPage");
                        if (iep != null) {
                            ((AdvancedTLCOptionsPage)iep).updateWorkersAndMemory(profile.getWorkerThreads(), profile.getMemoryPercentage());
                        }
                        MainModelPage.this.removeCustomTLCProfileComboItemIfPresent();
                        if (profile.profileIsForRemoteWorkers()) {
                            String configuration = profile.getConfigurationKey();
                            boolean isAdHoc = configuration.equals(TLCConsumptionProfile.REMOTE_AD_HOC.getConfigurationKey());
                            MainModelPage.this.moveToTopOfDistributedOptionsStack(configuration, false, isAdHoc);
                            if (isAdHoc) {
                                MainModelPage.this.currentProfileIsAdHoc.set(true);
                                MainModelPage.this.clearEmailErrors();
                            }
                        } else {
                            MainModelPage.this.moveToTopOfDistributedOptionsStack("off", true, true);
                            MainModelPage.this.clearEmailErrors();
                        }
                    } else {
                        MainModelPage.this.moveToTopOfDistributedOptionsStack("off", true, true);
                        MainModelPage.this.clearEmailErrors();
                    }
                }
                MainModelPage.this.updateTLCResourcesLabel();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        gd = new GridData();
        gd.horizontalIndent = 30;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.tlcProfileCombo.setLayoutData((Object)gd);
        this.lastSelectedTLCProfileIndex = new AtomicInteger(this.tlcProfileCombo.getSelectionIndex());
        this.tlcResourceSummaryLabel = toolkit.createLabel(howToRunArea, "");
        this.tlcResourceSummaryLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 0x1000000;
        this.tlcResourceSummaryLabel.setLayoutData((Object)gd);
        linkLineComposite = new Composite(howToRunArea, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 0x1000000;
        linkLineComposite.setLayoutData((Object)gd);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        linkLineComposite.setLayout((Layout)gl);
        this.tlcTuneHyperlink = toolkit.createHyperlink(linkLineComposite, "Tune these parameters and set defaults", 0);
        this.tlcTuneHyperlink.addHyperlinkListener((IHyperlinkListener)this.advancedTLCOptionsOpener);
        baseFont = JFaceResources.getFont((String)"org.eclipse.jface.dialogfont");
        baseFD = baseFont.getFontData();
        FontData smaller = new FontData(baseFD[0].getName(), baseFD[0].getHeight() - 2, baseFD[0].getStyle());
        this.tlcTuneHyperlink.setFont(new Font((Device)body.getDisplay(), smaller));
        this.distributedOptions = new Composite(howToRunArea, 0);
        stackLayout = new StackLayout();
        this.distributedOptions.setLayout((Layout)stackLayout);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.distributedOptions.setLayoutData((Object)gd);
        Composite offComposite = new Composite(this.distributedOptions, 0);
        this.distributedOptions.setData("off", (Object)offComposite);
        stackLayout.topControl = offComposite;
        Composite adHocOptions = new Composite(this.distributedOptions, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        adHocOptions.setLayout((Layout)gl);
        this.distributedOptions.setData(TLCConsumptionProfile.REMOTE_AD_HOC.getConfigurationKey(), (Object)adHocOptions);
        Button helpButton = HelpButton.helpButton((Composite)adHocOptions, (String)"model/distributed-mode.html");
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 0x1000008;
        helpButton.setLayoutData((Object)gd);
        toolkit.createLabel(adHocOptions, "Master's network address:");
        this.networkInterfaceCombo = new Combo(adHocOptions, 0);
        this.networkInterfaceCombo.addSelectionListener((SelectionListener)howToRunListener);
        this.networkInterfaceCombo.addFocusListener(this.focusListener);
        gd = new GridData();
        gd.horizontalIndent = 10;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.networkInterfaceCombo.setLayoutData((Object)gd);
        this.networkInterfaceCombo.setToolTipText("IP address to which workers (and distributed fingerprint sets) will connect.");
        this.networkInterfaceCombo.addSelectionListener((SelectionListener)howToRunListener);
        this.networkInterfaceCombo.addFocusListener(this.focusListener);
        try {
            Comparator<InetAddress> comparator = new Comparator<InetAddress>(){

                @Override
                public int compare(InetAddress o1, InetAddress o2) {
                    if (o1 instanceof Inet4Address && o2 instanceof Inet6Address) {
                        return -1;
                    }
                    if (o1 instanceof Inet6Address && o2 instanceof Inet4Address) {
                        return 1;
                    }
                    if (!o1.isLoopbackAddress() && o2.isLoopbackAddress()) {
                        return -1;
                    }
                    if (o1.isLoopbackAddress() && !o2.isLoopbackAddress()) {
                        return 1;
                    }
                    if (!o1.isSiteLocalAddress() && o2.isSiteLocalAddress()) {
                        return -1;
                    }
                    if (o1.isSiteLocalAddress() && !o2.isSiteLocalAddress()) {
                        return 1;
                    }
                    return 0;
                }
            };
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                NetworkInterface iface = nets.nextElement();
                Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress addr = inetAddresses.nextElement();
                    if (addr.isMulticastAddress()) continue;
                    addresses.add(addr);
                }
            }
            Collections.sort(addresses, comparator);
            for (InetAddress inetAddress : addresses) {
                this.networkInterfaceCombo.add(inetAddress.getHostAddress());
            }
            this.networkInterfaceCombo.select(0);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        dm.bindAttribute("distributedNetworkInterface", this.networkInterfaceCombo, howToRunPart);
        toolkit.createLabel(adHocOptions, "Number of distributed fingerprint sets (zero for single built-in set):");
        this.distributedFPSetCountSpinner = new Spinner(adHocOptions, 0);
        this.distributedFPSetCountSpinner.addSelectionListener((SelectionListener)howToRunListener);
        this.distributedFPSetCountSpinner.addFocusListener(this.focusListener);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 10;
        gd.widthHint = 40;
        this.distributedFPSetCountSpinner.setLayoutData((Object)gd);
        this.distributedFPSetCountSpinner.setMinimum(0);
        this.distributedFPSetCountSpinner.setMaximum(64);
        this.distributedFPSetCountSpinner.setPageIncrement(1);
        this.distributedFPSetCountSpinner.setToolTipText("Determines how many distributed FPSets will be expected by the TLCServer process");
        this.distributedFPSetCountSpinner.setSelection(0);
        dm.bindAttribute("distributedFPSetCount", this.distributedFPSetCountSpinner, howToRunPart);
        Composite jcloudsOptions = new Composite(this.distributedOptions, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        jcloudsOptions.setLayout((Layout)gl);
        helpButton = HelpButton.helpButton((Composite)jcloudsOptions, (String)"cloudtlc/index.html");
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 0x1000008;
        helpButton.setLayoutData((Object)gd);
        toolkit.createLabel(jcloudsOptions, "Number of compute nodes to use:");
        this.distributedNodesCountSpinner = new Spinner(jcloudsOptions, 0);
        this.distributedNodesCountSpinner.addSelectionListener((SelectionListener)howToRunListener);
        this.distributedNodesCountSpinner.addFocusListener(this.focusListener);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 10;
        gd.widthHint = 40;
        this.distributedNodesCountSpinner.setLayoutData((Object)gd);
        this.distributedNodesCountSpinner.setMinimum(1);
        this.distributedNodesCountSpinner.setMaximum(64);
        this.distributedNodesCountSpinner.setPageIncrement(1);
        this.distributedNodesCountSpinner.setToolTipText("Determines how many compute nodes/VMs will be launched. More VMs means faster results and higher costs.");
        this.distributedNodesCountSpinner.setSelection(1);
        dm.bindAttribute("distributedNodesCount", this.distributedNodesCountSpinner, howToRunPart);
        toolkit.createLabel(jcloudsOptions, "Result mailto addresses:");
        this.resultMailAddressText = toolkit.createText(jcloudsOptions, "", 2048);
        this.resultMailAddressText.setMessage("my-name@my-domain.org,alternative-name@alternative-domain.org");
        String resultAddressTooltip = "A list (comma-separated) of one to N email addresses to send the model checking result to.";
        this.resultMailAddressText.setToolTipText("A list (comma-separated) of one to N email addresses to send the model checking result to.");
        this.resultMailAddressText.addKeyListener((KeyListener)new KeyAdapter(){
            private final ModelEditor modelEditor;
            {
                this.modelEditor = (ModelEditor)MainModelPage.this.getEditor();
            }

            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                try {
                    String text = MainModelPage.this.resultMailAddressText.getText();
                    InternetAddress.parse((String)text, (boolean)true);
                }
                catch (AddressException exp) {
                    this.modelEditor.addErrorMessage("emailAddressInvalid", "Invalid email address", MainModelPage.this.getId(), 3, (Control)MainModelPage.this.resultMailAddressText);
                    return;
                }
                MainModelPage.this.clearEmailErrors();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 10;
        gd.minimumWidth = 330;
        this.resultMailAddressText.setLayoutData((Object)gd);
        this.resultMailAddressText.addModifyListener((ModifyListener)howToRunListener);
        dm.bindAttribute("result.mail.address", this.resultMailAddressText, howToRunPart);
        this.distributedOptions.setData(CLOUD_CONFIGURATION_KEY, (Object)jcloudsOptions);
        linkLineComposite = new Composite(body, 0);
        twd = new TableWrapData();
        twd.colspan = 2;
        twd.grabHorizontal = true;
        twd.align = 8;
        linkLineComposite.setLayoutData((Object)twd);
        linkLineComposite.setBackground(body.getDisplay().getSystemColor(1));
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginRight = 36;
        gl.horizontalSpacing = 0;
        linkLineComposite.setLayout((Layout)gl);
        hyper = toolkit.createHyperlink(linkLineComposite, "Evaluate Constant Expressions", 0);
        hyper.addHyperlinkListener((IHyperlinkListener)this.resultsPageOpener);
        hyper.setFont(biggerLinkFont);
        this.dirtyPartListeners.add((Object)commentsListener);
        this.dirtyPartListeners.add((Object)whatIsTheSpecListener);
        this.dirtyPartListeners.add((Object)whatToCheckListener);
        this.dirtyPartListeners.add((Object)howToRunListener);
        this.getSite().setSelectionProvider(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return null;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
    }

    private void moveToTopOfDistributedOptionsStack(String id, boolean enableWorker, boolean enableMaxHeap) {
        this.workerValueCanBeModified.set(enableWorker);
        this.heapPercentageCanBeModified.set(enableMaxHeap);
        IFormPage iep = this.getEditor().findPage("AdvancedTLCOptionsPage");
        if (iep != null) {
            ((AdvancedTLCOptionsPage)iep).setWorkerAndMemoryEnable(enableWorker, enableMaxHeap);
        }
        this.moveCompositeWithIdToTopOfStack(id, this.distributedOptions);
        this.distributedOptions.getParent().getParent().layout();
    }

    private void moveToTopOfBehaviorOptionsStack(String id) {
        this.moveCompositeWithIdToTopOfStack(id, this.behaviorOptions);
    }

    private void moveCompositeWithIdToTopOfStack(String id, Composite parent) {
        Composite composite = (Composite)parent.getData(id);
        StackLayout stackLayout = (StackLayout)parent.getLayout();
        stackLayout.topControl = composite;
        parent.layout();
    }

    private TLCConsumptionProfile getSelectedTLCProfile() {
        return TLCConsumptionProfile.getProfileWithDisplayName(this.tlcProfileCombo.getText());
    }

    private void clearEmailErrors() {
        ((ModelEditor)this.getEditor()).removeErrorMessage("emailAddressInvalid", (Control)this.resultMailAddressText);
    }

    private void setTLCProfileComboSelection(String displayName) {
        int index = this.tlcProfileCombo.indexOf(displayName);
        if (index != -1) {
            this.tlcProfileCombo.select(index);
            if (!CUSTOM_TLC_PROFILE_DISPLAY_NAME.equals(displayName)) {
                this.removeCustomTLCProfileComboItemIfPresent();
            }
        } else if (CUSTOM_TLC_PROFILE_DISPLAY_NAME.equals(displayName)) {
            this.tlcProfileCombo.add(displayName, 1);
            this.tlcProfileCombo.select(1);
        }
        this.lastSelectedTLCProfileIndex.set(this.tlcProfileCombo.getSelectionIndex());
    }

    private void removeCustomTLCProfileComboItemIfPresent() {
        if (this.tlcProfileCombo.getItem(1).equals(CUSTOM_TLC_PROFILE_DISPLAY_NAME)) {
            this.tlcProfileCombo.remove(1);
        }
    }

    private void updateTLCResourcesLabel() {
        TLCConsumptionProfile profile = this.getSelectedTLCProfile();
        StringBuilder sb = new StringBuilder();
        if (profile == null || !profile.profileIsForRemoteWorkers() || TLCConsumptionProfile.REMOTE_AD_HOC.equals((Object)profile)) {
            if (profile != null && profile.profileIsForRemoteWorkers()) {
                sb.append("Allocating ");
            } else {
                int workerCount = this.workerThreadCount.get();
                sb.append(workerCount).append(" worker");
                if (workerCount > 1) {
                    sb.append('s');
                }
                sb.append(" allocated ");
            }
            sb.append(this.generateMemoryDisplayText()).append(" of system memory.");
        }
        this.tlcResourceSummaryLabel.setText(sb.toString());
        this.tlcTuneHyperlink.setVisible(sb.toString().length() > 0);
    }

    private String generateMemoryDisplayText() {
        int percentage = this.heapPercentage.get();
        long megabytes = TLCRuntime.getInstance().getAbsolutePhysicalSystemMemory((double)percentage / 100.0);
        return MainModelPage.generateMemoryDisplayText(percentage, megabytes);
    }

    private void installTopMargin(Composite body) {
        Layout l;
        Composite c = body;
        CTabFolder tabFolder = c instanceof CTabFolder ? (CTabFolder)c : null;
        while (tabFolder == null && c.getParent() != null) {
            CTabFolder cTabFolder = tabFolder = (c = c.getParent()) instanceof CTabFolder ? (CTabFolder)c : null;
        }
        if (tabFolder != null && (l = tabFolder.getParent().getLayout()) instanceof FillLayout) {
            FillLayout fl = (FillLayout)l;
            fl.marginHeight = 6;
        }
    }
}

