/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.lamport.tla.toolbox.tool.tlc.ui.wizard.AssignmentWizard;
import org.lamport.tla.toolbox.util.UIHelper;
import tlc2.model.Assignment;
import tlc2.model.TypedSet;

public class TypingWizardPage
extends WizardPage {
    private Combo typeCombo;
    private Button optionUntyped;
    private Button optionTyped;
    private Label label;
    private final String helpId;

    protected TypingWizardPage(String action, String description, String helpId) {
        super("TypingWizardPage");
        this.setTitle(action);
        this.setDescription(description);
        this.setMessage("The set of model values you chose are untyped.  Do you want to assign types to these values?\nHit the  ?  button for help (especially if you chose the `Symmetry set' option)");
        this.helpId = helpId;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(16384, 128, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.optionUntyped = new Button(container, 16);
        this.optionUntyped.setText("Leave untyped");
        GridData gd = new GridData(16384, 128, false, false);
        gd.horizontalSpan = 2;
        this.optionUntyped.setLayoutData((Object)gd);
        this.optionTyped = new Button(container, 16);
        this.optionTyped.setText("Make typed:");
        this.optionTyped.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypingWizardPage.this.typeCombo.setEnabled(TypingWizardPage.this.optionTyped.getSelection());
                TypingWizardPage.this.label.setEnabled(TypingWizardPage.this.optionTyped.getSelection());
            }
        });
        gd = new GridData(16384, 128, false, false);
        gd.horizontalSpan = 2;
        this.optionTyped.setLayoutData((Object)gd);
        this.label = new Label(container, 0);
        this.label.setText("Type:");
        gd = new GridData(16384, 128, false, false);
        gd.horizontalIndent = 10;
        this.label.setLayoutData((Object)gd);
        this.typeCombo = new Combo(container, 2048);
        char i = 'A';
        while (i < 'z') {
            if (Character.isLetter(i)) {
                this.typeCombo.add("" + i);
            }
            i = (char)(i + '\u0001');
        }
        gd = new GridData(16384, 128, false, false);
        this.typeCombo.setLayoutData((Object)gd);
        this.optionUntyped.setSelection(true);
        this.typeCombo.setText("A");
        UIHelper.setHelp((Control)container, (String)this.helpId);
        this.setControl((Control)container);
    }

    public void dispose() {
        if (this.isCurrentPage() && this.optionTyped.getSelection()) {
            String type = this.typeCombo.getText();
            Assignment assignment = ((AssignmentWizard)this.getWizard()).getFormula();
            TypedSet set = TypedSet.parseSet((String)assignment.getRight());
            set.setType(type);
            assignment.setRight(set.toString());
        }
        super.dispose();
    }
}

