/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.preference;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.util.UIHelper;

public class TLCPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public TLCPreferencePage() {
        super(1);
        TLCUIActivator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IPreferenceStore store = TLCActivator.getDefault().getPreferenceStore();
                if ("numberOfSnapshotsToKeep".equals(event.getProperty())) {
                    store.setValue("numberOfSnapshotsToKeep", ((Integer)event.getNewValue()).intValue());
                }
            }
        });
        this.setPreferenceStore(TLCUIActivator.getDefault().getPreferenceStore());
        this.setDescription("TLC Model Checker preferences");
    }

    protected Control createContents(Composite parent) {
        Control pageControl = super.createContents(parent);
        UIHelper.setHelp((Control)pageControl, (String)"TLCPreferencePage");
        return pageControl;
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("popupOnMCErrors", "&Always pop up TLC errors view", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("revalidateOnModify", "&Re-validate model on save", this.getFieldEditorParent()));
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor("numberOfSnapshotsToKeep", "Number of model &snapshots to keep", this.getFieldEditorParent());
        integerFieldEditor.setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)integerFieldEditor);
        this.addField((FieldEditor)new IntegerFieldEditor("maxHeapSizeDefault", "Maximum JVM Heap Size default in % of physical system memory", this.getFieldEditorParent()));
        integerFieldEditor = new IntegerFieldEditor("traceMaxShowErrors", "Default number of states shown in error traces", this.getFieldEditorParent());
        integerFieldEditor.setValidRange(1, Integer.MAX_VALUE);
        this.addField((FieldEditor)integerFieldEditor);
    }

    public void init(IWorkbench workbench) {
    }
}

