/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.tool.tlc.output.data.ActionInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.ModuleCoverageInformation;
import org.lamport.tla.toolbox.util.AdapterFactory;
import tla2sany.st.Location;
import tlc2.tool.coverage.ActionWrapper;

public class CoverageInformation {
    private final List<CoverageInformationItem> items = new ArrayList<CoverageInformationItem>();
    private final Map<String, IDocument> nameToDocument = new HashMap<String, IDocument>();
    private final Map<IFile, ModuleCoverageInformation> fileToFCI = new HashMap<IFile, ModuleCoverageInformation>();

    public CoverageInformation() {
    }

    public CoverageInformation(List<IFile> savedTLAFiles) {
        for (IFile iFile : savedTLAFiles) {
            try {
                FileDocumentProvider fileDocumentProvider = new FileDocumentProvider();
                FileEditorInput fei = new FileEditorInput(iFile);
                fileDocumentProvider.connect((Object)fei);
                IDocument document = fileDocumentProvider.getDocument((Object)fei);
                this.nameToDocument.put(iFile.getName(), document);
            }
            catch (CoreException notExpectedToHappen) {
                notExpectedToHappen.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CoverageInformationItem item) {
        try {
            String filename = item.getModuleLocation().source() + ".tla";
            if (this.nameToDocument.containsKey(filename)) {
                IDocument document = this.nameToDocument.get(filename);
                IRegion region = AdapterFactory.locationToRegion((IDocument)document, (Location)item.getModuleLocation());
                item.setRegion(region);
            }
        }
        catch (BadLocationException notExpectedToHappen) {
            notExpectedToHappen.printStackTrace();
        }
        List<CoverageInformationItem> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActionInformationItem> getDisabledSpecActions() {
        List<CoverageInformationItem> list = this.items;
        synchronized (list) {
            return this.items.stream().filter(item -> item instanceof ActionInformationItem && ((ActionInformationItem)item).getRelation() != ActionWrapper.Relation.PROP && ((ActionInformationItem)item).getRelation() != ActionWrapper.Relation.CONSTRAINT && ((ActionInformationItem)item).getCount() == 0L).map(item -> (ActionInformationItem)item).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDisabledSpecActions() {
        List<CoverageInformationItem> list = this.items;
        synchronized (list) {
            return this.items.stream().filter(item -> item instanceof ActionInformationItem && ((ActionInformationItem)item).getRelation() != ActionWrapper.Relation.PROP && ((ActionInformationItem)item).getRelation() != ActionWrapper.Relation.CONSTRAINT && ((ActionInformationItem)item).getCount() == 0L).findAny().isPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActionInformationItem> getSpecActions() {
        List<CoverageInformationItem> list = this.items;
        synchronized (list) {
            return this.items.stream().filter(item -> item instanceof ActionInformationItem && ((ActionInformationItem)item).getRelation() != ActionWrapper.Relation.PROP && ((ActionInformationItem)item).getRelation() != ActionWrapper.Relation.CONSTRAINT).map(item -> (ActionInformationItem)item).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLegacy() {
        List<CoverageInformationItem> list = this.items;
        synchronized (list) {
            return !this.items.stream().filter(i -> i instanceof ActionInformationItem).findAny().isPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(IFile iFile) {
        List<CoverageInformationItem> list = this.items;
        synchronized (list) {
            return this.items.stream().filter(i -> i.isInFile(iFile)).findAny().isPresent();
        }
    }

    public ModuleCoverageInformation projectionFor(IFile iFile) {
        return this.fileToFCI.computeIfAbsent(iFile, f -> new ModuleCoverageInformation((IFile)f, this.items));
    }
}

