/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.lamport.tla.toolbox.AbstractTLCActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.util.ExecutionStatisticsDialog;
import org.lamport.tla.toolbox.util.UIHelper;
import org.osgi.framework.BundleContext;
import util.ExecutionStatisticsCollector;

public class TLCUIActivator
extends AbstractTLCActivator {
    public static final String PLUGIN_ID = "org.lamport.tla.toolbox.tool.tlc.ui";
    private static TLCUIActivator plugin;
    private Font courierFont;
    private Font outputFont;
    private Color changedColor;
    private Color addedColor;
    private Color deletedColor;

    public TLCUIActivator() {
        super(PLUGIN_ID);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.changedColor = new Color(null, 255, 200, 200);
        this.addedColor = new Color(null, 255, 255, 200);
        this.deletedColor = new Color(null, 240, 240, 255);
        if (Display.getCurrent() != null && ExecutionStatisticsCollector.promptUser()) {
            UIJob j = new UIJob(Display.getCurrent(), "TLA+ execution statistics approval."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    new ExecutionStatisticsDialog(false, PlatformUI.createDisplay().getActiveShell()).open();
                    return Status.OK_STATUS;
                }
            };
            j.schedule(300000L);
        }
    }

    public Color getChangedColor() {
        return this.changedColor;
    }

    public Color getAddedColor() {
        return this.addedColor;
    }

    public Color getDeletedColor() {
        return this.deletedColor;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.courierFont != null) {
            this.courierFont.dispose();
        }
        if (this.outputFont != null) {
            this.outputFont.dispose();
        }
        this.addedColor.dispose();
        this.changedColor.dispose();
        this.deletedColor.dispose();
        plugin = null;
        super.stop(context);
    }

    public static TLCUIActivator getDefault() {
        return plugin;
    }

    public synchronized Font getCourierFont() {
        if (this.courierFont == null) {
            this.courierFont = new Font((Device)UIHelper.getShellProvider().getShell().getDisplay(), "Courier New", 11, 0);
        }
        return this.courierFont;
    }

    public Font getOutputFont() {
        if (this.outputFont == null) {
            this.outputFont = new Font((Device)UIHelper.getShellProvider().getShell().getDisplay(), "Courier New", 8, 0);
        }
        return this.outputFont;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return TLCUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Color getColor(int color) {
        return UIHelper.getShellProvider().getShell().getDisplay().getSystemColor(color);
    }
}

