/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.traceexplorer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.dialog.ExtraModulesDialog;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.provider.FormulaContentProvider;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.view.TLCErrorView;
import org.lamport.tla.toolbox.tool.tlc.ui.wizard.FormulaWizard;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import org.lamport.tla.toolbox.util.RCPNameToFileIStream;
import tlc2.model.Formula;
import util.FilenameToStream;

public class TraceExplorerComposite {
    private static final String EXPANDED_STATE = "EXPANDED_STATE";
    protected CheckboxTableViewer tableViewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private Button buttonExplore;
    private Button buttonRestore;
    private Section section;
    private TLCErrorView view;
    private int m_tableIndexOfLastDragStart;
    protected SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == TraceExplorerComposite.this.buttonAdd) {
                TraceExplorerComposite.this.doAdd();
            } else if (source == TraceExplorerComposite.this.buttonRemove) {
                TraceExplorerComposite.this.doRemove();
            } else if (source == TraceExplorerComposite.this.buttonEdit) {
                TraceExplorerComposite.this.doEdit();
            } else if (source == TraceExplorerComposite.this.buttonExplore) {
                TraceExplorerComposite.this.doExplore();
            } else if (source == TraceExplorerComposite.this.buttonRestore) {
                TraceExplorerComposite.this.doRestore();
            }
        }
    };
    protected ISelectionChangedListener m_formulaEnablementListener = event -> {
        Object source = event.getSource();
        if (source != null && source == this.tableViewer) {
            this.changeButtonEnablement();
        }
    };

    public TraceExplorerComposite(Composite parent, String title, String description, FormToolkit toolkit, TLCErrorView errorView) {
        this.view = errorView;
        this.section = FormHelper.createSectionComposite(parent, title, description, toolkit, 452, null);
        GridData gd = new GridData(4, 4, true, false);
        this.section.setLayoutData((Object)gd);
        this.sectionInitialize(toolkit);
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        if (dialogSettings.get(EXPANDED_STATE) != null) {
            boolean expand = dialogSettings.getBoolean(EXPANDED_STATE);
            this.section.setExpanded(expand);
        } else {
            this.section.setExpanded(true);
        }
        this.section.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
                dialogSettings.put(TraceExplorerComposite.EXPANDED_STATE, TraceExplorerComposite.this.section.isExpanded());
            }
        });
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)this.section);
        toolBarManager.add((IAction)new ExtraModulesActions());
        toolBarManager.update(true);
        this.section.setTextClient((Control)toolbar);
    }

    protected void sectionInitialize(FormToolkit toolkit) {
        Composite sectionArea = (Composite)this.section.getClient();
        sectionArea.setLayout((Layout)new GridLayout(2, false));
        Table table = this.createTable(sectionArea, toolkit);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 5;
        table.setLayoutData((Object)gd);
        table.setToolTipText("Drag formulae to reorder.");
        this.tableViewer = this.createTableViewer(table);
        this.createButtons(sectionArea, toolkit);
        this.changeButtonEnablement();
    }

    protected CheckboxTableViewer createTableViewer(Table table) {
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new FormulaContentProvider());
        tableViewer.addSelectionChangedListener(this.m_formulaEnablementListener);
        tableViewer.addDoubleClickListener(event -> this.doEdit());
        tableViewer.addCheckStateListener(event -> this.view.getModel().save((IProgressMonitor)new NullProgressMonitor()));
        tableViewer.setInput(new Vector());
        return tableViewer;
    }

    protected Table createTable(Composite sectionArea, FormToolkit toolkit) {
        Table table = toolkit.createTable(sectionArea, 66338);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
            }

            public void keyReleased(KeyEvent ke) {
                if (ke.keyCode == 8 || ke.keyCode == 127) {
                    TraceExplorerComposite.this.doRemove();
                }
            }
        });
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSource source = new DragSource((Control)table, 2);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                Table table = TraceExplorerComposite.this.tableViewer.getTable();
                TableItem ti = table.getItem(new Point(event.x, event.y));
                TraceExplorerComposite.this.m_tableIndexOfLastDragStart = ti != null ? table.indexOf(ti) : -1;
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TraceExplorerComposite.this.tableViewer.getSelection();
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
            }
        });
        DropTarget target = new DropTarget((Control)table, 2);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 10;
                super.dragOver(event);
            }

            public void drop(DropTargetEvent event) {
                IStructuredSelection selection;
                Object data = event.data;
                if (data instanceof IStructuredSelection && (selection = (IStructuredSelection)data).size() > 0 && selection.getFirstElement() instanceof Formula) {
                    TableItem ti = (TableItem)event.item;
                    DropTarget target = (DropTarget)event.widget;
                    Table table = (Table)target.getControl();
                    int dropIndex = ti == null ? table.getItemCount() : table.indexOf(ti);
                    Vector model = (Vector)TraceExplorerComposite.this.tableViewer.getInput();
                    Iterator it = selection.iterator();
                    int[] selectionIndices = new int[selection.size()];
                    int counter = 0;
                    while (it.hasNext()) {
                        Formula f = (Formula)it.next();
                        selectionIndices[counter] = model.indexOf(f);
                        ++counter;
                    }
                    Arrays.sort(selectionIndices);
                    int dragDelta = TraceExplorerComposite.this.m_tableIndexOfLastDragStart == -1 ? dropIndex - selectionIndices[0] : dropIndex - TraceExplorerComposite.this.m_tableIndexOfLastDragStart;
                    if (dragDelta == 0) {
                        return;
                    }
                    List<String> serializedOriginalModel = FormHelper.getSerializedInput((TableViewer)TraceExplorerComposite.this.tableViewer);
                    int itemCount = serializedOriginalModel.size();
                    String[] movingItems = new String[selectionIndices.length];
                    int i = 0;
                    while (i < selectionIndices.length) {
                        movingItems[i] = serializedOriginalModel.get(selectionIndices[i]);
                        ++i;
                    }
                    if (dragDelta > 0) {
                        counter = selectionIndices.length - 1;
                        i = itemCount - 1;
                        while (i > -1) {
                            if (selectionIndices[counter] == i) {
                                String toMove = movingItems[counter];
                                int adjustedMoveIndex = serializedOriginalModel.indexOf(toMove);
                                int newIndex = i + dragDelta;
                                if (newIndex > itemCount) {
                                    newIndex = itemCount;
                                }
                                serializedOriginalModel.add(newIndex, toMove);
                                serializedOriginalModel.remove(adjustedMoveIndex);
                                if (--counter < 0) break;
                            }
                            --i;
                        }
                    } else {
                        counter = 0;
                        i = 0;
                        while (i < itemCount) {
                            if (selectionIndices[counter] == i) {
                                String toMove = movingItems[counter];
                                int adjustedMoveIndex = serializedOriginalModel.indexOf(toMove);
                                int newIndex = i + dragDelta;
                                if (newIndex < 0) {
                                    newIndex = 0;
                                }
                                serializedOriginalModel.remove(adjustedMoveIndex);
                                serializedOriginalModel.add(newIndex, toMove);
                                if (++counter == selectionIndices.length) break;
                            }
                            ++i;
                        }
                    }
                    TraceExplorerComposite.this.tableViewer.setInput(new Vector());
                    FormHelper.setSerializedInput((TableViewer)TraceExplorerComposite.this.tableViewer, serializedOriginalModel);
                    TraceExplorerComposite.this.changeButtonEnablement();
                    TraceExplorerComposite.this.saveModel();
                }
            }
        });
        return table;
    }

    protected void createButtons(Composite sectionArea, FormToolkit toolkit) {
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        this.buttonAdd = toolkit.createButton(sectionArea, "Add", 8);
        this.buttonAdd.addSelectionListener(this.fSelectionListener);
        this.buttonAdd.setLayoutData((Object)GridDataFactory.copyData((GridData)gd));
        this.buttonEdit = toolkit.createButton(sectionArea, "Edit", 8);
        this.buttonEdit.addSelectionListener(this.fSelectionListener);
        this.buttonEdit.setLayoutData((Object)GridDataFactory.copyData((GridData)gd));
        this.buttonRemove = toolkit.createButton(sectionArea, "Remove", 8);
        this.buttonRemove.addSelectionListener(this.fSelectionListener);
        this.buttonRemove.setLayoutData((Object)GridDataFactory.copyData((GridData)gd));
        this.buttonExplore = toolkit.createButton(sectionArea, "Explore", 8);
        this.buttonExplore.addSelectionListener(this.fSelectionListener);
        this.buttonExplore.setLayoutData((Object)GridDataFactory.copyData((GridData)gd));
        this.buttonRestore = toolkit.createButton(sectionArea, "Restore", 8);
        this.buttonRestore.addSelectionListener(this.fSelectionListener);
        this.buttonRestore.setLayoutData((Object)GridDataFactory.copyData((GridData)gd));
        this.buttonRestore.setEnabled(false);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Section getSection() {
        return this.section;
    }

    protected void doRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Vector input = (Vector)this.tableViewer.getInput();
        input.removeAll(selection.toList());
        this.tableViewer.setInput((Object)input);
        this.changeButtonEnablement();
        this.saveModel();
    }

    protected void doAdd() {
        Formula formula = this.doEditFormula(null);
        if (formula != null) {
            Vector input = (Vector)this.tableViewer.getInput();
            input.add(formula);
            this.tableViewer.setInput((Object)input);
            if (this.tableViewer instanceof CheckboxTableViewer) {
                this.tableViewer.setChecked((Object)formula, true);
            }
            this.changeButtonEnablement();
            this.saveModel();
        }
    }

    protected void doEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Formula formula = selection.size() == 1 ? (Formula)selection.getFirstElement() : (Formula)this.tableViewer.getElementAt(0);
        Formula editedFormula = this.doEditFormula(formula);
        if (editedFormula != null) {
            formula.setFormula(editedFormula.getFormula());
            if (this.tableViewer instanceof CheckboxTableViewer) {
                this.tableViewer.setChecked((Object)formula, true);
            }
            this.tableViewer.refresh();
        }
        this.saveModel();
    }

    private void saveModel() {
        this.view.getModel().setTraceExplorerExpression(FormHelper.getSerializedInput((TableViewer)this.tableViewer));
        WorkspaceJob job = new WorkspaceJob("Saving updated model..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                TraceExplorerComposite.this.view.getModel().save(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.schedule();
    }

    private void doExplore() {
        String rootModuleFileName = ToolboxHandle.getRootModule().getName();
        if (ModelHelper.containsTraceExplorerModuleConflict((String)rootModuleFileName)) {
            MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)"Illegal module name", (String)"Trace exploration is not allowed for a spec that contains a module named TE.");
            return;
        }
        ModelEditor modelEditor = (ModelEditor)((Object)this.view.getModel().getAdapter(ModelEditor.class));
        if (modelEditor == null) {
            MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)"Trace exploration not allowed", (String)"There is no model editor open on this model. The trace explorer cannot be run without opening the model editor on this model.");
            return;
        }
        if (!modelEditor.isComplete()) {
            MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)"Trace exploration not allowed", (String)"The model contains errors, which should be corrected before running the trace explorer.");
            return;
        }
        this.view.getModel().setTraceExplorerExpression(FormHelper.getSerializedInput((TableViewer)this.tableViewer));
        modelEditor.doSaveWithoutValidating((IProgressMonitor)new NullProgressMonitor());
        if (!this.view.getTrace().isTraceEmpty()) {
            WorkspaceJob job = new WorkspaceJob("Exploring the trace..."){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    TraceExplorerComposite.this.view.getModel().save(monitor).launch("exploreTrace", monitor, true);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.setUser(true);
            job.schedule();
            if (Boolean.getBoolean(TLCErrorView.class.getName() + ".noRestore")) {
                return;
            }
            this.tableViewer.getTable().setEnabled(false);
            this.buttonExplore.setEnabled(false);
            this.buttonAdd.setEnabled(false);
            this.buttonEdit.setEnabled(false);
            this.buttonRemove.setEnabled(false);
            this.buttonRestore.setEnabled(true);
        }
    }

    private void doRestore() {
        this.view.setOriginalTraceShown(true);
        this.view.updateErrorView();
        this.tableViewer.getTable().setEnabled(true);
        this.buttonExplore.setEnabled(true);
        this.buttonAdd.setEnabled(true);
        this.buttonEdit.setEnabled(true);
        this.buttonRemove.setEnabled(!((IStructuredSelection)this.tableViewer.getSelection()).isEmpty());
        if (Boolean.getBoolean(TLCErrorView.class.getName() + ".noRestore")) {
            return;
        }
        this.buttonRestore.setEnabled(false);
    }

    public void changeButtonEnablement() {
        if (this.tableViewer == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!this.tableViewer.getTable().isEnabled()) {
            return;
        }
        if (this.buttonRemove != null) {
            this.buttonRemove.setEnabled(!selection.isEmpty());
        }
        if (this.buttonEdit != null) {
            this.buttonEdit.setEnabled(selection.size() == 1 || this.tableViewer.getTable().getItemCount() == 1);
        }
        if (this.buttonExplore != null) {
            if (Boolean.getBoolean(TLCErrorView.class.getName() + ".noRestore")) {
                this.buttonExplore.setEnabled(this.tableViewer.getCheckedElements().length > 0);
            } else {
                this.buttonExplore.setEnabled(this.view.getTrace() != null && !this.view.getTrace().isTraceEmpty() && this.tableViewer.getCheckedElements().length > 0);
            }
        }
    }

    protected Formula doEditFormula(Formula formula) {
        FormulaWizard wizard = new FormulaWizard(this.section.getText(), "Enter an expression to be evaluated at each state of the trace.", String.format("The expression may be named and may include the %s and %s operators (click question mark below for details).", "_TETrace", "_TEPosition"), "ErrorTraceExplorerExpression");
        wizard.setFormula(formula);
        WizardDialog dialog = new WizardDialog(this.getTableViewer().getTable().getShell(), (IWizard)wizard);
        dialog.setHelpAvailable(true);
        if (dialog.open() == 0) {
            return wizard.getFormula();
        }
        return null;
    }

    private class ExtraModulesActions
    extends Action {
        public ExtraModulesActions() {
            super("Extend extra modules in trace expressions which are not extended by the actual spec.", TLCUIActivator.getImageDescriptor("platform:/plugin/org.eclipse.ui/icons/full/etool16/new_fastview.png"));
        }

        public void run() {
            Spec currentSpec = ToolboxHandle.getCurrentSpec();
            if (currentSpec != null && TraceExplorerComposite.this.view.getModel() != null) {
                Set availableModules = currentSpec.getModules().stream().map(m -> m.getModuleName()).collect(Collectors.toSet());
                FilenameToStream resolver = currentSpec.getValidRootModule().getResolver();
                if (resolver instanceof RCPNameToFileIStream) {
                    RCPNameToFileIStream rcpResolver = (RCPNameToFileIStream)resolver;
                    availableModules.addAll(rcpResolver.getAllModules().stream().map(m -> m.replaceFirst(".tla$", "")).collect(Collectors.toSet()));
                }
                Set includedModules = currentSpec.getValidRootModule().getModuleNames();
                Set<String> unusedModules = availableModules.stream().filter(m -> !includedModules.contains(m)).collect(Collectors.toSet());
                unusedModules.remove("Toolbox");
                unusedModules.remove("TLC");
                ExtraModulesDialog extraModulesDialog = new ExtraModulesDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), unusedModules, TraceExplorerComposite.this.view.getModel().getTraceExplorerExtends());
                if (extraModulesDialog.open() == 0) {
                    final Set<String> selectedModules = extraModulesDialog.getSelection();
                    WorkspaceJob job = new WorkspaceJob("Saving updated model..."){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            ((ExtraModulesActions)ExtraModulesActions.this).TraceExplorerComposite.this.view.getModel().setTraceExplorerExtends(selectedModules);
                            ((ExtraModulesActions)ExtraModulesActions.this).TraceExplorerComposite.this.view.getModel().save(monitor);
                            return Status.OK_STATUS;
                        }
                    };
                    job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    job.setUser(true);
                    job.schedule();
                }
            }
        }
    }
}

