/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.ModuleCoverageInformation;
import org.lamport.tla.toolbox.tool.tlc.output.data.Representation;
import tla2sany.st.Location;
import tlc2.tool.coverage.ActionWrapper;

public class ActionInformationItem
extends CoverageInformationItem {
    private static final Pattern pattern = Pattern.compile("^<(.*?) (line [^(]+)( \\(([0-9 ]+)\\))?>: ([0-9]+):([0-9]+)$");
    public static final int actionLayer = -1;
    private final ActionWrapper.Relation relation;
    private final String name;
    private long sum;
    private boolean isNotInFile = false;
    private final Location definition;

    public static ActionInformationItem parseInit(String outputMessage, String modelName) {
        return ActionInformationItem.parseInitAndNext(ActionWrapper.Relation.INIT, outputMessage, modelName);
    }

    public static ActionInformationItem parseNext(String outputMessage, String modelName) {
        return ActionInformationItem.parseInitAndNext(ActionWrapper.Relation.NEXT, outputMessage, modelName);
    }

    public static ActionInformationItem parseConstraint(String outputMessage, String modelName) {
        return ActionInformationItem.parseInitAndNext(ActionWrapper.Relation.CONSTRAINT, outputMessage, modelName);
    }

    private static ActionInformationItem parseInitAndNext(ActionWrapper.Relation rel, String outputMessage, String modelName) {
        Matcher matcher = pattern.matcher(outputMessage);
        matcher.find();
        Location declaration = Location.parseLocation((String)matcher.group(2));
        String group4 = matcher.group(4);
        Location definition = null;
        if (group4 != null) {
            definition = Location.parseCoordinates((String)declaration.source(), (String)group4);
        }
        long distinctStates = Long.parseLong(matcher.group(5));
        long generatedStates = Long.parseLong(matcher.group(6));
        return new ActionInformationItem(rel, matcher.group(1), declaration, definition, modelName, generatedStates, distinctStates);
    }

    public static ActionInformationItem parseProp(String outputMessage, String modelName) {
        Pattern pattern = Pattern.compile("^<(.*?) (line .*)>$");
        Matcher matcher = pattern.matcher(outputMessage);
        matcher.find();
        Location location = Location.parseLocation((String)matcher.group(2));
        return new ActionInformationItem(matcher.group(1), location, modelName);
    }

    public ActionInformationItem(String name, Location loc, String modelName) {
        super(loc, 0L, modelName, -1);
        this.name = name;
        this.relation = ActionWrapper.Relation.PROP;
        this.definition = null;
    }

    public ActionInformationItem(ActionWrapper.Relation relation, String name, Location loc, Location definition, String modelName, long generated, long unseen) {
        super(loc, generated, unseen, modelName, -1);
        this.name = name;
        this.relation = relation;
        this.definition = definition;
    }

    ActionInformationItem(ActionInformationItem item) {
        super(item.location, item.count, item.cost, item.modelName, item.layer);
        this.name = item.name;
        this.relation = item.relation;
        this.definition = item.definition;
    }

    public String getName() {
        return this.name;
    }

    public ActionWrapper.Relation getRelation() {
        return this.relation;
    }

    public Location getDefinition() {
        return this.definition;
    }

    public boolean hasDefinition() {
        return this.definition != null;
    }

    @Override
    public boolean includeInCounts() {
        return (this.relation != ActionWrapper.Relation.PROP || this.count != 0L) && this.relation != ActionWrapper.Relation.CONSTRAINT;
    }

    public long getUnseen() {
        return this.getCost();
    }

    public CoverageInformationItem setIsNotInFile() {
        this.isNotInFile = true;
        return this;
    }

    @Override
    CoverageInformationItem addChild(CoverageInformationItem child) {
        super.addChild(child);
        assert (child.getRoot() == null);
        child.setRoot(this);
        return this;
    }

    @Override
    protected StyleRange addStlye(StyleRange sr) {
        sr.borderStyle = 4;
        return sr;
    }

    @Override
    public void style(TextPresentation textPresentation, Representation rep) {
        if (this.relation == ActionWrapper.Relation.PROP) {
            return;
        }
        if (this.isNotInFile) {
            for (CoverageInformationItem child : this.getChildren()) {
                child.style(textPresentation, rep);
            }
            return;
        }
        super.style(textPresentation, rep);
    }

    @Override
    protected void style(TextPresentation textPresentation, boolean merge, Representation rep) {
        if (this.relation == ActionWrapper.Relation.PROP) {
            return;
        }
        if (this.isNotInFile) {
            for (CoverageInformationItem child : this.getChildren()) {
                child.style(textPresentation, merge, rep);
            }
            return;
        }
        super.style(textPresentation, merge, rep);
    }

    @Override
    public void style(TextPresentation textPresentation, Color c, Representation rep) {
        for (CoverageInformationItem child : this.getChildren()) {
            child.style(textPresentation, c, rep);
        }
    }

    @Override
    protected boolean addThisToLegend() {
        return false;
    }

    @Override
    Color colorItem(TreeSet<Long> counts, Representation ignored) {
        return this.colorItem(counts, counts);
    }

    Color colorItem(TreeSet<Long> distinctStateCounts, TreeSet<Long> stateCounts) {
        Representation[] representationArray = Representation.values();
        int n = representationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Representation rep = representationArray[n2];
            this.representations.put(rep, this.createColors(distinctStateCounts, this.getUnseen()));
            ++n2;
        }
        this.representations.put(Representation.STATES, this.createColors(stateCounts, this.getCount()));
        return ((Color[])this.representations.get((Object)Representation.STATES))[0];
    }

    private Color[] createColors(TreeSet<Long> counts, long count) {
        int hue = ModuleCoverageInformation.getHue(count, counts);
        String key = Integer.toString(hue);
        if (!JFaceResources.getColorRegistry().hasValueFor(key)) {
            JFaceResources.getColorRegistry().put(key, new RGB((float)hue, 0.25f, 1.0f));
        }
        return new Color[]{JFaceResources.getColorRegistry().get(key), JFaceResources.getColorRegistry().get(key)};
    }

    public String getHover() {
        String definition;
        String string = definition = this.hasDefinition() ? " (" + this.getDefinition().linesAndColumns() + ")" : "";
        if (this.relation == ActionWrapper.Relation.PROP) {
            return "";
        }
        if (this.relation == ActionWrapper.Relation.NEXT) {
            if (this.getCount() == 0L) {
                return String.format("Action %s%s:\n- No states found\n", this.name, definition);
            }
            if (this.getUnseen() == 0L) {
                return String.format("Action %s%s:\n- %,d state%s found but none distinct\n", this.name, definition, this.getCount(), this.getCount() == 1L ? "" : "s");
            }
            double ratio = (double)this.getUnseen() * 1.0 / (double)this.sum * 100.0;
            double overhead = (double)this.getUnseen() * 1.0 / (double)this.getCount() * 100.0;
            return String.format("Action %s%s:\n- %,d state%s found with %,d distinct (%.2f%%)\n- Contributes %.2f%% to total number of distinct states across all actions\n", this.name, definition, this.getCount(), this.getCount() == 1L ? "" : "s", this.getUnseen(), overhead, ratio);
        }
        if (this.relation == ActionWrapper.Relation.CONSTRAINT) {
            if (this.getCount() == this.getUnseen()) {
                return String.format("Constraint %s%s:\n- Constraint did not restrict the state-space at all and accepted all states.\n", this.name, definition);
            }
            if (this.getUnseen() == 0L) {
                return String.format("Constraint %s%s:\n- Constraint too restrictive because it did not accept any states.\n", this.name, definition);
            }
            return String.format("Constraint %s%s:\n- Accepted %s out of %s state%s.\n", this.name, definition, this.getUnseen(), this.getCount(), this.getCount() == 1L ? "" : "s");
        }
        if (this.relation == ActionWrapper.Relation.INIT) {
            return String.format("Action %s%s (Init):\n- %,d state%s found", this.name, definition, this.getCount(), this.getCount() == 1L ? "" : "s");
        }
        return "";
    }

    public void setSum(long sum) {
        this.sum = sum;
    }
}

