/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.launch.IConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.util.UIHelper;

public class OpenModelHandler
extends AbstractHandler
implements IConfigurationConstants {
    public static final String COMMAND_ID = "toolbox.tool.tlc.commands.model.open";
    public static final String PARAM_MODEL_NAME = "toolbox.tool.tlc.commands.model.open.param";
    public static final String PARAM_EXPAND_SECTIONS = "toolbox.tool.tlc.commands.model.open.param.expand.properties";
    public static final String PARAM_EXPAND_SECTIONS_DELIM = ",";
    public static final String EDITOR_ID = "org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String modelName = event.getParameter(PARAM_MODEL_NAME);
        Model model = ((TLCSpec)ToolboxHandle.getCurrentSpec().getAdapter(TLCSpec.class)).getModel(modelName);
        IFile launchFile = model.getLaunchConfiguration().getFile();
        if (!launchFile.exists()) {
            throw new ExecutionException("Model file " + launchFile.getFullPath().toOSString() + " does not exist. Try restarting the Toolbox and if that does not help, delete the model from the Spec Explorer.");
        }
        ModelEditor modelEditor = (ModelEditor)UIHelper.openEditor((String)EDITOR_ID, (IFile)launchFile);
        String expand = event.getParameter(PARAM_EXPAND_SECTIONS);
        if (expand != null) {
            modelEditor.expandSections(expand.split(PARAM_EXPAND_SECTIONS_DELIM));
        }
        return null;
    }
}

