/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.wizard;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.editor.basic.TLAFastPartitioner;
import org.lamport.tla.toolbox.editor.basic.TLAPartitionScanner;
import org.lamport.tla.toolbox.editor.basic.TLASourceViewerConfiguration;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.util.UIHelper;

public class FormulaWizardPage
extends WizardPage {
    private SourceViewer sourceViewer;
    private Document document;
    private final String extendedDescription;
    private final String helpId;

    public FormulaWizardPage(String action, String description) {
        this(action, description, null, null);
    }

    public FormulaWizardPage(String action, String description, String extendedDescription, String helpId) {
        super("FormulaWizardPage");
        this.setTitle(action);
        this.setDescription(description);
        this.extendedDescription = extendedDescription;
        this.helpId = helpId;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        if (this.helpId != null) {
            UIHelper.setHelp((Control)container, (String)this.helpId);
        }
        this.sourceViewer = FormHelper.createSourceViewer(container, 2818, (SourceViewerConfiguration)new TLASourceViewerConfiguration());
        this.sourceViewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (this.isUndoKeyPress(e)) {
                    FormulaWizardPage.this.sourceViewer.doOperation(1);
                } else if (this.isRedoKeyPress(e)) {
                    FormulaWizardPage.this.sourceViewer.doOperation(2);
                }
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        gd.widthHint = 400;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        StyledText control = this.sourceViewer.getTextWidget();
        control.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormulaWizardPage.this.getContainer().updateButtons();
            }
        });
        control.setEditable(true);
        control.setLayoutData((Object)gd);
        if (this.document == null) {
            this.document = new Document();
        }
        TLAFastPartitioner partitioner = new TLAFastPartitioner(TLAEditorActivator.getDefault().getTLAPartitionScanner(), TLAPartitionScanner.TLA_PARTITION_TYPES);
        this.document.setDocumentPartitioner("__tla_partitioning", (IDocumentPartitioner)partitioner);
        partitioner.connect((IDocument)this.document);
        this.sourceViewer.setDocument((IDocument)this.getDocument());
        if (this.extendedDescription != null) {
            Label extendedLbl = new Label(container, 64);
            extendedLbl.setText(this.extendedDescription);
            gd = new GridData(768);
            gd.widthHint = 400;
            extendedLbl.setLayoutData((Object)gd);
        }
        this.setControl((Control)container);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }
}

