/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.util;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.ui.util.ITLAReserveredWords;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.Context;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SymbolNode;
import tlc2.tool.impl.ModelConfig;
import util.UniqueString;

public class SemanticHelper {
    public static final String KEYWORD = "KEYWORD";
    public static final String TLA_BUILTIN = "--TLA+ BUILTINS--";
    private static Set<String> CONFIG_KEYWORDS = new HashSet<String>(Arrays.asList(ModelConfig.ALL_KEYWORDS));
    private Hashtable<Object, Hashtable<String, String>> pageStorage;
    private Context specContext;
    private Set<String> keywords = ITLAReserveredWords.ALL_WORDS_SET;

    public SemanticHelper() {
        this.pageStorage = new Hashtable();
        this.resetSpecNames();
    }

    public void resetModelNames() {
        this.pageStorage = new Hashtable();
    }

    public void resetModelNames(Object pageKey) {
        if (pageKey != null) {
            this.pageStorage.put(pageKey, new Hashtable());
        }
    }

    public void resetSpecNames() {
        this.specContext = SemanticHelper.getNewContext();
    }

    protected boolean isNameUsedOnPage(String name, Object pageKey) {
        Hashtable<String, String> pageNames = this.pageStorage.get(pageKey);
        if (pageNames != null) {
            return pageNames.containsKey(name);
        }
        return false;
    }

    public boolean isNameUsed(String name) {
        Enumeration<Object> pages = this.pageStorage.keys();
        while (pages.hasMoreElements()) {
            if (!this.isNameUsedOnPage(name, pages.nextElement())) continue;
            return true;
        }
        return this.keywords.contains(name) || this.specContext.occurSymbol((Object)UniqueString.uniqueStringOf((String)name));
    }

    public Object getUsedHint(String name) {
        Enumeration<Object> pages = this.pageStorage.keys();
        while (pages.hasMoreElements()) {
            Hashtable<String, String> pageNames = this.pageStorage.get(pages.nextElement());
            String description = pageNames.get(name);
            if (description == null) continue;
            return description;
        }
        if (this.keywords.contains(name)) {
            return KEYWORD;
        }
        SymbolNode specUsed = this.specContext.getSymbol((Object)UniqueString.uniqueStringOf((String)name));
        return specUsed;
    }

    public void addName(String name, Object pageKey, String usageDescription) {
        Hashtable<String, String> pageNames = this.pageStorage.get(pageKey);
        if (pageNames == null) {
            pageNames = new Hashtable();
            this.pageStorage.put(pageKey, pageNames);
        }
        pageNames.put(name, usageDescription);
    }

    public static boolean isConfigFileKeyword(String name) {
        return CONFIG_KEYWORDS.contains(name);
    }

    public static boolean containsConfigFileKeyword(String string) {
        Iterator<String> iterator = CONFIG_KEYWORDS.iterator();
        while (iterator.hasNext()) {
            if (!string.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static ModuleNode getRootModuleNode() {
        SpecObj specObj = ToolboxHandle.getSpecObj();
        if (specObj != null) {
            return specObj.getExternalModuleTable().getRootModule();
        }
        return null;
    }

    public static Context getNewContext() {
        Context moduleContext;
        SpecObj specObj = ToolboxHandle.getSpecObj();
        if (specObj != null) {
            ExternalModuleTable externalModuleTable = specObj.getExternalModuleTable();
            moduleContext = externalModuleTable.getRootModule().getContext().duplicate(externalModuleTable);
        } else {
            moduleContext = Context.getGlobalContext();
        }
        return moduleContext;
    }
}

