/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page.advanced;

import java.io.Closeable;
import java.io.IOException;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.ModelCoverage;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.DataBindingManager;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.BasicFormPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.MainModelPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.TLCConsumptionProfile;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.util.DirtyMarkingListener;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.util.SemanticHelper;
import org.lamport.tla.toolbox.util.HelpButton;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tlc2.TLCGlobals;
import tlc2.tool.fp.FPSet;
import tlc2.util.FP64;
import util.TLCRuntime;

public class AdvancedTLCOptionsPage
extends BasicFormPage
implements Closeable {
    public static final String ID = "AdvancedTLCOptionsPage";
    private static final String TITLE = "TLC Options";
    private Button saveDefaultConfigurationButton;
    private Spinner workers;
    private Scale maxHeapSize;
    private Label maxHeapSizeFraction;
    private AtomicBoolean programmaticallySettingWorkerParameters;
    private SourceViewer m_viewSource;
    private SourceViewer postConditionSource;
    private SourceViewer aliasSource;
    private Button m_depthFirstOptionCheckbox;
    private Button m_modelCheckModeOption;
    private Button m_simulationModeOption;
    private Button m_deferLivenessCheckbox;
    private Button m_visualizeStateGraphCheckbox;
    private Text m_depthText;
    private Text m_simulationDepthText;
    private Text m_simulationSeedText;
    private Text m_simulationArilText;
    private Text m_simulationNumTracesText;
    private Button m_checkpointRecoverCheckbox;
    private Text m_checkpointIdText;
    private Label m_checkpointSizeLabel;
    private Text m_checkpointSizeText;
    private Button m_checkpointDeleteButton;
    private ComboViewer m_collectCoverageCombo;
    private Spinner m_fingerprintSeedIndex;
    private Button m_randomFingerprintCheckbox;
    private Spinner m_fingerprintBits;
    private Spinner m_maxSetSize;
    private Text m_extraVMArgumentsText;
    private Text m_extraTLCParametersText;
    private final Interpolator linearInterpolator;
    private MainModelPage mainModelPage;

    public AdvancedTLCOptionsPage(FormEditor editor) {
        super(editor, ID, TITLE, "icons/full/advanced_tlc_options_[XXXXX].png");
        double upperLimit;
        double lowerLimit;
        this.helpId = "advancedTLCOptionsPage";
        long phySysMem = TLCRuntime.getInstance().getAbsolutePhysicalSystemMemory(1.0);
        int s = 0;
        double[] x = new double[6];
        double[] y = new double[x.length];
        y[s] = 0.0;
        x[s++] = 0.0;
        x[s] = lowerLimit = 40.0 / (double)phySysMem / 2.0;
        y[s++] = 0.0;
        int currentYear = Calendar.getInstance().get(1);
        double estimateSoftwareBloatInMBytes = Math.pow(2.0, (double)((currentYear - 1993) / 3) + 3.5);
        x[s] = lowerLimit * 2.0;
        y[s++] = 1.0;
        x[s] = 1.0 - estimateSoftwareBloatInMBytes / (double)phySysMem;
        y[s++] = 1.0;
        x[s] = upperLimit = 1.0 - estimateSoftwareBloatInMBytes / (double)phySysMem / 2.0;
        y[s++] = 0.0;
        x[s] = 1.0;
        y[s] = 0.0;
        this.linearInterpolator = new Interpolator(x, y);
        this.programmaticallySettingWorkerParameters = new AtomicBoolean(false);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateCheckpoints();
    }

    @Override
    protected void createBodyContent(IManagedForm managedForm) {
        DataBindingManager dm = this.getDataBindingManager();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite formBody = managedForm.getForm().getBody();
        int sectionFlags = 260;
        TableWrapLayout twl = new TableWrapLayout();
        twl.leftMargin = 0;
        twl.rightMargin = 0;
        twl.numColumns = 1;
        formBody.setLayout((Layout)twl);
        this.mainModelPage = (MainModelPage)this.getEditor().findPage("MainModelPage");
        this.programmaticallySettingWorkerParameters.set(true);
        Section section = FormHelper.createSectionComposite(formBody, "Configuration", "", toolkit, 324, this.getExpansionListener());
        TableWrapData twd = new TableWrapData();
        twd.align = 128;
        twd.grabHorizontal = true;
        section.setLayoutData((Object)twd);
        ValidateableSectionPart configPart = new ValidateableSectionPart(section, this, "__tlc_opt_config");
        managedForm.addPart((IFormPart)configPart);
        DirtyMarkingListener configPartListener = new DirtyMarkingListener((AbstractFormPart)configPart, true);
        Composite configBody = (Composite)section.getClient();
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        configBody.setLayout((Layout)gl);
        toolkit.createLabel(configBody, "Number of worker threads:");
        Composite workersLine = new Composite(configBody, 0);
        GridData gd = new GridData();
        gd.horizontalIndent = 40;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        workersLine.setLayoutData((Object)gd);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        workersLine.setLayout((Layout)gl);
        this.workers = new Spinner(workersLine, Platform.getOS().equals("win32") ? 8 : 0);
        this.workers.addFocusListener(this.focusListener);
        this.workers.addListener(25, e -> {
            if (!this.programmaticallySettingWorkerParameters.get()) {
                this.mainModelPage.setWorkerCount(this.workers.getSelection());
            }
        });
        gd = new GridData();
        gd.widthHint = 40;
        this.workers.setLayoutData((Object)gd);
        this.workers.setMinimum(1);
        this.workers.setPageIncrement(1);
        this.workers.setToolTipText("Determines how many threads will be spawned working on the next state relation.");
        this.workers.setSelection(TLCConsumptionProfile.LOCAL_NORMAL.getWorkerThreads());
        this.workers.setEnabled(false);
        dm.bindAttribute("numberOfWorkers", this.workers, configPart);
        this.saveDefaultConfigurationButton = new Button(workersLine, 8);
        this.saveDefaultConfigurationButton.setText("Save as default");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000008;
        gd.grabExcessHorizontalSpace = true;
        this.saveDefaultConfigurationButton.setLayoutData((Object)gd);
        this.saveDefaultConfigurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                IPreferenceStore prefStore = TLCUIActivator.getDefault().getPreferenceStore();
                prefStore.setValue("tlcWorkersCountDefault", AdvancedTLCOptionsPage.this.workers.getSelection());
                prefStore.setValue("maxHeapSizeDefault", AdvancedTLCOptionsPage.this.maxHeapSize.getSelection());
                prefStore.setValue("fpBitsDefault", AdvancedTLCOptionsPage.this.m_fingerprintBits.getSelection());
            }
        });
        toolkit.createLabel(configBody, "Fraction of physical memory allocated to TLC:");
        Composite maxHeapScale = new Composite(configBody, 0);
        gl = new GridLayout(2, false);
        maxHeapScale.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalIndent = 30;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        maxHeapScale.setLayoutData((Object)gd);
        IPreferenceStore prefStore = TLCUIActivator.getDefault().getPreferenceStore();
        int defaultMaxHeapSize = prefStore.getInt("maxHeapSizeDefault");
        this.maxHeapSize = new Scale(maxHeapScale, 0);
        this.maxHeapSize.addFocusListener(this.focusListener);
        this.maxHeapSize.addListener(13, e -> {
            if (!this.programmaticallySettingWorkerParameters.get()) {
                this.mainModelPage.setHeapPercentage(this.maxHeapSize.getSelection());
            }
        });
        gd = new GridData();
        gd.minimumWidth = 250;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.maxHeapSize.setLayoutData((Object)gd);
        this.maxHeapSize.setMaximum(99);
        this.maxHeapSize.setMinimum(1);
        this.maxHeapSize.setPageIncrement(5);
        this.maxHeapSize.setSelection(defaultMaxHeapSize);
        this.maxHeapSize.setToolTipText("Specifies the heap size of the Java VM that runs TLC.");
        dm.bindAttribute("maxHeapSize", this.maxHeapSize, configPart);
        TLCRuntime instance = TLCRuntime.getInstance();
        long memory = instance.getAbsolutePhysicalSystemMemory((double)defaultMaxHeapSize / 100.0);
        this.maxHeapSizeFraction = toolkit.createLabel(maxHeapScale, MainModelPage.generateMemoryDisplayText(defaultMaxHeapSize, memory));
        this.maxHeapSize.addPaintListener(pe -> {
            this.maxHeapSizeFraction.setText(this.generateMemoryDisplayText());
            maxHeapScale.layout();
        });
        this.maxHeapSize.setEnabled(false);
        Label l = toolkit.createLabel(configBody, "Log base 2 of number of disk storage files:");
        gd = new GridData();
        gd.verticalIndent = 6;
        l.setLayoutData((Object)gd);
        this.m_fingerprintBits = new Spinner(configBody, 0);
        this.m_fingerprintBits.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.m_fingerprintBits.addFocusListener(this.focusListener);
        gd = new GridData();
        gd.verticalIndent = 6;
        gd.horizontalIndent = 37;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_fingerprintBits.setLayoutData((Object)gd);
        this.m_fingerprintBits.setMinimum(0);
        this.m_fingerprintBits.setMaximum(30);
        int defaultFPBits = prefStore.getInt("fpBitsDefault");
        this.m_fingerprintBits.setSelection(defaultFPBits);
        section = FormHelper.createSectionComposite(formBody, "Checking Mode", "", toolkit, 260, this.getExpansionListener());
        ValidateableSectionPart modePart = new ValidateableSectionPart(section, this, "__tlc_opt_check_mode");
        managedForm.addPart((IFormPart)modePart);
        DirtyMarkingListener modePartListener = new DirtyMarkingListener((AbstractFormPart)modePart, true);
        Composite modeBody = (Composite)section.getClient();
        gl = new GridLayout(2, false);
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        modeBody.setLayout((Layout)gl);
        String postConditionHelp = "After executing the model, TLC evaluates the given constant-level, no-argument (zero-arity) operator.";
        Label postConditionLabel = toolkit.createLabel(modeBody, "Post Condition:");
        postConditionLabel.setToolTipText("After executing the model, TLC evaluates the given constant-level, no-argument (zero-arity) operator.");
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalIndent = 10;
        postConditionLabel.setLayoutData((Object)gd);
        this.postConditionSource = FormHelper.createFormsSourceViewer(toolkit, modeBody, 512);
        this.postConditionSource.getControl().setToolTipText("After executing the model, TLC evaluates the given constant-level, no-argument (zero-arity) operator.");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 60;
        gd.minimumWidth = 200;
        this.postConditionSource.getTextWidget().setLayoutData((Object)gd);
        this.postConditionSource.getTextWidget().setData("tla.dbm.enable.sigh", new Object());
        String aliasHelp = "TLC allows the cfg file to contain the statement ALIAS R\nwhere R is the definition of a record in the spec or the model.  R's\ncomponent expressions can be formed from constant-, state-, and\naction-level expressions.\nWhen printing an error-trace, TLC evaluates the record R on every step\n(pair or states s -> t) of the behavior that violated the property.\nTLC prints the result r of the evaluation of R in place of s by formatting\neach component h_i of r as a conjunct s.t. (\"h_i\" = r[\"h_i\"]).\nIf the evaluation of R fails for a step, TLC falls back to printing s.\n\nConsider  ALIAS R  with\n\n   R == [x |-> x+1, sum |-> x + y', te |-> ENABLED A]\n\nfor a state s with x = 42 and y = 24, a (successor) state t with\nx = 23 and y = -42, and action A defined as x' \\in Nat /\\ y' \\in Nat\nwill print s as\n   \n    /\\ x = 43\n    /\\ sum = 0\n    /\\ te = TRUE";
        Label aliasLabel = toolkit.createLabel(modeBody, "Alias:");
        aliasLabel.setToolTipText("TLC allows the cfg file to contain the statement ALIAS R\nwhere R is the definition of a record in the spec or the model.  R's\ncomponent expressions can be formed from constant-, state-, and\naction-level expressions.\nWhen printing an error-trace, TLC evaluates the record R on every step\n(pair or states s -> t) of the behavior that violated the property.\nTLC prints the result r of the evaluation of R in place of s by formatting\neach component h_i of r as a conjunct s.t. (\"h_i\" = r[\"h_i\"]).\nIf the evaluation of R fails for a step, TLC falls back to printing s.\n\nConsider  ALIAS R  with\n\n   R == [x |-> x+1, sum |-> x + y', te |-> ENABLED A]\n\nfor a state s with x = 42 and y = 24, a (successor) state t with\nx = 23 and y = -42, and action A defined as x' \\in Nat /\\ y' \\in Nat\nwill print s as\n   \n    /\\ x = 43\n    /\\ sum = 0\n    /\\ te = TRUE");
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalIndent = 10;
        aliasLabel.setLayoutData((Object)gd);
        this.aliasSource = FormHelper.createFormsSourceViewer(toolkit, modeBody, 512);
        this.aliasSource.getControl().setToolTipText("TLC allows the cfg file to contain the statement ALIAS R\nwhere R is the definition of a record in the spec or the model.  R's\ncomponent expressions can be formed from constant-, state-, and\naction-level expressions.\nWhen printing an error-trace, TLC evaluates the record R on every step\n(pair or states s -> t) of the behavior that violated the property.\nTLC prints the result r of the evaluation of R in place of s by formatting\neach component h_i of r as a conjunct s.t. (\"h_i\" = r[\"h_i\"]).\nIf the evaluation of R fails for a step, TLC falls back to printing s.\n\nConsider  ALIAS R  with\n\n   R == [x |-> x+1, sum |-> x + y', te |-> ENABLED A]\n\nfor a state s with x = 42 and y = 24, a (successor) state t with\nx = 23 and y = -42, and action A defined as x' \\in Nat /\\ y' \\in Nat\nwill print s as\n   \n    /\\ x = 43\n    /\\ sum = 0\n    /\\ te = TRUE");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 60;
        gd.minimumWidth = 200;
        this.aliasSource.getTextWidget().setLayoutData((Object)gd);
        this.aliasSource.getTextWidget().setData("tla.dbm.enable.sigh", new Object());
        this.m_modelCheckModeOption = toolkit.createButton(modeBody, "Model-checking mode", 16);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.m_modelCheckModeOption.setLayoutData((Object)gd);
        this.m_modelCheckModeOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedTLCOptionsPage.this.updateEnabledStatesForAdvancedLaunchRadioSelection();
            }
        });
        Label viewLabel = toolkit.createLabel(modeBody, "View:");
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalIndent = 10;
        viewLabel.setLayoutData((Object)gd);
        this.m_viewSource = FormHelper.createFormsSourceViewer(toolkit, modeBody, 512);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 60;
        gd.minimumWidth = 200;
        this.m_viewSource.getTextWidget().setLayoutData((Object)gd);
        this.m_viewSource.getTextWidget().setData("tla.dbm.enable.sigh", new Object());
        this.m_depthFirstOptionCheckbox = toolkit.createButton(modeBody, "Depth-first", 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 10;
        this.m_depthFirstOptionCheckbox.setLayoutData((Object)gd);
        this.m_depthFirstOptionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedTLCOptionsPage.this.m_depthText.setEnabled(AdvancedTLCOptionsPage.this.m_depthFirstOptionCheckbox.getSelection());
            }
        });
        this.m_depthFirstOptionCheckbox.setData("tla.dbm.enable.sigh", new Object());
        Label dfidDepthLabel = toolkit.createLabel(modeBody, "Depth:");
        gd = new GridData();
        gd.horizontalIndent = 36;
        dfidDepthLabel.setLayoutData((Object)gd);
        this.m_depthText = toolkit.createText(modeBody, "100");
        gd = new GridData();
        gd.minimumWidth = 100;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_depthText.setLayoutData((Object)gd);
        this.m_depthText.addFocusListener(this.focusListener);
        this.m_depthText.setEnabled(false);
        this.m_depthText.setData("tla.dbm.enable.sigh", new Object());
        this.m_simulationModeOption = toolkit.createButton(modeBody, "Simulation mode", 16);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.m_simulationModeOption.setLayoutData((Object)gd);
        this.m_simulationModeOption.addFocusListener(this.focusListener);
        this.m_simulationModeOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedTLCOptionsPage.this.updateEnabledStatesForAdvancedLaunchRadioSelection();
            }
        });
        Label numTracesLabel = toolkit.createLabel(modeBody, "Maximum number of traces:");
        numTracesLabel.setToolTipText("Leave empty to generate an unlimited number (2^64-1) of traces.");
        gd = new GridData();
        gd.horizontalIndent = 10;
        numTracesLabel.setLayoutData((Object)gd);
        this.m_simulationNumTracesText = toolkit.createText(modeBody, "");
        this.m_simulationNumTracesText.setToolTipText("Leave empty to generate an unlimited number (2^64-1) of traces.");
        gd = new GridData();
        gd.minimumWidth = 100;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_simulationNumTracesText.setLayoutData((Object)gd);
        this.m_simulationNumTracesText.addFocusListener(this.focusListener);
        this.m_simulationNumTracesText.setData("tla.dbm.enable.sigh", new Object());
        Label depthLabel = toolkit.createLabel(modeBody, "Maximum length of each trace:");
        gd = new GridData();
        gd.horizontalIndent = 10;
        depthLabel.setLayoutData((Object)gd);
        this.m_simulationDepthText = toolkit.createText(modeBody, "100");
        gd = new GridData();
        gd.minimumWidth = 100;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_simulationDepthText.setLayoutData((Object)gd);
        this.m_simulationDepthText.addFocusListener(this.focusListener);
        this.m_simulationDepthText.setData("tla.dbm.enable.sigh", new Object());
        Label seedLabel = toolkit.createLabel(modeBody, "Seed:");
        gd = new GridData();
        gd.horizontalIndent = 10;
        seedLabel.setLayoutData((Object)gd);
        this.m_simulationSeedText = toolkit.createText(modeBody, "");
        gd = new GridData();
        gd.minimumWidth = 200;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_simulationSeedText.setLayoutData((Object)gd);
        this.m_simulationSeedText.addFocusListener(this.focusListener);
        this.m_simulationSeedText.setData("tla.dbm.enable.sigh", new Object());
        Label arilLabel = toolkit.createLabel(modeBody, "Aril:");
        gd = new GridData();
        gd.horizontalIndent = 10;
        arilLabel.setLayoutData((Object)gd);
        this.m_simulationArilText = toolkit.createText(modeBody, "");
        gd = new GridData();
        gd.minimumWidth = 200;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_simulationArilText.setLayoutData((Object)gd);
        this.m_simulationArilText.addFocusListener(this.focusListener);
        this.m_simulationArilText.setData("tla.dbm.enable.sigh", new Object());
        section = FormHelper.createSectionComposite(formBody, "Features", "", toolkit, 260, this.getExpansionListener());
        ValidateableSectionPart featuresPart = new ValidateableSectionPart(section, this, "__tlc_opt_features");
        managedForm.addPart((IFormPart)featuresPart);
        DirtyMarkingListener featuresPartListener = new DirtyMarkingListener((AbstractFormPart)featuresPart, true);
        Composite featuresBody = (Composite)section.getClient();
        gl = new GridLayout(2, false);
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        featuresBody.setLayout((Layout)gl);
        Composite checkpointComposite = new Composite(featuresBody, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        checkpointComposite.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 6;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        checkpointComposite.setLayoutData((Object)gd);
        this.m_checkpointRecoverCheckbox = toolkit.createButton(checkpointComposite, "Recover from checkpoint", 32);
        this.m_checkpointRecoverCheckbox.addFocusListener(this.focusListener);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        this.m_checkpointRecoverCheckbox.setLayoutData((Object)gd);
        Button b = HelpButton.helpButton((Composite)checkpointComposite, (String)"model/tlc-options-page.html#checkpoint");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000008;
        gd.grabExcessHorizontalSpace = true;
        b.setLayoutData((Object)gd);
        toolkit.createLabel(featuresBody, "Checkpoint ID:");
        this.m_checkpointIdText = toolkit.createText(featuresBody, "");
        this.m_checkpointIdText.setEditable(false);
        gd = new GridData();
        gd.minimumWidth = 100;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_checkpointIdText.setLayoutData((Object)gd);
        this.m_checkpointSizeLabel = toolkit.createLabel(featuresBody, "Checkpoint size (kbytes):");
        this.m_checkpointSizeText = toolkit.createText(featuresBody, "");
        gd = new GridData();
        gd.minimumWidth = 100;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_checkpointSizeText.setLayoutData((Object)gd);
        this.m_checkpointDeleteButton = toolkit.createButton(featuresBody, "Delete Checkpoint", 8);
        this.m_checkpointDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IResource[] checkpoints = AdvancedTLCOptionsPage.this.getModel().getCheckpoints(false);
                    if (checkpoints != null && checkpoints.length > 0) {
                        ResourcesPlugin.getWorkspace().run(monitor -> checkpoints[0].delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1)), null);
                    }
                }
                catch (CoreException e1) {
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_checkpointDeleteButton.addFocusListener(this.focusListener);
        new Label(featuresBody, 0);
        String collectCoverageHelp = "Profiling helps identify problems with the specification such as actions which are never enabled (Action enablement). Invocation and cost statistics allow to diagnose expensive expressions (to evaluate) and state space explosion (On). Profiling negatively impacts model checking performance and should thus be off while checking large models.";
        Label collectCoverageLabel = toolkit.createLabel(featuresBody, "Profiling:");
        gd = new GridData();
        gd.verticalIndent = 9;
        gd.grabExcessHorizontalSpace = true;
        collectCoverageLabel.setLayoutData((Object)gd);
        collectCoverageLabel.setToolTipText("Profiling helps identify problems with the specification such as actions which are never enabled (Action enablement). Invocation and cost statistics allow to diagnose expensive expressions (to evaluate) and state space explosion (On). Profiling negatively impacts model checking performance and should thus be off while checking large models.");
        Composite coverageComposite = new Composite(featuresBody, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        coverageComposite.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        coverageComposite.setLayoutData((Object)gd);
        this.m_collectCoverageCombo = new ComboViewer(new Combo(coverageComposite, 8));
        gd = new GridData();
        gd.verticalIndent = 9;
        gd.grabExcessHorizontalSpace = true;
        this.m_collectCoverageCombo.getCombo().setLayoutData((Object)gd);
        this.m_collectCoverageCombo.getCombo().addFocusListener(this.focusListener);
        this.m_collectCoverageCombo.getCombo().setToolTipText("Profiling helps identify problems with the specification such as actions which are never enabled (Action enablement). Invocation and cost statistics allow to diagnose expensive expressions (to evaluate) and state space explosion (On). Profiling negatively impacts model checking performance and should thus be off while checking large models.");
        this.m_collectCoverageCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_collectCoverageCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelCoverage) {
                    switch ((ModelCoverage)element) {
                        case OFF: {
                            return "Off";
                        }
                        case ACTION: {
                            return "Action enablement";
                        }
                        case ON: {
                            return "On";
                        }
                    }
                }
                return "Off";
            }
        });
        this.m_collectCoverageCombo.setInput((Object)ModelCoverage.values());
        b = HelpButton.helpButton((Composite)coverageComposite, (String)"model/tlc-options-page.html#profiling");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000008;
        gd.verticalAlignment = 1024;
        gd.grabExcessHorizontalSpace = true;
        b.setLayoutData((Object)gd);
        String visualizeStateGraphHelp = "Draw the state graph after completion of model checking provided the state graph is sufficiently small (cannot handle more than a few dozen states and slows down model checking).";
        Label visualizeStateGraphLabel = toolkit.createLabel(featuresBody, "Visualize state graph after completion of model checking:");
        gd = new GridData();
        gd.verticalIndent = 9;
        gd.grabExcessHorizontalSpace = true;
        visualizeStateGraphLabel.setLayoutData((Object)gd);
        visualizeStateGraphLabel.setToolTipText("Draw the state graph after completion of model checking provided the state graph is sufficiently small (cannot handle more than a few dozen states and slows down model checking).");
        this.m_visualizeStateGraphCheckbox = toolkit.createButton(featuresBody, "", 32);
        gd = new GridData();
        gd.verticalIndent = 9;
        this.m_visualizeStateGraphCheckbox.setLayoutData((Object)gd);
        this.m_visualizeStateGraphCheckbox.addFocusListener(this.focusListener);
        this.m_visualizeStateGraphCheckbox.setToolTipText("Draw the state graph after completion of model checking provided the state graph is sufficiently small (cannot handle more than a few dozen states and slows down model checking).");
        section = FormHelper.createSectionComposite(formBody, "Parameters", "", toolkit, 260, this.getExpansionListener());
        ValidateableSectionPart parametersPart = new ValidateableSectionPart(section, this, "__tlc_opt_params");
        managedForm.addPart((IFormPart)parametersPart);
        DirtyMarkingListener parametersPartListener = new DirtyMarkingListener((AbstractFormPart)parametersPart, true);
        Composite parametersBody = (Composite)section.getClient();
        gl = new GridLayout(2, false);
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        parametersBody.setLayout((Layout)gl);
        String deferLivenessHelp = "Defer verification of temporal properties (liveness) to the end of model checking to reduce overall model checking time. Liveness violations will be found late compared to invariant violations. In other words check liveness only once on the complete state space.";
        Label deferLivenessLabel = toolkit.createLabel(parametersBody, "Verify temporal properties upon termination only:");
        gd = new GridData();
        gd.verticalIndent = 6;
        deferLivenessLabel.setLayoutData((Object)gd);
        deferLivenessLabel.setToolTipText("Defer verification of temporal properties (liveness) to the end of model checking to reduce overall model checking time. Liveness violations will be found late compared to invariant violations. In other words check liveness only once on the complete state space.");
        this.m_deferLivenessCheckbox = toolkit.createButton(parametersBody, "", 32);
        this.m_deferLivenessCheckbox.addFocusListener(this.focusListener);
        this.m_deferLivenessCheckbox.setToolTipText("Defer verification of temporal properties (liveness) to the end of model checking to reduce overall model checking time. Liveness violations will be found late compared to invariant violations. In other words check liveness only once on the complete state space.");
        gd = new GridData();
        gd.verticalIndent = 6;
        this.m_deferLivenessCheckbox.setLayoutData((Object)gd);
        toolkit.createLabel(parametersBody, "Fingerprint seed index:");
        Composite fpIndex = toolkit.createComposite(parametersBody);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        fpIndex.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        fpIndex.setLayoutData((Object)gd);
        this.m_randomFingerprintCheckbox = toolkit.createButton(fpIndex, "Select randomly", 32);
        this.m_randomFingerprintCheckbox.setToolTipText("Let TLC randomly choose the irreducible polynomial at startup. The actual value will be shon in TLC's startup banner.");
        this.m_randomFingerprintCheckbox.setSelection(true);
        this.m_randomFingerprintCheckbox.addFocusListener(this.focusListener);
        this.m_randomFingerprintCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedTLCOptionsPage.this.m_fingerprintSeedIndex.setEnabled(!AdvancedTLCOptionsPage.this.m_randomFingerprintCheckbox.getSelection());
            }
        });
        this.m_fingerprintSeedIndex = new Spinner(fpIndex, 0);
        this.m_fingerprintSeedIndex.setEnabled(false);
        this.m_fingerprintSeedIndex.setToolTipText("Index of irreducible polynominal used as a seed for fingerprint hashing (corresponds to \"-fp value\"). Set to the irreducible polynomial used for the previous run if \"Select randomly\" checked.");
        gd = new GridData();
        gd.horizontalIndent = 15;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_fingerprintSeedIndex.setLayoutData((Object)gd);
        this.m_fingerprintSeedIndex.setMinimum(0);
        this.m_fingerprintSeedIndex.setMaximum(FP64.Polys.length - 1);
        this.m_fingerprintSeedIndex.addFocusListener(this.focusListener);
        toolkit.createLabel(parametersBody, "Cardinality of largest enumerable set:");
        this.m_maxSetSize = new Spinner(parametersBody, 0);
        this.m_maxSetSize.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.m_maxSetSize.addFocusListener(this.focusListener);
        gd = new GridData();
        gd.verticalIndent = 20;
        gd.minimumWidth = 100;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_maxSetSize.setLayoutData((Object)gd);
        this.m_maxSetSize.setMinimum(1);
        this.m_maxSetSize.setMaximum(Integer.MAX_VALUE);
        int defaultMaxSetSize = prefStore.getInt("maxSetSizeDefault");
        this.m_maxSetSize.setSelection(defaultMaxSetSize);
        toolkit.createLabel(parametersBody, "JVM arguments:");
        this.m_extraVMArgumentsText = toolkit.createText(parametersBody, "", 578);
        this.m_extraVMArgumentsText.setEditable(true);
        this.m_extraVMArgumentsText.setToolTipText("Optionally pass additional JVM arguments to TLC process (e.g. -Djava.rmi.server.hostname=ThisHostName)");
        this.m_extraVMArgumentsText.addFocusListener(this.focusListener);
        gd = new GridData();
        gd.verticalIndent = 20;
        gd.heightHint = 40;
        gd.minimumWidth = 300;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_extraVMArgumentsText.setLayoutData((Object)gd);
        toolkit.createLabel(parametersBody, "TLC command line parameters:");
        this.m_extraTLCParametersText = toolkit.createText(parametersBody, "", 578);
        this.m_extraTLCParametersText.setEditable(true);
        this.m_extraTLCParametersText.setToolTipText("Optionally pass additional TLC process parameters (e.g. -Dcheckpoint 0)");
        this.m_extraTLCParametersText.addFocusListener(this.focusListener);
        gd = new GridData();
        gd.verticalIndent = 20;
        gd.heightHint = 40;
        gd.minimumWidth = 300;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.m_extraTLCParametersText.setLayoutData((Object)gd);
        this.updateEnabledStatesForAdvancedLaunchRadioSelection();
        dm.bindAttribute("modelParameterAlias", this.aliasSource, modePart);
        dm.bindAttribute("modelParameterPostCondition", this.postConditionSource, modePart);
        dm.bindAttribute("modelParameterView", this.m_viewSource, modePart);
        dm.bindAttribute("recover", this.m_checkpointRecoverCheckbox, featuresPart);
        this.workers.addSelectionListener((SelectionListener)configPartListener);
        this.maxHeapSize.addSelectionListener((SelectionListener)configPartListener);
        this.m_modelCheckModeOption.addSelectionListener((SelectionListener)modePartListener);
        this.m_viewSource.addTextListener((ITextListener)modePartListener);
        this.postConditionSource.addTextListener((ITextListener)modePartListener);
        this.aliasSource.addTextListener((ITextListener)modePartListener);
        this.m_depthFirstOptionCheckbox.addSelectionListener((SelectionListener)modePartListener);
        this.m_depthText.addModifyListener((ModifyListener)modePartListener);
        this.m_simulationModeOption.addSelectionListener((SelectionListener)modePartListener);
        this.m_simulationNumTracesText.addModifyListener((ModifyListener)modePartListener);
        this.m_simulationDepthText.addModifyListener((ModifyListener)modePartListener);
        this.m_simulationSeedText.addModifyListener((ModifyListener)modePartListener);
        this.m_simulationArilText.addModifyListener((ModifyListener)modePartListener);
        this.m_checkpointRecoverCheckbox.addSelectionListener((SelectionListener)featuresPartListener);
        this.m_collectCoverageCombo.getCombo().addSelectionListener((SelectionListener)featuresPartListener);
        this.m_visualizeStateGraphCheckbox.addSelectionListener((SelectionListener)featuresPartListener);
        this.m_deferLivenessCheckbox.addSelectionListener((SelectionListener)parametersPartListener);
        this.m_fingerprintSeedIndex.addModifyListener((ModifyListener)parametersPartListener);
        this.m_randomFingerprintCheckbox.addSelectionListener((SelectionListener)parametersPartListener);
        this.m_fingerprintBits.addModifyListener((ModifyListener)parametersPartListener);
        this.m_maxSetSize.addModifyListener((ModifyListener)parametersPartListener);
        this.m_extraVMArgumentsText.addModifyListener((ModifyListener)parametersPartListener);
        this.m_extraTLCParametersText.addModifyListener((ModifyListener)parametersPartListener);
        this.dirtyPartListeners.add((Object)configPartListener);
        this.dirtyPartListeners.add((Object)modePartListener);
        this.dirtyPartListeners.add((Object)featuresPartListener);
        this.dirtyPartListeners.add((Object)parametersPartListener);
    }

    @Override
    protected void loadData() throws CoreException {
        Model model = this.getModel();
        String view = model.getAttribute("view", "");
        this.m_viewSource.setDocument((IDocument)new Document(view));
        String alias = model.getAttribute("alias", "");
        this.aliasSource.setDocument((IDocument)new Document(alias));
        String postCondition = model.getAttribute("postCondition", "");
        this.postConditionSource.setDocument((IDocument)new Document(postCondition));
        boolean isMCMode = model.getAttribute("mcMode", true);
        this.m_modelCheckModeOption.setSelection(isMCMode);
        this.m_simulationModeOption.setSelection(!isMCMode);
        int dfidDepth = model.getAttribute("dfidDepth", 100);
        this.m_depthText.setText("" + dfidDepth);
        boolean isDFIDMode = model.getAttribute("dfidMode", false);
        this.m_depthFirstOptionCheckbox.setSelection(isDFIDMode);
        this.m_depthText.setEnabled(isDFIDMode);
        long simuNumTraces = model.getAttribute("simuNumTraces", Long.MAX_VALUE);
        if (simuNumTraces == Long.MAX_VALUE) {
            this.m_simulationNumTracesText.setText("");
        } else {
            this.m_simulationNumTracesText.setText("" + simuNumTraces);
        }
        int simuDepth = model.getAttribute("simuDepth", 100);
        this.m_simulationDepthText.setText("" + simuDepth);
        int simuAril = model.getAttribute("simuSeed", -1);
        if (-1 != simuAril) {
            this.m_simulationArilText.setText("" + simuAril);
        } else {
            this.m_simulationArilText.setText("");
        }
        int simuSeed = model.getAttribute("simuAril", -1);
        if (-1 != simuSeed) {
            this.m_simulationSeedText.setText("" + simuSeed);
        } else {
            this.m_simulationSeedText.setText("");
        }
        this.m_deferLivenessCheckbox.setSelection(model.getAttribute("deferLiveness", false));
        boolean recover = model.getAttribute("recover", false);
        this.m_checkpointRecoverCheckbox.setSelection(recover);
        this.m_collectCoverageCombo.setSelection((ISelection)new StructuredSelection((Object)model.getCoverage()), true);
        boolean randomly = model.getAttribute("fpIndexRandom", true);
        this.m_randomFingerprintCheckbox.setSelection(randomly);
        int fpIndex = model.getAttribute("fpIndex", 1);
        this.m_fingerprintSeedIndex.setSelection(fpIndex);
        this.m_fingerprintSeedIndex.setEnabled(!randomly);
        IPreferenceStore prefStore = TLCUIActivator.getDefault().getPreferenceStore();
        int defaultFPBits = prefStore.getInt("fpBitsDefault");
        this.m_fingerprintBits.setSelection(model.getAttribute("fpBits", defaultFPBits));
        int defaultMaxSetSize = prefStore.getInt("maxSetSizeDefault");
        this.m_maxSetSize.setSelection(model.getAttribute("maxSetSize", defaultMaxSetSize));
        this.m_visualizeStateGraphCheckbox.setSelection(model.getAttribute("visualizeStateGraph", false));
        String vmArgs = model.getAttribute("distributedTLCVMArgs", "");
        this.m_extraVMArgumentsText.setText(vmArgs);
        String tlcParameters = model.getAttribute("TLCCmdLineParameters", "");
        this.m_extraTLCParametersText.setText(tlcParameters);
        this.programmaticallySettingWorkerParameters.set(true);
        this.workers.setSelection(this.mainModelPage.getWorkerCount());
        this.maxHeapSize.setSelection(this.mainModelPage.getHeapPercentage());
        this.programmaticallySettingWorkerParameters.set(false);
        this.setWorkerAndMemoryEnable(this.mainModelPage.workerCountCanBeModified(), this.mainModelPage.heapPercentageCanBeModified());
        this.updateEnabledStatesForAdvancedLaunchRadioSelection();
    }

    @Override
    public void commit(boolean onSave) {
        Model model = this.getModel();
        boolean isMCMode = this.m_modelCheckModeOption.getSelection();
        model.setAttribute("mcMode", isMCMode);
        boolean isDFIDMode = this.m_depthFirstOptionCheckbox.getSelection();
        model.setAttribute("dfidMode", isDFIDMode);
        int dfidDepth = Integer.parseInt(this.m_simulationDepthText.getText());
        int simuDepth = Integer.parseInt(this.m_simulationDepthText.getText());
        int simuAril = -1;
        int simuSeed = -1;
        if (!"".equals(this.m_simulationArilText.getText())) {
            simuAril = Integer.parseInt(this.m_simulationArilText.getText());
        }
        if (!"".equals(this.m_simulationSeedText.getText())) {
            simuSeed = Integer.parseInt(this.m_simulationSeedText.getText());
        }
        model.setAttribute("dfidDepth", dfidDepth);
        String simuNumTracesS = this.m_simulationNumTracesText.getText();
        long simuNumTraces = Long.MAX_VALUE;
        if (!"".equals(simuNumTracesS)) {
            simuNumTraces = Long.parseLong(simuNumTracesS);
        }
        model.setAttribute("simuNumTraces", simuNumTraces);
        model.setAttribute("simuDepth", simuDepth);
        model.setAttribute("simuSeed", simuSeed);
        model.setAttribute("simuAril", simuAril);
        model.setAttribute("deferLiveness", this.m_deferLivenessCheckbox.getSelection());
        model.setAttribute("recover", this.m_checkpointRecoverCheckbox.getSelection());
        model.setAttribute("fpIndexRandom", this.m_randomFingerprintCheckbox.getSelection());
        model.setAttribute("fpIndex", this.m_fingerprintSeedIndex.getSelection());
        model.setAttribute("fpBits", this.m_fingerprintBits.getSelection());
        model.setAttribute("maxSetSize", this.m_maxSetSize.getSelection());
        model.setAttribute("visualizeStateGraph", this.m_visualizeStateGraphCheckbox.getSelection());
        Object coverage = this.m_collectCoverageCombo.getStructuredSelection().getFirstElement();
        if (coverage instanceof ModelCoverage) {
            model.setCoverage((ModelCoverage)coverage);
        }
        String viewFormula = FormHelper.trimTrailingSpaces(this.m_viewSource.getDocument().get());
        model.setAttribute("view", viewFormula);
        String postConditionFormula = FormHelper.trimTrailingSpaces(this.postConditionSource.getDocument().get());
        model.setAttribute("postCondition", postConditionFormula);
        String aliasFormula = FormHelper.trimTrailingSpaces(this.aliasSource.getDocument().get());
        model.setAttribute("alias", aliasFormula);
        String vmArgs = this.m_extraVMArgumentsText.getText().replace("\r\n", " ").replace("\n", " ");
        model.setAttribute("distributedTLCVMArgs", vmArgs);
        String tlcParameters = this.m_extraTLCParametersText.getText();
        model.setAttribute("TLCCmdLineParameters", tlcParameters);
        super.commit(onSave);
    }

    @Override
    public void validatePage(boolean switchToErrorPage) {
        String aliasString;
        IDocument aliasDocument;
        String postConditionString;
        IDocument postConditionDocument;
        String viewString;
        if (this.getManagedForm() == null) {
            return;
        }
        DataBindingManager dm = this.getDataBindingManager();
        IMessageManager mm = this.getManagedForm().getMessageManager();
        mm.setAutoUpdate(false);
        ModelEditor modelEditor = (ModelEditor)this.getEditor();
        this.setComplete(true);
        this.getLookupHelper().resetModelNames(this);
        int number = this.workers.getSelection();
        if (number > Runtime.getRuntime().availableProcessors()) {
            modelEditor.addErrorMessage("strangeNumber1", "Specified number of workers is " + number + ". The number of processors available on the system is " + Runtime.getRuntime().availableProcessors() + ".\n The number of workers should not exceed the number of processors.", this.getId(), 2, UIHelper.getWidget((Object)dm.getAttributeControl("numberOfWorkers")));
            this.expandSection("__tlc_opt_config");
        } else {
            modelEditor.removeErrorMessage("strangeNumber1", UIHelper.getWidget((Object)dm.getAttributeControl("numberOfWorkers")));
        }
        try {
            int defaultMaxHeapSize = TLCUIActivator.getDefault().getPreferenceStore().getInt("maxHeapSizeDefault");
            int legacyValue = this.getModel().getAttribute("maxHeapSize", defaultMaxHeapSize);
            if (legacyValue == 500) {
                this.getModel().setAttribute("maxHeapSize", 25);
                this.maxHeapSize.setSelection(25);
            } else if (legacyValue >= 100) {
                modelEditor.addErrorMessage("strangeNumber1", "Found legacy value for physically memory of (" + legacyValue + "mb) that needs manual conversion. 25% is a safe setting on most computers.", this.getId(), 2, (Control)this.maxHeapSize);
                this.setComplete(false);
                this.expandSection("__tlc_opt_config");
            }
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logWarning("Faild to read heap value", e);
        }
        int maxHeapSizeValue = this.maxHeapSize.getSelection();
        double x = (double)maxHeapSizeValue / 100.0;
        float y = (float)this.linearInterpolator.interpolate(x);
        this.maxHeapSize.setBackground(new Color((Device)Display.getDefault(), new RGB(120.0f * y, 1.0f - y, 1.0f)));
        try {
            int dfidDepth = Integer.parseInt(this.m_depthText.getText());
            if (dfidDepth <= 0) {
                modelEditor.addErrorMessage("dfid1", "Depth of DFID launch must be a positive integer", this.getId(), 3, (Control)this.m_depthText);
                this.setComplete(false);
                this.expandSection("__tlc_opt_check_mode");
            } else {
                modelEditor.removeErrorMessage("dfid1", (Control)this.m_depthText);
            }
            modelEditor.removeErrorMessage("dfid2", (Control)this.m_depthText);
        }
        catch (NumberFormatException e) {
            modelEditor.addErrorMessage("dfid2", "Depth of DFID launch must be a positive integer", this.getId(), 3, (Control)this.m_depthText);
            this.setComplete(false);
            this.expandSection("__tlc_opt_check_mode");
        }
        try {
            if (!"".equals(this.m_simulationNumTracesText.getText().trim())) {
                long simuNumTraces = Long.parseLong(this.m_simulationNumTracesText.getText());
                if (simuNumTraces <= 0L) {
                    modelEditor.addErrorMessage("simuNumTraces1", "Length of the number of traces must be a positive long or empty for unlimited.", this.getId(), 3, (Control)this.m_simulationNumTracesText);
                    this.setComplete(false);
                    this.expandSection("__tlc_opt_check_mode");
                } else {
                    modelEditor.removeErrorMessage("simuNumTraces1", (Control)this.m_simulationNumTracesText);
                }
                modelEditor.removeErrorMessage("simuNumTraces2", (Control)this.m_simulationNumTracesText);
            }
        }
        catch (NumberFormatException e) {
            modelEditor.addErrorMessage("simuNumTraces2", "Length of the number of traces must be a positive long or empty for unlimited.", this.getId(), 3, (Control)this.m_simulationNumTracesText);
            this.setComplete(false);
            this.expandSection("__tlc_opt_check_mode");
        }
        try {
            int simuDepth = Integer.parseInt(this.m_simulationDepthText.getText());
            if (simuDepth <= 0) {
                modelEditor.addErrorMessage("simuDepth1", "Length of the simulation trace must be a positive integer.", this.getId(), 3, (Control)this.m_simulationDepthText);
                this.setComplete(false);
                this.expandSection("__tlc_opt_check_mode");
            } else {
                modelEditor.removeErrorMessage("simuDepth1", (Control)this.m_simulationDepthText);
            }
            modelEditor.removeErrorMessage("simuDepth2", (Control)this.m_simulationDepthText);
        }
        catch (NumberFormatException e) {
            modelEditor.addErrorMessage("simuDepth2", "Length of the simulation trace must be a positive integer.", this.getId(), 3, (Control)this.m_simulationDepthText);
            this.setComplete(false);
            this.expandSection("__tlc_opt_check_mode");
        }
        if (!"".equals(this.m_simulationArilText.getText())) {
            try {
                long simuAril = Long.parseLong(this.m_simulationArilText.getText());
                if (simuAril <= 0L) {
                    modelEditor.addErrorMessage("simuAril1", "The simulation aril must be a positive integer.", this.getId(), 3, (Control)this.m_simulationArilText);
                    this.setComplete(false);
                } else {
                    modelEditor.removeErrorMessage("simuAril1", (Control)this.m_simulationArilText);
                }
                modelEditor.removeErrorMessage("simuAril2", (Control)this.m_simulationArilText);
            }
            catch (NumberFormatException e) {
                modelEditor.addErrorMessage("simuAril2", "The simulation aril must be a positive integer.", this.getId(), 3, (Control)this.m_simulationArilText);
                this.setComplete(false);
                this.expandSection("__tlc_opt_check_mode");
            }
        }
        if (!"".equals(this.m_simulationSeedText.getText())) {
            try {
                Long.parseLong(this.m_simulationSeedText.getText());
                modelEditor.removeErrorMessage("simuSeed1", (Control)this.m_simulationSeedText);
            }
            catch (NumberFormatException e) {
                modelEditor.addErrorMessage("simuSeed1", "The simulation aril must be a positive integer.", this.getId(), 3, (Control)this.m_simulationSeedText);
                this.expandSection("__tlc_opt_check_mode");
                this.setComplete(false);
            }
        }
        this.updateCheckpoints();
        Control checkpointRecover = UIHelper.getWidget((Object)dm.getAttributeControl("recover"));
        modelEditor.removeErrorMessage("noCheckpoint", checkpointRecover);
        if (this.m_checkpointRecoverCheckbox.getSelection() && "".equals(this.m_checkpointIdText.getText())) {
            modelEditor.addErrorMessage("noCheckpoint", "No checkpoint data found", this.getId(), 3, checkpointRecover);
            this.setComplete(false);
            this.expandSection("__tlc_opt_check_mode");
        }
        Control viewWidget = UIHelper.getWidget((Object)dm.getAttributeControl("modelParameterView"));
        IDocument viewerDocument = this.m_viewSource.getDocument();
        if (viewerDocument != null && SemanticHelper.containsConfigFileKeyword(viewString = FormHelper.trimTrailingSpaces(viewerDocument.get()))) {
            modelEditor.addErrorMessage(viewString, "The toolbox cannot handle the string " + viewString + " because it contains a configuration file keyword.", this.getId(), 3, viewWidget);
            this.setComplete(false);
        }
        if ((postConditionDocument = this.postConditionSource.getDocument()) != null && SemanticHelper.containsConfigFileKeyword(postConditionString = FormHelper.trimTrailingSpaces(postConditionDocument.get()))) {
            modelEditor.addErrorMessage(postConditionString, "The toolbox cannot handle the string " + postConditionString + " because it contains a configuration file keyword.", this.getId(), 3, UIHelper.getWidget((Object)dm.getAttributeControl("modelParameterPostCondition")));
            this.setComplete(false);
        }
        if ((aliasDocument = this.aliasSource.getDocument()) != null && SemanticHelper.containsConfigFileKeyword(aliasString = FormHelper.trimTrailingSpaces(aliasDocument.get()))) {
            modelEditor.addErrorMessage(aliasString, "The toolbox cannot handle the string " + aliasString + " because it contains a configuration file keyword.", this.getId(), 3, UIHelper.getWidget((Object)dm.getAttributeControl("modelParameterAlias")));
            this.setComplete(false);
        }
        mm.setAutoUpdate(true);
        if (!FPSet.isValid((int)this.m_fingerprintBits.getSelection())) {
            modelEditor.addErrorMessage("wrongNumber3", "fpbits must be a positive integer number smaller than 31", this.getId(), 3, UIHelper.getWidget((Object)dm.getAttributeControl("fpBits")));
            this.setComplete(false);
            this.expandSection("__tlc_opt_config");
        }
        if (!TLCGlobals.isValidSetSize((int)this.m_maxSetSize.getSelection())) {
            modelEditor.addErrorMessage("wrongNumber3", "maxSetSize must be a positive integer number", this.getId(), 3, UIHelper.getWidget((Object)dm.getAttributeControl("maxSetSize")));
            this.setComplete(false);
            this.expandSection("__tlc_opt_params");
        }
        super.validatePage(switchToErrorPage);
    }

    private void updateCheckpoints() {
        IResource[] checkpoints = null;
        try {
            checkpoints = this.getModel().getCheckpoints(false);
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Error checking chekpoint data", e);
        }
        if (checkpoints != null && checkpoints.length > 0) {
            this.m_checkpointIdText.setText(checkpoints[0].getName());
        } else {
            this.m_checkpointIdText.setText("");
        }
        if (checkpoints == null || checkpoints.length == 0) {
            this.m_checkpointSizeText.setVisible(false);
            this.m_checkpointSizeLabel.setVisible(false);
            this.m_checkpointDeleteButton.setVisible(false);
        } else {
            this.m_checkpointSizeText.setText(String.valueOf(ResourceHelper.getSizeOfJavaFileResource((IResource)checkpoints[0]) / 1000L));
            this.m_checkpointSizeText.setVisible(true);
            this.m_checkpointSizeLabel.setVisible(true);
            this.m_checkpointDeleteButton.setVisible(true);
        }
    }

    private void updateEnabledStatesForAdvancedLaunchRadioSelection() {
        boolean simulationMode = this.m_simulationModeOption.getSelection();
        this.m_viewSource.getTextWidget().setEnabled(!simulationMode);
        this.m_depthFirstOptionCheckbox.setEnabled(!simulationMode);
        if (simulationMode) {
            this.m_depthText.setEnabled(false);
        } else {
            this.m_depthText.setEnabled(this.m_depthFirstOptionCheckbox.getSelection());
        }
        this.m_simulationNumTracesText.setEnabled(simulationMode);
        this.m_simulationDepthText.setEnabled(simulationMode);
        this.m_simulationSeedText.setEnabled(simulationMode);
        this.m_simulationArilText.setEnabled(simulationMode);
    }

    public void updateWorkersAndMemory(int workerCount, int memoryPercentage) {
        this.programmaticallySettingWorkerParameters.set(true);
        this.workers.setSelection(workerCount);
        this.maxHeapSize.setSelection(memoryPercentage);
        this.programmaticallySettingWorkerParameters.set(false);
    }

    public void setWorkerAndMemoryEnable(boolean enableWorker, boolean enableMaxHeap) {
        this.workers.getDisplay().asyncExec(() -> {
            if (!this.saveDefaultConfigurationButton.isDisposed()) {
                this.saveDefaultConfigurationButton.setEnabled(enableWorker);
                this.workers.setEnabled(enableWorker);
                this.maxHeapSize.setEnabled(enableMaxHeap);
            }
        });
    }

    public void setFpIndex(int fpIndex) {
        Listener listener;
        Listener[] listeners;
        if (this.m_fingerprintSeedIndex.getSelection() == fpIndex) {
            return;
        }
        Listener[] listenerArray = listeners = this.m_fingerprintSeedIndex.getListeners(24);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            listener = listenerArray[n2];
            this.m_fingerprintSeedIndex.removeListener(24, listener);
            ++n2;
        }
        this.m_fingerprintSeedIndex.setSelection(fpIndex);
        listenerArray = listeners;
        n = listeners.length;
        n2 = 0;
        while (n2 < n) {
            listener = listenerArray[n2];
            this.m_fingerprintSeedIndex.addListener(24, listener);
            ++n2;
        }
    }

    @Override
    public void close() throws IOException {
        int openTabState = this.getModel().getOpenTabsValue();
        this.getModelEditor().updateOpenTabsState(openTabState & 0xFFFFFFFB);
        DataBindingManager dm = this.getDataBindingManager();
        dm.unbindSectionAndAttribute("maxHeapSize");
        dm.unbindSectionAndAttribute("numberOfWorkers");
        dm.unbindSectionAndAttribute("recover");
        dm.unbindSectionAndAttribute("modelParameterView");
        dm.unbindSectionAndAttribute("modelParameterPostCondition");
        dm.unbindSectionAndAttribute("modelParameterAlias");
    }

    private String generateMemoryDisplayText() {
        int percentage = this.maxHeapSize.getSelection();
        long megabytes = TLCRuntime.getInstance().getAbsolutePhysicalSystemMemory((double)percentage / 100.0);
        return MainModelPage.generateMemoryDisplayText(percentage, megabytes);
    }

    private class Interpolator {
        private final double[] yCoords;
        private final double[] xCoords;

        public Interpolator(double[] x, double[] y) {
            this.xCoords = x;
            this.yCoords = y;
        }

        public double interpolate(double x) {
            int i = 1;
            while (i < this.xCoords.length) {
                if (x < this.xCoords[i]) {
                    return this.yCoords[i] - (this.yCoords[i] - this.yCoords[i - 1]) * (this.xCoords[i] - x) / (this.xCoords[i] - this.xCoords[i - 1]);
                }
                ++i;
            }
            return 0.0;
        }
    }
}

