/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.Section;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ISectionConstants;

public class DataBindingManager
implements ISectionConstants {
    public static final String WIDGET_HAS_ENABLED_STATE_HANDLED_ELSEWHERE = "tla.dbm.enable.sigh";
    private static final String[] EMPTY = new String[0];
    private Hashtable<String, SectionPart> sectionParts = new Hashtable(13);
    private Hashtable<String, String> pageForSection = new Hashtable(13);
    private Hashtable<String, Vector<String>> sectionsForPage = new Hashtable(13);
    private Hashtable<String, String> sectionForAttribute = new Hashtable(37);
    private Hashtable<String, Object> viewerForAttribute = new Hashtable(37);

    public void expandSection(String id) {
        SectionPart part = this.sectionParts.get(id);
        if (part == null) {
            throw new IllegalArgumentException("No section for id");
        }
        if (!part.getSection().isExpanded()) {
            part.getSection().setExpanded(true);
        }
    }

    public void setAllSectionsEnabled(String pageId, boolean enabled) {
        String[] sectionIds = this.getSectionsForPage(pageId);
        int i = 0;
        while (i < sectionIds.length) {
            this.enableSection(sectionIds[i], enabled);
            ++i;
        }
    }

    private void enableSection(String id, boolean enabled) {
        SectionPart part = this.sectionParts.get(id);
        if (part == null) {
            throw new IllegalArgumentException("No section for id [" + id + "]");
        }
        Section section = part.getSection();
        Control[] children = section.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                this.enableSectionComposite((Composite)children[i], enabled);
            }
            ++i;
        }
    }

    private void enableSectionComposite(Composite composite, boolean enabled) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!(child instanceof Section) && child.getData(WIDGET_HAS_ENABLED_STATE_HANDLED_ELSEWHERE) == null) {
                child.setEnabled(enabled);
            }
            ++n2;
        }
    }

    public String getSectionPage(String id) {
        String pageId = this.pageForSection.get(id);
        if (pageId != null) {
            return pageId;
        }
        throw new IllegalArgumentException("No page for id");
    }

    public void bindSection(SectionPart sectionPart, String id, String pageId) {
        this.sectionParts.put(id, sectionPart);
        this.pageForSection.put(id, pageId);
        Vector<String> sectionIds = this.sectionsForPage.get(pageId);
        if (sectionIds == null) {
            sectionIds = new Vector();
            this.sectionsForPage.put(pageId, sectionIds);
        }
        sectionIds.add(id);
    }

    public void unbindSectionAndAttribute(String attributeName) {
        this.viewerForAttribute.remove(attributeName);
        String sectionId = this.sectionForAttribute.remove(attributeName);
        if (sectionId != null) {
            Vector<String> sectionIds;
            this.sectionParts.remove(sectionId);
            String pageId = this.pageForSection.remove(sectionId);
            if (pageId != null && (sectionIds = this.sectionsForPage.get(pageId)) != null) {
                sectionIds.remove(sectionId);
            }
        }
    }

    public void unbindSectionFromPage(String sectionId, String pageId) {
        Vector<String> sectionIds = this.sectionsForPage.get(pageId);
        if (sectionIds != null) {
            sectionIds.remove(sectionId);
        }
    }

    private String[] getSectionsForPage(String pageId) {
        Vector<String> sectionIds = this.sectionsForPage.get(pageId);
        if (sectionIds == null) {
            return EMPTY;
        }
        return sectionIds.toArray(new String[sectionIds.size()]);
    }

    public String getSectionForAttribute(String attributeName) {
        return this.sectionForAttribute.get(attributeName);
    }

    public SectionPart getSection(String sectionId) {
        return this.sectionParts.get(sectionId);
    }

    public void bindAttribute(String attributeName, Object attributeViewer, SectionPart sectionPart) {
        this.viewerForAttribute.put(attributeName, attributeViewer);
        Enumeration<String> enumeration = this.sectionParts.keys();
        while (enumeration.hasMoreElements()) {
            String sectionId = enumeration.nextElement();
            SectionPart registeredPart = this.sectionParts.get(sectionId);
            if (!registeredPart.equals(sectionPart)) continue;
            this.sectionForAttribute.put(attributeName, sectionId);
            break;
        }
    }

    public Object getAttributeControl(String attributeName) {
        return this.viewerForAttribute.get(attributeName);
    }
}

