/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.List;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCFcnElementVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCMultiVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCSimpleVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariableValue;

public class TLCSequenceVariableValue
extends TLCVariableValue
implements TLCMultiVariableValue {
    private static final String[] DELIMETERS = new String[]{"<<", ",", ">>"};
    private TLCFcnElementVariableValue[] elements;
    private TLCVariableValue[] elementValues;

    TLCSequenceVariableValue(List values) {
        this.value = values;
        this.elements = this.innerGetElements();
        this.elementValues = new TLCVariableValue[this.elements.length];
        int i = 0;
        while (i < this.elements.length) {
            this.elementValues[i] = (TLCVariableValue)this.elements[i].getValue();
            ++i;
        }
    }

    @Override
    public Object getValue() {
        return this.getElements();
    }

    public TLCFcnElementVariableValue[] getElements() {
        return this.elements;
    }

    private TLCFcnElementVariableValue[] innerGetElements() {
        List list = (List)this.value;
        TLCFcnElementVariableValue[] result = new TLCFcnElementVariableValue[list.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new TLCFcnElementVariableValue(new TLCSimpleVariableValue("" + (i + 1)), (TLCVariableValue)list.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public String toSimpleString() {
        return TLCSequenceVariableValue.arrayToSimpleStringBuffer(this.elementValues, DELIMETERS).toString();
    }

    @Override
    public List<TLCVariableValue> asList() {
        return (List)this.value;
    }

    @Override
    protected void innerDiff(TLCVariableValue other) {
        TLCFcnElementVariableValue[] secondElts;
        if (!(other instanceof TLCSequenceVariableValue)) {
            return;
        }
        TLCFcnElementVariableValue[] firstElts = this.getElements();
        if (firstElts.length == (secondElts = ((TLCSequenceVariableValue)other).getElements()).length) {
            this.setFcnElementArrayDiffInfo(firstElts, secondElts);
            return;
        }
        TLCFcnElementVariableValue[] shorter = firstElts;
        TLCFcnElementVariableValue[] longer = secondElts;
        boolean firstShorter = true;
        if (firstElts.length > secondElts.length) {
            longer = firstElts;
            shorter = secondElts;
            firstShorter = false;
        }
        boolean isPrefix = true;
        int i = 0;
        while (i < shorter.length) {
            if (!((TLCVariableValue)shorter[i].getValue()).toSimpleString().equals(((TLCVariableValue)longer[i].getValue()).toSimpleString())) {
                isPrefix = false;
                break;
            }
            ++i;
        }
        boolean isSuffix = true;
        int i2 = 0;
        while (i2 < shorter.length) {
            if (!((TLCVariableValue)shorter[i2].getValue()).toSimpleString().equals(((TLCVariableValue)longer[i2 + longer.length - shorter.length].getValue()).toSimpleString())) {
                isSuffix = false;
                break;
            }
            ++i2;
        }
        if (isPrefix && isSuffix) {
            if (firstShorter) {
                isSuffix = false;
            } else {
                isPrefix = false;
            }
        } else if (!isPrefix && !isSuffix) {
            this.setFcnElementArrayDiffInfo(firstElts, secondElts);
            return;
        }
        int firstEltToMark = isPrefix ? shorter.length : 0;
        int i3 = 0;
        while (i3 < longer.length - shorter.length) {
            TLCVariableValue value = (TLCVariableValue)longer[i3 + firstEltToMark].value;
            if (firstShorter) {
                value.setAdded();
            } else {
                value.setDeleted();
            }
            ++i3;
        }
    }
}

