/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.st.Location;
import util.UniqueString;

public class TLCUIHelper {
    public static final Pattern PCAL_LOC_PATTERN = Pattern.compile("line ([0-9]+), column ([0-9]+)");

    public static void setHelp(Control control, String localContext) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.lamport.tla.toolbox.tool.tlc.ui." + localContext);
    }

    public static void setTLCLocationHyperlinks(StyledText styledText) {
        String text = styledText.getText();
        List<StyleRange> list = TLCUIHelper.setTLCLocationHyperlinks(text);
        for (StyleRange styleRange : list) {
            styledText.setStyleRange(styleRange);
        }
    }

    protected static List<StyleRange> setTLCLocationHyperlinks(String text) {
        Matcher matcher;
        ArrayList<StyleRange> result = new ArrayList<StyleRange>();
        String mutableText = text;
        String moduleName = null;
        int i = 0;
        while (i < Location.ALL_PATTERNS.length) {
            matcher = Location.ALL_PATTERNS[i].matcher(mutableText);
            while (matcher.find()) {
                String locationString = matcher.group();
                Location location = Location.parseLocation((String)locationString);
                if (!(location == null || location.equals((Object)Location.nullLoc) || location.source().equals("MC") || location.source().equals("TE"))) {
                    moduleName = location.source();
                    result.add(TLCUIHelper.getHyperlinkStyleRange(location, matcher.start(), matcher.end()));
                }
                mutableText = mutableText.replace(locationString, "");
            }
            ++i;
        }
        matcher = PCAL_LOC_PATTERN.matcher(mutableText);
        if (matcher.find()) {
            try {
                Assert.isNotNull(moduleName, (String)"Found a plus cal assertion failed location without a TLC error location with the module name.");
                int beginLine = Integer.parseInt(matcher.group(1));
                int beginColumn = Integer.parseInt(matcher.group(2));
                Location l = new Location(UniqueString.uniqueStringOf(moduleName), beginLine, beginColumn, beginLine, beginColumn);
                result.add(TLCUIHelper.getHyperlinkStyleRange(l, matcher.start(), matcher.end()));
            }
            catch (NumberFormatException e) {
                TLCUIActivator.getDefault().logError("Error parsing PlusCal assertion failed location.", e);
            }
        }
        return result;
    }

    public static void openTLCLocationHyperlink(StyledText styledText, MouseEvent trigger, Model model) {
        TLCUIHelper.openTLCLocationHyperlink(styledText, trigger, model, new HashSet<Class<? extends ITextEditor>>());
    }

    public static void openTLCLocationHyperlink(StyledText styledText, MouseEvent trigger, Model model, Set<Class<? extends ITextEditor>> blacklist) {
        try {
            boolean jumpToSavedModule;
            Object data;
            int offset = styledText.getOffsetAtLocation(new Point(trigger.x, trigger.y));
            StyleRange range = styledText.getStyleRangeAtOffset(offset);
            if (range != null && (data = range.data) instanceof Location && !(jumpToSavedModule = TLCUIHelper.jumpToSavedLocation((Location)data, model, blacklist))) {
                UIHelper.jumpToLocation((Location)((Location)data), ((trigger.stateMask & SWT.MOD1) != 0 ? 1 : 0) != 0, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static StyleRange getHyperlinkStyleRange(Location location, int start, int end) {
        StyleRange style = new StyleRange(start, end - start, null, null);
        style.underlineStyle = 4;
        style.underline = true;
        style.data = location;
        return style;
    }

    public static boolean jumpToSavedLocation(Location location, Model model) {
        return TLCUIHelper.jumpToSavedLocation(location, model, new HashSet<Class<? extends ITextEditor>>());
    }

    public static boolean jumpToSavedLocation(Location location, Model model, Set<Class<? extends ITextEditor>> blacklist) {
        ModelEditor modelEditor;
        ITextEditor moduleEditor;
        IEditorPart editor = (IEditorPart)model.getAdapter(ModelEditor.class);
        if (editor instanceof ModelEditor && (moduleEditor = (modelEditor = (ModelEditor)editor).getSavedModuleEditor(location.source())) != null && !blacklist.contains(moduleEditor.getClass())) {
            try {
                IRegion jumpToRegion = AdapterFactory.locationToRegion((IDocument)moduleEditor.getDocumentProvider().getDocument((Object)moduleEditor.getEditorInput()), (Location)location);
                UIHelper.getActivePage().activate((IWorkbenchPart)modelEditor);
                modelEditor.setActiveEditor((IEditorPart)moduleEditor);
                moduleEditor.selectAndReveal(jumpToRegion.getOffset(), jumpToRegion.getLength());
                return true;
            }
            catch (BadLocationException e) {
                TLCUIActivator.getDefault().logError("Error converting location to region in saved module. The location is " + String.valueOf(location), e);
            }
        }
        return false;
    }
}

