/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.modelexplorer;

import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.util.UIHelper;

public class CloneModelContributionItem
extends CompoundContributionItem {
    public static final String COMMAND_ID_ALWAYS_ENABLED = "toolbox.tool.tlc.commands.model.clone.delegate.always.enabled";
    private ImageDescriptor modelIcon = TLCUIActivator.getImageDescriptor("icons/full/choice_sc_obj.gif");

    protected IContributionItem[] getContributionItems() {
        Vector<CommandContributionItem> modelContributions = new Vector<CommandContributionItem>();
        Spec currentSpec = ToolboxHandle.getCurrentSpec();
        if (currentSpec == null) {
            return new IContributionItem[0];
        }
        IProject specProject = currentSpec.getProject();
        try {
            specProject.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Exception encountered refreshing the project.", e);
        }
        Set modelNames = ((TLCSpec)currentSpec.getAdapter(TLCSpec.class)).getModels().keySet();
        for (String modelName : modelNames) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("toolbox.tool.tlc.commands.model.clone.param.modelName", modelName);
            CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)UIHelper.getActiveWindow(), "toolbox.command.model.clone." + modelName, COMMAND_ID_ALWAYS_ENABLED, parameters, this.modelIcon, null, null, modelName, null, "Clones " + modelName, 8, null, true);
            modelContributions.add(new CommandContributionItem(param));
        }
        CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)UIHelper.getActiveWindow(), "toolbox.command.model.cloneforeign", "toolbox.tool.tlc.commands.model.cloneforeign", null, null, null, null, "Foreign Model...", null, "Shows a chooser dialog to select a foreign model.", 8, null, true);
        modelContributions.add(new CommandContributionItem(param));
        return modelContributions.toArray(new IContributionItem[modelContributions.size()]);
    }
}

