/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results;

import java.text.NumberFormat;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.lamport.tla.toolbox.tool.tlc.output.data.StateSpaceInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.ResultPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.ResultPageColumnListener;
import org.lamport.tla.toolbox.tool.tlc.ui.util.AbstractTableLabelProvider;

class StateSpaceLabelProvider
extends AbstractTableLabelProvider {
    static final int COL_TIME = 0;
    static final int COL_DIAMETER = 1;
    static final int COL_FOUND = 2;
    static final int COL_DISTINCT = 3;
    static final int COL_LEFT = 4;
    private static final String[] COLUMN_TITLES = new String[]{"Time", "Diameter", "States Found", "Distinct States", "Queue Size"};
    private static final String NO_DATA_TEXT = "--";
    private static final int[] COLUMN_WIDTHS;
    private static final double[] COLUMN_WIDTH_PERCENTAGES;
    private static final int MIN_WIDTH;
    private boolean m_doHighlight = false;
    private final ResultPage m_resultPage;

    static {
        double scale = 1.0;
        COLUMN_WIDTHS = new int[5];
        StateSpaceLabelProvider.COLUMN_WIDTHS[0] = 60;
        StateSpaceLabelProvider.COLUMN_WIDTHS[1] = 30;
        StateSpaceLabelProvider.COLUMN_WIDTHS[2] = 40;
        StateSpaceLabelProvider.COLUMN_WIDTHS[3] = 50;
        StateSpaceLabelProvider.COLUMN_WIDTHS[4] = 40;
        MIN_WIDTH = COLUMN_WIDTHS[0] + COLUMN_WIDTHS[1] + COLUMN_WIDTHS[2] + COLUMN_WIDTHS[3] + COLUMN_WIDTHS[4];
        COLUMN_WIDTH_PERCENTAGES = new double[5];
        int i = 0;
        while (i < 5) {
            StateSpaceLabelProvider.COLUMN_WIDTH_PERCENTAGES[i] = (double)COLUMN_WIDTHS[i] / (double)MIN_WIDTH;
            ++i;
        }
    }

    StateSpaceLabelProvider(ResultPage resultPage) {
        super(MIN_WIDTH, COLUMN_TITLES, COLUMN_WIDTH_PERCENTAGES);
        this.m_resultPage = resultPage;
    }

    void createTableColumns(Table stateTable, ResultPage page, TableColumnLayout layout) {
        int i = 0;
        while (i < COLUMN_TITLES.length) {
            TableColumn column = new TableColumn(stateTable, 0);
            column.setWidth(COLUMN_WIDTHS[i]);
            column.setText(COLUMN_TITLES[i]);
            int weight = (int)(100.0 * COLUMN_WIDTH_PERCENTAGES[i]);
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight, COLUMN_WIDTHS[i], true));
            column.addSelectionListener((SelectionListener)new ResultPageColumnListener(i, page));
            ++i;
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof StateSpaceInformationItem) {
            NumberFormat nf = NumberFormat.getIntegerInstance();
            StateSpaceInformationItem item = (StateSpaceInformationItem)element;
            switch (columnIndex) {
                case 0: {
                    return TLCModelLaunchDataProvider.formatInterval(this.m_resultPage.getStartTimestamp(), item.getTime().getTime());
                }
                case 1: {
                    if (item.getDiameter() >= 0L) {
                        return nf.format(item.getDiameter());
                    }
                    return NO_DATA_TEXT;
                }
                case 2: {
                    return nf.format(item.getFoundStates());
                }
                case 3: {
                    if (item.getDistinctStates() >= 0L) {
                        return nf.format(item.getDistinctStates());
                    }
                    return NO_DATA_TEXT;
                }
                case 4: {
                    if (item.getLeftStates() >= 0L) {
                        return nf.format(item.getLeftStates());
                    }
                    return NO_DATA_TEXT;
                }
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        StateSpaceInformationItem ssii = (StateSpaceInformationItem)element;
        if (this.m_doHighlight && columnIndex == 4 && ssii.isMostRecent()) {
            return TLCUIActivator.getColor(3);
        }
        return null;
    }

    void setHighlightUnexplored() {
        this.m_doHighlight = true;
    }

    void unsetHighlightUnexplored() {
        this.m_doHighlight = false;
    }
}

