/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.source;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.ITLCOutputListener;
import org.lamport.tla.toolbox.tool.tlc.output.LogFileReader;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.output.data.TraceExplorerDataProvider;
import org.lamport.tla.toolbox.tool.tlc.output.source.ITLCOutputSource;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;

public class TLCOutputSourceRegistry {
    private static final boolean DO_DEBUG = Boolean.getBoolean(TLCOutputSourceRegistry.class.getName() + ".debug");
    private static TLCOutputSourceRegistry modelCheckInstance;
    private static TLCOutputSourceRegistry traceExploreInstance;
    private Map<Model, ITLCOutputSource> sources = new HashMap<Model, ITLCOutputSource>();
    private Map<Model, TLCModelLaunchDataProvider> providers = new HashMap<Model, TLCModelLaunchDataProvider>();
    private boolean isTraceExploreInstance;

    public synchronized void addTLCOutputSource(ITLCOutputSource source) {
        TLCModelLaunchDataProvider provider;
        Assert.isNotNull((Object)source);
        ITLCOutputSource existingSource = this.sources.get(source.getModel());
        if (existingSource != null && source.getSourcePrio() >= existingSource.getSourcePrio()) {
            ITLCOutputListener[] registered = existingSource.getListeners();
            int i = 0;
            while (i < registered.length) {
                existingSource.removeTLCOutputListener(registered[i]);
                source.addTLCOutputListener(registered[i]);
                registered[i].onNewSource();
                ++i;
            }
        } else if (existingSource == null && (provider = this.providers.get(source.getModel())) != null) {
            source.addTLCOutputListener(provider);
        }
        this.sources.put(source.getModel(), source);
        this.printStats();
    }

    private synchronized void removeTLCStatusSource(Model model) {
        this.sources.remove(model);
        this.providers.remove(model);
        this.printStats();
    }

    public synchronized void removeTLCStatusSource(Model[] models) {
        int i = 0;
        while (i < models.length) {
            this.removeTLCStatusSource(models[i]);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized boolean connect(ITLCOutputListener listener) {
        block5: {
            Assert.isNotNull((Object)listener);
            Model model = listener.getModel();
            ITLCOutputSource source = this.sources.get(model);
            if (source == null) {
                if (model == null) {
                    return false;
                }
                IFile logFile = model.getOutputLogFile(this.isTraceExploreInstance);
                if (logFile != null && logFile.exists()) {
                    final LogFileReader logFileReader = new LogFileReader(model, logFile, this.isTraceExploreInstance);
                    source = logFileReader.getSource();
                    source.addTLCOutputListener(listener);
                    WorkspaceJob job = new WorkspaceJob("Logfile reader..."){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            try {
                                logFileReader.read(monitor);
                            }
                            catch (BadLocationException e) {
                                return new Status(4, "org.lamport.tla.toolbox", e.getMessage());
                            }
                            catch (IOException e) {
                                return new Status(4, "org.lamport.tla.toolbox", e.getMessage());
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setPriority(20);
                    job.setUser(true);
                    job.schedule();
                    Assert.isTrue((this.sources.get(model) != null ? 1 : 0) != 0);
                    break block5;
                } else {
                    if (DO_DEBUG) {
                        TLCUIActivator.getDefault().logDebug("No source for " + model.getName() + " found.");
                    }
                    return false;
                }
            }
            source.addTLCOutputListener(listener);
        }
        this.printStats();
        return true;
    }

    public synchronized void disconnect(ITLCOutputListener listener) {
        Assert.isNotNull((Object)listener);
        ITLCOutputSource source = this.sources.get(listener.getModel());
        if (source != null) {
            source.removeTLCOutputListener(listener);
        }
        this.printStats();
    }

    public synchronized TLCModelLaunchDataProvider getProvider(Model model) {
        Assert.isNotNull((Object)model);
        TLCModelLaunchDataProvider provider = this.providers.get(model);
        if (provider == null) {
            provider = this.isTraceExploreInstance ? new TraceExplorerDataProvider(model) : new TLCModelLaunchDataProvider(model);
            this.providers.put(model, provider);
        }
        return provider;
    }

    public synchronized boolean hasProvider(Model model) {
        return this.providers.containsKey(model);
    }

    private TLCOutputSourceRegistry() {
    }

    public static TLCOutputSourceRegistry getModelCheckSourceRegistry() {
        if (modelCheckInstance == null) {
            modelCheckInstance = new TLCOutputSourceRegistry();
            TLCOutputSourceRegistry.modelCheckInstance.isTraceExploreInstance = false;
        }
        return modelCheckInstance;
    }

    public static TLCOutputSourceRegistry getTraceExploreSourceRegistry() {
        if (traceExploreInstance == null) {
            traceExploreInstance = new TLCOutputSourceRegistry();
            TLCOutputSourceRegistry.traceExploreInstance.isTraceExploreInstance = true;
        }
        return traceExploreInstance;
    }

    private void printStats() {
        if (DO_DEBUG) {
            String type = "model checking";
            if (this.isTraceExploreInstance) {
                type = "trace exploration";
            }
            TLCUIActivator.getDefault().logDebug("TLCOutputSourceRegistry for " + type + " maintains " + this.sources.size() + " sources.");
            Set<Model> keySet = this.sources.keySet();
            for (Model model : keySet) {
                ITLCOutputSource source = this.sources.get(model);
                TLCUIActivator.getDefault().logDebug("The source " + model.getName() + " has " + source.getSourcePrio() + " prio and " + source.getListeners().length + " listeners");
            }
        }
    }
}

