/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.handlers;

import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.handlers.CloneModelHandlerDelegate;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;

public class CloneForeignModelHandler
extends AbstractHandler
implements IModelConfigurationConstants {
    public static final String COMMAND_ID = "toolbox.tool.tlc.commands.model.cloneforeign";
    private static final Comparator<Model> MODEL_SORTER = (m1, m2) -> m1.getName().compareTo(m2.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TreeMap<String, TreeSet<Model>> projectModelMap = this.buildMap();
        if (projectModelMap == null) {
            return null;
        }
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        ForeignModelPicker modelPicker = new ForeignModelPicker(shell, projectModelMap);
        if (modelPicker.open() == 0) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("toolbox.tool.tlc.commands.model.clone.param.foreignFullyQualifiedModelName", modelPicker.getFullyQualifiedNameOfSelection());
            ExecutionEvent cloneEvent = new ExecutionEvent(null, parameters, null, null);
            CloneModelHandlerDelegate cloner = new CloneModelHandlerDelegate();
            cloner.execute(cloneEvent);
        }
        return null;
    }

    private TreeMap<String, TreeSet<Model>> buildMap() {
        Spec currentSpec = ToolboxHandle.getCurrentSpec();
        if (currentSpec == null) {
            return null;
        }
        IProject specProject = currentSpec.getProject();
        TreeMap<String, TreeSet<Model>> projectModelMap = new TreeMap<String, TreeSet<Model>>();
        try {
            ILaunchConfiguration[] launchConfigurations;
            IProject[] projects;
            IWorkspace iws = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = iws.getRoot();
            IProject[] iProjectArray = projects = root.getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!specProject.equals((Object)project)) {
                    projectModelMap.put(project.getName(), new TreeSet<Model>(MODEL_SORTER));
                }
                ++n2;
            }
            String currentProjectName = specProject.getName();
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.lamport.tla.toolbox.tool.tlc.modelCheck");
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
            int n3 = launchConfigurations.length;
            int n4 = 0;
            while (n4 < n3) {
                ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n4];
                String projectName = launchConfiguration.getAttribute("specName", "-l!D!q_-l!D!q_-l!D!q_");
                if (!projectName.equals(currentProjectName)) {
                    TreeSet<Model> models = projectModelMap.get(projectName);
                    if (models != null) {
                        Model model = (Model)launchConfiguration.getAdapter(Model.class);
                        if (!model.isSnapshot()) {
                            models.add(model);
                        }
                    } else {
                        TLCUIActivator.getDefault().logError("Could not generate model map for [" + projectName + "]!");
                    }
                }
                ++n4;
            }
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Building foreign model map.", e);
            return null;
        }
        return projectModelMap;
    }

    private static class ForeignModelPicker
    extends Dialog {
        private final TreeMap<String, TreeSet<Model>> specNameModelMap;
        private List specList;
        private List modelList;
        private String selectedFullyQualifiedName;

        private ForeignModelPicker(Shell shell, TreeMap<String, TreeSet<Model>> projectModelMap) {
            super(shell);
            this.specNameModelMap = projectModelMap;
        }

        private String getFullyQualifiedNameOfSelection() {
            return this.selectedFullyQualifiedName;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            GridLayout gl = new GridLayout(2, false);
            container.setLayout((Layout)gl);
            Composite leftPane = new Composite(container, 0);
            gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            leftPane.setLayout((Layout)gl);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
            leftPane.setLayoutData((Object)gd);
            Composite rightPane = new Composite(container, 0);
            gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            rightPane.setLayout((Layout)gl);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
            rightPane.setLayoutData((Object)gd);
            Label l = new Label(leftPane, 16384);
            l.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            l.setText("Spec:");
            this.specList = new List(leftPane, 2564);
            for (String specName : this.specNameModelMap.keySet()) {
                this.specList.add(specName);
            }
            this.specList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    this.getButton(0).setEnabled(false);
                    selectedFullyQualifiedName = null;
                    modelList.removeAll();
                    TreeSet<Model> models = specNameModelMap.get(specList.getSelection()[0]);
                    for (Model model : models) {
                        modelList.add(model.getName());
                    }
                }
            });
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
            this.specList.setLayoutData((Object)gd);
            l = new Label(rightPane, 16384);
            l.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            l.setText("Model:");
            this.modelList = new List(rightPane, 2564);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
            this.modelList.setLayoutData((Object)gd);
            this.modelList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    this.getButton(0).setEnabled(true);
                    selectedFullyQualifiedName = Model.fullyQualifiedNameFromSpecNameAndModelName((String)specList.getSelection()[0], (String)modelList.getSelection()[0]);
                }
            });
            return container;
        }

        protected Control createButtonBar(Composite parent) {
            Control buttonBar = super.createButtonBar(parent);
            this.getButton(0).setEnabled(false);
            return buttonBar;
        }

        protected Point getInitialSize() {
            return new Point(500, 330);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Please choose a spec and a model");
        }
    }
}

