/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.wizard;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.wizard.AssignmentWizard;
import org.lamport.tla.toolbox.tool.tlc.ui.wizard.LabeledListComposite;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.semantic.OpDefNode;
import tlc2.model.Assignment;
import tlc2.model.TypedSet;

public class AssignmentWizardPage
extends WizardPage {
    public static final String CONSTANT_WIZARD_ID = "constant_assignment_wizard";
    public static final String DEF_OVERRIDE_WIZARD_ID = "definition_override_wizard";
    private LabeledListComposite paramComposite;
    private SourceViewer source;
    private final int fieldFlags;
    private final String helpId;
    private Button optionOrdinaryValue;
    private Button optionModelValue = null;
    private Button optionSetModelValues;
    private Button flagSymmetricalSet;
    private Combo smvTypeCombo;
    private Button optionSMVUntyped;
    private final SelectionListener typingOptionSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AssignmentWizardPage.this.smvTypeCombo.setEnabled(AssignmentWizardPage.this.optionSMVUntyped.getSelection());
        }
    };
    private final SelectionListener optionSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AssignmentWizardPage.this.configureTextWidget(AssignmentWizardPage.this.optionModelValue.getSelection());
            if (AssignmentWizardPage.this.fieldFlags == 1) {
                boolean modelValueSetSelected = AssignmentWizardPage.this.optionSetModelValues.getSelection();
                AssignmentWizardPage.this.flagSymmetricalSet.setEnabled(modelValueSetSelected);
                AssignmentWizardPage.this.smvTypeCombo.setEnabled(modelValueSetSelected);
                AssignmentWizardPage.this.optionSMVUntyped.setEnabled(modelValueSetSelected);
            }
            AssignmentWizardPage.this.getContainer().updateButtons();
        }
    };

    public AssignmentWizardPage(String action, String description, int fieldFlags, String helpId) {
        super("AssignmentWizardPage");
        this.fieldFlags = fieldFlags;
        this.helpId = helpId;
        this.setTitle(action);
        this.setDescription(description);
    }

    private void configureTextWidget(boolean forModelValue) {
        StyledText textWidget = this.source.getTextWidget();
        if (forModelValue) {
            textWidget.setBackground(textWidget.getParent().getBackground());
        } else {
            textWidget.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(1));
        }
        textWidget.setEnabled(!forModelValue);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(16384, 128, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Assignment assignment = this.getAssignment();
        Object localLabel = assignment.getLocalLabel();
        OpDefNode node = ModelHelper.getOpDefNode((String)assignment.getLabel());
        if (node != null && node.getSource() != node) {
            localLabel = (String)localLabel + " [" + node.getSource().getOriginallyDefinedInModuleNode().getName().toString() + "]";
        }
        this.paramComposite = new LabeledListComposite(container, (String)localLabel, assignment.getParams());
        GridData gd = new GridData(16384, 128, false, true);
        this.paramComposite.setLayoutData(gd);
        this.source = FormHelper.createSourceViewer(container, 2818);
        this.source.setDocument((IDocument)new Document(assignment.getRight()));
        StyledText styledText = this.source.getTextWidget();
        styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AssignmentWizardPage.this.getContainer().updateButtons();
            }
        });
        styledText.setBackgroundMode(2);
        styledText.setEditable(true);
        styledText.setFocus();
        gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 500;
        gd.minimumHeight = 100;
        styledText.setLayoutData((Object)gd);
        if (!this.paramComposite.hasParameters()) {
            if (this.fieldFlags == 1) {
                Composite leftContainer = new Composite(container, 0);
                gd = new GridData(16384, 128, false, false);
                leftContainer.setLayoutData((Object)gd);
                leftContainer.setLayout((Layout)new GridLayout(1, false));
                this.optionOrdinaryValue = new Button(leftContainer, 16);
                this.optionOrdinaryValue.setText("Ordinary assignment");
                gd = new GridData(16384, 128, false, false);
                this.optionOrdinaryValue.setLayoutData((Object)gd);
                this.optionModelValue = new Button(leftContainer, 16);
                this.optionModelValue.setText("Model value");
                gd = new GridData(16384, 128, false, false);
                this.optionModelValue.setLayoutData((Object)gd);
                this.optionSetModelValues = new Button(leftContainer, 16);
                this.optionSetModelValues.setText("Set of model values");
                gd = new GridData(16384, 128, false, false);
                this.optionSetModelValues.setLayoutData((Object)gd);
                this.flagSymmetricalSet = new Button(leftContainer, 32);
                this.flagSymmetricalSet.setText("Symmetry set");
                gd = new GridData(16384, 128, false, false);
                gd.horizontalIndent = 10;
                this.flagSymmetricalSet.setLayoutData((Object)gd);
                Composite rightContainer = new Composite(leftContainer, 0);
                gd = new GridData(16384, 128, false, false);
                rightContainer.setLayoutData((Object)gd);
                rightContainer.setLayout((Layout)new GridLayout(2, false));
                this.optionSMVUntyped = new Button(rightContainer, 32);
                this.optionSMVUntyped.setText("Type:");
                this.optionSMVUntyped.addSelectionListener(this.typingOptionSelectionAdapter);
                gd = new GridData(16384, 128, true, false);
                gd.horizontalIndent = 5;
                this.optionSMVUntyped.setLayoutData((Object)gd);
                this.smvTypeCombo = new Combo(rightContainer, 2048);
                char i = 'A';
                while (i < 'z') {
                    if (Character.isLetter(i)) {
                        this.smvTypeCombo.add("" + i);
                    }
                    i = (char)(i + '\u0001');
                }
                gd = new GridData(16384, 128, false, false);
                this.smvTypeCombo.setLayoutData((Object)gd);
                this.smvTypeCombo.setText("A");
                this.smvTypeCombo.setEnabled(false);
                this.optionOrdinaryValue.addSelectionListener(this.optionSelectionAdapter);
                this.optionModelValue.addSelectionListener(this.optionSelectionAdapter);
                this.optionSetModelValues.addSelectionListener(this.optionSelectionAdapter);
                this.configureTextWidget(assignment.isModelValue());
                if (assignment.isModelValue()) {
                    if (!assignment.isSetOfModelValues()) {
                        this.flagSymmetricalSet.setEnabled(false);
                        this.smvTypeCombo.setEnabled(false);
                        this.optionSMVUntyped.setEnabled(false);
                        this.optionModelValue.setSelection(assignment.isModelValue());
                    } else {
                        this.optionSetModelValues.setSelection(assignment.isModelValue());
                        this.flagSymmetricalSet.setSelection(assignment.isSymmetricalSet());
                        TypedSet set = TypedSet.parseSet((String)this.getAssignment().getRight());
                        boolean hasType = set.hasType();
                        this.optionSMVUntyped.setSelection(hasType);
                        if (hasType) {
                            this.smvTypeCombo.setText(set.getType());
                            this.smvTypeCombo.setEnabled(true);
                        }
                        styledText.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(1));
                        styledText.setEnabled(true);
                    }
                } else {
                    this.flagSymmetricalSet.setEnabled(false);
                    this.smvTypeCombo.setEnabled(false);
                    this.optionSMVUntyped.setEnabled(false);
                    this.optionOrdinaryValue.setSelection(true);
                }
            } else if (this.fieldFlags == 2) {
                this.optionOrdinaryValue = new Button(container, 16);
                this.optionOrdinaryValue.setText("Ordinary assignment");
                gd = new GridData(16384, 128, false, false);
                gd.horizontalSpan = 2;
                this.optionOrdinaryValue.setLayoutData((Object)gd);
                this.optionModelValue = new Button(container, 16);
                this.optionModelValue.setText("Model value");
                gd = new GridData(16384, 128, false, false);
                gd.horizontalSpan = 2;
                this.optionModelValue.setLayoutData((Object)gd);
                this.optionOrdinaryValue.addSelectionListener(this.optionSelectionAdapter);
                this.optionModelValue.addSelectionListener(this.optionSelectionAdapter);
                this.configureTextWidget(assignment.isModelValue());
                if (assignment.isModelValue()) {
                    if (!assignment.isSetOfModelValues()) {
                        this.optionModelValue.setSelection(assignment.isModelValue());
                        this.source.getTextWidget().setBackground(container.getBackground());
                    } else {
                        styledText.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(1));
                        styledText.setEnabled(true);
                    }
                } else {
                    this.optionOrdinaryValue.setSelection(true);
                }
            }
        }
        UIHelper.setHelp((Control)container, (String)this.helpId);
        this.setControl((Control)container);
    }

    public Assignment getAssignment() {
        return ((AssignmentWizard)this.getWizard()).getFormula();
    }

    public void dispose() {
        AssignmentWizard wizard = (AssignmentWizard)this.getWizard();
        if (wizard.getWizardDialogReturnCode() == 1) {
            super.dispose();
            return;
        }
        String rightSide = FormHelper.trimTrailingSpaces(this.source.getDocument().get());
        if (this.optionModelValue != null && this.optionSetModelValues != null) {
            this.getAssignment().setModelValue(this.optionModelValue.getSelection() || this.optionSetModelValues.getSelection());
            if (this.optionModelValue.getSelection()) {
                this.getAssignment().setRight(this.getAssignment().getLabel());
            } else if (this.optionSetModelValues.getSelection()) {
                TypedSet set = TypedSet.parseSet((String)rightSide);
                this.getAssignment().setSymmetric(this.flagSymmetricalSet.getSelection());
                this.getAssignment().setRight(set.toString());
                set = TypedSet.parseSet((String)this.getAssignment().getRight());
                if (this.optionSMVUntyped.getSelection()) {
                    String type = this.smvTypeCombo.getText();
                    set.setType(type);
                } else {
                    set.unsetType();
                }
                this.getAssignment().setRight(set.toString());
            } else {
                this.getAssignment().setRight(rightSide);
            }
        } else if (this.optionModelValue != null) {
            this.getAssignment().setModelValue(this.optionModelValue.getSelection());
            if (this.optionModelValue.getSelection()) {
                this.getAssignment().setRight(this.getAssignment().getLabel());
            } else {
                this.getAssignment().setRight(rightSide);
            }
        } else {
            this.getAssignment().setRight(rightSide);
        }
        if (this.paramComposite.hasParameters()) {
            this.getAssignment().setParams(this.paramComposite.getValues());
        }
        super.dispose();
    }

    public String getInputText() {
        return this.source.getDocument().get();
    }

    public boolean modelValueSelected() {
        if (this.optionModelValue == null) {
            return false;
        }
        return this.optionModelValue.getSelection();
    }
}

