/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import tlc2.model.Formula;

public class FormHelper {
    public static final int FORM_BODY_MARGIN_TOP = 12;
    public static final int FORM_BODY_MARGIN_BOTTOM = 12;
    public static final int FORM_BODY_MARGIN_LEFT = 6;
    public static final int FORM_BODY_MARGIN_RIGHT = 6;
    public static final int FORM_BODY_HORIZONTAL_SPACING = 20;
    public static final int FORM_BODY_VERTICAL_SPACING = 17;
    public static final String SECTION_IS_NOT_SPACE_GRABBING = "_no_space_grab";

    public static TableWrapLayout createFormTableWrapLayout(boolean makeColumnsEqualWidth, int numColumns) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 12;
        layout.bottomMargin = 12;
        layout.leftMargin = 6;
        layout.rightMargin = 6;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static GridLayout createFormGridLayout(boolean makeColumnsEqualWidth, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.marginTop = 12;
        layout.marginBottom = 12;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static Section createSectionComposite(Composite parent, String title, String description, FormToolkit toolkit, int sectionFlags, IExpansionListener expansionListener) {
        Section section = toolkit.createSection(parent, sectionFlags);
        section.setData(SECTION_IS_NOT_SPACE_GRABBING, new Object());
        section.setText(title);
        section.setDescription(description);
        if (expansionListener != null) {
            section.addExpansionListener(expansionListener);
        }
        Composite sectionClient = toolkit.createComposite((Composite)section);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        sectionClient.setLayout((Layout)layout);
        section.setClient((Control)sectionClient);
        toolkit.paintBordersFor(sectionClient);
        return section;
    }

    public static Section createSpaceGrabbingSectionComposite(Composite parent, String title, String description, FormToolkit toolkit, int sectionFlags, IExpansionListener expansionListener) {
        final Section section = toolkit.createSection(parent, sectionFlags);
        section.setText(title);
        section.setDescription(description);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                GridData gd = (GridData)section.getLayoutData();
                gd.grabExcessVerticalSpace = e.getState();
                section.setLayoutData((Object)gd);
                if (e.getState()) {
                    ((Composite)section.getClient()).layout(true, true);
                }
            }
        });
        if (expansionListener != null) {
            section.addExpansionListener(expansionListener);
        }
        Composite sectionClient = toolkit.createComposite((Composite)section);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        sectionClient.setLayout((Layout)layout);
        section.setClient((Control)sectionClient);
        toolkit.paintBordersFor(sectionClient);
        return section;
    }

    public static Section createSectionComposite(Composite parent, String title, String description, FormToolkit toolkit) {
        return FormHelper.createSectionComposite(parent, title, description, toolkit, 384, null);
    }

    public static SourceViewer createFormsSourceViewer(FormToolkit toolkit, Composite parent, int flags) {
        return FormHelper.createFormsSourceViewer(toolkit, parent, flags, new SourceViewerConfiguration());
    }

    public static SourceViewer createFormsSourceViewer(FormToolkit toolkit, Composite parent, int flags, SourceViewerConfiguration config) {
        SourceViewer sourceViewer = FormHelper.createSourceViewer(parent, flags, config);
        sourceViewer.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        sourceViewer.getTextWidget().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        toolkit.adapt((Control)sourceViewer.getTextWidget(), true, true);
        return sourceViewer;
    }

    public static SourceViewer createFormsOutputViewer(FormToolkit toolkit, Composite parent, int flags) {
        SourceViewer sourceViewer = FormHelper.createOutputViewer(parent, flags);
        sourceViewer.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        sourceViewer.getTextWidget().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        toolkit.adapt((Control)sourceViewer.getTextWidget(), true, true);
        return sourceViewer;
    }

    public static SourceViewer createOutputViewer(Composite parent, int flags) {
        SourceViewer sourceViewer = new SourceViewer(parent, null, null, false, flags);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration();
        sourceViewer.configure(configuration);
        sourceViewer.setTabsToSpacesConverter((IAutoEditStrategy)FormHelper.getTabToSpacesConverter());
        StyledText control = sourceViewer.getTextWidget();
        control.setFont(TLCUIActivator.getDefault().getOutputFont());
        control.setEditable(false);
        return sourceViewer;
    }

    public static SourceViewer createSourceViewer(Composite parent, int flags) {
        return FormHelper.createSourceViewer(parent, flags, new SourceViewerConfiguration());
    }

    public static SourceViewer createSourceViewer(Composite parent, int flags, SourceViewerConfiguration config) {
        SourceViewer sourceViewer = new SourceViewer(parent, null, null, false, flags);
        sourceViewer.configure(config);
        sourceViewer.setTabsToSpacesConverter((IAutoEditStrategy)FormHelper.getTabToSpacesConverter());
        StyledText control = sourceViewer.getTextWidget();
        control.setWordWrap(true);
        control.setFont(TLCUIActivator.getDefault().getCourierFont());
        control.setEditable(true);
        return sourceViewer;
    }

    public static List<String> getSerializedInput(TableViewer tableViewer) {
        if (tableViewer instanceof CheckboxTableViewer) {
            ArrayList<String> result = new ArrayList<String>();
            TableItem[] tableItems = tableViewer.getTable().getItems();
            int itemCount = tableItems.length;
            int i = 0;
            while (i < itemCount) {
                TableItem item = tableItems[i];
                String serialized = (item.getChecked() ? "1" : "0") + item.getText();
                result.add(serialized);
                ++i;
            }
            return result;
        }
        List assignments = (List)tableViewer.getInput();
        if (assignments == null) {
            return null;
        }
        return ModelHelper.serializeAssignmentList((List)assignments);
    }

    public static void setSerializedInput(TableViewer table, List<String> serializedInput) {
        Vector<Formula> input = (Vector<Formula>)table.getInput();
        if (input == null) {
            input = new Vector<Formula>();
        }
        if (table instanceof CheckboxTableViewer) {
            Iterator<String> serializedIterator = serializedInput.iterator();
            Vector<Formula> checked = new Vector<Formula>();
            CheckboxTableViewer checkTable = (CheckboxTableViewer)table;
            while (serializedIterator.hasNext()) {
                String entry = serializedIterator.next();
                Formula formula = new Formula(entry.substring(1));
                input.add(formula);
                if (!"1".equals(entry.substring(0, 1))) continue;
                checked.add(formula);
            }
            checkTable.setInput(input);
            checkTable.setCheckedElements(checked.toArray());
        } else {
            List deserializeAssignmentList = ModelHelper.deserializeAssignmentList(serializedInput);
            table.setInput((Object)deserializeAssignmentList);
        }
    }

    public static TabsToSpacesConverter getTabToSpacesConverter() {
        TabsToSpacesConverter converter = new TabsToSpacesConverter();
        converter.setNumberOfSpacesPerTab(4);
        return converter;
    }

    public static String trimTrailingSpaces(String string) {
        if (string == null) {
            return null;
        }
        int i = string.length() - 1;
        while (i >= 0) {
            if (string.charAt(i) != '\t' && string.charAt(i) != ' ' && string.charAt(i) != '\n' && string.charAt(i) != '\r') {
                string = string.substring(0, i + 1);
                return string;
            }
            --i;
        }
        return string;
    }

    public static Hyperlink createHyperlinkLeft(String title, Composite parent, FormToolkit toolkit) {
        Label createLabel = toolkit.createLabel(parent, title);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        createLabel.setLayoutData((Object)gd);
        Hyperlink hyperlink = toolkit.createHyperlink(parent, "", 131072);
        gd = new GridData(4, 128, true, false);
        gd.horizontalIndent = 30;
        gd.minimumWidth = 300;
        hyperlink.setLayoutData((Object)gd);
        return hyperlink;
    }

    public static Text createTextLeft(String title, Composite parent, FormToolkit toolkit) {
        Label createLabel = toolkit.createLabel(parent, title);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        createLabel.setLayoutData((Object)gd);
        Text text = toolkit.createText(parent, "");
        gd = new GridData(4, 128, true, false);
        gd.horizontalIndent = 30;
        gd.minimumWidth = 400;
        text.setLayoutData((Object)gd);
        return text;
    }

    public static boolean isIdentifier(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        return string.matches("[A-Za-z0-9_]*[A-Za-z]{1}[A-Za-z0-9_]*");
    }

    public static void setHelp(Control control, String localContext) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.lamport.tla.toolbox.tool.tlc.ui." + localContext);
    }
}

