/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.editor.basic.TLAFastPartitioner;
import org.lamport.tla.toolbox.editor.basic.TLAPartitionScanner;
import org.lamport.tla.toolbox.editor.basic.TLASourceViewerConfiguration;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.data.ITLCModelLaunchDataPresenter;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.BasicFormPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.MainModelPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.util.DirtyMarkingListener;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.util.UIHelper;

public class EvaluateConstantExpressionPage
extends BasicFormPage
implements ITLCModelLaunchDataPresenter {
    public static final String ID = "evaluateConstantExpressionPage";
    private SourceViewer m_expressionInput;
    private SourceViewer m_expressionOutput;
    private ValidateableSectionPart m_validateableCalculatorSection;
    private Button m_toggleButton;
    private final Lock disposeLock = new ReentrantLock(true);

    public static String getTabTitle() {
        return "Constant Expressions";
    }

    static BodyContentAssets createBodyContent(Composite body, FormToolkit toolkit, int sectionFlags, int textFieldFlags, IExpansionListener expansionListener, final ModelEditor modelEditor) {
        Section section = FormHelper.createSpaceGrabbingSectionComposite(body, "Evaluate Constant Expression", "", toolkit, sectionFlags & 0xFFFFFF7F, expansionListener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        Composite resultArea = (Composite)section.getClient();
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        resultArea.setLayout((Layout)gl);
        Composite expressionComposite = toolkit.createComposite(resultArea);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        gd.minimumWidth = 360;
        expressionComposite.setLayoutData((Object)gd);
        gl = new GridLayout(1, false);
        expressionComposite.setLayout((Layout)gl);
        Composite labelToggleLine = toolkit.createComposite(expressionComposite);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        gd.minimumWidth = 360;
        labelToggleLine.setLayoutData((Object)gd);
        gl = new GridLayout(2, false);
        labelToggleLine.setLayout((Layout)gl);
        Label l = toolkit.createLabel(labelToggleLine, "Expression: ");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.heightHint = l.computeSize((int)-1, (int)-1).y;
        l.setLayoutData((Object)gd);
        final Button b = new Button(labelToggleLine, 32);
        b.setText("No Behavior Spec");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.heightHint = b.computeSize((int)-1, (int)-1).y;
        gd.grabExcessHorizontalSpace = true;
        b.setLayoutData((Object)gd);
        b.setSelection(modelEditor.modelIsConfiguredWithNoBehaviorSpec());
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainModelPage mmp = (MainModelPage)modelEditor.findPage("MainModelPage");
                mmp.setNoBehaviorSpec(b.getSelection());
            }
        });
        final SourceViewer input = FormHelper.createFormsSourceViewer(toolkit, expressionComposite, textFieldFlags, (SourceViewerConfiguration)new TLASourceViewerConfiguration());
        input.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (this.isUndoKeyPress(e)) {
                    input.doOperation(1);
                } else if (this.isRedoKeyPress(e)) {
                    input.doOperation(2);
                }
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.minimumWidth = 360;
        gd.minimumHeight = 80;
        input.getTextWidget().setLayoutData((Object)gd);
        l = toolkit.createLabel(expressionComposite, "Value: ");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.heightHint = l.computeSize((int)-1, (int)-1).y;
        l.setLayoutData((Object)gd);
        SourceViewer output = FormHelper.createFormsOutputViewer(toolkit, expressionComposite, textFieldFlags);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.minimumWidth = 360;
        gd.minimumHeight = 80;
        output.getTextWidget().setLayoutData((Object)gd);
        input.getTextWidget().setFont(JFaceResources.getTextFont());
        output.getTextWidget().setFont(JFaceResources.getTextFont());
        toolkit.paintBordersFor(expressionComposite);
        return new BodyContentAssets(section, input, output, b);
    }

    public EvaluateConstantExpressionPage(FormEditor editor) {
        super(editor, ID, EvaluateConstantExpressionPage.getTabTitle(), "icons/full/ece_page_[XXXXX].png");
        this.helpId = ID;
    }

    @Override
    protected void createBodyContent(IManagedForm managedForm) {
        int sectionFlags = 324;
        int textFieldFlags = 66122;
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        body.setLayout((Layout)gl);
        BodyContentAssets bca = EvaluateConstantExpressionPage.createBodyContent(body, toolkit, 324, 66122, this.getExpansionListener(), (ModelEditor)this.getEditor());
        this.m_expressionInput = bca.getExpressionInput();
        this.m_expressionOutput = bca.getExpressionOutput();
        this.m_toggleButton = bca.m_toggleButton;
        this.m_validateableCalculatorSection = new ValidateableSectionPart(bca.getSection(), this, "__expression");
        managedForm.addPart((IFormPart)this.m_validateableCalculatorSection);
        this.m_expressionInput.getTextWidget().addModifyListener((ModifyListener)new DirtyMarkingListener((AbstractFormPart)this.m_validateableCalculatorSection, false));
        this.getDataBindingManager().bindSection(this.m_validateableCalculatorSection, "__expression", this.getId());
        this.getDataBindingManager().bindAttribute("modelExpressionEval", this.m_expressionInput, this.m_validateableCalculatorSection);
    }

    public void setNoBehaviorSpecToggleState(boolean selected) {
        this.m_toggleButton.setSelection(selected);
    }

    public State getECEContent() {
        if (this.m_expressionInput != null) {
            return new State(this.m_expressionInput.getDocument(), this.m_expressionOutput.getTextWidget().getText(), this.m_toggleButton.getSelection());
        }
        return null;
    }

    public void setECEContent(State state) {
        if (this.m_expressionInput == null) {
            TLCUIActivator.getDefault().logError("Can't set ECE content on null objects.");
        } else {
            this.m_expressionInput.setDocument(state.getInputDocument());
            this.m_expressionOutput.getTextWidget().setText(state.getOutputText());
            this.m_toggleButton.setSelection(state.getToggleState());
        }
    }

    @Override
    public void loadData() throws CoreException {
        TLCOutputSourceRegistry modelCheckSourceRegistry = TLCOutputSourceRegistry.getModelCheckSourceRegistry();
        TLCModelLaunchDataProvider provider = modelCheckSourceRegistry.getProvider(this.getModel());
        if (provider != null) {
            provider.addDataPresenter(this);
        } else {
            this.m_expressionOutput.getTextWidget().setText("");
        }
        Document document = new Document(this.getModel().getEvalExpression());
        TLAFastPartitioner partitioner = new TLAFastPartitioner(TLAEditorActivator.getDefault().getTLAPartitionScanner(), TLAPartitionScanner.TLA_PARTITION_TYPES);
        document.setDocumentPartitioner("__tla_partitioning", (IDocumentPartitioner)partitioner);
        partitioner.connect((IDocument)document);
        this.m_expressionInput.setDocument((IDocument)document);
    }

    @Override
    public void commit(boolean onSave) {
        String expression = this.m_expressionInput.getDocument().get();
        this.getModel().unsavedSetEvalExpression(expression);
        super.commit(onSave);
    }

    @Override
    public void dispose() {
        this.disposeLock.lock();
        try {
            TLCModelLaunchDataProvider provider;
            IManagedForm managedForm = this.getManagedForm();
            managedForm.removePart((IFormPart)this.m_validateableCalculatorSection);
            this.getDataBindingManager().unbindSectionAndAttribute("__expression");
            this.getDataBindingManager().unbindSectionFromPage("__expression", this.getId());
            Model model = this.getModel();
            TLCOutputSourceRegistry modelCheckSourceRegistry = TLCOutputSourceRegistry.getModelCheckSourceRegistry();
            if (modelCheckSourceRegistry.hasProvider(model) && (provider = modelCheckSourceRegistry.getProvider(model)) != null) {
                provider.removeDataPresenter(this);
            }
            super.dispose();
        }
        finally {
            this.disposeLock.unlock();
        }
    }

    public void setFocus() {
        if (this.m_expressionInput != null && !this.m_expressionInput.getTextWidget().isDisposed() && !this.m_expressionInput.getTextWidget().isFocusControl()) {
            StyledText st = this.m_expressionInput.getTextWidget();
            int caretOffset = st.getText().length();
            st.setFocus();
            Runnable ohSWT = () -> {
                try {
                    Thread.sleep(75L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!st.isDisposed()) {
                    st.getDisplay().asyncExec(() -> {
                        if (!st.isDisposed()) {
                            st.setCaretOffset(caretOffset);
                        }
                    });
                }
            };
            new Thread(ohSWT).start();
        }
    }

    @Override
    public void modelChanged(TLCModelLaunchDataProvider dataProvider, int fieldId) {
        UIHelper.runUIAsync(() -> {
            this.disposeLock.lock();
            try {
                if (this.getPartControl().isDisposed()) {
                    return;
                }
                if (fieldId == 4096) {
                    this.m_expressionOutput.getTextWidget().setText(dataProvider.getCalcOutput());
                }
            }
            finally {
                this.disposeLock.unlock();
            }
        });
    }

    static class BodyContentAssets {
        private final Section m_section;
        private final SourceViewer m_expressionInput;
        private final SourceViewer m_expressionOutput;
        private final Button m_toggleButton;

        BodyContentAssets(Section s, SourceViewer input, SourceViewer output, Button toggle) {
            this.m_section = s;
            this.m_expressionInput = input;
            this.m_expressionOutput = output;
            this.m_toggleButton = toggle;
        }

        Section getSection() {
            return this.m_section;
        }

        SourceViewer getExpressionInput() {
            return this.m_expressionInput;
        }

        SourceViewer getExpressionOutput() {
            return this.m_expressionOutput;
        }

        Button getToggleButton() {
            return this.m_toggleButton;
        }
    }

    public static class State {
        private final IDocument m_inputDocument;
        private final String m_outputText;
        private final boolean m_toggleState;

        State(IDocument document, String text, boolean toggleState) {
            this.m_inputDocument = document;
            this.m_outputText = text;
            this.m_toggleState = toggleState;
        }

        public IDocument getInputDocument() {
            return this.m_inputDocument;
        }

        public String getOutputText() {
            return this.m_outputText;
        }

        public boolean getToggleState() {
            return this.m_toggleState;
        }
    }
}

