/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor;

import com.abstratt.graphviz.GraphViz;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.model.AbstractModelStateChangeListener;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCModelFactory;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageInformation;
import org.lamport.tla.toolbox.tool.tlc.output.data.ITLCModelLaunchDataPresenter;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.DataBindingManager;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.TLACoverageEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.BasicFormPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.ErrorMessage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.MainModelPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.advanced.AdvancedModelPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.advanced.AdvancedTLCOptionsPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.EvaluateConstantExpressionPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.ResultPage;
import org.lamport.tla.toolbox.tool.tlc.ui.util.ModelEditorPartListener;
import org.lamport.tla.toolbox.tool.tlc.ui.util.SemanticHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.view.TLCErrorView;
import org.lamport.tla.toolbox.tool.tlc.util.ChangedSpecModulesGatheringDeltaVisitor;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import org.lamport.tla.toolbox.ui.view.PDFBrowser;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.semantic.ModuleNode;

public class ModelEditor
extends FormEditor {
    public static final String ID = "org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor";
    public static final String ZERO_COVERAGE_ACTION_MARKER = "org.lamport.tla.toolbox.tlc.zerocoverage";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("MMM dd,yyyy HH:mm:ss");
    private SemanticHelper helper;
    private ModelStateListener modelStateListener = new ModelStateListener();
    private final ValidateRunnable validateRunable = new ValidateRunnable();
    private DataBindingManager dataBindingManager = new DataBindingManager();
    private CTabFolder2Listener listener = new CloseModuleTabListener();
    private final Map<Integer, Closeable> indexCloseableMap;
    private BasicFormPage[] pagesToAdd;
    private Model model;
    private IResourceChangeListener workspaceResourceChangeListener = event -> {
        IResourceDelta delta = event.getDelta();
        ChangedSpecModulesGatheringDeltaVisitor visitor = new ChangedSpecModulesGatheringDeltaVisitor(this.model){

            public IResource getModel() {
                return ModelEditor.this.model.getFile();
            }
        };
        try {
            delta.accept((IResourceDeltaVisitor)visitor);
            if (!visitor.getModules().isEmpty() || visitor.isModelChanged() || visitor.getCheckpointChanged()) {
                this.helper.resetSpecNames();
                this.validateRunable.switchToErrorPage = visitor.isModelChanged();
                UIHelper.runUIAsync((Runnable)this.validateRunable);
                return;
            }
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Error visiting changed resource", e);
            return;
        }
    };
    private final IPageChangedListener pageChangedListener = event -> {
        INavigationHistory navigationHistory = this.getSite().getPage().getNavigationHistory();
        navigationHistory.markLocation((IEditorPart)event.getSelectedPage());
    };
    private final IPropertyChangeListener preferenceChangeListener = event -> {
        if ("showECEAsTab".equals(event.getProperty())) {
            boolean eceAsTab = (Boolean)event.getNewValue();
            Pair<Integer, FormPage> pair = this.getLastFormPage();
            String id = ((FormPage)pair.getRight()).getId();
            if (!"resultPage".equals(id) && !"evaluateConstantExpressionPage".equals(id)) {
                return;
            }
            if (eceAsTab) {
                if (!"evaluateConstantExpressionPage".equals(id)) {
                    try {
                        EvaluateConstantExpressionPage ecePage = new EvaluateConstantExpressionPage(this);
                        this.addPage((Integer)pair.getLeft() + 1, (IEditorPart)ecePage, this.getEditorInput());
                        ResultPage rp = (ResultPage)this.findPage("resultPage");
                        EvaluateConstantExpressionPage.State eceState = rp.getECEContent();
                        ecePage.setECEContent(eceState);
                        rp.pageShouldDisplayEvaluateConstantUI(false);
                    }
                    catch (Exception e) {
                        TLCUIActivator.getDefault().logError("Error attempting to open ECE page.", e);
                    }
                }
            } else if ("evaluateConstantExpressionPage".equals(id)) {
                try {
                    EvaluateConstantExpressionPage ecePage = (EvaluateConstantExpressionPage)pair.getRight();
                    EvaluateConstantExpressionPage.State eceState = ecePage.getECEContent();
                    ResultPage rp = (ResultPage)this.findPage("resultPage");
                    rp.pageShouldDisplayEvaluateConstantUI(true);
                    rp.setECEContent(eceState);
                    this.removePage((Integer)pair.getLeft());
                }
                catch (Exception e) {
                    TLCUIActivator.getDefault().logError("Error attempting to close ECE page.", e);
                }
            }
        }
    };

    public ModelEditor() {
        this.helper = new SemanticHelper();
        this.indexCloseableMap = new HashMap<Integer, Closeable>();
    }

    public ModelEditor(Model testingModel) {
        this();
        this.model = testingModel;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        FileEditorInput finput = this.getFileEditorInput();
        if (finput == null || !finput.exists()) {
            throw new PartInitException("Editor input does not exist: " + finput.getName());
        }
        this.model = TLCModelFactory.getBy((IFile)finput.getFile());
        int openTabsValue = 0;
        try {
            openTabsValue = this.model.getLaunchConfiguration().getAttribute("modelEditorOpenTabs", 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        boolean mustShowResultsPage = this.model.isSnapshot() || this.parsePotentialAssociatedTLCRunToDetermineWhetherResultsPageMustBeShown();
        IPreferenceStore ips = TLCUIActivator.getDefault().getPreferenceStore();
        if (openTabsValue == 0) {
            BasicFormPage[] basicFormPageArray;
            if (mustShowResultsPage) {
                BasicFormPage[] basicFormPageArray2 = new BasicFormPage[2];
                basicFormPageArray2[0] = new MainModelPage(this);
                basicFormPageArray = basicFormPageArray2;
                basicFormPageArray2[1] = new ResultPage(this);
            } else {
                BasicFormPage[] basicFormPageArray3 = new BasicFormPage[1];
                basicFormPageArray = basicFormPageArray3;
                basicFormPageArray3[0] = new MainModelPage(this);
            }
            this.pagesToAdd = basicFormPageArray;
        } else {
            ArrayList<BasicFormPage> editorPages = new ArrayList<BasicFormPage>();
            editorPages.add(new MainModelPage(this));
            if ((openTabsValue & 2) != 0) {
                editorPages.add(new AdvancedModelPage(this));
            }
            if ((openTabsValue & 4) != 0) {
                editorPages.add(new AdvancedTLCOptionsPage(this));
            }
            if (mustShowResultsPage || (openTabsValue & 8) != 0) {
                editorPages.add(new ResultPage(this));
                if (ips.getBoolean("showECEAsTab")) {
                    editorPages.add(new EvaluateConstantExpressionPage(this));
                }
                if (mustShowResultsPage) {
                    int openTabState = this.getModel().getOpenTabsValue();
                    this.updateOpenTabsState(openTabState | 8);
                }
            }
            this.pagesToAdd = editorPages.toArray(new BasicFormPage[editorPages.size()]);
        }
        ips.addPropertyChangeListener(this.preferenceChangeListener);
        if (this.model.isSnapshot()) {
            String date = SIMPLE_DATE_FORMAT.format(this.model.getSnapshotTimeStamp());
            this.setPartName(this.model.getSnapshotFor().getName() + " (" + date + ")");
        } else {
            this.setPartName(this.model.getName());
        }
        this.setTitleToolTip(this.model.getFile().getLocation().toOSString());
        IPartService service = (IPartService)this.getSite().getService(IPartService.class);
        service.addPartListener((IPartListener2)ModelEditorPartListener.getDefault());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.workspaceResourceChangeListener, 16);
        this.helper.resetSpecNames();
        UIHelper.runUIAsync((Runnable)this.validateRunable);
        UIHelper.runUIAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                ModelEditor.this.addPageChangedListener(ModelEditor.this.pageChangedListener);
            }
        });
        this.model.add((AbstractModelStateChangeListener)this.modelStateListener);
    }

    private boolean parsePotentialAssociatedTLCRunToDetermineWhetherResultsPageMustBeShown() {
        TLCModelLaunchDataProvider ldp = TLCOutputSourceRegistry.getModelCheckSourceRegistry().getProvider(this.model);
        AtomicBoolean hasStartTime = new AtomicBoolean(false);
        AtomicBoolean hasError = new AtomicBoolean(false);
        AtomicBoolean hasZeroCoverage = new AtomicBoolean(false);
        ITLCModelLaunchDataPresenter consumer = (dataProvider, fieldId) -> {
            switch (fieldId) {
                case 4: {
                    hasStartTime.set(dataProvider.getStartTimestamp() > 0L);
                    break;
                }
                case 32: {
                    if (hasZeroCoverage.get()) break;
                    CoverageInformation coverageInfo = dataProvider.getCoverageInfo();
                    if (!dataProvider.isDone() || coverageInfo.isEmpty() || !dataProvider.hasZeroCoverage()) break;
                    hasZeroCoverage.set(true);
                    break;
                }
                case 512: {
                    if (dataProvider.getErrors().size() <= 0) break;
                    hasError.set(true);
                }
            }
        };
        ldp.addDataPresenter(consumer);
        ldp.waitForParsingFinish();
        ldp.removeDataPresenter(consumer);
        return hasStartTime.get() || hasError.get() || hasZeroCoverage.get();
    }

    public String getIdForEditorAtIndex(int index) {
        FormPage editor = (FormPage)this.getEditor(index);
        if (editor != null) {
            return editor.getId();
        }
        return null;
    }

    public void dispose() {
        this.removePageChangedListener(this.pageChangedListener);
        TLCUIActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceChangeListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceResourceChangeListener);
        this.model.remove((AbstractModelStateChangeListener)this.modelStateListener);
        super.dispose();
        this.model = null;
    }

    public boolean isDisposed() {
        return this.model == null;
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(monitor, true);
        this.model.save(monitor);
        this.model.removeMarkers("org.lamport.tla.toolbox.tlc.modelErrorSANY");
        boolean revalidate = TLCUIActivator.getDefault().getPreferenceStore().getBoolean("revalidateOnModify");
        if (revalidate) {
            this.launchModel("generate", false, monitor);
        }
        this.editorDirtyStateChanged();
    }

    public void doSaveWithoutValidating(IProgressMonitor monitor) {
        this.commitPages(monitor, true);
        this.model.save(monitor);
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
    }

    public <T> T getAdapter(Class<T> required) {
        if (TLCModelLaunchDataProvider.class.equals(required)) {
            TLCModelLaunchDataProvider provider = TLCOutputSourceRegistry.getModelCheckSourceRegistry().getProvider(this.getModel());
            if (provider != null) {
                return (T)provider;
            }
        } else if (IFile.class.equals(required)) {
            IFolder folder = this.model.getFolder();
            String name = this.model.getName().concat(".dot");
            return (T)folder.getFile(name);
        }
        return (T)super.getAdapter(required);
    }

    public void setFocus() {
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected synchronized void commitPages(IProgressMonitor monitor, boolean onSave) {
        int i = 0;
        while (i < this.getPageCount()) {
            BasicFormPage page;
            if (this.pages.get(i) instanceof BasicFormPage && (page = (BasicFormPage)this.pages.get(i)).isInitialized()) {
                page.commit(onSave);
            }
            ++i;
        }
    }

    protected void addPages() {
        try {
            CTabFolder tabFolder = (CTabFolder)this.getContainer();
            tabFolder.setTabPosition(128);
            tabFolder.addCTabFolder2Listener(this.listener);
            int i = 0;
            while (i < this.pagesToAdd.length) {
                this.addPage((IFormPage)this.pagesToAdd[i]);
                if (this.pagesToAdd[i].getPartControl() == null) {
                    this.pagesToAdd[i].createPartControl((Composite)tabFolder);
                    this.setControl(i, this.pagesToAdd[i].getPartControl());
                    this.pagesToAdd[i].getPartControl().setMenu(tabFolder.getMenu());
                }
                CTabItem item = tabFolder.getItem(i);
                item.setData((Object)this.pagesToAdd[i]);
                if (this.pagesToAdd[i] instanceof Closeable) {
                    item.setShowClose(true);
                    this.indexCloseableMap.put(new Integer(i), (Closeable)((Object)this.pagesToAdd[i]));
                }
                ++i;
            }
            UIHelper.runUIAsync((Runnable)this.validateRunable);
            ModuleNode rootModule = SemanticHelper.getRootModuleNode();
            if (rootModule != null && rootModule.getVariableDecls().length == 0 && rootModule.getConstantDecls().length == 0) {
                this.addOrShowResultsPage();
            }
            if (this.model.hasStateGraphDump()) {
                this.addOrUpdateStateGraphEditor(this.model.getStateGraphDump());
            }
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Error initializing editor", e);
        }
    }

    protected void configurePage(int index, IFormPage page) throws PartInitException {
        this.setPageImage(index, page.getTitleImage());
        super.configurePage(index, page);
    }

    public void addOrUpdateStateGraphEditor(final IFile stateGraphDotDump) throws CoreException {
        if (Boolean.getBoolean(ModelEditor.class.getName() + ".dotWebView")) {
            try {
                Path path = stateGraphDotDump.getLocation().toFile().toPath();
                String dotString = new String(Files.readAllBytes(path), StandardCharsets.US_ASCII);
                String urlEncodedDotString = URLEncoder.encode(dotString, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
                String url = "https://edotor.net/?engine=dot#" + urlEncodedDotString;
                PDFBrowser browser = (PDFBrowser)UIHelper.openView((String)"org.lamport.tla.toolbox.PDFBrowser");
                browser.setInput(this.model.getName(), url);
                return;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", e.getMessage(), (Throwable)e));
            }
        }
        final boolean useEmbeddedViewer = Platform.getPreferencesService().getBoolean("org.lamport.tla.toolbox.tool.tla2tex", "embeddedViewer", false, null);
        boolean osOpensPDF = Platform.getPreferencesService().getBoolean("org.lamport.tla.toolbox.tool.tla2tex", "osHandlesPDF", false, null);
        final IEditorPart pdfEditor = osOpensPDF ? null : (useEmbeddedViewer ? UIHelper.findEditor((String)"de.vonloesch.pdf4eclipse.editors.PDFEditor") : UIHelper.findEditor((String)"org.lamport.tla.toolbox.PDFBrowserEditor"));
        final IFile pdfFile = this.model.getFolder().getFile(this.model.getName() + ".pdf");
        if (pdfFile.exists()) {
            this.saferAddPage(stateGraphDotDump, pdfEditor, pdfFile, useEmbeddedViewer);
            return;
        }
        WorkspaceJob j = new WorkspaceJob("Generating State Graph Visualization..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    byte[] load = GraphViz.load((InputStream)new FileInputStream(stateGraphDotDump.getLocation().toFile()), (String)"pdf", (int)0, (int)0);
                    pdfFile.create((InputStream)new ByteArrayInputStream(load), 0, null);
                    UIHelper.runUISync((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ModelEditor.this.saferAddPage(stateGraphDotDump, pdfEditor, pdfFile, useEmbeddedViewer);
                        }
                    });
                }
                catch (CoreException e) {
                    return ModelEditor.shortenStatusMessage(e.getStatus());
                }
                catch (FileNotFoundException notExpectedTohappen) {
                    return new Status(4, "org.lamport.tla.toolbox.tool.tlc", notExpectedTohappen.getMessage(), (Throwable)notExpectedTohappen);
                }
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.setPriority(30);
        j.schedule();
    }

    private void saferAddPage(IFile stateGraphDotDump, IEditorPart pdfEditor, IFile file, boolean usesEmbeddedViewer) {
        if (pdfEditor == null) {
            String openCommand = "open " + file.getLocation().toOSString();
            try {
                Runtime.getRuntime().exec(openCommand);
            }
            catch (Exception e) {
                TLCUIActivator.getDefault().logError("Unable to execute 'open' command on PDF.", e);
            }
            return;
        }
        try {
            this.addPage(pdfEditor, (IEditorInput)new FileEditorInput(file));
        }
        catch (PartInitException e) {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialog.openError((Shell)(shell == null ? new Shell() : shell), (String)"Opening state graph visualization failed.", (String)("Opening state graph visualization failed: " + e.getMessage()));
        }
        catch (OutOfMemoryError oom) {
            System.gc();
            try {
                stateGraphDotDump.move(stateGraphDotDump.getFullPath().addFileExtension("large"), true, (IProgressMonitor)new NullProgressMonitor());
                file.move(file.getFullPath().addFileExtension("large"), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                TLCUIActivator.getDefault().logWarning(e.getMessage());
            }
            Shell shell = Display.getDefault().getActiveShell();
            Object label = "Opening state graph visualization ran out of memory. The state graph is likely too large. ";
            if (usesEmbeddedViewer) {
                label = (String)label + "\n\nTry switching from the built-in to a standalone PDF viewer by unchecking \"Use built-in PDF viewer\" on the Toolbox's \"PDF Viewer\" preference page.\n\n";
            }
            label = (String)label + String.format("To prevent future problems, the file %s has been renamed to %s.", file.getLocation().toOSString(), file.getLocation().addFileExtension("large").toOSString());
            label = (String)label + "\n\nPlease restart the Toolbox in case it now behaves strangely.";
            MessageDialog.openError((Shell)(shell == null ? new Shell() : shell), (String)"Opening state graph visualization ran out of memory.", (String)label);
        }
    }

    private static IStatus shortenStatusMessage(IStatus status) {
        if (status.isMultiStatus()) {
            Status[] convertedChildren = new Status[status.getChildren().length];
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                convertedChildren[i] = new Status(child.getSeverity(), child.getPlugin(), child.getCode(), ModelEditor.substring(child.getMessage()), child.getException());
                ++i;
            }
            return new MultiStatus(status.getPlugin(), status.getCode(), (IStatus[])convertedChildren, ModelEditor.substring(status.getMessage()), status.getException());
        }
        return new Status(status.getSeverity(), status.getPlugin(), status.getCode(), ModelEditor.substring(status.getMessage()), status.getException());
    }

    private static String substring(String in) {
        if (in.length() > 1024) {
            return in.substring(0, 1024) + "... (" + (in.length() - 1024) + " chars omitted)";
        }
        return in;
    }

    private Pair<Integer, FormPage> getLastFormPage() {
        int index = this.getPageCount() - 1;
        while (index >= 0) {
            IEditorPart iep = this.getEditor(index);
            if (iep instanceof FormPage) {
                return Pair.of((Object)new Integer(index), (Object)((FormPage)iep));
            }
            --index;
        }
        return null;
    }

    public boolean modelIsConfiguredWithNoBehaviorSpec() {
        try {
            return this.model.getAttribute("modelBehaviorSpecType", Integer.MIN_VALUE) == 0;
        }
        catch (CoreException ce) {
            TLCUIActivator.getDefault().logError("Encountered error attempting to determine previous run configuration.", ce);
            return false;
        }
    }

    public void launchModel(String mode, boolean userPased) {
        this.launchModel(mode, userPased, (IProgressMonitor)new NullProgressMonitor());
    }

    public void launchModel(final String mode, final boolean userInvoked, IProgressMonitor monitor) {
        boolean launchSnapshot;
        if (userInvoked && this.model.isSnapshot() && !(launchSnapshot = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Model is a snapshot", (String)"The model which is about to launch is a snapshot of another model. Beware that no snapshots of snapshots are taken. Click the \"OK\" button to launch the snapshot anyway."))) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            workspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IEditorReference[] editors;
                    Spec spec;
                    if (Activator.isSpecManagerInstantiated()) {
                        spec = Activator.getSpecManager().getSpecLoaded();
                        if (spec == null || spec.getStatus() != 0) {
                            if (mode == "modelcheck") {
                                MessageDialog.openError((Shell)ModelEditor.this.getSite().getShell(), (String)"Model checking not allowed", (String)"The spec status is not \"parsed\". The status must be \"parsed\" before model checking is allowed.");
                            } else if (mode == "generate") {
                                if (userInvoked) {
                                    MessageDialog.openError((Shell)ModelEditor.this.getSite().getShell(), (String)"Revalidation not allowed", (String)"The spec status is not \"parsed\". The status must be \"parsed\" before model revalidation is allowed.");
                                } else {
                                    MessageDialog.openError((Shell)ModelEditor.this.getSite().getShell(), (String)"Revalidation not allowed", (String)"The model can be saved, but since the spec status is not \"parsed\" model revalidation is not allowed.");
                                }
                            }
                            return;
                        }
                        String rootModuleName = spec.getRootModule().getName();
                        if (ModelHelper.containsModelCheckingModuleConflict((String)rootModuleName)) {
                            MessageDialog.openError((Shell)ModelEditor.this.getSite().getShell(), (String)"Illegal module name", (String)("Model validation and checking is not allowed on a spec containing a module named MC." + (userInvoked ? "" : " However, the model can still be saved.")));
                            return;
                        }
                        if (ModelHelper.containsTraceExplorerModuleConflict((String)rootModuleName)) {
                            MessageDialog.openError((Shell)ModelEditor.this.getSite().getShell(), (String)"Illegal module name", (String)("Model validation and checking is not allowed on a spec containing a module named TE." + (userInvoked ? "" : " However, the model can still be saved.")));
                            return;
                        }
                    } else {
                        Activator.getDefault().logDebug("The spec manager has not been instantiated. This is a bug.");
                        return;
                    }
                    spec.deleteMarker(ModelEditor.ZERO_COVERAGE_ACTION_MARKER);
                    IEditorReference[] iEditorReferenceArray = editors = ModelEditor.this.getSite().getPage().getEditorReferences();
                    int n = editors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference ref = iEditorReferenceArray[n2];
                        if ("org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer".equals(ref.getId()) && ref.isDirty()) {
                            String title = ref.getName();
                            boolean save = MessageDialog.openQuestion((Shell)ModelEditor.this.getSite().getShell(), (String)("Save " + title + " spec?"), (String)("The spec " + title + " has not been saved, should the spec be saved prior to launching?"));
                            if (save) {
                                ref.getEditor(true).doSave(monitor);
                            } else {
                                return;
                            }
                        }
                        ++n2;
                    }
                    UIHelper.runUISync((Runnable)ModelEditor.this.validateRunable);
                    if (ModelEditor.this.isDirty()) {
                        ModelEditor.this.doSave((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                    }
                    if (!ModelEditor.this.isComplete()) {
                        if (userInvoked) {
                            MessageDialog.openError((Shell)ModelEditor.this.getSite().getShell(), (String)"Model processing not allowed", (String)"The model contains errors, which should be corrected before further processing");
                            return;
                        }
                    } else {
                        TLCErrorView errorView;
                        int i = ModelEditor.this.getPageCount() - 1;
                        while (i >= 0) {
                            if (ModelEditor.this.pages.get(i) instanceof BasicFormPage) {
                                ((BasicFormPage)ModelEditor.this.pages.get(i)).modelCheckingWillBegin();
                            } else {
                                ModelEditor.this.removePage(i);
                            }
                            --i;
                        }
                        ModelEditor.this.model.launch(mode, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), true);
                        if (mode.equals("modelcheck") && (errorView = (TLCErrorView)UIHelper.findView((String)"toolbox.tool.tlc.view.TLCErrorView")) != null) {
                            errorView.clear();
                        }
                    }
                }
            }, (ISchedulingRule)workspace.getRoot(), 1, monitor);
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Error launching the configuration " + this.model.getName(), e);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Model processing failed", (String)e.getMessage());
        }
    }

    public void stop() {
        block3: {
            Job[] remoteJobs;
            block2: {
                if (!this.getModel().isRunning()) break block2;
                Job[] runningSpecJobs = Job.getJobManager().find((Object)this.getModel().getLaunchConfiguration());
                int i = 0;
                while (i < runningSpecJobs.length) {
                    runningSpecJobs[i].cancel();
                    ++i;
                }
                break block3;
            }
            if (!this.getModel().isRunningRemotely()) break block3;
            Job[] jobArray = remoteJobs = Job.getJobManager().find((Object)this.getModel());
            int n = remoteJobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job remoteJob = jobArray[n2];
                remoteJob.cancel();
                ++n2;
            }
        }
    }

    public Model getModel() {
        return this.model;
    }

    public boolean isComplete() {
        int i = 0;
        while (i < this.getPageCount()) {
            BasicFormPage page;
            if (this.pages.get(i) instanceof BasicFormPage && !(page = (BasicFormPage)this.pages.get(i)).isComplete()) {
                this.setActivePage(page.getId());
                return false;
            }
            ++i;
        }
        return true;
    }

    public void handleProblemMarkers(boolean switchToErrorPage) {
        int errorPageIndex = -1;
        int currentPageIndex = this.getActivePage();
        try {
            IMarker[] modelProblemMarkers = this.model.getMarkers();
            DataBindingManager dm = this.getDataBindingManager();
            int j = 0;
            while (j < this.getPageCount()) {
                if (this.pages.get(j) instanceof BasicFormPage) {
                    BasicFormPage page = (BasicFormPage)this.pages.get(j);
                    Assert.isNotNull((Object)page.getManagedForm(), (String)"Page not initialized, this is a bug.");
                    page.getManagedForm().getMessageManager().setAutoUpdate(false);
                    int i = 0;
                    while (i < modelProblemMarkers.length) {
                        IMessageManager mm;
                        String pageId;
                        String attributeName = modelProblemMarkers[i].getAttribute("attributeName", "");
                        int bubbleType = -1;
                        bubbleType = modelProblemMarkers[i].getType().equals("org.lamport.tla.toolbox.tlc.modelErrorSANY") ? 3 : (modelProblemMarkers[i].getType().equals("org.lamport.tla.toolbox.tlc.modelErrorTLC") ? 2 : 1);
                        if ("".equals(attributeName)) {
                            String message = modelProblemMarkers[i].getAttribute("message", "");
                            pageId = modelProblemMarkers[i].getAttribute("basicFormPageId", null);
                            if (pageId != null && bubbleType == 2 && !"".equals(message)) {
                                ResultPage rp = (ResultPage)this.findPage("resultPage");
                                if (rp != null) {
                                    rp.addGlobalTLCErrorMessage("ResultPageProblem", message);
                                }
                            } else if (bubbleType == 2) {
                                PageIterator iterator = new PageIterator();
                                while (iterator.hasNext()) {
                                    BasicFormPage bfp = iterator.next();
                                    if ("resultPage".equals(bfp.getId())) continue;
                                    bfp.addGlobalTLCErrorMessage("modelProblem_" + i);
                                }
                            } else {
                                mm = ((BasicFormPage)this.pages.get(0)).getManagedForm().getMessageManager();
                                mm.addMessage((Object)("modelProblem_" + i), message, null, bubbleType);
                            }
                        } else {
                            String sectionId = dm.getSectionForAttribute(attributeName);
                            Assert.isNotNull((Object)sectionId, (String)"Page is either not initialized or attribute not bound, this is a bug.");
                            pageId = dm.getSectionPage(sectionId);
                            mm = page.getManagedForm().getMessageManager();
                            String message = modelProblemMarkers[i].getAttribute("message", "");
                            Control widget = UIHelper.getWidget((Object)dm.getAttributeControl(attributeName));
                            if (widget != null) {
                                mm.addMessage((Object)("modelProblem_" + i), message, (Object)pageId, bubbleType, widget);
                            }
                            dm.expandSection(sectionId);
                            if (page.getId().equals(pageId) && errorPageIndex < j) {
                                errorPageIndex = j;
                            }
                        }
                        ++i;
                    }
                }
                ++j;
            }
            PageIterator iterator = new PageIterator();
            while (iterator.hasNext()) {
                IMessageManager mm = iterator.next().getManagedForm().getMessageManager();
                mm.setAutoUpdate(true);
            }
            if (switchToErrorPage && errorPageIndex != -1 && currentPageIndex != errorPageIndex) {
                this.setActivePage(errorPageIndex);
            }
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Error retrieving model error markers", e);
        }
    }

    public void setActivePage(int index) {
        if (this.pages != null && this.getCurrentPage() != index) {
            super.setActivePage(index);
        }
    }

    public SemanticHelper getHelper() {
        return this.helper;
    }

    public DataBindingManager getDataBindingManager() {
        return this.dataBindingManager;
    }

    public FileEditorInput getFileEditorInput() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            return (FileEditorInput)input;
        }
        throw new IllegalStateException("Something weird. The editor is designed for FileEditorInputOnly");
    }

    public ITextEditor getSavedModuleEditor(String moduleName) {
        int i = 0;
        while (i < this.getPageCount()) {
            IEditorPart nestedEditor = this.getEditor(i);
            if (nestedEditor != null && nestedEditor instanceof ITextEditor && ((FileEditorInput)nestedEditor.getEditorInput()).getName().equals(ResourceHelper.getModuleFileName((String)moduleName))) {
                return (ITextEditor)nestedEditor;
            }
            ++i;
        }
        return null;
    }

    public void expandSections(String[] sections) {
        PageIterator iterator = new PageIterator();
        while (iterator.hasNext()) {
            iterator.next().expandSections(sections);
        }
    }

    public void expandSections(String pageId, List<String> sections) {
        BasicFormPage formPage = this.getFormPage(pageId);
        formPage.expandSections(sections.toArray(new String[sections.size()]));
    }

    public BasicFormPage getFormPage(String id) {
        PageIterator iterator = new PageIterator();
        while (iterator.hasNext()) {
            BasicFormPage basicFormPage = iterator.next();
            if (!basicFormPage.getId().equals(id)) continue;
            return basicFormPage;
        }
        return null;
    }

    public void addErrorMessage(Object key, String messageText, String pageId, int type, Control control) {
        if (control != null) {
            PageIterator iterator = new PageIterator();
            while (iterator.hasNext()) {
                iterator.next().getManagedForm().getMessageManager().addMessage(key, messageText, (Object)pageId, type, control);
            }
        }
    }

    public void addErrorMessage(ErrorMessage errorMessage) {
        this.addErrorMessage(errorMessage.getKey(), errorMessage.getMessage(), errorMessage.getModelEditorPageId(), 2, UIHelper.getWidget((Object)this.getDataBindingManager().getAttributeControl(errorMessage.getViewerId())));
        this.expandSections(errorMessage.getModelEditorPageId(), errorMessage.getSections());
    }

    public void removeErrorMessage(Object key, Control control) {
        if (control != null) {
            PageIterator iterator = new PageIterator();
            while (iterator.hasNext()) {
                iterator.next().getManagedForm().getMessageManager().removeMessage(key, control);
            }
        }
    }

    public void updateOpenTabsState(int newValue) {
        this.getModel().setOpenTabsValue(newValue);
        this.saveModel();
    }

    public void saveModel() {
        WorkspaceJob job = new WorkspaceJob("Saving updated model..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ModelEditor.this.getModel().save(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.schedule();
    }

    public void addOrShowAdvancedModelPage() {
        if (this.setActivePage("advancedModelPage") == null) {
            try {
                this.addPage(1, (IEditorPart)new AdvancedModelPage(this), this.getEditorInput());
                this.setActivePage("advancedModelPage");
                int openTabState = this.getModel().getOpenTabsValue();
                this.updateOpenTabsState(openTabState | 2);
            }
            catch (Exception e) {
                TLCActivator.getDefault().getLog().log((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Could not add advanced model options page", (Throwable)e));
            }
        }
    }

    public void addOrShowAdvancedTLCOptionsPage() {
        if (this.setActivePage("AdvancedTLCOptionsPage") == null) {
            try {
                String id;
                int pageIndex = 1;
                if (pageIndex < this.getPageCount() && "advancedModelPage".equals(id = this.getIdForEditorAtIndex(pageIndex))) {
                    ++pageIndex;
                }
                this.addPage(pageIndex, (IEditorPart)new AdvancedTLCOptionsPage(this), this.getEditorInput());
                this.setActivePage("AdvancedTLCOptionsPage");
                int openTabState = this.getModel().getOpenTabsValue();
                this.updateOpenTabsState(openTabState | 4);
            }
            catch (Exception e) {
                TLCActivator.getDefault().getLog().log((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Could not add advanced TLC options page", (Throwable)e));
            }
        }
    }

    public void addOrShowResultsPage() {
        if (this.setActivePage("resultPage") == null) {
            try {
                String id;
                int pageIndex = 1;
                if (pageIndex < this.getPageCount() && ("AdvancedTLCOptionsPage".equals(id = this.getIdForEditorAtIndex(pageIndex)) || "advancedModelPage".equals(id)) && ++pageIndex < this.getPageCount() && ("AdvancedTLCOptionsPage".equals(id = this.getIdForEditorAtIndex(pageIndex)) || "advancedModelPage".equals(id))) {
                    ++pageIndex;
                }
                this.addPage(pageIndex, (IEditorPart)new ResultPage(this), this.getEditorInput());
                IPreferenceStore ips = TLCUIActivator.getDefault().getPreferenceStore();
                if (ips.getBoolean("showECEAsTab")) {
                    this.addPage(pageIndex + 1, (IEditorPart)new EvaluateConstantExpressionPage(this), this.getEditorInput());
                }
                ResultPage rp = (ResultPage)this.setActivePage("resultPage");
                int openTabState = this.getModel().getOpenTabsValue();
                this.updateOpenTabsState(openTabState | 8);
                rp.loadData();
                MainModelPage page = (MainModelPage)this.findPage("MainModelPage");
                page.validatePage(true);
            }
            catch (Exception e) {
                TLCActivator.getDefault().getLog().log((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Could not add results page", (Throwable)e));
            }
        }
    }

    public void resultsPageIsClosing() {
        IPreferenceStore ips = TLCUIActivator.getDefault().getPreferenceStore();
        if (ips.getBoolean("showECEAsTab")) {
            this.removePage(this.getPageCount() - 1);
        }
        int openTabState = this.getModel().getOpenTabsValue();
        this.updateOpenTabsState(openTabState & 0xFFFFFFF7);
    }

    public void addPage(int index, IEditorPart editor, IEditorInput input) throws PartInitException {
        super.addPage(index, editor, input);
        if (editor instanceof TLACoverageEditor) {
            this.setPageText(index, editor.getTitle());
            this.setPageImage(index, editor.getTitleImage());
            ((CTabFolder)this.getContainer()).getItem(index).setShowClose(true);
        } else if (input instanceof FileEditorInput && ((FileEditorInput)input).getFile().getFileExtension().equals("tla")) {
            this.setPageText(index, input.getName());
            ((CTabFolder)this.getContainer()).getItem(index).setShowClose(true);
        } else if (input instanceof FileEditorInput && "pdf".equals(((FileEditorInput)input).getFile().getFileExtension())) {
            this.setPageText(index, "State Graph");
        } else if (editor instanceof Closeable) {
            CTabFolder tabFolder = (CTabFolder)this.getContainer();
            tabFolder.getItem(index).setShowClose(true);
            int tabCount = tabFolder.getItemCount();
            int i = tabCount - 2;
            while (i >= index) {
                Closeable c = this.indexCloseableMap.remove(new Integer(i));
                if (c != null) {
                    this.indexCloseableMap.put(new Integer(i + 1), c);
                }
                --i;
            }
            this.indexCloseableMap.put(new Integer(index), (Closeable)editor);
        }
    }

    private class CloseModuleTabListener
    extends CTabFolder2Adapter {
        private CloseModuleTabListener() {
        }

        public void close(CTabFolderEvent event) {
            Assert.isTrue((boolean)(event.item instanceof CTabItem), (String)"Something other than a CTabItem was closed in a CTabFolder.");
            CTabItem item = (CTabItem)event.item;
            CTabFolder tabFolder = item.getParent();
            int index = tabFolder.indexOf(item);
            event.doit = false;
            Closeable c = ModelEditor.this.indexCloseableMap.remove(new Integer(index));
            if (c != null) {
                int tabCount = tabFolder.getItemCount();
                int i = index;
                while (i <= tabCount) {
                    Closeable remaining = ModelEditor.this.indexCloseableMap.remove(new Integer(i));
                    if (remaining != null) {
                        ModelEditor.this.indexCloseableMap.put(new Integer(i - 1), remaining);
                    }
                    ++i;
                }
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ModelEditor.this.removePage(index);
        }
    }

    private class ModelStateListener
    extends AbstractModelStateChangeListener {
        private AbstractModelStateChangeListener.State lastState = AbstractModelStateChangeListener.State.NOT_RUNNING;

        private ModelStateListener() {
        }

        public boolean handleChange(AbstractModelStateChangeListener.ChangeEvent event) {
            if (event.getState().in(new AbstractModelStateChangeListener.State[]{AbstractModelStateChangeListener.State.NOT_RUNNING, AbstractModelStateChangeListener.State.RUNNING})) {
                AbstractModelStateChangeListener.State lastStateCopy = this.lastState;
                UIHelper.runUIAsync(() -> {
                    int i = 0;
                    while (i < ModelEditor.this.getPageCount()) {
                        Object object = ModelEditor.this.pages.get(i);
                        if (object instanceof BasicFormPage) {
                            BasicFormPage bfp = (BasicFormPage)object;
                            bfp.refresh();
                        }
                        ++i;
                    }
                    if (event.getState().in(new AbstractModelStateChangeListener.State[]{AbstractModelStateChangeListener.State.RUNNING})) {
                        IPreferenceStore ips = TLCUIActivator.getDefault().getPreferenceStore();
                        boolean eceInItsOwnTab = ips.getBoolean("showECEAsTab");
                        if (!eceInItsOwnTab || !ModelEditor.this.modelIsConfiguredWithNoBehaviorSpec()) {
                            ModelEditor.this.addOrShowResultsPage();
                        }
                    } else if (event.getState().in(new AbstractModelStateChangeListener.State[]{AbstractModelStateChangeListener.State.NOT_RUNNING})) {
                        IPreferenceStore ips;
                        boolean eceInItsOwnTab;
                        if (event.getModel().hasStateGraphDump()) {
                            try {
                                ModelEditor.this.addOrUpdateStateGraphEditor(event.getModel().getStateGraphDump());
                            }
                            catch (CoreException e) {
                                TLCUIActivator.getDefault().logError("Error initializing editor", e);
                            }
                        }
                        if (lastStateCopy.in(new AbstractModelStateChangeListener.State[]{AbstractModelStateChangeListener.State.RUNNING, AbstractModelStateChangeListener.State.REMOTE_RUNNING}) && (eceInItsOwnTab = (ips = TLCUIActivator.getDefault().getPreferenceStore()).getBoolean("showECEAsTab")) && ModelEditor.this.modelIsConfiguredWithNoBehaviorSpec()) {
                            ModelEditor.this.setActivePage("evaluateConstantExpressionPage");
                        }
                        UIHelper.runUISync((Runnable)ModelEditor.this.validateRunable);
                    }
                });
            }
            this.lastState = event.getState();
            return false;
        }
    }

    private class PageIterator
    implements Iterator<BasicFormPage> {
        private final List<Object> cachedPages;
        private int counter;
        private BasicFormPage nextPage;

        PageIterator() {
            this.cachedPages = new ArrayList<Object>(ModelEditor.this.pages);
            this.counter = 0;
            this.nextPage = this.findNextPage();
        }

        private BasicFormPage findNextPage() {
            BasicFormPage page = null;
            while (page == null && this.counter < this.cachedPages.size()) {
                Object o = this.cachedPages.get(this.counter);
                if (o instanceof BasicFormPage) {
                    page = (BasicFormPage)o;
                }
                ++this.counter;
            }
            return page;
        }

        @Override
        public boolean hasNext() {
            return this.nextPage != null;
        }

        @Override
        public BasicFormPage next() {
            BasicFormPage next = this.nextPage;
            this.nextPage = this.findNextPage();
            return next;
        }
    }

    private class ValidateRunnable
    implements Runnable {
        private boolean switchToErrorPage = false;

        private ValidateRunnable() {
        }

        @Override
        public void run() {
            if (ModelEditor.this.model != null && !ModelEditor.this.model.isRunning()) {
                BasicFormPage page;
                int i = 0;
                while (i < ModelEditor.this.getPageCount()) {
                    if (ModelEditor.this.pages.get(i) instanceof BasicFormPage) {
                        page = (BasicFormPage)ModelEditor.this.pages.get(i);
                        page.resetAllMessages(true);
                    }
                    ++i;
                }
                i = 0;
                while (i < ModelEditor.this.getPageCount()) {
                    if (ModelEditor.this.pages.get(i) instanceof BasicFormPage) {
                        page = (BasicFormPage)ModelEditor.this.pages.get(i);
                        page.validatePage(this.switchToErrorPage);
                    }
                    ++i;
                }
            }
        }
    }
}

