/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCState;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariable;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariableValue;
import tlc2.model.Formula;
import tlc2.model.TraceExpressionInformationHolder;

public class TLCError {
    private String message = "";
    private LinkedList<TLCState> states = new LinkedList();
    private TLCError cause;
    private int errorCode;
    private int numberOfStatesToShow = Integer.MAX_VALUE;
    private Order stateSortDirection;

    public TLCError() {
        this(Order.OneToN);
    }

    public TLCError(Order order) {
        this.stateSortDirection = order;
    }

    public void addState(TLCState state) {
        if (this.stateSortDirection == Order.NToOne) {
            this.states.addFirst(state);
        } else {
            this.states.add(state);
        }
    }

    public final TLCError getCause() {
        return this.cause;
    }

    public final void setCause(TLCError cause) {
        this.cause = cause;
    }

    public final String getMessage() {
        return this.message;
    }

    public void restrictTraceTo(int numberOfStatesToShow) {
        this.numberOfStatesToShow = numberOfStatesToShow;
    }

    public boolean isTraceRestricted() {
        return this.states.size() > this.numberOfStatesToShow;
    }

    public int getNumberOfRestrictedTraceStates() {
        if (this.isTraceRestricted()) {
            return this.states.size() - this.numberOfStatesToShow;
        }
        return 0;
    }

    public int getTraceRestriction() {
        return this.numberOfStatesToShow;
    }

    public void reduceTraceRestrictionBy(int numberOfStatesToShow) {
        this.numberOfStatesToShow += numberOfStatesToShow;
    }

    public int getTraceSize(int level) {
        if (this.states.isEmpty()) {
            return 0;
        }
        TLCState representative = this.states.getFirst();
        if (representative.isInitialState()) {
            representative = this.states.getLast();
        }
        int varCnt = representative.getVariableCount(level);
        if (this.numberOfStatesToShow < this.states.size()) {
            return this.numberOfStatesToShow * (varCnt + 1);
        }
        return this.states.size() * (varCnt + 1);
    }

    public int getTraceSize() {
        return this.getTraceSize(0);
    }

    public final List<TLCState> getStates() {
        return this.getStates(Length.RESTRICTED);
    }

    public final List<TLCState> getStates(Length l) {
        if (l == Length.ALL) {
            return this.states;
        }
        if (this.states.size() > this.numberOfStatesToShow) {
            if (this.states.getFirst().isInitialState()) {
                return this.states.subList(this.states.size() - this.numberOfStatesToShow, this.states.size());
            }
            return this.states.subList(0, this.numberOfStatesToShow);
        }
        return this.states;
    }

    public void removeStates(List<TLCState> statesToRemove) {
        this.states.removeAll(statesToRemove);
    }

    public boolean isTraceEmpty() {
        return this.numberOfStatesToShow == 0 || this.states.isEmpty();
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean hasTrace() {
        return this.states != null && !this.states.isEmpty();
    }

    public void reverseTrace() {
        this.stateSortDirection = this.stateSortDirection == Order.OneToN ? Order.NToOne : Order.OneToN;
        Collections.reverse(this.states);
    }

    public Order getOrder() {
        return this.stateSortDirection;
    }

    public boolean isOrder(Order o) {
        return this.stateSortDirection == o;
    }

    private void orderTrace(Order order) {
        if (this.stateSortDirection != order) {
            Collections.reverse(this.states);
            this.stateSortDirection = order;
        }
    }

    public String toSequenceOfRecords(boolean includeHeaders) {
        StringBuffer buf = new StringBuffer();
        buf.append("<<");
        buf.append("\n");
        int i = 0;
        while (i < this.states.size()) {
            TLCState tlcState = this.states.get(i);
            if (!tlcState.isBackToState() && !tlcState.isStuttering()) {
                if (tlcState.getVariablesAsList().isEmpty() && !includeHeaders) break;
                if (i > 0) {
                    buf.append(",").append("\n");
                }
                buf.append(tlcState.asRecord(includeHeaders));
            }
            ++i;
        }
        buf.append("\n");
        buf.append(">>");
        return buf.toString();
    }

    public void applyFrom(TLCError originalErrorWithTrace, Map<String, Formula> traceExplorerExpressions, Hashtable<String, TraceExpressionInformationHolder> traceExpressionDataTable, String modelName) {
        List<TLCState> originalTrace = originalErrorWithTrace.getStates(Length.ALL);
        Assert.isNotNull(originalTrace, (String)"Could not get original trace after running trace explorer. This is a bug.");
        Comparator<TLCVariable> varComparator = new Comparator<TLCVariable>(){

            @Override
            public int compare(TLCVariable var0, TLCVariable var1) {
                if (var0.isTraceExplorerVar() && var1.isTraceExplorerVar() || !var0.isTraceExplorerVar() && !var1.isTraceExplorerVar()) {
                    return var0.getName().compareTo(var1.getName());
                }
                if (var0.isTraceExplorerVar()) {
                    return -1;
                }
                return 1;
            }
        };
        Order requestedOrder = originalErrorWithTrace.stateSortDirection;
        this.orderTrace(Order.OneToN);
        originalErrorWithTrace.orderTrace(Order.OneToN);
        List<TLCState> newTrace = this.getStates();
        Iterator<TLCState> newTraceIt = newTrace.iterator();
        Iterator<TLCState> originalTraceIt = originalTrace.iterator();
        TLCState currentStateNewTrace = newTraceIt.next();
        TLCState nextStateNewTrace = null;
        TLCState currentStateOriginalTrace = originalTraceIt.next();
        while (newTraceIt.hasNext() && originalTraceIt.hasNext()) {
            currentStateNewTrace.setLabel(currentStateOriginalTrace.getLabel());
            currentStateNewTrace.setLocation(currentStateOriginalTrace.getModuleLocation());
            nextStateNewTrace = newTraceIt.next();
            TLCVariable[] currentStateNewTraceVariables = currentStateNewTrace.getVariables();
            TLCVariable[] nextStateNewTraceVariables = nextStateNewTrace.getVariables();
            this.applyFrom(traceExplorerExpressions, traceExpressionDataTable, nextStateNewTrace, currentStateNewTraceVariables, nextStateNewTraceVariables);
            Arrays.sort(currentStateNewTraceVariables, varComparator);
            currentStateNewTrace = nextStateNewTrace;
            currentStateOriginalTrace = originalTraceIt.next();
        }
        if ((currentStateOriginalTrace.isBackToState() || currentStateOriginalTrace.isStuttering()) && newTrace.size() >= originalTrace.size()) {
            newTrace.subList(originalTrace.size() - 1, newTrace.size()).clear();
        }
        this.restrictTraceTo(originalErrorWithTrace.getTraceRestriction());
        Assert.isTrue((newTrace.size() <= originalTrace.size() ? 1 : 0) != 0, (String)"States from trace explorer trace not removed properly.");
        TLCState finalStateOriginalTrace = originalTrace.get(originalTrace.size() - 1);
        if (newTrace.size() < originalTrace.size() - 1 || !finalStateOriginalTrace.isStuttering() && !finalStateOriginalTrace.isBackToState()) {
            TLCState finalStateNewTrace = newTrace.get(newTrace.size() - 1);
            TLCState samePositionOriginalTrace = originalTrace.get(newTrace.size() - 1);
            finalStateNewTrace.setLabel(samePositionOriginalTrace.getLabel());
            finalStateNewTrace.setLocation(samePositionOriginalTrace.getModuleLocation());
            TLCVariable[] finalStateNewTraceVariables = finalStateNewTrace.getVariables();
            int i = 0;
            while (i < finalStateNewTraceVariables.length) {
                TraceExpressionInformationHolder traceExpressionData = traceExpressionDataTable.get(finalStateNewTraceVariables[i].getName().trim());
                if (traceExpressionData != null) {
                    if (traceExpressionData.getLevel() == 2) {
                        finalStateNewTraceVariables[i].setValue(TLCVariableValue.parseValue("\"--\""));
                    }
                    finalStateNewTraceVariables[i].setName(traceExpressionData.getExpression());
                    finalStateNewTraceVariables[i].setTraceExplorerVar(true);
                }
                ++i;
            }
            Arrays.sort(finalStateNewTraceVariables, varComparator);
        } else if (finalStateOriginalTrace.isBackToState()) {
            this.addState(TLCState.BACK_TO_STATE(finalStateOriginalTrace.getStateNumber(), modelName));
        } else {
            this.addState(TLCState.STUTTERING_STATE(finalStateOriginalTrace.getStateNumber(), modelName));
        }
        this.orderTrace(requestedOrder);
    }

    private void applyFrom(Map<String, Formula> traceExplorerExpressions, Hashtable<String, TraceExpressionInformationHolder> traceExpressionDataTable, TLCState nextStateNewTrace, TLCVariable[] currentStateNewTraceVariables, TLCVariable[] nextStateNewTraceVariables) {
        int i = 0;
        while (i < currentStateNewTraceVariables.length) {
            TraceExpressionInformationHolder traceExpressionData;
            String variableName = currentStateNewTraceVariables[i].getName();
            if (!nextStateNewTrace.isBackToState() && !nextStateNewTrace.isStuttering()) {
                Assert.isTrue((boolean)variableName.equals(nextStateNewTraceVariables[i].getName()), (String)"Variables are not in the same order in each state. This is unexpected.");
            }
            if ((traceExpressionData = traceExpressionDataTable.get(variableName.trim())) != null) {
                if (!nextStateNewTrace.isBackToState() && !nextStateNewTrace.isStuttering() && traceExpressionData.getLevel() == 2) {
                    currentStateNewTraceVariables[i].setValue(nextStateNewTraceVariables[i].getValue());
                }
                currentStateNewTraceVariables[i].setName(traceExpressionData.getExpression());
                currentStateNewTraceVariables[i].setTraceExplorerVar(true);
            } else if (traceExplorerExpressions.containsKey(variableName.trim())) {
                currentStateNewTraceVariables[i].setTraceExplorerVar(true);
            }
            ++i;
        }
    }

    public TLCError clone() {
        TLCError clone = new TLCError(this.stateSortDirection);
        clone.message = this.message;
        clone.cause = this.cause;
        clone.errorCode = this.errorCode;
        clone.numberOfStatesToShow = this.numberOfStatesToShow;
        this.states.stream().forEach(state -> {
            boolean bl = tLCError.states.add(state.clone());
        });
        return clone;
    }

    public static enum Length {
        ALL,
        RESTRICTED;

    }

    public static enum Order {
        OneToN,
        NToOne;


        public static Order valueOf(String string) {
            return Enum.valueOf(Order.class, string);
        }
    }
}

