/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCRegion;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;

public class PartitionToolkit {
    public static ITypedRegion mergePartitions(ITypedRegion[] regions) {
        Assert.isNotNull((Object)regions);
        if (regions.length == 0) {
            return null;
        }
        String type = null;
        int offset = -1;
        int length = 0;
        int matcher = -1;
        int i = 0;
        while (i < regions.length) {
            if (type == null) {
                type = regions[i].getType();
            } else if (!type.equals(regions[i].getType())) {
                return null;
            }
            if (offset == -1) {
                offset = regions[i].getOffset();
            } else if (regions[i].getOffset() != matcher) {
                return null;
            }
            matcher = regions[i].getOffset() + regions[i].getLength();
            length += regions[i].getLength();
            ++i;
        }
        return new TypedRegion(offset, length, type);
    }

    public static void printPartition(ITypedRegion region, IDocument document) {
        if (region == null) {
            return;
        }
        try {
            StringBuffer messageBuffer = new StringBuffer();
            String location = "[" + region.getOffset() + ":" + region.getLength() + "]";
            if (region instanceof TLCRegion) {
                TLCRegion tlcRegion = (TLCRegion)region;
                messageBuffer.append("TLC:" + tlcRegion.getMessageCode() + " " + tlcRegion.getSeverity() + " " + location);
            } else {
                int offset = region.getOffset();
                int printLength = Math.min(region.getLength(), 255);
                String type = region.getType();
                Assert.isTrue((boolean)type.equals("__tlc_output"));
                String head = document.get(offset, printLength);
                messageBuffer.append("OUTPUT:" + location + ": >" + head + "< ...");
            }
            TLCUIActivator.getDefault().logDebug(messageBuffer.toString());
        }
        catch (BadLocationException e) {
            TLCUIActivator.getDefault().logError("Error printing partition", e);
        }
    }
}

