/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariable;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariableValue;
import org.lamport.tla.toolbox.tool.tlc.ui.util.IModuleLocatable;
import tla2sany.st.Location;

public class TLCState
implements IModuleLocatable {
    private static final String BACK_TO_STATE = " Back to state";
    private int number;
    private boolean stuttering = false;
    private boolean isBackToState = false;
    private String label;
    private String variablesAsString;
    private List<TLCVariable> variables = new ArrayList<TLCVariable>(0);
    private Location location;
    private final String modelName;
    private boolean wasDiffed = false;

    protected static TLCState STUTTERING_STATE(int number, String modelName) {
        TLCState state = new TLCState(number, modelName);
        state.stuttering = true;
        return state;
    }

    protected static TLCState BACK_TO_STATE(int number, String modelName) {
        TLCState state = new TLCState(number, modelName);
        state.isBackToState = true;
        return state;
    }

    public static TLCState parseState(String input, String modelName) {
        int index = input.indexOf(":");
        int index2 = input.indexOf("\n", index);
        if (index2 == -1) {
            index2 = input.length();
        }
        int number = Integer.parseInt(input.substring(0, index));
        String label = input.substring(index + 1, index2);
        if (label.indexOf(" Stuttering") == 0) {
            return TLCState.STUTTERING_STATE(number, modelName);
        }
        if (label.indexOf(BACK_TO_STATE) == 0) {
            TLCState state = TLCState.BACK_TO_STATE(number, modelName);
            if (label.indexOf(" Back to state: ") < 0) {
                state.setLocation(Location.nullLoc);
            } else {
                state.setLocation(Location.parseLocation((String)label.substring(" Back to state: ".length(), label.length())));
            }
            return state;
        }
        TLCState state = new TLCState(number, modelName);
        state.label = label;
        state.variablesAsString = input.substring(index2 + 1);
        state.variables = TLCVariable.parseVariables(state.variablesAsString);
        state.setLocation(Location.parseLocation((String)label));
        return state;
    }

    public TLCState(int number, String modelName) {
        this.number = number;
        this.modelName = modelName;
    }

    public boolean isStuttering() {
        return this.stuttering;
    }

    public boolean isBackToState() {
        return this.isBackToState;
    }

    public boolean isInitialState() {
        return this.number == 1;
    }

    public boolean isExpandable() {
        return !this.isBackToState() && !this.isStuttering();
    }

    public int getStateNumber() {
        return this.number;
    }

    public final String getName() {
        if (this.label != null && this.label.length() > 3) {
            return this.label.substring(2, this.label.length() - 1).replaceAll(this.getModuleLocation().toString(), "").trim();
        }
        return this.label;
    }

    public final String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public final List<TLCVariable> getVariablesAsList() {
        return this.variables;
    }

    public final TLCVariable[] getVariables() {
        return this.variables.toArray(new TLCVariable[this.variables.size()]);
    }

    public String toString() {
        return this.variablesAsString;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getModuleLocation() {
        return this.location;
    }

    public String getConjunctiveDescription(boolean includeTraceExpressions) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.variables.size()) {
            TLCVariable var = this.variables.get(i);
            if (!var.isTraceExplorerVar() || includeTraceExpressions) {
                result.append("/\\ ");
                if (var.isTraceExplorerVar()) {
                    result.append(var.getSingleLineName());
                } else {
                    result.append(var.getName());
                }
                result.append(" = ");
                if (var.getValue().toString() != null) {
                    result.append(var.getValue().toString());
                } else {
                    result.append(var.getValue().toSimpleString());
                }
                result.append('\n');
            }
            ++i;
        }
        return result.toString();
    }

    public String asRecord(boolean includeHeader) {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append("\n");
        if (includeHeader) {
            result.append(" ");
            result.append("_TEAction");
            result.append(" |-> ");
            result.append("[");
            result.append("\n");
            result.append(" ").append(" ").append(" ");
            result.append("position");
            result.append(" |-> ");
            result.append(this.getStateNumber());
            result.append(",").append("\n");
            result.append(" ").append(" ").append(" ");
            result.append("name");
            result.append(" |-> ");
            result.append("\"");
            result.append(this.getName());
            result.append("\"");
            result.append(",").append("\n");
            result.append(" ").append(" ").append(" ");
            result.append("location");
            result.append(" |-> ");
            result.append("\"");
            result.append(this.getModuleLocation());
            result.append("\"");
            result.append("\n");
            result.append(" ").append("]");
            if (!this.variables.isEmpty()) {
                result.append(",").append("\n");
            }
        }
        int i = 0;
        while (i < this.variables.size()) {
            TLCVariable var = this.variables.get(i);
            if (var.isTraceExplorerVar()) {
                result.append(var.getSingleLineName());
            } else {
                result.append(var.getName());
            }
            result.append(" |-> ");
            if (var.getValue().toString() != null) {
                result.append(var.getValue().toString());
            } else {
                result.append(var.getValue().toSimpleString());
            }
            if (i < this.variables.size() - 1) {
                result.append(",").append("\n");
            }
            ++i;
        }
        result.append("\n").append("]");
        return result.toString();
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    public void diff(TLCState other) {
        if (this == other || this.wasDiffed || other.isStuttering() || other.isBackToState()) {
            return;
        }
        this.wasDiffed = true;
        List<TLCVariable> predecessorVariables = this.getVariablesAsList();
        List<TLCVariable> secondVariables = other.getVariablesAsList();
        int i = 0;
        while (i < predecessorVariables.size()) {
            TLCVariableValue firstValue = predecessorVariables.get(i).getValue();
            TLCVariableValue secondValue = secondVariables.get(i).getValue();
            firstValue.diff(secondValue);
            ++i;
        }
    }

    public Map<String, TLCVariable> getDiff(TLCState other) {
        HashMap<String, TLCVariable> map = new HashMap<String, TLCVariable>();
        block0: for (TLCVariable v1 : this.variables) {
            for (TLCVariable v2 : other.variables) {
                if (v1.getName().equals(v2.getName()) && v1.getValue().toString().equals(v2.getValue().toString())) continue block0;
            }
            map.put(v1.getName(), v1);
        }
        return map;
    }

    public int getVariableCount(int level) {
        if (level > 1) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (level == 1) {
            return this.variables.size();
        }
        return 0;
    }

    public TLCState clone() {
        TLCState clone = new TLCState(this.number, this.modelName);
        clone.stuttering = this.stuttering;
        clone.isBackToState = this.isBackToState;
        clone.label = this.label;
        clone.variablesAsString = this.variablesAsString;
        clone.location = this.location;
        clone.wasDiffed = this.wasDiffed;
        clone.variables.addAll(this.variables);
        return clone;
    }
}

