/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.RGB;
import org.lamport.tla.toolbox.tool.tlc.output.data.ActionInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.Representation;
import org.lamport.tla.toolbox.tool.tlc.output.data.RootCoverageInformationItem;
import tla2sany.st.Location;

public class ModuleCoverageInformation {
    public static final String GRAY = "GRAY";
    public static final String RED = "RED";
    private static final int BLUE = 240;
    private final Map<Location, List<CoverageInformationItem>> loc2cci = new HashMap<Location, List<CoverageInformationItem>>();
    private final TreeMap<Integer, List<CoverageInformationItem>> offset2cii = new TreeMap();
    private final Map<Representation, TreeSet<CoverageInformationItem>> rootLegends = new HashMap<Representation, TreeSet<CoverageInformationItem>>();
    private final IFile file;
    private final List<CoverageInformationItem> allItems;
    private CoverageInformationItem root;

    static {
        JFaceResources.getColorRegistry().put(RED, new RGB(255, 0, 0));
        JFaceResources.getColorRegistry().put(GRAY, new RGB(211, 211, 211));
    }

    static int getHue(long count, TreeSet<Long> counts) {
        int size = counts.size();
        float r = 240.0f / (float)size;
        SortedSet<Long> headSet = counts.headSet(count);
        return 240 - Math.round(r * (float)(headSet.size() + 1));
    }

    private static CoverageInformationItem getRoot(List<CoverageInformationItem> items, IFile file) {
        RootCoverageInformationItem root = new RootCoverageInformationItem();
        ArrayDeque<CoverageInformationItem> stack = new ArrayDeque<CoverageInformationItem>();
        stack.push(root);
        ActionInformationItem aiiRoot = null;
        for (CoverageInformationItem item : items) {
            if (item.isInFile(file)) {
                if (item instanceof ActionInformationItem) {
                    aiiRoot = (ActionInformationItem)item;
                }
                int layer = item.getLayer();
                while (layer <= ((CoverageInformationItem)stack.peek()).getLayer()) {
                    stack.pop();
                }
                ((CoverageInformationItem)stack.peek()).addChild(item);
                stack.push(item);
                continue;
            }
            if (aiiRoot != null || !(item instanceof ActionInformationItem)) continue;
            aiiRoot = new ActionInformationItem((ActionInformationItem)item);
            aiiRoot.setIsNotInFile();
            ((CoverageInformationItem)root).addChild(aiiRoot);
            stack.push(aiiRoot);
        }
        assert (root.getChildren().stream().allMatch(c -> c instanceof ActionInformationItem));
        return root;
    }

    public ModuleCoverageInformation(IFile file, List<CoverageInformationItem> allItems) {
        this.file = file;
        this.allItems = allItems;
        List subset = allItems.stream().filter(i -> i.isInFile(file)).collect(Collectors.toList());
        for (CoverageInformationItem item : subset) {
            this.loc2cci.computeIfAbsent(item.getModuleLocation(), c -> new ArrayList()).add(item);
            this.offset2cii.computeIfAbsent(item.getRegion().getOffset(), c -> new ArrayList()).add(item);
        }
        for (CoverageInformationItem item : subset) {
            item.setSiblings(this.loc2cci.get(item.getModuleLocation()));
        }
        Representation[] representationArray = Representation.values();
        int n = representationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Representation rep2 = representationArray[n2];
            this.rootLegends.put(rep2, new TreeSet<CoverageInformationItem>(rep2.getComparator(Representation.Grouping.COMBINED)));
            ++n2;
        }
        List<ActionInformationItem> actionSubset = subset.stream().filter(cii -> cii instanceof ActionInformationItem).map(ActionInformationItem.class::cast).collect(Collectors.toList());
        long sum = actionSubset.stream().mapToLong(ActionInformationItem::getUnseen).sum();
        TreeSet distinctStateCounts = new TreeSet();
        TreeSet stateCounts = new TreeSet();
        actionSubset.forEach(a -> {
            distinctStateCounts.add(a.getUnseen());
            stateCounts.add(a.getCount());
            a.setSum(sum);
        });
        actionSubset.forEach(a -> {
            a.colorItem((TreeSet<Long>)distinctStateCounts, stateCounts);
            this.rootLegends.get((Object)Representation.STATES).add((CoverageInformationItem)a);
            this.rootLegends.get((Object)Representation.STATES_DISTINCT).add((CoverageInformationItem)a);
        });
        List values = Arrays.asList(Representation.values()).stream().filter(rep -> rep != Representation.STATES && rep != Representation.STATES_DISTINCT).collect(Collectors.toList());
        subset.removeAll(actionSubset);
        for (Representation rep3 : values) {
            TreeSet<Long> ciiCounts = new TreeSet<Long>();
            for (CoverageInformationItem item : subset) {
                ciiCounts.add(rep3.getValue(item, Representation.Grouping.INDIVIDUAL));
                ciiCounts.add(rep3.getValue(item, Representation.Grouping.COMBINED));
            }
            Set set = this.rootLegends.get((Object)rep3);
            for (CoverageInformationItem item : subset) {
                item.colorItem(ciiCounts, rep3);
                set.add(item);
            }
        }
    }

    public boolean hasStates() {
        return this.allItems.stream().filter(i -> i.isInFile(this.file) && i instanceof ActionInformationItem).count() > 0L;
    }

    public CoverageInformationItem getRoot() {
        if (this.root == null) {
            this.root = ModuleCoverageInformation.getRoot(this.allItems, this.file);
        }
        return this.root;
    }

    private List<CoverageInformationItem> getNodes(int offset) {
        Map.Entry<Integer, List<CoverageInformationItem>> entry = this.offset2cii.floorEntry(offset);
        if (entry != null) {
            return entry.getValue().stream().filter(cii -> offset <= cii.getRegion().getOffset() + cii.getRegion().getLength()).collect(Collectors.toList());
        }
        return new ArrayList<CoverageInformationItem>();
    }

    public CoverageInformationItem getNode(int offset) {
        return this.getNodes(offset).stream().findFirst().orElse(null);
    }

    public String getHoverInfo(int offset) {
        List actionItems;
        List<CoverageInformationItem> nodes = this.getNodes(offset);
        List sorted = nodes.stream().filter(cii -> !(cii instanceof ActionInformationItem)).sorted((c1, c2) -> c1.isActive() ? -1 : (c2.isActive() ? 1 : Long.compare(c1.getCount(), c2.getCount()))).collect(Collectors.toList());
        Object hover = "";
        String plus = "";
        Long sum = 0L;
        for (CoverageInformationItem cii2 : sorted) {
            long count = cii2.getCount();
            sum = sum + count;
            String cost = "";
            if (cii2.getCost() > 0L) {
                cost = String.format(", cost %s", cii2.getCost());
            }
            hover = String.format("%s%s%,d invocation%s%s (%s)\n", hover, plus, count, count == 1L ? "" : "s", cost, cii2.getRoot().getLocation());
            plus = "+";
        }
        if (sorted.size() > 1 && sum > 0L) {
            hover = (String)hover + String.format("---------\n%,d invocations", sum);
        }
        if (!(actionItems = nodes.stream().filter(cii -> cii instanceof ActionInformationItem).collect(Collectors.toList())).isEmpty()) {
            hover = (String)hover + "\n";
            for (CoverageInformationItem cii3 : actionItems) {
                ActionInformationItem aii = (ActionInformationItem)cii3;
                hover = (String)hover + aii.getHover();
                hover = (String)hover + "\n";
            }
        }
        return ((String)hover).replaceAll("^\n", "").replaceAll("\n$", "");
    }

    public TreeSet<CoverageInformationItem> getLegend(Representation rep) {
        return this.rootLegends.get((Object)rep);
    }
}

