/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tla2tex.handler;

import java.io.File;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.lamport.tla.toolbox.tool.tla2tex.TLA2TeXActivator;
import org.lamport.tla.toolbox.tool.tla2tex.handler.AbstractPDFViewerRunnable;
import org.lamport.tla.toolbox.tool.tla2tex.handler.EmbeddedPDFViewerRunnable;
import org.lamport.tla.toolbox.tool.tla2tex.handler.OperatingSystemPDFRunnable;
import org.lamport.tla.toolbox.tool.tla2tex.handler.StandalonePDFViewerRunnable;
import org.lamport.tla.toolbox.ui.handler.SaveDirtyEditorAbstractHandler;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2tex.TLA;
import tla2tex.TLA2TexException;

public class ProducePDFHandler
extends SaveDirtyEditorAbstractHandler {
    private final String TLA2TeX_Output_Extension = "pdf";

    public Object execute(ExecutionEvent event) {
        IFile fileToTranslate;
        if (!this.saveDirtyEditor(event)) {
            return null;
        }
        IPreferenceStore preferenceStore = TLA2TeXActivator.getDefault().getPreferenceStore();
        boolean useEmbeddedViewer = preferenceStore.getBoolean("embeddedViewer");
        boolean osHandlesPDF = preferenceStore.getBoolean("osHandlesPDF");
        IEditorInput editorInput = this.activeEditor.getEditorInput();
        if (editorInput instanceof IFileEditorInput && (fileToTranslate = ((IFileEditorInput)editorInput).getFile()) != null && ResourceHelper.isModule((IResource)fileToTranslate)) {
            AbstractPDFViewerRunnable pdfViewer = osHandlesPDF ? new OperatingSystemPDFRunnable(this, this.activeEditor.getSite(), (IResource)fileToTranslate) : (useEmbeddedViewer ? new EmbeddedPDFViewerRunnable(this, this.activeEditor.getSite(), (IResource)fileToTranslate) : new StandalonePDFViewerRunnable(this, this.activeEditor.getSite(), (IResource)fileToTranslate));
            this.runPDFJob(pdfViewer, (IResource)fileToTranslate);
        }
        return null;
    }

    void runPDFJob(final AbstractPDFViewerRunnable runnable, final IResource fileToTranslate) {
        WorkspaceJob tla2TexJob = new WorkspaceJob("Produce PDF"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    Vector<String> tla2texArgs = new Vector<String>();
                    IPreferenceStore preferenceStore = TLA2TeXActivator.getDefault().getPreferenceStore();
                    if (preferenceStore.getBoolean("shadeComments")) {
                        tla2texArgs.add("-shade");
                        tla2texArgs.add("-nops");
                    }
                    if (preferenceStore.getBoolean("noPcalShade")) {
                        tla2texArgs.add("-noPcalShade");
                    }
                    if (preferenceStore.getBoolean("numberLines")) {
                        tla2texArgs.add("-number");
                    }
                    tla2texArgs.add("-latexCommand");
                    String latexCommand = preferenceStore.getString("latexCommand");
                    tla2texArgs.add(latexCommand);
                    tla2texArgs.add("-grayLevel");
                    tla2texArgs.add(Double.toString(preferenceStore.getDouble("greyLevel")));
                    tla2texArgs.add("-latexOutputExt");
                    tla2texArgs.add("pdf");
                    tla2texArgs.add("-metadir");
                    tla2texArgs.add(fileToTranslate.getProject().getLocation().toOSString());
                    tla2texArgs.add(fileToTranslate.getLocation().toOSString());
                    monitor.beginTask("Producing PDF", 2);
                    monitor.subTask("Translating Module");
                    TLA.runTranslation((String[])tla2texArgs.toArray(new String[tla2texArgs.size()]));
                    fileToTranslate.getProject().refreshLocal(2, monitor);
                    monitor.worked(1);
                    String outputFileName = fileToTranslate.getProject().getLocation().toOSString() + File.separator + ResourceHelper.getModuleName((IResource)fileToTranslate) + ".pdf";
                    File outputFile = new File(outputFileName);
                    if (outputFile.exists()) {
                        runnable.setFile(outputFileName);
                        runnable.setMonitor(monitor);
                        UIHelper.runUISync((Runnable)runnable);
                    } else {
                        Runnable r = () -> MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"PDF file not found", (String)"Could not locate a pdf file for the module.");
                        UIHelper.runUIAsync((Runnable)r);
                    }
                }
                catch (CoreException | TLA2TexException e) {
                    ProducePDFHandler.this.handleJobException((Exception)e);
                }
                return Status.OK_STATUS;
            }
        };
        tla2TexJob.setUser(false);
        tla2TexJob.setPriority(30);
        tla2TexJob.schedule();
    }

    private void handleJobException(Exception e) {
        TLA2TeXActivator.getDefault().logError("Error while producing pdf file: " + e.getMessage(), e);
        Runnable r = () -> {
            Shell s = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            int response = MessageDialog.open((int)1, (Shell)s, (String)"PDF Production Problem", (String)("The following error was encountered while attempting to generate the PDF - perhaps you have not set a full path to pdflatex in the preferences?\n\n" + e.getMessage()), (int)0, (String[])new String[]{"Open Preferences", "Ok"});
            if (response == 0) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)s, (String)"toolbox.tool.tla2tex.preference.TLA2TeXPreferencePage", (String[])new String[]{"toolbox.tool.tla2tex.preference.TLA2TeXPreferencePage"}, null);
                dialog.open();
            }
        };
        UIHelper.runUIAsync((Runnable)r);
    }
}

