/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tla2tex;

import com.abstratt.graphviz.GraphVizActivator;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.lamport.tla.toolbox.AbstractTLCActivator;
import org.osgi.framework.BundleContext;

public class TLA2TeXActivator
extends AbstractTLCActivator {
    public static final String PLUGIN_ID = "org.lamport.tla.toolbox.tool.tlatex";
    private static final boolean IS_WINDOWS = "win32".equals(Platform.getOS());
    private static final String USR_LOCAL_BIN_PATH = "/usr/local/bin/dot";
    private static TLA2TeXActivator plugin;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("dotCommand".equals(event.getProperty())) {
                TLA2TeXActivator.this.configureGraphViz((String)event.getNewValue());
            }
        }
    };

    public TLA2TeXActivator() {
        super(PLUGIN_ID);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.addPropertyChangeListener(this.listener);
        this.configureGraphViz(preferenceStore.getString("dotCommand"));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static TLA2TeXActivator getDefault() {
        return plugin;
    }

    private void configureGraphViz(String dotLocationPreferenceValue) {
        File f;
        String dotCommand = dotLocationPreferenceValue;
        if (!IS_WINDOWS && (dotCommand == null || dotCommand.trim().length() == 0 || "dot".equals(dotCommand)) && (f = new File(USR_LOCAL_BIN_PATH)).exists() && f.canExecute()) {
            dotCommand = USR_LOCAL_BIN_PATH;
        }
        if ("dot".equals(dotCommand)) {
            this.logInfo("dot command set to automatic lookup.");
            GraphVizActivator.getInstance().setDotSearchMethod(GraphVizActivator.DotMethod.AUTO);
        } else {
            this.logInfo("dot command set to: " + dotCommand);
            GraphVizActivator.getInstance().setDotSearchMethod(GraphVizActivator.DotMethod.MANUAL);
            GraphVizActivator.getInstance().setManualDotPath(dotCommand);
        }
    }
}

