/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tla2tex.preference;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class DoubleFieldEditor
extends StringFieldEditor {
    private double minVal;
    private double maxVal;

    public DoubleFieldEditor(String name, String labelText, Composite parent, double min, double max) {
        super(name, labelText, parent);
        this.minVal = min;
        this.maxVal = max;
    }

    protected boolean checkState() {
        String text;
        block3: {
            String errorMessage = "Enter a real number between " + this.minVal + " and " + this.maxVal + ".";
            try {
                text = this.getTextControl().getText();
                if (!text.endsWith("d") && !text.endsWith("f") && !text.contains("e")) break block3;
                this.showErrorMessage(errorMessage);
                return false;
            }
            catch (NumberFormatException e) {
                this.showErrorMessage(errorMessage);
                return false;
            }
        }
        double value = Double.parseDouble(text);
        this.clearErrorMessage();
        return value >= this.minVal && value <= this.maxVal;
    }

    protected void doStore() {
        try {
            this.getPreferenceStore().setValue(this.getPreferenceName(), Double.parseDouble(this.getTextControl().getText()));
        }
        catch (NumberFormatException e) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.getPreferenceStore().getDefaultDouble(this.getPreferenceName()));
        }
    }
}

