/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.lamport.tla.toolbox.util.UIHelper;

public class TLAPMConsoleFactory
implements IConsoleFactory {
    private static final String TLAPM_CONSOLE_ID = "TLAPM-Console";

    public void openConsole() {
        IWorkbenchPage activePage = UIHelper.getActivePage();
        if (activePage != null) {
            try {
                activePage.showView("org.eclipse.ui.console.ConsoleView", TLAPM_CONSOLE_ID, 1);
            }
            catch (PartInitException e) {
                ConsolePlugin.log((Throwable)e);
            }
        }
    }

    public static MessageConsole getTLAPMConsole() {
        MessageConsole console = TLAPMConsoleFactory.findConsole(TLAPM_CONSOLE_ID);
        return console;
    }

    private static MessageConsole findConsole(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Console name must be not null");
        }
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] existing = consoleManager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        consoleManager.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

