/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.output.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.lamport.tla.toolbox.tool.prover.job.ProverJob;
import org.lamport.tla.toolbox.tool.prover.output.IProverProcessOutputSink;
import org.lamport.tla.toolbox.tool.prover.ui.ConsoleProverProcessOutputSink;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.tool.prover.ui.output.TagBasedTLAPMOutputIncrementalParser;

public class TLAPMBroadcastStreamListener
implements IStreamListener {
    private IProverProcessOutputSink[] listeners = null;

    public TLAPMBroadcastStreamListener(IFile module, ProverJob proverJob, IProgressMonitor monitor) {
        this.listeners = TLAPMBroadcastStreamListener.getRegisteredStreamManagers(module, proverJob, monitor);
    }

    public synchronized void streamAppended(String text, IStreamMonitor monitor) {
        int i = 0;
        while (i < this.listeners.length) {
            if (this.listeners[i] != null) {
                try {
                    this.listeners[i].appendText(text);
                }
                catch (Exception e) {
                    ProverUIActivator.getDefault().logError("Error broadcasting the message", e);
                }
            }
            ++i;
        }
    }

    public synchronized void streamClosed() {
        int i = 0;
        while (i < this.listeners.length) {
            try {
                if (this.listeners[i] != null) {
                    this.listeners[i].processFinished();
                }
            }
            catch (Exception e) {
                ProverUIActivator.getDefault().logError("Error broadcasting the stream closed event", e);
            }
            ++i;
        }
    }

    public static IProverProcessOutputSink[] getRegisteredStreamManagers(IFile module, ProverJob proverJob, IProgressMonitor monitor) {
        IProverProcessOutputSink[] outputSinks = new IProverProcessOutputSink[]{new ConsoleProverProcessOutputSink(), new TagBasedTLAPMOutputIncrementalParser()};
        outputSinks[0].initializeSink(module, proverJob, monitor);
        outputSinks[1].initializeSink(module, proverJob, monitor);
        return outputSinks;
    }
}

