/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.output.source;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.lamport.tla.toolbox.tool.prover.ui.output.source.ITLAPMOutputSource;
import org.lamport.tla.toolbox.tool.prover.ui.output.source.ITLAPMOutputSourceListener;

public class TLAPMOutputSourceRegistry {
    private static TLAPMOutputSourceRegistry instance;
    private HashMap sources = new HashMap();
    private HashMap listenerLists = new HashMap();

    public void addSource(ITLAPMOutputSource source) {
        ITLAPMOutputSource existingSource = (ITLAPMOutputSource)this.sources.get(source.getFullModulePath());
        if (existingSource != null) {
            ITLAPMOutputSourceListener[] existingListeners = existingSource.getListeners();
            int i = 0;
            while (i < existingListeners.length) {
                source.addListener(existingListeners[i]);
                existingSource.removeListener(existingListeners[i]);
                ++i;
            }
        } else {
            List list = (List)this.listenerLists.get(source.getFullModulePath());
            if (list != null) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    source.addListener((ITLAPMOutputSourceListener)it.next());
                    it.remove();
                }
            }
        }
        this.sources.put(source.getFullModulePath(), source);
    }

    public void addListener(ITLAPMOutputSourceListener listener) {
        ITLAPMOutputSource source = (ITLAPMOutputSource)this.sources.get(listener.getFullModulePath());
        if (source != null) {
            source.addListener(listener);
        } else {
            LinkedList<ITLAPMOutputSourceListener> list = (LinkedList<ITLAPMOutputSourceListener>)this.listenerLists.get(listener.getFullModulePath());
            if (list == null) {
                list = new LinkedList<ITLAPMOutputSourceListener>();
            }
            list.add(listener);
            this.listenerLists.put(listener.getFullModulePath(), list);
        }
    }

    public void removeListener(ITLAPMOutputSourceListener listener) {
        ITLAPMOutputSource source = (ITLAPMOutputSource)this.sources.get(listener.getFullModulePath());
        if (source != null) {
            source.removeListener(listener);
        } else {
            List list = (List)this.listenerLists.get(listener.getFullModulePath());
            if (list != null) {
                list.remove(listener);
            }
        }
    }

    private TLAPMOutputSourceRegistry() {
    }

    public static TLAPMOutputSourceRegistry getInstance() {
        if (instance == null) {
            instance = new TLAPMOutputSourceRegistry();
        }
        return instance;
    }
}

