/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.output.data;

import java.util.Map;
import java.util.Set;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.TLAPMMessage;
import tla2sany.st.Location;

public class ObligationStatusMessage
extends TLAPMMessage {
    public static final String ID_FIELD = "id";
    public static final String METH_FIELD = "meth";
    public static final String OBL_FIELD = "obl";
    public static final String PROVER_FIELD = "prover";
    public static final String ALREADY_FIELD = "already";
    public static final String REASON_FIELD = "reason";
    private String status;
    private Location location;
    private String obString;
    private String prover;
    private String method;
    private int id;
    private boolean alreadyProcessed = false;
    private String reason;

    private ObligationStatusMessage() {
    }

    public String getStatus() {
        return this.status;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getObString() {
        return this.obString;
    }

    public int getID() {
        return this.id;
    }

    public String getBackend() {
        return this.prover;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isAlreadyProcessed() {
        return this.alreadyProcessed;
    }

    public String getReason() {
        return this.reason;
    }

    public static ObligationStatusMessage getObMessage(Set fieldPairs, String moduleName) {
        ObligationStatusMessage message = new ObligationStatusMessage();
        for (Map.Entry nextEntry : fieldPairs) {
            String fieldName = (String)nextEntry.getKey();
            String fieldValue = (String)nextEntry.getValue();
            if (fieldName == null || fieldValue == null) continue;
            if (fieldName.equals("loc")) {
                message.location = ObligationStatusMessage.parseLocation(fieldValue, moduleName);
                continue;
            }
            if (fieldName.equals(OBL_FIELD)) {
                message.obString = fieldValue;
                continue;
            }
            if (fieldName.equals("status")) {
                message.status = fieldValue;
                continue;
            }
            if (fieldName.equals(ID_FIELD)) {
                try {
                    message.id = Integer.parseInt(fieldValue.trim());
                }
                catch (NumberFormatException e) {
                    ProverUIActivator.getDefault().logError("Error parsing obligation id from TLAPM message. ID string : " + fieldValue, e);
                }
                continue;
            }
            if (fieldName.equals(METH_FIELD)) {
                message.method = fieldValue;
                continue;
            }
            if (fieldName.equals(PROVER_FIELD)) {
                message.prover = fieldValue;
                continue;
            }
            if (fieldName.equals(ALREADY_FIELD)) {
                message.alreadyProcessed = Boolean.parseBoolean(fieldName.trim());
                continue;
            }
            if (fieldName.equals(REASON_FIELD)) {
                message.reason = fieldValue;
                continue;
            }
            ProverUIActivator.getDefault().logDebug("Unknown field name for obligation status message : " + fieldName + ".");
        }
        return message;
    }

    public String toString() {
        return "---------Obligation status message--------\nLOCATION : " + String.valueOf(this.location) + "\nID : " + this.id + "\nOBLIGATION : " + this.obString + "\nSTATUS : " + this.status + "\nMETHOD : " + this.method;
    }
}

