/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.tool.SpecEvent;
import org.lamport.tla.toolbox.tool.SpecLifecycleParticipant;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationStatus;
import org.lamport.tla.toolbox.tool.prover.ui.util.ProverHelper;
import org.lamport.tla.toolbox.tool.prover.ui.view.ObligationSourceViewerConfiguration;
import org.lamport.tla.toolbox.util.FontPreferenceChangeListener;
import org.lamport.tla.toolbox.util.TLAMarkerHelper;
import org.lamport.tla.toolbox.util.UIHelper;

public class ObligationsView
extends ViewPart {
    public static final String VIEW_ID = "org.lamport.tla.toolbox.tool.prover.ui.rejectedObligations";
    public static final String PART_NAME_BASE = "Interesting Obligations for ";
    private static final String KEY = ObligationsView.class.getName() + "ID";
    private static final String KEY_BUTTON = ObligationsView.class.getName() + "BUTTON";
    private ExpandBar bar = null;
    private Map<Integer, ExpandItem> items;
    private Map<ExpandItem, SourceViewer> viewers;
    private FontPreferenceChangeListener fontListener;
    private Listener obClickListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 3 && event.widget.getData() instanceof IMarker) {
                TLAMarkerHelper.gotoMarker((IMarker)((IMarker)event.widget.getData()));
            }
        }
    };
    private SelectionListener stopObListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button && e.widget.getData() instanceof IMarker) {
                ProverHelper.stopObligation((IMarker)e.widget.getData());
            }
        }
    };
    private SelectionListener gotoObListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button && e.widget.getData() instanceof IMarker) {
                TLAMarkerHelper.gotoMarker((IMarker)((IMarker)e.widget.getData()));
            }
        }
    };
    private final SpecLifecycleParticipant specLifecycleParticipant = new SpecLifecycleParticipant(){

        public boolean eventOccured(SpecEvent event) {
            if (event.getType() == 8) {
                ObligationsView.refreshObligationView();
            }
            return false;
        }
    };

    public ObligationsView() {
        this.items = new HashMap<Integer, ExpandItem>();
        this.viewers = new HashMap<ExpandItem, SourceViewer>();
        this.fontListener = new FontPreferenceChangeListener(null, "org.eclipse.jface.textfont");
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.fontListener);
    }

    public void createPartControl(Composite parent) {
        this.bar = new ExpandBar(parent, 2560);
        this.bar.setSpacing(8);
        this.fillFromCurrentSpec();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        Activator.getSpecManager().addSpecLifecycleParticipant(this.specLifecycleParticipant);
    }

    public static void refreshObligationView() {
        UIHelper.runUIAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                ObligationsView oblView = (ObligationsView)UIHelper.findView((String)ObligationsView.VIEW_ID);
                if (oblView != null) {
                    ExpandItem[] expandItems = oblView.bar.getItems();
                    int i = 0;
                    while (i < expandItems.length) {
                        oblView.removeItem(expandItems[i]);
                        ++i;
                    }
                    oblView.fillFromCurrentSpec();
                    if (oblView.isEmpty()) {
                        UIHelper.getActivePage().hideView((IViewPart)oblView);
                    }
                }
            }
        });
    }

    private void fillFromCurrentSpec() {
        ObligationStatus[] statuses = ProverHelper.getObligationStatuses();
        if (statuses != null) {
            int i = 0;
            while (i < statuses.length) {
                this.updateItem(statuses[i]);
                ++i;
            }
        }
    }

    public static void updateObligationView(ObligationStatus status) {
        ObligationsView oblView = !ProverHelper.isInterestingObligation(status) ? (ObligationsView)UIHelper.findView((String)VIEW_ID) : (ObligationsView)UIHelper.openView((String)VIEW_ID);
        if (oblView != null) {
            String moduleName = status.getObMarker().getResource().getName();
            if (!oblView.getPartName().equals(PART_NAME_BASE + moduleName)) {
                oblView.setPartName(PART_NAME_BASE + moduleName);
            }
            oblView.updateItem(status);
            if (oblView.isEmpty()) {
                UIHelper.getActivePage().hideView((IViewPart)oblView);
            }
        }
    }

    private void updateItem(ObligationStatus status) {
        int id = status.getId();
        if (id != -1) {
            ExpandItem item = this.items.get(new Integer(id));
            if (!ProverHelper.isInterestingObligation(status)) {
                if (item != null) {
                    this.removeItem(item);
                }
                return;
            }
            if (item == null) {
                item = new ExpandItem(this.bar, 0, 0);
                item.setData(KEY, (Object)new Integer(id));
                Composite oblWidget = new Composite((Composite)this.bar, 1);
                GridLayout gl = new GridLayout(1, true);
                gl.marginWidth = 0;
                gl.marginHeight = 0;
                oblWidget.setLayout((Layout)gl);
                Composite buttonsWidget = new Composite(oblWidget, 1);
                GridLayout buttonsGl = new GridLayout(2, true);
                buttonsGl.marginWidth = 0;
                buttonsGl.marginHeight = 0;
                buttonsWidget.setLayout((Layout)buttonsGl);
                buttonsWidget.setLayoutData((Object)new GridData(4, 4, true, true));
                Button stopButton = new Button(buttonsWidget, 8);
                stopButton.setText("Stop Proving");
                stopButton.setLayoutData((Object)new GridData(4, 4, true, true));
                stopButton.setData((Object)status.getObMarker());
                stopButton.addSelectionListener(this.stopObListener);
                item.setControl((Control)oblWidget);
                item.setData(KEY_BUTTON, (Object)stopButton);
                Button gotoButton = new Button(buttonsWidget, 8);
                gotoButton.setText("Goto Obligation");
                gotoButton.setLayoutData((Object)new GridData(4, 4, true, true));
                gotoButton.setData((Object)status.getObMarker());
                gotoButton.addSelectionListener(this.gotoObListener);
                SourceViewer viewer = new SourceViewer(oblWidget, null, 266);
                viewer.getTextWidget().setLayoutData((Object)new GridData(4, 4, true, true));
                viewer.configure((SourceViewerConfiguration)new ObligationSourceViewerConfiguration());
                viewer.getControl().setFont(JFaceResources.getTextFont());
                this.fontListener.addControl(viewer.getControl());
                this.viewers.put(item, viewer);
                item.setControl((Control)oblWidget);
                item.setExpanded(true);
                item.setData((Object)status.getObMarker());
                viewer.getTextWidget().setData((Object)status.getObMarker());
                oblWidget.setData((Object)status.getObMarker());
                item.addListener(3, this.obClickListener);
                this.items.put(new Integer(id), item);
            }
            item.setText("Obligation " + id + " - status : " + status.getProverStatusString());
            Button button = (Button)item.getData(KEY_BUTTON);
            button.setEnabled(ProverHelper.isBeingProvedObligation(status));
            SourceViewer viewer = this.viewers.get(item);
            Assert.isNotNull((Object)viewer, (String)"Expand item has been created without a source viewer. This is a bug.");
            String oblString = status.getObligationString();
            if (oblString == null) {
                oblString = "";
            }
            if (!(viewer.getDocument() != null && viewer.getDocument().get().equals(oblString) || oblString.length() == 0)) {
                viewer.setDocument((IDocument)new Document(oblString.trim()));
                item.setHeight(item.getControl().computeSize((int)-1, (int)-1, (boolean)true).y);
            } else if (oblString.length() == 0 && (viewer.getDocument() == null || viewer.getDocument().get().length() == 0)) {
                viewer.setDocument((IDocument)new Document("No obligation text available."));
                item.setHeight(100);
            }
        }
    }

    private boolean isEmpty() {
        return this.bar.getItemCount() == 0;
    }

    public void setFocus() {
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.fontListener);
        super.dispose();
    }

    private void removeItem(ExpandItem item) {
        this.fontListener.removeControl(this.viewers.get(item).getControl());
        Object data = item.getData(KEY);
        this.items.remove(Integer.parseInt(data.toString()));
        item.getControl().dispose();
        item.dispose();
    }
}

