/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.output.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationStatusMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.StepTuple;
import org.lamport.tla.toolbox.tool.prover.ui.util.ProverHelper;
import tla2sany.st.Location;

public class ObligationStatus {
    private StepTuple parent;
    private IMarker obMarker;
    private Map proverStatuses;
    private Map proverReasons;
    private String obligationString;
    private int obState;
    private int id;
    private Location location;

    public ObligationStatus(StepTuple parent, IMarker obMarker, int initialState, Location location, int id) {
        this.parent = parent;
        this.proverStatuses = new HashMap();
        this.proverReasons = new HashMap();
        this.obState = initialState;
        this.id = id;
        this.location = location;
        this.obMarker = obMarker;
    }

    public int getObligationState() {
        return this.obState;
    }

    public Map getProverStatuses() {
        return this.proverStatuses;
    }

    public StepTuple getParent() {
        return this.parent;
    }

    public void setParent(StepTuple parentStep) {
        this.parent = parentStep;
    }

    public int getId() {
        return this.id;
    }

    public String getObligationString() {
        return this.obligationString;
    }

    public String getProverStatusString() {
        StringBuilder buffer = new StringBuilder();
        Set entrySet = this.proverStatuses.entrySet();
        Iterator it = entrySet.iterator();
        while (it.hasNext()) {
            Map.Entry nextEntry = it.next();
            String key = (String)nextEntry.getKey();
            Object reason = (String)this.proverReasons.get(key);
            reason = reason != null && !((String)reason).equals("") && !((String)reason).equals("false") ? " (" + (String)reason + ")" : "";
            buffer.append(key + " : " + String.valueOf(nextEntry.getValue()) + (String)reason);
            if (!it.hasNext()) continue;
            buffer.append(" , ");
        }
        return buffer.toString();
    }

    public void updateObligation(ObligationStatusMessage message) {
        int newState;
        int oldState;
        String oldStatusOnBackend = (String)this.proverStatuses.get(message.getBackend());
        if (oldStatusOnBackend != null && oldStatusOnBackend.equals("proved")) {
            return;
        }
        if (this.obligationString == null || this.obligationString.length() == 0) {
            this.obligationString = message.getObString();
        }
        if (message.getBackend() != null && message.getStatus() != null) {
            this.proverStatuses.put(message.getBackend(), message.getStatus());
        }
        if (message.getBackend() != null && message.getReason() != null) {
            this.proverReasons.put(message.getBackend(), message.getReason());
        }
        if ((oldState = this.getObligationState()) != (newState = ProverHelper.getIntFromStringStatus(message.getStatus(), oldState, message.getBackend()))) {
            this.obState = newState;
            this.parent.updateStatus();
        }
    }

    public IMarker getObMarker() {
        return this.obMarker;
    }

    public Location getTLAPMLocation() {
        return this.location;
    }

    public String toString() {
        return "ID : " + this.id + "\nLocation : " + String.valueOf(this.location) + "\nStatus : " + this.getProverStatusString() + "\nState : " + this.obState + "\nObligation : " + this.obligationString;
    }
}

