/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.preference;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.tool.prover.ui.util.TLAPMExecutableLocator;

public class MainProverPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String EXECUTABLE_LOCATION_KEY = "tlapm_filepath";
    public static final String NUM_THREADS_KEY = "num_threads";
    public static final String SOLVER_KEY = "solver";
    public static final String SAFEFP_KEY = "safefp";
    private TLAPMLocationEditor locationFieldEditor;
    private Label tlapmWarningLabel;

    public MainProverPreferencePage() {
        super(1);
        this.setPreferenceStore(ProverUIActivator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.locationFieldEditor = new TLAPMLocationEditor(EXECUTABLE_LOCATION_KEY, "Location of tlapm", parent);
        this.addField((FieldEditor)this.locationFieldEditor);
        this.tlapmWarningLabel = new Label(this.getFieldEditorParent(), 0x1000000);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        gd.exclude = true;
        this.tlapmWarningLabel.setLayoutData((Object)gd);
        this.tlapmWarningLabel.setForeground(this.tlapmWarningLabel.getDisplay().getSystemColor(3));
        this.tlapmWarningLabel.setText("The tlapm executable is not present or cannot be found.");
        this.tlapmWarningLabel.setVisible(false);
        Label lbl = new Label(this.getFieldEditorParent(), 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        lbl.setLayoutData((Object)gd);
        lbl = new Label(this.getFieldEditorParent(), 0);
        lbl.setLayoutData((Object)gd);
        lbl.setText("Advanced Execution Preferences");
        this.addField((FieldEditor)new ThreadsFieldEditor(NUM_THREADS_KEY, "  Num. of Threads", parent));
        this.addField((FieldEditor)new SolverFieldEditor(SOLVER_KEY, "  SMT Solver Command", parent));
        this.addField((FieldEditor)new BooleanFieldEditor(SAFEFP_KEY, "Do not trust previous results from earlier versions of provers.", parent));
    }

    public void setVisible(boolean flag) {
        if (flag) {
            TLAPMExecutableLocator locator = TLAPMExecutableLocator.INSTANCE;
            this.updateLocationWarningLabelForPath(locator.getTLAPMPath());
            String pathPreference = ProverUIActivator.getDefault().getPreferenceStore().getString(EXECUTABLE_LOCATION_KEY);
            if (pathPreference.trim().length() == 0 && locator.tlapmDoesExist()) {
                this.locationFieldEditor.setStringValue(locator.getTLAPMPath().toFile().getAbsolutePath());
            }
        }
        super.setVisible(flag);
    }

    private void updateLocationWarningLabelForPath(IPath path) {
        if (TLAPMExecutableLocator.pathForExecutableIsUsable(path)) {
            GridData gd = (GridData)this.tlapmWarningLabel.getLayoutData();
            this.tlapmWarningLabel.setVisible(false);
            gd.exclude = true;
            this.tlapmWarningLabel.setLayoutData((Object)gd);
            this.tlapmWarningLabel.getParent().layout(true, true);
        } else {
            this.showTLAPMWarningLabel();
        }
    }

    private void showTLAPMWarningLabel() {
        GridData gd = (GridData)this.tlapmWarningLabel.getLayoutData();
        this.tlapmWarningLabel.setVisible(true);
        gd.exclude = false;
        this.tlapmWarningLabel.setLayoutData((Object)gd);
        this.tlapmWarningLabel.getParent().layout(true, true);
    }

    private static class SolverFieldEditor
    extends StringFieldEditor {
        public SolverFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        public boolean doCheckState() {
            return true;
        }
    }

    private class TLAPMLocationEditor
    extends FileFieldEditor {
        public TLAPMLocationEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setErrorMessage("Selected file must be an executable.");
        }

        protected void showErrorMessage(String msg) {
            MainProverPreferencePage.this.showTLAPMWarningLabel();
            super.showErrorMessage(msg);
        }

        public boolean doCheckState() {
            String textFieldValue = this.getStringValue().trim();
            Path path = new Path(textFieldValue);
            MainProverPreferencePage.this.updateLocationWarningLabelForPath((IPath)path);
            return textFieldValue.length() == 0 || TLAPMExecutableLocator.pathForExecutableIsUsable((IPath)path);
        }
    }

    private static class ThreadsFieldEditor
    extends StringFieldEditor {
        public ThreadsFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        public boolean doCheckState() {
            String value = this.getStringValue().trim();
            if (value.length() == 0) {
                return true;
            }
            try {
                int numThreads = Integer.parseInt(value);
                return numThreads > 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

