/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.job;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.spec.parser.ModuleParserLauncher;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.tool.prover.job.ProverJobRule;
import org.lamport.tla.toolbox.tool.prover.output.internal.TLAPMBroadcastStreamListener;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ColorPredicate;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationStatus;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationStatusMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.StepStatusMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.StepTuple;
import org.lamport.tla.toolbox.tool.prover.ui.preference.ColorPredicatePreferencePage;
import org.lamport.tla.toolbox.tool.prover.ui.util.ProverHelper;
import org.lamport.tla.toolbox.tool.prover.ui.util.TLAPMExecutableLocator;
import org.lamport.tla.toolbox.tool.prover.ui.view.ObligationsView;
import org.lamport.tla.toolbox.util.ResourceHelper;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.TheoremNode;
import util.UniqueString;

public class ProverJob
extends Job {
    private long startTime;
    private boolean noToBeProved = true;
    private boolean toBeProvedOnly = true;
    private static ProverJob lastJob;
    private IFile module;
    private IPath tlapmPath;
    private IPath cygwinPath;
    private ILaunch launch;
    private IProcess proverProcess;
    private TLAPMBroadcastStreamListener listener;
    protected static final long TIMEOUT = 100L;
    private boolean checkStatus = false;
    private boolean toolboxMode = true;
    private String[] options;
    private String[] command;
    private LevelNode nodeToProve;
    private int offset;
    private Map<Integer, StepStatusMessage> stepMessageMap = new HashMap<Integer, StepStatusMessage>();
    private Map<Integer, StepTuple> leafStepMap = new TreeMap<Integer, StepTuple>();
    private Map<Integer, ObligationStatus> obsMap = new HashMap<Integer, ObligationStatus>();
    private List<ObligationStatusMessage> obMessageList = new LinkedList<ObligationStatusMessage>();
    private ColorPredicate[] colorPredicates;

    public ProverJob(IFile module, int offset, boolean checkStatus, String[] options, boolean toolboxMode) {
        super(checkStatus ? "Status Checking Launch" : "Prover Launch");
        this.checkStatus = checkStatus;
        this.toolboxMode = toolboxMode;
        this.module = module;
        this.offset = offset;
        this.options = options;
        this.setRule((ISchedulingRule)new MultiRule(new ISchedulingRule[]{new ProverJobRule(), this.module.getWorkspace().getRoot()}));
        Assert.isTrue((boolean)Platform.isRunning(), (String)"Platform is not running when prover was launched. This makes no sense.");
        TLAPMExecutableLocator locator = TLAPMExecutableLocator.INSTANCE;
        this.tlapmPath = locator.getTLAPMPath();
        this.cygwinPath = locator.getCygwinPath();
        this.launch = new Launch(null, "", null);
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.startTime = System.currentTimeMillis();
        ProverUIActivator.getDefault().logDebug("Run method called " + this.getCurRelTime());
        this.colorPredicates = new ColorPredicate[12];
        IPreferenceStore store = ProverUIActivator.getDefault().getPreferenceStore();
        int i = 1;
        while (i <= this.colorPredicates.length) {
            String predicate = store.getString(ColorPredicatePreferencePage.getColorPredPrefName(i));
            boolean appliesToLeafOnly = store.getBoolean(ColorPredicatePreferencePage.getAppliesToLeafPrefName(i));
            this.colorPredicates[i - 1] = new ColorPredicate((appliesToLeafOnly ? "leaf " : "") + predicate);
            ++i;
        }
        this.initializeFields();
        if (this.nodeToProve == null) {
            return new Status(1, "org.lamport.tla.toolbox.tool.prover.ui", "The module has parse errors. The prover cannot be run.");
        }
        try {
            block48: {
                block47: {
                    IPath modulePath = this.module.getLocation();
                    if (!modulePath.toFile().exists()) {
                        ProverUIActivator.getDefault().logDebug("Module file given to ProverJob does not exist.");
                        Status status = new Status(4, "org.lamport.tla.toolbox.tool.prover.ui", "Module file does not exist.");
                        return status;
                    }
                    if (Platform.getOS().equals("win32") && this.cygwinPath != null && !this.cygwinPath.toFile().exists()) {
                        ProverUIActivator.getDefault().logDebug("The given cygwin path does not exist.");
                        Status status = new Status(4, "org.lamport.tla.toolbox.tool.prover.ui", "The given cygwin path " + String.valueOf(this.cygwinPath) + " does not exist.");
                        return status;
                    }
                    lastJob = this;
                    try {
                        ProverHelper.clearObligationMarkers((IResource)this.module.getProject());
                        ObligationsView.refreshObligationView();
                        ProverHelper.prepareModuleForProverLaunch(this.module, this);
                    }
                    catch (CoreException e1) {
                        ProverUIActivator.getDefault().logError("Error clearing obligation markers for project of module " + String.valueOf(modulePath), e1);
                    }
                    this.command = this.constructCommand();
                    ProcessBuilder pb = new ProcessBuilder(this.command);
                    ProverUIActivator.getDefault().logDebug("Prover ARGUMENTS: " + Arrays.toString(this.command));
                    pb.directory(modulePath.toFile().getParentFile());
                    if (Platform.isRunning() && Platform.getOS().equals("win32")) {
                        String pathVar = "Path";
                        if (this.cygwinPath != null) {
                            pb.environment().put(pathVar, this.cygwinPath.toOSString() + ";" + pb.environment().get(pathVar));
                        }
                    }
                    pb.redirectErrorStream(true);
                    ProverUIActivator.getDefault().logDebug("TLAPM launched " + this.getCurRelTime());
                    Process process = pb.start();
                    this.setUpStreamListening(process, monitor);
                    if (this.proverProcess == null) break block48;
                    while (this.checkAndSleep()) {
                        if (!monitor.isCanceled()) continue;
                        this.proverProcess.getStreamsProxy().write("kill\n");
                        ProverUIActivator.getDefault().logDebug("Sent kill to tlapm.");
                        while (this.checkAndSleep()) {
                        }
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        if (!this.proverProcess.isTerminated() || this.proverProcess.getExitValue() != 2) break block47;
                        Status status = new Status(4, "org.lamport.tla.toolbox.tool.prover.ui", "Incorrect arguments to the PM. The command to launch the PM was :\n" + this.getLaunchProverCommand());
                        return status;
                    }
                    catch (DebugException e) {
                        Status status = new Status(4, "org.lamport.tla.toolbox.tool.prover.ui", "Error getting exit code for tlapm process. This is a bug. Report it to the developers at https://github.com/tlaplus/tlapm/issues");
                        return status;
                    }
                }
                if (this.proverProcess.isTerminated() && this.proverProcess.getExitValue() != 0 && this.proverProcess.getExitValue() != 1) {
                    Status status = new Status(4, "org.lamport.tla.toolbox.tool.prover.ui", "Error running tlapm. Report a bug with the error code to the developers at https://github.com/tlaplus/tlapm/issues.\n \n Error code: " + this.proverProcess.getExitValue());
                    return status;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            Status status = new Status(4, "org.lamport.tla.toolbox.tool.prover.ui", "Error launching prover. Launching the prover returned a null process.");
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.lamport.tla.toolbox.tool.prover.ui", "The following error occurred while running the PM : \n" + e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            if (this.listener != null) {
                this.listener.streamClosed();
            }
            monitor.done();
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.launch);
            if (this.proverProcess != null && this.listener != null) {
                this.proverProcess.getStreamsProxy().getErrorStreamMonitor().removeListener((IStreamListener)this.listener);
                this.proverProcess.getStreamsProxy().getOutputStreamMonitor().removeListener((IStreamListener)this.listener);
            }
            ProverUIActivator.getDefault().logDebug("Done with proving " + this.getCurRelTime());
            EditorUtil.setReadOnly((IResource)this.module, (boolean)false);
            try {
                ProverHelper.removeSANYStepMarkers((IResource)this.module);
            }
            catch (CoreException e) {
                ProverUIActivator.getDefault().logError("Error removing SANY step markers after prover finished running.", e);
            }
        }
    }

    public boolean checkAndSleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.proverProcess != null && !this.proverProcess.isTerminated();
    }

    public boolean belongsTo(Object family) {
        return family instanceof ProverJobMatcher;
    }

    private String[] constructCommand() {
        String[] pathList;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tlapmPath.toOSString());
        boolean useWSL = this.tlapmPath.toOSString().contains("wsl.exe");
        if (useWSL) {
            command.add("tlapm");
        }
        if (this.toolboxMode) {
            command.add("--toolbox");
            if (this.nodeToProve instanceof ModuleNode) {
                command.add("0");
                command.add("0");
            } else {
                int beginLine = ProverJob.getBeginLine(this.nodeToProve);
                int endLine = ProverJob.getEndLine(this.nodeToProve);
                command.add("" + beginLine);
                command.add("" + endLine);
            }
        }
        ProverHelper.setThreadsOption(command);
        ProverHelper.setSolverOption(command);
        ProverHelper.setSafeFPOption(command);
        if (this.checkStatus) {
            command.add("--noproving");
        }
        if (this.options != null) {
            int i = 0;
            while (i < this.options.length) {
                command.add(this.options[i]);
                ++i;
            }
        }
        if ((pathList = Activator.getSpecManager().getSpecLoaded().getTLALibraryPath()) != null) {
            int i = 0;
            while (i < pathList.length) {
                command.add("-I");
                if (useWSL) {
                    command.add(String.format("$(wslpath %s)", pathList[pathList.length - i - 1].replace("\\", "\\\\")));
                } else {
                    command.add(pathList[pathList.length - i - 1]);
                }
                ++i;
            }
        }
        if (useWSL) {
            command.add(String.format("$(wslpath %s)", this.module.getLocation().toOSString().replace("\\", "\\\\")));
        } else {
            command.add(this.module.getLocation().toOSString());
        }
        return command.toArray(new String[command.size()]);
    }

    private static int getBeginLine(LevelNode nodeToProve) {
        return nodeToProve.getLocation().beginLine();
    }

    private static int getEndLine(LevelNode nodeToProve) {
        if (nodeToProve instanceof TheoremNode && ((TheoremNode)nodeToProve).getProof() != null) {
            return ((TheoremNode)nodeToProve).getProof().getLocation().endLine();
        }
        return nodeToProve.getLocation().endLine();
    }

    public boolean isStatusCheck() {
        return this.checkStatus;
    }

    public LevelNode getLevelNode() {
        return this.nodeToProve;
    }

    public Map<Integer, StepStatusMessage> getStepMessageMap() {
        return this.stepMessageMap;
    }

    public Map<Integer, StepTuple> getLeafStepMap() {
        return this.leafStepMap;
    }

    public Collection<StepTuple> getLeafSteps() {
        return this.leafStepMap.values();
    }

    public Map<Integer, ObligationStatus> getObsMap() {
        return this.obsMap;
    }

    public Collection<ObligationStatus> getObs() {
        return this.obsMap.values();
    }

    public ColorPredicate[] getColorPredicates() {
        return this.colorPredicates;
    }

    private void initializeFields() {
        ParseResult parseResult = ResourceHelper.getValidParseResult((IFile)this.module);
        if (parseResult == null) {
            parseResult = new ModuleParserLauncher().parseModule((IResource)this.module, (IProgressMonitor)new NullProgressMonitor());
        }
        if (parseResult.getStatus() != 0) {
            return;
        }
        String moduleName = ResourceHelper.getModuleName((IResource)this.module);
        if (this.offset != -1) {
            this.nodeToProve = ResourceHelper.getPfStepOrUseHideFromMod((ParseResult)parseResult, (String)moduleName, (ITextSelection)new TextSelection(this.offset, 0), (IDocument)ResourceHelper.getDocFromFile((IFile)this.module));
        }
        if (this.nodeToProve == null) {
            this.nodeToProve = parseResult.getSpecObj().getExternalModuleTable().getModuleNode(UniqueString.uniqueStringOf((String)moduleName));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpStreamListening(Process process, IProgressMonitor monitor) {
        if (process != null) {
            InputStream inputStream = process.getInputStream();
            synchronized (inputStream) {
                InputStream inputStream2 = process.getErrorStream();
                synchronized (inputStream2) {
                    this.proverProcess = DebugPlugin.newProcess((ILaunch)this.launch, (Process)process, (String)this.getName());
                    this.listener = new TLAPMBroadcastStreamListener(this.module, this, monitor);
                    this.listener.streamAppended("---------------- New Prover Launch --------------\n", null);
                    IStreamMonitor esMonitor = this.proverProcess.getStreamsProxy().getErrorStreamMonitor();
                    IStreamMonitor osMonitor = this.proverProcess.getStreamsProxy().getOutputStreamMonitor();
                    esMonitor.addListener((IStreamListener)this.listener);
                    osMonitor.addListener((IStreamListener)this.listener);
                    if (esMonitor instanceof IFlushableStreamMonitor && osMonitor instanceof IFlushableStreamMonitor) {
                        ((IFlushableStreamMonitor)esMonitor).setBuffered(false);
                        ((IFlushableStreamMonitor)osMonitor).setBuffered(false);
                    }
                }
            }
        }
    }

    public String getProverJobTaskName() {
        return (this.checkStatus ? "Status check" : "Prover") + " launched on " + (this.nodeToProve instanceof ModuleNode ? "entire" : "") + " module " + this.module.getName() + (String)(this.nodeToProve instanceof ModuleNode ? "" : " from line " + ProverJob.getBeginLine(this.nodeToProve) + " to line " + ProverJob.getEndLine(this.nodeToProve));
    }

    public void stopObligation(int id) {
        if (this.proverProcess != null && !this.proverProcess.isTerminated()) {
            try {
                this.proverProcess.getStreamsProxy().write("stop " + id + "\n");
            }
            catch (IOException e) {
                ProverUIActivator.getDefault().logError("Error sending signal to tlapm to stop obligation " + id, e);
            }
        }
    }

    public static ProverJob getLastJob() {
        return lastJob;
    }

    public List<ObligationStatusMessage> getObMessageList() {
        return this.obMessageList;
    }

    public boolean addObMessageList(ObligationStatusMessage message) {
        return this.obMessageList.add(message);
    }

    public void setToBeProvedOnly(boolean toBeProvedOnly) {
        this.toBeProvedOnly = toBeProvedOnly;
    }

    public boolean isToBeProvedOnly() {
        return this.toBeProvedOnly;
    }

    public IFile getModule() {
        return this.module;
    }

    public String getLaunchProverCommand() {
        if (this.command == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.command.length) {
            buffer.append(this.command[i]).append(" ");
            ++i;
        }
        return buffer.toString();
    }

    public String[] getProverCommandArray() {
        return this.command;
    }

    public long getCurRelTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public boolean getNoToBeProved() {
        return this.noToBeProved;
    }

    public void setNoToBeProved(boolean b) {
        this.noToBeProved = b;
    }

    public static class ProverJobMatcher {
    }
}

